/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.source.ads;

import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.MediaItem;
import com.akamai.amp.exoplayer2.Timeline;
import com.akamai.amp.exoplayer2.source.CompositeMediaSource;
import com.akamai.amp.exoplayer2.source.LoadEventInfo;
import com.akamai.amp.exoplayer2.source.MaskingMediaPeriod;
import com.akamai.amp.exoplayer2.source.MediaPeriod;
import com.akamai.amp.exoplayer2.source.MediaSource;
import com.akamai.amp.exoplayer2.source.MediaSourceFactory;
import com.akamai.amp.exoplayer2.source.ProgressiveMediaSource;
import com.akamai.amp.exoplayer2.source.ads.AdPlaybackState;
import com.akamai.amp.exoplayer2.source.ads.AdsLoader;
import com.akamai.amp.exoplayer2.source.ads.SinglePeriodAdTimeline;
import com.akamai.amp.exoplayer2.upstream.Allocator;
import com.akamai.amp.exoplayer2.upstream.DataSource;
import com.akamai.amp.exoplayer2.upstream.DataSpec;
import com.akamai.amp.exoplayer2.upstream.TransferListener;
import com.akamai.amp.exoplayer2.util.Assertions;
import com.akamai.amp.exoplayer2.util.Util;
import java.io.IOException;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.checkerframework.checker.nullness.compatqual.NullableType;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public final class AdsMediaSource
extends CompositeMediaSource<MediaSource.MediaPeriodId> {
    private static final MediaSource.MediaPeriodId CHILD_SOURCE_MEDIA_PERIOD_ID = new MediaSource.MediaPeriodId(new Object());
    private final MediaSource contentMediaSource;
    private final MediaSourceFactory adMediaSourceFactory;
    private final AdsLoader adsLoader;
    private final AdsLoader.AdViewProvider adViewProvider;
    @Nullable
    private final DataSpec adTagDataSpec;
    private final Handler mainHandler;
    private final Timeline.Period period;
    @Nullable
    private ComponentListener componentListener;
    @Nullable
    private Timeline contentTimeline;
    @Nullable
    private AdPlaybackState adPlaybackState;
    private @NullableType AdsMediaSource.AdMediaSourceHolder[][] adMediaSourceHolders;

    @Deprecated
    public AdsMediaSource(MediaSource contentMediaSource, DataSource.Factory dataSourceFactory, AdsLoader adsLoader, AdsLoader.AdViewProvider adViewProvider) {
        this(contentMediaSource, new ProgressiveMediaSource.Factory(dataSourceFactory), adsLoader, adViewProvider, null);
    }

    @Deprecated
    public AdsMediaSource(MediaSource contentMediaSource, MediaSourceFactory adMediaSourceFactory, AdsLoader adsLoader, AdsLoader.AdViewProvider adViewProvider) {
        this(contentMediaSource, adMediaSourceFactory, adsLoader, adViewProvider, null);
    }

    public AdsMediaSource(MediaSource contentMediaSource, DataSpec adTagDataSpec, MediaSourceFactory adMediaSourceFactory, AdsLoader adsLoader, AdsLoader.AdViewProvider adViewProvider) {
        this(contentMediaSource, adMediaSourceFactory, adsLoader, adViewProvider, adTagDataSpec);
    }

    private AdsMediaSource(MediaSource contentMediaSource, MediaSourceFactory adMediaSourceFactory, AdsLoader adsLoader, AdsLoader.AdViewProvider adViewProvider, @Nullable DataSpec adTagDataSpec) {
        this.contentMediaSource = contentMediaSource;
        this.adMediaSourceFactory = adMediaSourceFactory;
        this.adsLoader = adsLoader;
        this.adViewProvider = adViewProvider;
        this.adTagDataSpec = adTagDataSpec;
        this.mainHandler = new Handler(Looper.getMainLooper());
        this.period = new Timeline.Period();
        this.adMediaSourceHolders = new AdMediaSourceHolder[0][];
        adsLoader.setSupportedContentTypes(adMediaSourceFactory.getSupportedTypes());
    }

    @Override
    public boolean isLive() {
        return false;
    }

    @Override
    @Deprecated
    @Nullable
    public Object getTag() {
        return this.contentMediaSource.getTag();
    }

    @Override
    public MediaItem getMediaItem() {
        return this.contentMediaSource.getMediaItem();
    }

    @Override
    protected void prepareSourceInternal(@Nullable TransferListener mediaTransferListener) {
        ComponentListener componentListener;
        super.prepareSourceInternal(mediaTransferListener);
        this.componentListener = componentListener = new ComponentListener();
        this.prepareChildSource(CHILD_SOURCE_MEDIA_PERIOD_ID, this.contentMediaSource);
        this.mainHandler.post(() -> {
            if (this.adTagDataSpec != null) {
                this.adsLoader.setAdTagDataSpec(this.adTagDataSpec);
            }
            this.adsLoader.start(componentListener, this.adViewProvider);
        });
    }

    @Override
    public MediaPeriod createPeriod(MediaSource.MediaPeriodId id, Allocator allocator, long startPositionUs) {
        AdPlaybackState adPlaybackState = Assertions.checkNotNull(this.adPlaybackState);
        if (adPlaybackState.adGroupCount > 0 && id.isAd()) {
            AdMediaSourceHolder adMediaSourceHolder;
            int adGroupIndex = id.adGroupIndex;
            int adIndexInAdGroup = id.adIndexInAdGroup;
            if (this.adMediaSourceHolders[adGroupIndex].length <= adIndexInAdGroup) {
                int adCount = adIndexInAdGroup + 1;
                this.adMediaSourceHolders[adGroupIndex] = Arrays.copyOf(this.adMediaSourceHolders[adGroupIndex], adCount);
            }
            if ((adMediaSourceHolder = this.adMediaSourceHolders[adGroupIndex][adIndexInAdGroup]) == null) {
                this.adMediaSourceHolders[adGroupIndex][adIndexInAdGroup] = adMediaSourceHolder = new AdMediaSourceHolder(id);
                this.maybeUpdateAdMediaSources();
            }
            return adMediaSourceHolder.createMediaPeriod(id, allocator, startPositionUs);
        }
        MaskingMediaPeriod mediaPeriod = new MaskingMediaPeriod(id, allocator, startPositionUs);
        mediaPeriod.setMediaSource(this.contentMediaSource);
        mediaPeriod.createPeriod(id);
        return mediaPeriod;
    }

    @Override
    public void releasePeriod(MediaPeriod mediaPeriod) {
        MaskingMediaPeriod maskingMediaPeriod = (MaskingMediaPeriod)mediaPeriod;
        MediaSource.MediaPeriodId id = maskingMediaPeriod.id;
        if (id.isAd()) {
            AdMediaSourceHolder adMediaSourceHolder = Assertions.checkNotNull(this.adMediaSourceHolders[id.adGroupIndex][id.adIndexInAdGroup]);
            adMediaSourceHolder.releaseMediaPeriod(maskingMediaPeriod);
            if (adMediaSourceHolder.isInactive()) {
                adMediaSourceHolder.release();
                this.adMediaSourceHolders[id.adGroupIndex][id.adIndexInAdGroup] = null;
            }
        } else {
            maskingMediaPeriod.releasePeriod();
        }
    }

    @Override
    protected void releaseSourceInternal() {
        super.releaseSourceInternal();
        Assertions.checkNotNull(this.componentListener).release();
        this.componentListener = null;
        this.contentTimeline = null;
        this.adPlaybackState = null;
        this.adMediaSourceHolders = new AdMediaSourceHolder[0][];
        this.mainHandler.post(this.adsLoader::stop);
    }

    @Override
    protected void onChildSourceInfoRefreshed(MediaSource.MediaPeriodId mediaPeriodId, MediaSource mediaSource, Timeline timeline) {
        if (mediaPeriodId.isAd()) {
            int adGroupIndex = mediaPeriodId.adGroupIndex;
            int adIndexInAdGroup = mediaPeriodId.adIndexInAdGroup;
            Assertions.checkNotNull(this.adMediaSourceHolders[adGroupIndex][adIndexInAdGroup]).handleSourceInfoRefresh(timeline);
        } else {
            Assertions.checkArgument(timeline.getPeriodCount() == 1);
            this.contentTimeline = timeline;
        }
        this.maybeUpdateSourceInfo();
    }

    @Override
    protected MediaSource.MediaPeriodId getMediaPeriodIdForChildMediaPeriodId(MediaSource.MediaPeriodId childId, MediaSource.MediaPeriodId mediaPeriodId) {
        return childId.isAd() ? childId : mediaPeriodId;
    }

    private void onAdPlaybackState(AdPlaybackState adPlaybackState) {
        if (this.adPlaybackState == null) {
            this.adMediaSourceHolders = new AdMediaSourceHolder[adPlaybackState.adGroupCount][];
            Arrays.fill((Object[])this.adMediaSourceHolders, new AdMediaSourceHolder[0]);
        }
        this.adPlaybackState = adPlaybackState;
        this.maybeUpdateAdMediaSources();
        this.maybeUpdateSourceInfo();
    }

    private void maybeUpdateAdMediaSources() {
        AdPlaybackState adPlaybackState = this.adPlaybackState;
        if (adPlaybackState == null) {
            return;
        }
        for (int adGroupIndex = 0; adGroupIndex < this.adMediaSourceHolders.length; ++adGroupIndex) {
            for (int adIndexInAdGroup = 0; adIndexInAdGroup < this.adMediaSourceHolders[adGroupIndex].length; ++adIndexInAdGroup) {
                Uri adUri;
                AdMediaSourceHolder adMediaSourceHolder = this.adMediaSourceHolders[adGroupIndex][adIndexInAdGroup];
                if (adMediaSourceHolder == null || adMediaSourceHolder.hasMediaSource() || adPlaybackState.adGroups[adGroupIndex] == null || adIndexInAdGroup >= adPlaybackState.adGroups[adGroupIndex].uris.length || (adUri = adPlaybackState.adGroups[adGroupIndex].uris[adIndexInAdGroup]) == null) continue;
                MediaSource adMediaSource = this.adMediaSourceFactory.createMediaSource(MediaItem.fromUri(adUri));
                adMediaSourceHolder.initializeWithMediaSource(adMediaSource, adUri);
            }
        }
    }

    private void maybeUpdateSourceInfo() {
        Timeline contentTimeline = this.contentTimeline;
        if (this.adPlaybackState != null && contentTimeline != null) {
            this.adPlaybackState = this.adPlaybackState.withAdDurationsUs(this.getAdDurationsUs());
            Timeline timeline = this.adPlaybackState.adGroupCount == 0 ? contentTimeline : new SinglePeriodAdTimeline(contentTimeline, this.adPlaybackState);
            this.refreshSourceInfo(timeline);
        }
    }

    private long[][] getAdDurationsUs() {
        long[][] adDurationsUs = new long[this.adMediaSourceHolders.length][];
        for (int i = 0; i < this.adMediaSourceHolders.length; ++i) {
            adDurationsUs[i] = new long[this.adMediaSourceHolders[i].length];
            for (int j = 0; j < this.adMediaSourceHolders[i].length; ++j) {
                AdMediaSourceHolder holder = this.adMediaSourceHolders[i][j];
                adDurationsUs[i][j] = holder == null ? -9223372036854775807L : holder.getDurationUs();
            }
        }
        return adDurationsUs;
    }

    private final class AdMediaSourceHolder {
        private final MediaSource.MediaPeriodId id;
        private final List<MaskingMediaPeriod> activeMediaPeriods;
        private @MonotonicNonNull Uri adUri;
        private @MonotonicNonNull MediaSource adMediaSource;
        private @MonotonicNonNull Timeline timeline;

        public AdMediaSourceHolder(MediaSource.MediaPeriodId id) {
            this.id = id;
            this.activeMediaPeriods = new ArrayList<MaskingMediaPeriod>();
        }

        public void initializeWithMediaSource(MediaSource adMediaSource, Uri adUri) {
            this.adMediaSource = adMediaSource;
            this.adUri = adUri;
            for (int i = 0; i < this.activeMediaPeriods.size(); ++i) {
                MaskingMediaPeriod maskingMediaPeriod = this.activeMediaPeriods.get(i);
                maskingMediaPeriod.setMediaSource(adMediaSource);
                maskingMediaPeriod.setPrepareListener(new AdPrepareListener(adUri));
            }
            AdsMediaSource.this.prepareChildSource(this.id, adMediaSource);
        }

        public MediaPeriod createMediaPeriod(MediaSource.MediaPeriodId id, Allocator allocator, long startPositionUs) {
            MaskingMediaPeriod maskingMediaPeriod = new MaskingMediaPeriod(id, allocator, startPositionUs);
            this.activeMediaPeriods.add(maskingMediaPeriod);
            if (this.adMediaSource != null) {
                maskingMediaPeriod.setMediaSource(this.adMediaSource);
                maskingMediaPeriod.setPrepareListener(new AdPrepareListener(Assertions.checkNotNull(this.adUri)));
            }
            if (this.timeline != null) {
                Object periodUid = this.timeline.getUidOfPeriod(0);
                MediaSource.MediaPeriodId adSourceMediaPeriodId = new MediaSource.MediaPeriodId(periodUid, id.windowSequenceNumber);
                maskingMediaPeriod.createPeriod(adSourceMediaPeriodId);
            }
            return maskingMediaPeriod;
        }

        public void handleSourceInfoRefresh(Timeline timeline) {
            Assertions.checkArgument(timeline.getPeriodCount() == 1);
            if (this.timeline == null) {
                Object periodUid = timeline.getUidOfPeriod(0);
                for (int i = 0; i < this.activeMediaPeriods.size(); ++i) {
                    MaskingMediaPeriod mediaPeriod = this.activeMediaPeriods.get(i);
                    MediaSource.MediaPeriodId adSourceMediaPeriodId = new MediaSource.MediaPeriodId(periodUid, mediaPeriod.id.windowSequenceNumber);
                    mediaPeriod.createPeriod(adSourceMediaPeriodId);
                }
            }
            this.timeline = timeline;
        }

        public long getDurationUs() {
            return this.timeline == null ? -9223372036854775807L : this.timeline.getPeriod(0, AdsMediaSource.this.period).getDurationUs();
        }

        public void releaseMediaPeriod(MaskingMediaPeriod maskingMediaPeriod) {
            this.activeMediaPeriods.remove(maskingMediaPeriod);
            maskingMediaPeriod.releasePeriod();
        }

        public void release() {
            if (this.hasMediaSource()) {
                AdsMediaSource.this.releaseChildSource(this.id);
            }
        }

        public boolean hasMediaSource() {
            return this.adMediaSource != null;
        }

        public boolean isInactive() {
            return this.activeMediaPeriods.isEmpty();
        }
    }

    private final class ComponentListener
    implements AdsLoader.EventListener {
        private final Handler playerHandler = Util.createHandlerForCurrentLooper();
        private volatile boolean released;

        public void release() {
            this.released = true;
            this.playerHandler.removeCallbacksAndMessages(null);
        }

        @Override
        public void onAdPlaybackState(AdPlaybackState adPlaybackState) {
            if (this.released) {
                return;
            }
            this.playerHandler.post(() -> {
                if (this.released) {
                    return;
                }
                AdsMediaSource.this.onAdPlaybackState(adPlaybackState);
            });
        }

        @Override
        public void onAdLoadError(AdLoadException error, DataSpec dataSpec) {
            if (this.released) {
                return;
            }
            AdsMediaSource.this.createEventDispatcher(null).loadError(new LoadEventInfo(LoadEventInfo.getNewId(), dataSpec, SystemClock.elapsedRealtime()), 6, (IOException)error, true);
        }
    }

    private final class AdPrepareListener
    implements MaskingMediaPeriod.PrepareListener {
        private final Uri adUri;

        public AdPrepareListener(Uri adUri) {
            this.adUri = adUri;
        }

        @Override
        public void onPrepareComplete(MediaSource.MediaPeriodId mediaPeriodId) {
            AdsMediaSource.this.mainHandler.post(() -> AdsMediaSource.this.adsLoader.handlePrepareComplete(mediaPeriodId.adGroupIndex, mediaPeriodId.adIndexInAdGroup));
        }

        @Override
        public void onPrepareError(MediaSource.MediaPeriodId mediaPeriodId, IOException exception) {
            AdsMediaSource.this.createEventDispatcher(mediaPeriodId).loadError(new LoadEventInfo(LoadEventInfo.getNewId(), new DataSpec(this.adUri), SystemClock.elapsedRealtime()), 6, (IOException)AdLoadException.createForAd(exception), true);
            AdsMediaSource.this.mainHandler.post(() -> AdsMediaSource.this.adsLoader.handlePrepareError(mediaPeriodId.adGroupIndex, mediaPeriodId.adIndexInAdGroup, exception));
        }
    }

    public static final class AdLoadException
    extends IOException {
        public static final int TYPE_AD = 0;
        public static final int TYPE_AD_GROUP = 1;
        public static final int TYPE_ALL_ADS = 2;
        public static final int TYPE_UNEXPECTED = 3;
        public final int type;

        public static AdLoadException createForAd(Exception error) {
            return new AdLoadException(0, error);
        }

        public static AdLoadException createForAdGroup(Exception error, int adGroupIndex) {
            return new AdLoadException(1, new IOException("Failed to load ad group " + adGroupIndex, error));
        }

        public static AdLoadException createForAllAds(Exception error) {
            return new AdLoadException(2, error);
        }

        public static AdLoadException createForUnexpected(RuntimeException error) {
            return new AdLoadException(3, error);
        }

        private AdLoadException(int type, Exception cause) {
            super(cause);
            this.type = type;
        }

        public RuntimeException getRuntimeExceptionForUnexpected() {
            Assertions.checkState(this.type == 3);
            return (RuntimeException)Assertions.checkNotNull(this.getCause());
        }

        @Documented
        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Type {
        }
    }
}

