/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2;

import android.os.Looper;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.TextureView;
import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.ExoPlaybackException;
import com.akamai.amp.exoplayer2.MediaItem;
import com.akamai.amp.exoplayer2.PlaybackParameters;
import com.akamai.amp.exoplayer2.Timeline;
import com.akamai.amp.exoplayer2.audio.AudioAttributes;
import com.akamai.amp.exoplayer2.audio.AudioListener;
import com.akamai.amp.exoplayer2.audio.AuxEffectInfo;
import com.akamai.amp.exoplayer2.device.DeviceInfo;
import com.akamai.amp.exoplayer2.device.DeviceListener;
import com.akamai.amp.exoplayer2.metadata.MetadataOutput;
import com.akamai.amp.exoplayer2.source.TrackGroupArray;
import com.akamai.amp.exoplayer2.text.Cue;
import com.akamai.amp.exoplayer2.text.TextOutput;
import com.akamai.amp.exoplayer2.trackselection.TrackSelectionArray;
import com.akamai.amp.exoplayer2.trackselection.TrackSelector;
import com.akamai.amp.exoplayer2.video.VideoDecoderOutputBufferRenderer;
import com.akamai.amp.exoplayer2.video.VideoFrameMetadataListener;
import com.akamai.amp.exoplayer2.video.VideoListener;
import com.akamai.amp.exoplayer2.video.spherical.CameraMotionListener;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;

public interface Player {
    public static final int STATE_IDLE = 1;
    public static final int STATE_BUFFERING = 2;
    public static final int STATE_READY = 3;
    public static final int STATE_ENDED = 4;
    public static final int PLAY_WHEN_READY_CHANGE_REASON_USER_REQUEST = 1;
    public static final int PLAY_WHEN_READY_CHANGE_REASON_AUDIO_FOCUS_LOSS = 2;
    public static final int PLAY_WHEN_READY_CHANGE_REASON_AUDIO_BECOMING_NOISY = 3;
    public static final int PLAY_WHEN_READY_CHANGE_REASON_REMOTE = 4;
    public static final int PLAY_WHEN_READY_CHANGE_REASON_END_OF_MEDIA_ITEM = 5;
    public static final int PLAYBACK_SUPPRESSION_REASON_NONE = 0;
    public static final int PLAYBACK_SUPPRESSION_REASON_TRANSIENT_AUDIO_FOCUS_LOSS = 1;
    public static final int REPEAT_MODE_OFF = 0;
    public static final int REPEAT_MODE_ONE = 1;
    public static final int REPEAT_MODE_ALL = 2;
    public static final int DISCONTINUITY_REASON_PERIOD_TRANSITION = 0;
    public static final int DISCONTINUITY_REASON_SEEK = 1;
    public static final int DISCONTINUITY_REASON_SEEK_ADJUSTMENT = 2;
    public static final int DISCONTINUITY_REASON_AD_INSERTION = 3;
    public static final int DISCONTINUITY_REASON_INTERNAL = 4;
    public static final int TIMELINE_CHANGE_REASON_PLAYLIST_CHANGED = 0;
    public static final int TIMELINE_CHANGE_REASON_SOURCE_UPDATE = 1;
    public static final int MEDIA_ITEM_TRANSITION_REASON_REPEAT = 0;
    public static final int MEDIA_ITEM_TRANSITION_REASON_AUTO = 1;
    public static final int MEDIA_ITEM_TRANSITION_REASON_SEEK = 2;
    public static final int MEDIA_ITEM_TRANSITION_REASON_PLAYLIST_CHANGED = 3;

    @Nullable
    public AudioComponent getAudioComponent();

    @Nullable
    public VideoComponent getVideoComponent();

    @Nullable
    public TextComponent getTextComponent();

    @Nullable
    public MetadataComponent getMetadataComponent();

    @Nullable
    public DeviceComponent getDeviceComponent();

    public Looper getApplicationLooper();

    public void addListener(EventListener var1);

    public void removeListener(EventListener var1);

    public void setMediaItems(List<MediaItem> var1);

    public void setMediaItems(List<MediaItem> var1, boolean var2);

    public void setMediaItems(List<MediaItem> var1, int var2, long var3);

    public void setMediaItem(MediaItem var1);

    public void setMediaItem(MediaItem var1, long var2);

    public void setMediaItem(MediaItem var1, boolean var2);

    public void addMediaItem(MediaItem var1);

    public void addMediaItem(int var1, MediaItem var2);

    public void addMediaItems(List<MediaItem> var1);

    public void addMediaItems(int var1, List<MediaItem> var2);

    public void moveMediaItem(int var1, int var2);

    public void moveMediaItems(int var1, int var2, int var3);

    public void removeMediaItem(int var1);

    public void removeMediaItems(int var1, int var2);

    public void clearMediaItems();

    public void prepare();

    public int getPlaybackState();

    public int getPlaybackSuppressionReason();

    public boolean isPlaying();

    @Nullable
    public ExoPlaybackException getPlayerError();

    @Deprecated
    @Nullable
    public ExoPlaybackException getPlaybackError();

    public void play();

    public void pause();

    public void setPlayWhenReady(boolean var1);

    public boolean getPlayWhenReady();

    public void setRepeatMode(int var1);

    public int getRepeatMode();

    public void setShuffleModeEnabled(boolean var1);

    public boolean getShuffleModeEnabled();

    public boolean isLoading();

    public void seekToDefaultPosition();

    public void seekToDefaultPosition(int var1);

    public void seekTo(long var1);

    public void seekTo(int var1, long var2);

    public boolean hasPrevious();

    public void previous();

    public boolean hasNext();

    public void next();

    public void setPlaybackParameters(@Nullable PlaybackParameters var1);

    public PlaybackParameters getPlaybackParameters();

    public void stop();

    public void stop(boolean var1);

    public void release();

    public int getRendererCount();

    public int getRendererType(int var1);

    @Nullable
    public TrackSelector getTrackSelector();

    public TrackGroupArray getCurrentTrackGroups();

    public TrackSelectionArray getCurrentTrackSelections();

    @Nullable
    public Object getCurrentManifest();

    public Timeline getCurrentTimeline();

    public int getCurrentPeriodIndex();

    public int getCurrentWindowIndex();

    public int getNextWindowIndex();

    public int getPreviousWindowIndex();

    @Deprecated
    @Nullable
    public Object getCurrentTag();

    @Nullable
    public MediaItem getCurrentMediaItem();

    public int getMediaItemCount();

    public MediaItem getMediaItemAt(int var1);

    public long getDuration();

    public long getCurrentPosition();

    public long getBufferedPosition();

    public int getBufferedPercentage();

    public long getTotalBufferedDuration();

    public boolean isCurrentWindowDynamic();

    public boolean isCurrentWindowLive();

    public long getCurrentLiveOffset();

    public boolean isCurrentWindowSeekable();

    public boolean isPlayingAd();

    public int getCurrentAdGroupIndex();

    public int getCurrentAdIndexInAdGroup();

    public long getContentDuration();

    public long getContentPosition();

    public long getContentBufferedPosition();

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MediaItemTransitionReason {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TimelineChangeReason {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DiscontinuityReason {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RepeatMode {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PlaybackSuppressionReason {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PlayWhenReadyChangeReason {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface State {
    }

    @Deprecated
    public static abstract class DefaultEventListener
    implements EventListener {
        @Override
        public void onTimelineChanged(Timeline timeline, int reason) {
            Object manifest = null;
            if (timeline.getWindowCount() == 1) {
                Timeline.Window window = new Timeline.Window();
                manifest = timeline.getWindow((int)0, (Timeline.Window)window).manifest;
            }
            this.onTimelineChanged(timeline, manifest, reason);
        }

        @Override
        public void onTimelineChanged(Timeline timeline, @Nullable Object manifest, int reason) {
            this.onTimelineChanged(timeline, manifest);
        }

        @Deprecated
        public void onTimelineChanged(Timeline timeline, @Nullable Object manifest) {
        }
    }

    public static interface EventListener {
        default public void onTimelineChanged(Timeline timeline, int reason) {
            Object manifest = null;
            if (timeline.getWindowCount() == 1) {
                Timeline.Window window = new Timeline.Window();
                manifest = timeline.getWindow((int)0, (Timeline.Window)window).manifest;
            }
            this.onTimelineChanged(timeline, manifest, reason);
        }

        @Deprecated
        default public void onTimelineChanged(Timeline timeline, @Nullable Object manifest, int reason) {
        }

        default public void onMediaItemTransition(@Nullable MediaItem mediaItem, int reason) {
        }

        default public void onTracksChanged(TrackGroupArray trackGroups, TrackSelectionArray trackSelections) {
        }

        default public void onIsLoadingChanged(boolean isLoading) {
            this.onLoadingChanged(isLoading);
        }

        @Deprecated
        default public void onLoadingChanged(boolean isLoading) {
        }

        @Deprecated
        default public void onPlayerStateChanged(boolean playWhenReady, int playbackState) {
        }

        default public void onPlaybackStateChanged(int state) {
        }

        default public void onPlayWhenReadyChanged(boolean playWhenReady, int reason) {
        }

        default public void onPlaybackSuppressionReasonChanged(int playbackSuppressionReason) {
        }

        default public void onIsPlayingChanged(boolean isPlaying) {
        }

        default public void onRepeatModeChanged(int repeatMode) {
        }

        default public void onShuffleModeEnabledChanged(boolean shuffleModeEnabled) {
        }

        default public void onPlayerError(ExoPlaybackException error) {
        }

        default public void onPositionDiscontinuity(int reason) {
        }

        default public void onPlaybackParametersChanged(PlaybackParameters playbackParameters) {
        }

        @Deprecated
        default public void onSeekProcessed() {
        }

        default public void onExperimentalOffloadSchedulingEnabledChanged(boolean offloadSchedulingEnabled) {
        }
    }

    public static interface DeviceComponent {
        public void addDeviceListener(DeviceListener var1);

        public void removeDeviceListener(DeviceListener var1);

        public DeviceInfo getDeviceInfo();

        public int getDeviceVolume();

        public boolean isDeviceMuted();

        public void setDeviceVolume(int var1);

        public void increaseDeviceVolume();

        public void decreaseDeviceVolume();

        public void setDeviceMuted(boolean var1);
    }

    public static interface MetadataComponent {
        public void addMetadataOutput(MetadataOutput var1);

        public void removeMetadataOutput(MetadataOutput var1);
    }

    public static interface TextComponent {
        public void addTextOutput(TextOutput var1);

        public void removeTextOutput(TextOutput var1);

        public List<Cue> getCurrentCues();
    }

    public static interface VideoComponent {
        public void setVideoScalingMode(int var1);

        public int getVideoScalingMode();

        public void addVideoListener(VideoListener var1);

        public void removeVideoListener(VideoListener var1);

        public void setVideoFrameMetadataListener(VideoFrameMetadataListener var1);

        public void clearVideoFrameMetadataListener(VideoFrameMetadataListener var1);

        public void setCameraMotionListener(CameraMotionListener var1);

        public void clearCameraMotionListener(CameraMotionListener var1);

        public void clearVideoSurface();

        public void clearVideoSurface(@Nullable Surface var1);

        public void setVideoSurface(@Nullable Surface var1);

        public void setVideoSurfaceHolder(@Nullable SurfaceHolder var1);

        public void clearVideoSurfaceHolder(@Nullable SurfaceHolder var1);

        public void setVideoSurfaceView(@Nullable SurfaceView var1);

        public void clearVideoSurfaceView(@Nullable SurfaceView var1);

        public void setVideoTextureView(@Nullable TextureView var1);

        public void clearVideoTextureView(@Nullable TextureView var1);

        public void setVideoDecoderOutputBufferRenderer(@Nullable VideoDecoderOutputBufferRenderer var1);

        public void clearVideoDecoderOutputBufferRenderer();

        public void clearVideoDecoderOutputBufferRenderer(@Nullable VideoDecoderOutputBufferRenderer var1);
    }

    public static interface AudioComponent {
        public void addAudioListener(AudioListener var1);

        public void removeAudioListener(AudioListener var1);

        @Deprecated
        public void setAudioAttributes(AudioAttributes var1);

        public void setAudioAttributes(AudioAttributes var1, boolean var2);

        public AudioAttributes getAudioAttributes();

        public void setAudioSessionId(int var1);

        public int getAudioSessionId();

        public void setAuxEffectInfo(AuxEffectInfo var1);

        public void clearAuxEffectInfo();

        public void setVolume(float var1);

        public float getVolume();

        public void setSkipSilenceEnabled(boolean var1);

        public boolean getSkipSilenceEnabled();
    }
}

