/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2;

import android.content.Context;
import android.media.AudioFocusRequest;
import android.media.AudioManager;
import android.os.Handler;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import com.akamai.amp.exoplayer2.audio.AudioAttributes;
import com.akamai.amp.exoplayer2.util.Assertions;
import com.akamai.amp.exoplayer2.util.Log;
import com.akamai.amp.exoplayer2.util.Util;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

final class AudioFocusManager {
    public static final int PLAYER_COMMAND_DO_NOT_PLAY = -1;
    public static final int PLAYER_COMMAND_WAIT_FOR_CALLBACK = 0;
    public static final int PLAYER_COMMAND_PLAY_WHEN_READY = 1;
    private static final int AUDIO_FOCUS_STATE_NO_FOCUS = 0;
    private static final int AUDIO_FOCUS_STATE_HAVE_FOCUS = 1;
    private static final int AUDIO_FOCUS_STATE_LOSS_TRANSIENT = 2;
    private static final int AUDIO_FOCUS_STATE_LOSS_TRANSIENT_DUCK = 3;
    private static final String TAG = "AudioFocusManager";
    private static final float VOLUME_MULTIPLIER_DUCK = 0.2f;
    private static final float VOLUME_MULTIPLIER_DEFAULT = 1.0f;
    private final AudioManager audioManager;
    private final AudioFocusListener focusListener;
    @Nullable
    private PlayerControl playerControl;
    @Nullable
    private AudioAttributes audioAttributes;
    private int audioFocusState;
    private int focusGain;
    private float volumeMultiplier = 1.0f;
    private @MonotonicNonNull AudioFocusRequest audioFocusRequest;
    private boolean rebuildAudioFocusRequest;

    public AudioFocusManager(Context context, Handler eventHandler, PlayerControl playerControl) {
        this.audioManager = Assertions.checkNotNull((AudioManager)context.getApplicationContext().getSystemService("audio"));
        this.playerControl = playerControl;
        this.focusListener = new AudioFocusListener(eventHandler);
        this.audioFocusState = 0;
    }

    public float getVolumeMultiplier() {
        return this.volumeMultiplier;
    }

    public void setAudioAttributes(@Nullable AudioAttributes audioAttributes) {
        if (!Util.areEqual(this.audioAttributes, audioAttributes)) {
            this.audioAttributes = audioAttributes;
            this.focusGain = AudioFocusManager.convertAudioAttributesToFocusGain(audioAttributes);
            Assertions.checkArgument(this.focusGain == 1 || this.focusGain == 0, "Automatic handling of audio focus is only available for USAGE_MEDIA and USAGE_GAME.");
        }
    }

    public int updateAudioFocus(boolean playWhenReady, int playbackState) {
        if (this.shouldAbandonAudioFocus(playbackState)) {
            this.abandonAudioFocus();
            return playWhenReady ? 1 : -1;
        }
        return playWhenReady ? this.requestAudioFocus() : -1;
    }

    public void release() {
        this.playerControl = null;
        this.abandonAudioFocus();
    }

    @VisibleForTesting
    AudioManager.OnAudioFocusChangeListener getFocusListener() {
        return this.focusListener;
    }

    private boolean shouldAbandonAudioFocus(int playbackState) {
        return playbackState == 1 || this.focusGain != 1;
    }

    private int requestAudioFocus() {
        int requestResult;
        if (this.audioFocusState == 1) {
            return 1;
        }
        int n = requestResult = Util.SDK_INT >= 26 ? this.requestAudioFocusV26() : this.requestAudioFocusDefault();
        if (requestResult == 1) {
            this.setAudioFocusState(1);
            return 1;
        }
        this.setAudioFocusState(0);
        return -1;
    }

    private void abandonAudioFocus() {
        if (this.audioFocusState == 0) {
            return;
        }
        if (Util.SDK_INT >= 26) {
            this.abandonAudioFocusV26();
        } else {
            this.abandonAudioFocusDefault();
        }
        this.setAudioFocusState(0);
    }

    private int requestAudioFocusDefault() {
        return this.audioManager.requestAudioFocus((AudioManager.OnAudioFocusChangeListener)this.focusListener, Util.getStreamTypeForAudioUsage(Assertions.checkNotNull(this.audioAttributes).usage), this.focusGain);
    }

    @RequiresApi(value=26)
    private int requestAudioFocusV26() {
        if (this.audioFocusRequest == null || this.rebuildAudioFocusRequest) {
            AudioFocusRequest.Builder builder = this.audioFocusRequest == null ? new AudioFocusRequest.Builder(this.focusGain) : new AudioFocusRequest.Builder(this.audioFocusRequest);
            boolean willPauseWhenDucked = this.willPauseWhenDucked();
            this.audioFocusRequest = builder.setAudioAttributes(Assertions.checkNotNull(this.audioAttributes).getAudioAttributesV21()).setWillPauseWhenDucked(willPauseWhenDucked).setOnAudioFocusChangeListener((AudioManager.OnAudioFocusChangeListener)this.focusListener).build();
            this.rebuildAudioFocusRequest = false;
        }
        return this.audioManager.requestAudioFocus(this.audioFocusRequest);
    }

    private void abandonAudioFocusDefault() {
        this.audioManager.abandonAudioFocus((AudioManager.OnAudioFocusChangeListener)this.focusListener);
    }

    @RequiresApi(value=26)
    private void abandonAudioFocusV26() {
        if (this.audioFocusRequest != null) {
            this.audioManager.abandonAudioFocusRequest(this.audioFocusRequest);
        }
    }

    private boolean willPauseWhenDucked() {
        return this.audioAttributes != null && this.audioAttributes.contentType == 1;
    }

    private static int convertAudioAttributesToFocusGain(@Nullable AudioAttributes audioAttributes) {
        if (audioAttributes == null) {
            return 0;
        }
        switch (audioAttributes.usage) {
            case 3: {
                return 0;
            }
            case 1: 
            case 14: {
                return 1;
            }
            case 0: {
                Log.w(TAG, "Specify a proper usage in the audio attributes for audio focus handling. Using AUDIOFOCUS_GAIN by default.");
                return 1;
            }
            case 2: 
            case 4: {
                return 2;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                return 3;
            }
            case 16: {
                if (Util.SDK_INT >= 19) {
                    return 4;
                }
                return 2;
            }
            case 11: {
                if (audioAttributes.contentType == 1) {
                    return 2;
                }
                return 3;
            }
        }
        Log.w(TAG, "Unidentified audio usage: " + audioAttributes.usage);
        return 0;
    }

    private void setAudioFocusState(int audioFocusState) {
        float volumeMultiplier;
        if (this.audioFocusState == audioFocusState) {
            return;
        }
        this.audioFocusState = audioFocusState;
        float f = volumeMultiplier = audioFocusState == 3 ? 0.2f : 1.0f;
        if (this.volumeMultiplier == volumeMultiplier) {
            return;
        }
        this.volumeMultiplier = volumeMultiplier;
        if (this.playerControl != null) {
            this.playerControl.setVolumeMultiplier(volumeMultiplier);
        }
    }

    private void handlePlatformAudioFocusChange(int focusChange) {
        switch (focusChange) {
            case 1: {
                this.setAudioFocusState(1);
                this.executePlayerCommand(1);
                return;
            }
            case -1: {
                this.executePlayerCommand(-1);
                this.abandonAudioFocus();
                return;
            }
            case -3: 
            case -2: {
                if (focusChange == -2 || this.willPauseWhenDucked()) {
                    this.executePlayerCommand(0);
                    this.setAudioFocusState(2);
                } else {
                    this.setAudioFocusState(3);
                }
                return;
            }
        }
        Log.w(TAG, "Unknown focus change type: " + focusChange);
    }

    private void executePlayerCommand(int playerCommand) {
        if (this.playerControl != null) {
            this.playerControl.executePlayerCommand(playerCommand);
        }
    }

    public static interface PlayerControl {
        public void setVolumeMultiplier(float var1);

        public void executePlayerCommand(int var1);
    }

    private class AudioFocusListener
    implements AudioManager.OnAudioFocusChangeListener {
        private final Handler eventHandler;

        public AudioFocusListener(Handler eventHandler) {
            this.eventHandler = eventHandler;
        }

        public void onAudioFocusChange(int focusChange) {
            this.eventHandler.post(() -> AudioFocusManager.this.handlePlatformAudioFocusChange(focusChange));
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface AudioFocusState {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PlayerCommand {
    }
}

