/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.ads.freewheel;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.widget.FrameLayout;
import com.akamai.amp.ads.AdPosition;
import com.akamai.amp.ads.AdsCount;
import com.akamai.amp.ads.AdsInfo;
import com.akamai.amp.ads.IAdsComponentListener;
import com.akamai.amp.ads.bidder.AdsBidder;
import com.akamai.amp.ads.bidder.Bid;
import com.akamai.amp.ads.bidder.BidderCallback;
import com.akamai.amp.ads.freewheel.AdSlot;
import com.akamai.amp.ads.freewheel.AmpFreewheelManager;
import com.akamai.amp.ads.freewheel.FreewheelAdsInfo;
import com.akamai.amp.ads.freewheel.FreewheelUtils;
import com.akamai.amp.config.Config;
import com.akamai.amp.config.data.FreewheelData;
import com.akamai.amp.exoplayer2.util.Log;
import com.akamai.amp.media.IPlayerEventsListener;
import com.akamai.amp.media.Listeners;
import com.akamai.amp.media.PlayerEvents;
import com.akamai.amp.media.VideoPlayerContainer;
import com.akamai.amp.media.VideoPlayerView;
import com.akamai.amp.ui.UIEventsListener;
import com.akamai.amp.utils.LogManager;
import com.akamai.amp.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import tv.freewheel.ad.AdManager;
import tv.freewheel.ad.interfaces.IAdContext;
import tv.freewheel.ad.interfaces.IAdInstance;
import tv.freewheel.ad.interfaces.IAdManager;
import tv.freewheel.ad.interfaces.IConstants;
import tv.freewheel.ad.interfaces.ICreativeRendition;
import tv.freewheel.ad.interfaces.IEvent;
import tv.freewheel.ad.interfaces.IEventListener;
import tv.freewheel.ad.interfaces.ISlot;
import tv.freewheel.ad.request.config.AdRequestConfiguration;
import tv.freewheel.ad.request.config.KeyValueConfiguration;
import tv.freewheel.ad.request.config.SiteSectionConfiguration;
import tv.freewheel.ad.request.config.SlotConfiguration;
import tv.freewheel.ad.request.config.TemporalSlotConfiguration;
import tv.freewheel.ad.request.config.VideoAssetConfiguration;
import tv.freewheel.ad.request.config.utils.Size;
import tv.freewheel.extension.ExtensionManager;
import tv.freewheel.extension.IExtension;
import tv.freewheel.renderers.temporal.VideoAdView;
import tv.freewheel.utils.Logger;

public class FreewheelAdsHandler
extends FrameLayout
implements AmpFreewheelManager {
    private static final String TAG = FreewheelAdsHandler.class.getSimpleName();
    public static final String VERSION = "9.10.6";
    private static final String POPUP_TITLE = "Advertisement";
    private static final String POPUP_YES_BUTTON = "Yes";
    private static final String POPUP_NO_BUTTON = "No";
    private SurfaceView holderView;
    private VideoPlayerView videoView;
    private VideoPlayerContainer videoContainer;
    private Activity mActivity;
    private IAdManager fwAdm = null;
    private IAdContext fwContext = null;
    private IConstants fwConstants = null;
    private List<String> supportedEventNames = new ArrayList<String>();
    private ISlot currentSlot;
    private int fwNetworkId;
    private String fwAdsURL;
    private String fwProfile;
    private String fwSiteSectionId;
    private String fwVideoAssetId;
    private String warningMessage;
    private int currentPosition = 0;
    private boolean fwInitialSequenceCompleted = false;
    private boolean isInAdBreak = false;
    private boolean isAdPlaying = false;
    private boolean manualParameters = false;
    private boolean playBackFinished = false;
    private boolean isPopupVisible = false;
    private boolean isAdBuffering = false;
    private boolean isEventError = false;
    private boolean adsEnabled = true;
    private Listeners<IAdsComponentListener<FreewheelAdsInfo>> mListeners = new Listeners();
    private List<ISlot> fwPrerollSlots;
    private List<ISlot> fwPostrollSlots;
    private List<ISlot> fwPauseMidrollSlots;
    private List<AdSlot> adSlots;
    private Timer fwCuepointTimer = null;
    private boolean warnOnAdClick = false;
    private ISlot slotInterruptedByBrowser = null;
    private static final boolean AD_VISIBLE_VIDEO_GONE = true;
    private static final boolean VIDEO_VISIBLE_AD_GONE = false;
    private int previousPosition = -1;
    private int positionInAdBreak = 0;
    private int videoDuration = 0;
    private int currentTime = 0;
    private long updateRate = 1000L;
    private Handler mHandler = new Handler();
    private Runnable mRunnable;
    private FreewheelAdsInfo latestAdInfo;
    private List<Bid> adRequestParameters = new ArrayList<Bid>();
    private AdsBidder bidder;
    private boolean showProgressBarBetweenAds = true;
    boolean isResumingFromBackground = false;
    private Map<String, String> adRequestMetadata;
    private IEventListener iEventListener = new IEventListener(){

        public void run(IEvent event) {
            String eventType = event.getType();
            LogManager.log((String)TAG, (String)("Event type: " + eventType));
            if (eventType.equals(FreewheelAdsHandler.this.fwConstants.EVENT_REQUEST_COMPLETE())) {
                FreewheelAdsHandler.this.requestCompleteListener(event);
            } else if (eventType.equals(FreewheelAdsHandler.this.fwConstants.EVENT_SLOT_STARTED())) {
                FreewheelAdsHandler.this.isEventError = false;
                FreewheelAdsHandler.this.slotStartedListener(event);
            } else if (eventType.equals(FreewheelAdsHandler.this.fwConstants.EVENT_SLOT_ENDED())) {
                FreewheelAdsHandler.this.slotEndedListener(event);
            } else if (eventType.equals(FreewheelAdsHandler.this.fwConstants.EVENT_AD_IMPRESSION())) {
                FreewheelAdsHandler.this.isEventError = false;
                boolean result = FreewheelAdsHandler.this.adImpression(event);
                if (!result) {
                    FreewheelData freewheelData = new FreewheelData();
                    FreewheelAdsInfo adInfo = new FreewheelAdsInfo(freewheelData, null);
                    FreewheelAdsHandler.this.doListenerOnAdStarted(adInfo);
                }
            } else if (eventType.equals(FreewheelAdsHandler.this.fwConstants.EVENT_AD_IMPRESSION_END())) {
                FreewheelAdsHandler.this.adImpressionEnd();
            } else if (eventType.equals(FreewheelAdsHandler.this.fwConstants.EVENT_ERROR())) {
                FreewheelAdsHandler.this.isEventError = true;
                FreewheelAdsHandler.this.errorNotificationOnly(event);
            } else if (eventType.equals(FreewheelAdsHandler.this.fwConstants.EVENT_AD_BUFFERING_START())) {
                FreewheelAdsHandler.this.onAdBufferingStarted();
            } else if (eventType.equals(FreewheelAdsHandler.this.fwConstants.EVENT_AD_BUFFERING_END())) {
                FreewheelAdsHandler.this.onAdBufferingEnded();
            } else if (eventType.equals(FreewheelAdsHandler.this.fwConstants.EVENT_AD_RESUME())) {
                FreewheelAdsHandler.this.isResumingFromBackground = true;
                FreewheelAdsHandler.this.isEventError = false;
            }
        }
    };
    private BidderCallback bidderCallback = new BidderCallback(){

        public void setBidder(AdsBidder bidder) {
            LogManager.log((String)TAG, (String)("setBidder: " + bidder));
            FreewheelAdsHandler.this.bidder = bidder;
        }

        public void onBidsFound(List<Bid> bids) {
            LogManager.log((String)TAG, (String)("onBidsFound: " + bids));
            FreewheelAdsHandler.this.setRequestParameters(bids);
            FreewheelAdsHandler.this.checkInitialized();
            FreewheelAdsHandler.this.fireAdRequest();
            FreewheelAdsHandler.this.continueInitialization();
        }

        public void onBidsNotFound() {
            LogManager.log((String)TAG, (String)"onBidsNotFound");
            this.onBidsFound(null);
        }
    };
    private IPlayerEventsListener iPlayerEventsListener = new IPlayerEventsListener(){

        public boolean onPlayerEvent(int eventId) {
            if (FreewheelAdsHandler.this.messageHandler == null) {
                LogManager.error((String)TAG, (String)("onPlayerEvent() messageHandler is NULL, " + PlayerEvents.toString((int)eventId)));
                return false;
            }
            FreewheelAdsHandler.this.messageHandler.sendEmptyMessage(eventId);
            return true;
        }

        public boolean onPlayerExtendedEvent(int iInEventType, int arg1, int arg2) {
            return false;
        }
    };
    private UIEventsListener uiEventsListener = new UIEventsListener(){

        public void onScrubbingEnded() {
            if (FreewheelAdsHandler.this.videoView != null && FreewheelAdsHandler.this.videoView.getTimelineDuration() != FreewheelAdsHandler.this.videoView.getCurrentTimelinePosition()) {
                FreewheelAdsHandler.this.playSkippedMidroll();
            }
        }
    };
    private Handler messageHandler = new Handler(Looper.getMainLooper()){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 22: {
                    FreewheelAdsHandler.this.videoDuration = FreewheelAdsHandler.this.videoView.getMediaResource().getDuration();
                    if (FreewheelAdsHandler.this.videoDuration > 0 || FreewheelAdsHandler.this.adSlots != null) {
                        Log.d((String)TAG, (String)"video duration or ad slots were provided manually, ad initialization can start now");
                        FreewheelAdsHandler.this.checkInitialized();
                        break;
                    }
                    Log.d((String)TAG, (String)"video duration is not available yet, waiting for the player to extract it");
                    break;
                }
                case 3: {
                    FreewheelAdsHandler.this.checkInitialized();
                    break;
                }
                case 16: {
                    if (!FreewheelAdsHandler.this.fwInitialSequenceCompleted) break;
                    FreewheelAdsHandler.this.fwContext.setVideoState(IConstants.VideoState.PAUSED);
                    break;
                }
                case 15: {
                    if (!FreewheelAdsHandler.this.fwInitialSequenceCompleted) break;
                    FreewheelAdsHandler.this.fwContext.setVideoState(IConstants.VideoState.PLAYING);
                    break;
                }
                case 2: {
                    FreewheelAdsHandler.this.playBackFinished = true;
                    if (FreewheelAdsHandler.this.isInAdBreak) break;
                    FreewheelAdsHandler.this.videoCompleted();
                    break;
                }
                case 0: {
                    if (FreewheelAdsHandler.this.videoView.isSeeking()) break;
                    FreewheelAdsHandler.this.currentPosition = FreewheelAdsHandler.this.videoView.getCurrentStreamPosition() * 1000;
                    break;
                }
                case 23: {
                    FreewheelAdsHandler.this.onDestroy();
                    break;
                }
                case 1: {
                    FreewheelAdsHandler.this.isResumingFromBackground = false;
                }
            }
            super.handleMessage(msg);
        }
    };
    private static final Map<String, Class<? extends IExtension>> extensions = new HashMap<String, Class<? extends IExtension>>();

    private List<String> getSupportedEventNames(IConstants fwConstants) {
        List<String> eventNames = Arrays.asList(fwConstants.EVENT_REQUEST_COMPLETE(), fwConstants.EVENT_SLOT_STARTED(), fwConstants.EVENT_AD_IMPRESSION(), fwConstants.EVENT_AD_IMPRESSION_END(), fwConstants.EVENT_SLOT_ENDED(), fwConstants.EVENT_ERROR(), fwConstants.EVENT_AD_BUFFERING_START(), fwConstants.EVENT_AD_BUFFERING_END(), fwConstants.EVENT_AD_RESUME(), fwConstants.EVENT_ACTIVITY_STATE_CHANGED(), fwConstants.EVENT_AD_STARTED());
        return eventNames;
    }

    private void addEvents() {
        if (this.supportedEventNames == null) {
            return;
        }
        if (this.fwContext == null) {
            return;
        }
        for (String eventName : this.supportedEventNames) {
            this.fwContext.addEventListener(eventName, this.iEventListener);
        }
    }

    private void onAdBufferingStarted() {
        this.isAdBuffering = true;
        for (IAdsComponentListener listener : this.mListeners) {
            listener.onAdBufferingStarted();
        }
    }

    private void onAdBufferingEnded() {
        this.isAdBuffering = false;
        for (IAdsComponentListener listener : this.mListeners) {
            listener.onAdBufferingEnded();
        }
    }

    private Size getVideoDimensions() {
        Context context = this.getContext();
        int videoWidth = this.videoContainer.getWidth();
        int videoHeight = this.videoContainer.getHeight();
        if (context == null) {
            return null;
        }
        if (videoWidth == 0 || videoHeight == 0) {
            DisplayMetrics dm = new DisplayMetrics();
            WindowManager windowManager = (WindowManager)context.getSystemService("window");
            windowManager.getDefaultDisplay().getMetrics(dm);
            videoWidth = Math.round((float)dm.widthPixels / dm.density);
            videoHeight = Math.round((float)dm.heightPixels / dm.density);
        }
        return new Size(FreewheelUtils.convertPixelsToDp(videoWidth, context), FreewheelUtils.convertPixelsToDp(videoHeight, context));
    }

    public FreewheelAdsHandler(Context context, int networkId, String adsURL, String siteSectionId, String videoAssetId, String profile) {
        super(context);
        Utils.checkModuleVersion((String)TAG, (String)VERSION);
        this.mActivity = (Activity)context;
        this.fwNetworkId = networkId;
        this.fwAdsURL = adsURL;
        this.fwProfile = profile;
        this.fwSiteSectionId = siteSectionId;
        this.fwVideoAssetId = videoAssetId;
        this.manualParameters = true;
        this.createSurfaceView(context);
        this.showProgressBar(true);
        LogManager.log((String)TAG, (String)String.format("FreeWheel component created: networkId(%s) adsURL(%s) siteSectionId(%s) videoAssetId(%s) profile(%s)", networkId, adsURL, siteSectionId, videoAssetId, profile));
    }

    public FreewheelAdsHandler(Context context) {
        super(context);
        this.mActivity = (Activity)context;
        this.createSurfaceView(context);
        this.showProgressBar(true);
        LogManager.log((String)TAG, (String)String.format("FreeWheel component created: context(%s)", context));
    }

    public FreewheelAdsHandler(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.showProgressBar(true);
        LogManager.log((String)TAG, (String)String.format("FreeWheel component created: context(%s) AttributeSet(%s)", context, attrs));
    }

    public String getExternalLibVersion() {
        return "6.56.0-713707ee-202305032312";
    }

    @Override
    public String getAdsURL() {
        return this.fwAdsURL;
    }

    @Override
    public void setVideoDuration(int videoDurationInSeconds) {
        this.videoDuration = videoDurationInSeconds;
    }

    @Override
    public UIEventsListener getUIEventsListener() {
        return this.uiEventsListener;
    }

    @Override
    public BidderCallback getBidderCallback() {
        return this.bidderCallback;
    }

    public void setVideoPlayerContainer(VideoPlayerContainer param) {
        this.videoContainer = param;
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
        Utils.tryRemoveFromParent((View)this);
        LogManager.log((String)TAG, (String)("setVideoPlayerContainer LayoutParams: " + params.width + "x" + params.height));
        this.videoContainer.addView((View)this, (ViewGroup.LayoutParams)params);
    }

    public void setVideoPlayerView(VideoPlayerView param) {
        this.videoView = param;
        this.videoView.addEventsListener(this.iPlayerEventsListener);
        this.addEventsListener(this.videoView.getAdsComponentListener());
        this.setValuesFromConfig();
    }

    public void addEventsListener(IAdsComponentListener listener) {
        LogManager.log((String)TAG, (String)("addEventListener " + listener));
        if (listener == null) {
            return;
        }
        this.mListeners.add((Object)listener);
        listener.onListenerRegistered();
    }

    public void playWithServerAds(String assetKey) {
        this.throwIllegalMethodCall("playWithServerAds");
    }

    public void playWithServerAds(String vodContentSourceId, String videoId) {
        this.throwIllegalMethodCall("playWithServerAds");
    }

    public void setAdsUrl(String adsUrl) {
        this.throwIllegalMethodCall("setAdsUrl");
    }

    public void setURLSuffix(String manifestSuffix) {
        this.throwIllegalMethodCall("setURLSuffix");
    }

    @Override
    public void removeEventListener(IAdsComponentListener listener) {
        LogManager.log((String)TAG, (String)("removeEventListener: " + listener));
        this.mListeners.remove((Object)listener);
    }

    @Override
    public boolean isAdsEnabled() {
        return this.adsEnabled;
    }

    @Override
    public void setAdsEnabled(boolean adsEnabled) {
        this.adsEnabled = adsEnabled;
    }

    @Override
    public void warnOnAdClick(String message) {
        this.warningMessage = message;
        this.warnOnAdClick = true;
    }

    @Override
    public void setRequestParameters(List<Bid> params) {
        LogManager.log((String)TAG, (String)("setRequestParameters: " + params));
        this.adRequestParameters = params;
    }

    @Override
    public void addTemporalSlots(AdSlot ... slots) {
        this.adSlots = Arrays.asList(slots);
    }

    @Override
    public List<FreewheelAdsInfo> getCuePoints() {
        ArrayList<FreewheelAdsInfo> cuePoints = new ArrayList<FreewheelAdsInfo>();
        if (this.fwPauseMidrollSlots == null) {
            return cuePoints;
        }
        for (ISlot slot : this.fwPauseMidrollSlots) {
            FreewheelAdsInfo info = new FreewheelAdsInfo(new FreewheelData(), null);
            info.positionInStream = slot.getTimePosition();
            cuePoints.add(info);
        }
        return cuePoints;
    }

    @Override
    public void updateSlotsTimePosition() {
        this.destroyRunnable();
        this.mRunnable = new Runnable(){

            @Override
            public void run() {
                FreewheelAdsHandler.this.videoView.safeRun(new Runnable(){

                    @Override
                    public void run() {
                        FreewheelAdsHandler.this.updateTimer();
                        FreewheelAdsHandler.this.mHandler.postDelayed(FreewheelAdsHandler.this.mRunnable, FreewheelAdsHandler.this.updateRate);
                    }
                });
            }
        };
        this.mHandler.postDelayed(this.mRunnable, this.updateRate);
    }

    @Override
    public void onPause() {
        LogManager.log((String)TAG, (String)"onPause()");
        if (this.fwContext != null) {
            this.pauseAd();
            this.fwContext.setActivityState(IConstants.ActivityState.PAUSED);
        }
    }

    @Override
    public void onResume() {
        LogManager.log((String)TAG, (String)"onResume()");
        if (this.fwContext != null && !this.isPopupVisible) {
            this.resumeAd();
            this.fwContext.setActivityState(IConstants.ActivityState.RESUMED);
        }
    }

    @Override
    public void onStart() {
        LogManager.log((String)TAG, (String)"onStart()");
        if (this.fwContext != null) {
            this.fwContext.setActivityState(IConstants.ActivityState.STARTED);
        }
    }

    @Override
    public void onStop() {
        LogManager.log((String)TAG, (String)"onStop()");
        if (this.fwContext != null) {
            this.fwContext.setActivityState(IConstants.ActivityState.STOPPED);
        }
    }

    @Override
    public void onRestart() {
        LogManager.log((String)TAG, (String)"onRestart()");
        if (this.fwContext != null) {
            this.fwContext.setActivityState(IConstants.ActivityState.RESTARTED);
        }
    }

    public void onDestroy() {
        LogManager.log((String)TAG, (String)"onDestroy()");
        if (this.videoView != null) {
            this.videoView.removeEventsListener(this.iPlayerEventsListener);
        }
        this.destroyRunnable();
        if (this.fwContext != null) {
            AsyncTask.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (FreewheelAdsHandler.this.fwContext == null) {
                        return;
                    }
                    FreewheelAdsHandler.this.fwContext.dispose();
                    FreewheelAdsHandler.this.fwContext = null;
                }
            });
        }
    }

    public boolean getPlayButtonVisibilityOnAds() {
        this.invalid("getPlayButtonVisibilityOnAds");
        return false;
    }

    public boolean canPreparePlayback() {
        this.invalid("canPreparePlayback");
        return false;
    }

    public int getContentPosition(int streamPosition) {
        return streamPosition;
    }

    public int getStreamPosition(int contentPosition) {
        return contentPosition;
    }

    public int getContentDuration(int streamDuration) {
        return streamDuration;
    }

    public boolean isClientSideAds() {
        return true;
    }

    public boolean isServerSideAds() {
        return false;
    }

    private void createSurfaceView(Context context) {
        this.holderView = new SurfaceView((Context)this.mActivity);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
        LogManager.log((String)TAG, (String)("createSurfaceView LayoutParams: " + params.width + "x" + params.height));
        this.addView((View)this.holderView, (ViewGroup.LayoutParams)params);
    }

    private void playMainVideo() {
        LogManager.log((String)TAG, (String)"Starting main video");
        LogManager.log((String)TAG, (String)"video view playing main video");
        this.onContentResumeRequested();
    }

    private void setVisibilities(boolean isAdVisible) {
        this.setVisibility(isAdVisible ? 0 : 8);
        this.videoView.setVisibility(isAdVisible ? 8 : 0);
    }

    private void setValuesFromConfig() {
        Config c = Config.getConfig();
        if (!c.configLoaded) {
            return;
        }
        FreewheelData data = c.freewheelData;
        if (data == null) {
            return;
        }
        if (this.manualParameters) {
            return;
        }
        this.fwNetworkId = data.getFwNetworkId();
        this.fwAdsURL = data.getFwAdsURL();
        this.fwProfile = data.getFwProfile();
        this.fwSiteSectionId = data.getFwSiteSectionId();
        this.fwVideoAssetId = data.getFwVideoAssetId();
        this.adsEnabled = data.isFreewheelEnabled();
    }

    private void fireAdRequest() {
        if (this.videoContainer != null) {
            this.videoContainer.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    FreewheelAdsHandler.this.videoContainer.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    FreewheelAdsHandler.this.doAdRequest();
                }
            });
        } else {
            this.doAdRequest();
        }
    }

    private void doAdRequest() {
        LogManager.log((String)TAG, (String)"submitting Ad Request");
        String slotType = "";
        Size dimensions = this.getVideoDimensions();
        AdRequestConfiguration fwAdRequestConfiguration = dimensions == null ? new AdRequestConfiguration(this.fwAdsURL, this.fwProfile) : new AdRequestConfiguration(this.fwAdsURL, this.fwProfile, dimensions);
        this.setRequestConfigParams(fwAdRequestConfiguration, this.adRequestParameters);
        SiteSectionConfiguration fwSiteSectionConfiguration = new SiteSectionConfiguration(this.fwSiteSectionId, IConstants.IdType.CUSTOM);
        fwAdRequestConfiguration.setSiteSectionConfiguration(fwSiteSectionConfiguration);
        VideoAssetConfiguration fwVideoAssetConfiguration = new VideoAssetConfiguration(this.fwVideoAssetId, IConstants.IdType.CUSTOM, this.videoDuration > 0 ? (double)this.videoDuration : (double)this.videoView.getTimelineDuration(), IConstants.VideoAssetDurationType.EXACT, IConstants.VideoAssetAutoPlayType.ATTENDED);
        fwAdRequestConfiguration.setVideoAssetConfiguration(fwVideoAssetConfiguration);
        this.addMetadata(fwAdRequestConfiguration);
        this.addTemporalSlots(slotType, fwAdRequestConfiguration);
        if (this.fwContext == null) {
            LogManager.error((String)TAG, (String)"Freewheel context is not initialized, Ad request aborted");
            return;
        }
        this.fwContext.setActivity(this.mActivity);
        FrameLayout parent = (FrameLayout)this.holderView.getParent();
        this.fwContext.registerVideoDisplayBase(parent);
        if (this.warnOnAdClick) {
            this.fwContext.setParameter(this.fwConstants.PARAMETER_CLICK_DETECTION(), (Object)"false", IConstants.ParameterLevel.GLOBAL);
        }
        this.isResumingFromBackground = false;
        this.addEvents();
        this.fwContext.submitRequestWithConfiguration(fwAdRequestConfiguration, 10.0);
    }

    private void addMetadata(AdRequestConfiguration config) {
        if (this.adRequestMetadata == null) {
            return;
        }
        for (String key : this.adRequestMetadata.keySet()) {
            String value = this.adRequestMetadata.get(key);
            KeyValueConfiguration entry = new KeyValueConfiguration(key, value);
            config.addKeyValueConfiguration(entry);
        }
    }

    private void addTemporalSlots(String slotType, AdRequestConfiguration fwAdRequestConfiguration) {
        if (this.adSlots != null) {
            for (AdSlot slot : this.adSlots) {
                switch (slot.getType()) {
                    case "preroll": {
                        slotType = this.fwConstants.ADUNIT_PREROLL();
                        break;
                    }
                    case "postroll": {
                        slotType = this.fwConstants.ADUNIT_POSTROLL();
                        break;
                    }
                    case "midroll": {
                        slotType = this.fwConstants.ADUNIT_MIDROLL();
                    }
                }
                TemporalSlotConfiguration slotConfiguration = new TemporalSlotConfiguration(slot.getName(), slotType, (double)slot.getTime());
                fwAdRequestConfiguration.addSlotConfiguration((SlotConfiguration)slotConfiguration);
            }
        }
    }

    private void setRequestConfigParams(AdRequestConfiguration config, List<Bid> params) {
        if (config == null) {
            return;
        }
        if (params == null) {
            return;
        }
        for (Bid bid : params) {
            String bidKey = bid.getKey();
            String bidValue = bid.getValue();
            KeyValueConfiguration keyValue = new KeyValueConfiguration(bidKey, bidValue);
            config.addKeyValueConfiguration(keyValue);
            LogManager.log((String)TAG, (String)("setRequestConfigParams: " + bidKey + ", " + bidValue));
        }
    }

    private boolean adImpression(IEvent e) {
        LogManager.log((String)TAG, (String)"adImpression");
        this.currentTime = 0;
        this.showProgressBar(false);
        if (e == null) {
            return false;
        }
        HashMap data = e.getData();
        if (data == null) {
            return false;
        }
        Object value = data.get(this.fwConstants.INFO_KEY_SLOT_CUSTOM_ID());
        if (value == null) {
            return false;
        }
        String customId = (String)value;
        ISlot slot = this.fwContext.getSlotByCustomId(customId);
        if (slot == null) {
            return false;
        }
        Object adIdObject = data.get(this.fwConstants.INFO_KEY_AD_ID());
        if (adIdObject == null) {
            return false;
        }
        int adId = (Integer)adIdObject;
        return this.reportAdStarted(slot, adId);
    }

    private boolean reportAdStarted(ISlot slot, int adId) {
        LogManager.log((String)TAG, (String)("reportAdStarted() " + ISlot.class.getCanonicalName() + " width and height: " + slot.getWidth() + " x " + slot.getHeight()));
        List adInstances = slot.getAdInstances();
        int size = adInstances.size();
        int finalSize = Math.max(size, 1);
        boolean result = true;
        for (IAdInstance adInstance : adInstances) {
            this.logCreativeRendition(adInstance.getActiveCreativeRendition());
            boolean isThisAd = adInstance.getAdId() == adId;
            if (!isThisAd) continue;
            result = result && this.onAdStarted(slot, finalSize, adInstance);
        }
        return result;
    }

    private void logCreativeRendition(ICreativeRendition rendition) {
        if (rendition == null) {
            return;
        }
        LogManager.log((String)TAG, (String)("reportAdStarted() " + ICreativeRendition.class.getCanonicalName() + " width and height: " + rendition.getWidth() + " x " + rendition.getHeight()));
    }

    private boolean onAdStarted(ISlot slot, int adBreakTotal, IAdInstance adInstance) {
        FreewheelAdsInfo adInfo = this.getAdInfo(slot, adInstance, adBreakTotal);
        this.updateSlotsTimePosition();
        this.doListenerOnAdStarted(adInfo);
        this.addOnClickListener(adInstance, slot);
        LogManager.log((String)TAG, (String)("onAdStarted " + adInfo.adPosition));
        return true;
    }

    private void doListenerOnAdStarted(FreewheelAdsInfo adInfo) {
        this.isAdPlaying = true;
        if (this.showProgressBarBetweenAds) {
            this.showProgressBar(false);
        }
        for (IAdsComponentListener listener : this.mListeners) {
            listener.onAdsStarted((AdsInfo)adInfo);
        }
    }

    private void addOnClickListener(final IAdInstance ad, final ISlot playingSlot) {
        this.getAdViewOrThis().setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent motionEvent) {
                if (motionEvent.getAction() == 0) {
                    FreewheelAdsHandler.this.onAdTapped();
                    if (FreewheelAdsHandler.this.warnOnAdClick) {
                        FreewheelAdsHandler.this.showPopup(playingSlot, ad);
                    }
                }
                return false;
            }
        });
    }

    private void showPopup(ISlot playingSlot, IAdInstance ad) {
        playingSlot.pause();
        this.slotInterruptedByBrowser = playingSlot;
        this.showExternalAdPopup(ad);
        this.isPopupVisible = true;
    }

    private void onAdTapped() {
        LogManager.log((String)TAG, (String)"onAdTapped");
        for (IAdsComponentListener listener : this.mListeners) {
            listener.onAdsTapped();
        }
    }

    private void onResumeContentRequested() {
        for (IAdsComponentListener listener : this.mListeners) {
            listener.onResumeContentRequested();
        }
    }

    private void onPauseContentRequested() {
        for (IAdsComponentListener listener : this.mListeners) {
            listener.onPauseContentRequested();
        }
    }

    private View getAdViewOrThis() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            if (!(child instanceof VideoAdView)) continue;
            return child;
        }
        return this;
    }

    private void showExternalAdPopup(final IAdInstance ad) {
        AlertDialog.Builder dialogBuilder = new AlertDialog.Builder(this.videoView.getContext());
        dialogBuilder.setTitle((CharSequence)POPUP_TITLE);
        dialogBuilder.setMessage((CharSequence)this.warningMessage);
        dialogBuilder.setIcon(17301659);
        dialogBuilder.setPositiveButton((CharSequence)POPUP_YES_BUTTON, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                ad.getRendererController().processEvent(FreewheelAdsHandler.this.fwConstants.EVENT_AD_CLICK());
                FreewheelAdsHandler.this.isPopupVisible = false;
            }
        });
        dialogBuilder.setNegativeButton((CharSequence)POPUP_NO_BUTTON, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                FreewheelAdsHandler.this.isPopupVisible = false;
                FreewheelAdsHandler.this.checkResumeSlotInterruptedByBrowser();
            }
        });
        AlertDialog alertDialog = dialogBuilder.create();
        alertDialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialogInterface) {
                FreewheelAdsHandler.this.checkResumeSlotInterruptedByBrowser();
                FreewheelAdsHandler.this.isPopupVisible = false;
            }
        });
        alertDialog.setCanceledOnTouchOutside(true);
        alertDialog.show();
    }

    private void checkResumeSlotInterruptedByBrowser() {
        if (this.slotInterruptedByBrowser == null) {
            return;
        }
        this.slotInterruptedByBrowser.resume();
        this.slotInterruptedByBrowser = null;
    }

    private void adImpressionEnd() {
        LogManager.log((String)TAG, (String)"adImpressionEnd");
        this.isAdPlaying = false;
        if (this.showProgressBarBetweenAds) {
            this.showProgressBar(true);
        }
        for (IAdsComponentListener listener : this.mListeners) {
            listener.onAdsEnded();
        }
        if (this.latestAdInfo != null) {
            this.playNextAd(this.latestAdInfo.adPosition);
        }
    }

    private void playNextAd(AdPosition position) {
        switch (position) {
            case PREROLL: {
                this.playNextPreroll();
                break;
            }
            case MIDROLL: {
                this.playNextMidroll();
                break;
            }
            case POSTROLL: {
                this.playNextPostroll();
            }
        }
    }

    private void handleAdManagerRequestComplete() {
        LogManager.log((String)TAG, (String)"handleAdManagerRequestComplete");
        this.fwPrerollSlots = this.getSlotsByTimePositionClass(IConstants.TimePositionClass.PREROLL);
        this.fwPauseMidrollSlots = this.getSlotsByTimePositionClass(IConstants.TimePositionClass.MIDROLL);
        this.fwPostrollSlots = this.getSlotsByTimePositionClass(IConstants.TimePositionClass.POSTROLL);
        LogManager.log((String)TAG, (String)String.format("FREEWHEEL found: prerolls(%d) midrolls(%d) postrolls(%d)", this.fwPrerollSlots.size(), this.fwPauseMidrollSlots.size(), this.fwPostrollSlots.size()));
        AdsCount adsCount = new AdsCount(this.fwPrerollSlots.size(), this.fwPauseMidrollSlots.size(), this.fwPostrollSlots.size());
        for (IAdsComponentListener listener : this.mListeners) {
            listener.onAdsLoaded(adsCount);
        }
        new Handler(this.mActivity.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                FreewheelAdsHandler.this.playNextPreroll();
            }
        });
        this.playNextMidroll();
    }

    private void printTimes(List<ISlot> fwPauseMidrollSlots) {
        for (ISlot slot : fwPauseMidrollSlots) {
            double timePosition = slot.getTimePosition();
            double endTimePosition = slot.getEndTimePosition();
            LogManager.error((String)TAG, (String)(timePosition + " to " + endTimePosition));
        }
    }

    private List<ISlot> getSlotsByTimePositionClass(IConstants.TimePositionClass timePositionClass) {
        List slotsByTimePositionClass = this.fwContext.getSlotsByTimePositionClass(timePositionClass);
        return Collections.synchronizedList(slotsByTimePositionClass);
    }

    private void playNextPreroll() {
        if (this.fwPrerollSlots != null) {
            if (this.fwPrerollSlots.size() > 0) {
                this.currentSlot = this.fwPrerollSlots.remove(0);
                if (this.currentSlot == null) {
                    LogManager.error((String)TAG, (String)"currentSlot is NULL");
                    return;
                }
                LogManager.log((String)TAG, (String)("Playing preroll slot: " + this.currentSlot.getCustomId()));
                this.currentPosition = 0;
                this.currentSlot.play();
            } else {
                LogManager.log((String)TAG, (String)"Finished all prerolls. Starting main content.");
                this.playMainVideo();
            }
        } else {
            this.playMainVideo();
        }
    }

    private void playNextPostroll() {
        if (this.fwPostrollSlots != null) {
            int size = this.fwPostrollSlots.size();
            LogManager.log((String)TAG, (String)("Postrolls found: " + size));
            if (size > 0) {
                this.currentSlot = this.fwPostrollSlots.remove(0);
                LogManager.log((String)TAG, (String)("Playing Postrolls slot: " + this.currentSlot.getCustomId()));
                this.currentPosition = 0;
                this.currentSlot.play();
            } else {
                LogManager.log((String)TAG, (String)"Finished all Postrolls.");
                this.setVisibility(4);
                this.fwContext.setVideoState(IConstants.VideoState.COMPLETED);
                this.showFreewheelsPlayer(false);
            }
        }
    }

    private void showFreewheelsPlayer(boolean showFreewheelsView) {
        this.showProgressBar(showFreewheelsView);
        this.setVisibilities(showFreewheelsView);
    }

    private void playNextMidroll() {
        boolean hasMidrollsInitial;
        boolean bl = hasMidrollsInitial = this.fwPauseMidrollSlots != null && this.fwPauseMidrollSlots.size() > 0;
        if (hasMidrollsInitial) {
            LogManager.log((String)TAG, (String)"Start midroll/overlay timer");
            this.fwCuepointTimer = new Timer();
            this.fwCuepointTimer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    boolean hasMidrolls;
                    boolean bl = hasMidrolls = FreewheelAdsHandler.this.fwPauseMidrollSlots != null && FreewheelAdsHandler.this.fwPauseMidrollSlots.size() > 0;
                    if (hasMidrolls) {
                        FreewheelAdsHandler.this.videoView.safeRun(new Runnable(){

                            @Override
                            public void run() {
                                FreewheelAdsHandler.this.playMidroll();
                            }
                        });
                    }
                }
            }, 500L, 500L);
        }
    }

    private void playMidroll() {
        int i = 0;
        if (this.fwPauseMidrollSlots != null) {
            for (i = 0; i < this.fwPauseMidrollSlots.size(); ++i) {
                double diff;
                ISlot slot = this.fwPauseMidrollSlots.get(i);
                int currentPosition = this.videoView.getCurrentStreamPosition() * 1000;
                int slotTimePosition = (int)slot.getTimePosition() * 1000;
                double d = diff = slotTimePosition > currentPosition ? (double)(slotTimePosition - currentPosition) : (double)(currentPosition - slotTimePosition);
                if (!(diff <= 1000.0)) continue;
                LogManager.log((String)TAG, (String)("Playing midroll or overlay slot:" + slot.getCustomId()));
                break;
            }
            if (i == this.fwPauseMidrollSlots.size()) {
                return;
            }
        }
        final int index = i;
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                if (FreewheelAdsHandler.this.fwPauseMidrollSlots == null || FreewheelAdsHandler.this.fwPauseMidrollSlots.size() <= index) {
                    return;
                }
                FreewheelAdsHandler.this.currentSlot = (ISlot)FreewheelAdsHandler.this.fwPauseMidrollSlots.get(index);
                FreewheelAdsHandler.this.fwPauseMidrollSlots.remove(index);
                LogManager.error((String)TAG, (String)("fwPauseMidrollSlots.remove " + FreewheelAdsHandler.this.currentSlot.getCustomId()));
                FreewheelAdsHandler.this.onContentPauseRequested();
                FreewheelAdsHandler.this.currentPosition = 0;
                FreewheelAdsHandler.this.currentSlot.play();
            }
        });
    }

    private void checkInitialized() {
        if (!this.adsEnabled) {
            LogManager.error((String)TAG, (String)"Ads marked as disabled, Freewheel was not initialized");
            return;
        }
        if (this.bidder != null) {
            this.initialize();
        } else if (!this.fwInitialSequenceCompleted) {
            this.initialize();
            this.fireAdRequest();
            this.continueInitialization();
        }
    }

    private void initialize() {
        if (this.fwContext != null) {
            LogManager.log((String)TAG, (String)"Freewheel context already instantiated");
            return;
        }
        this.showFreewheelsPlayer(true);
        LogManager.log((String)TAG, (String)"Loading AdManager");
        this.fwAdm = AdManager.getInstance((Context)this.getContext());
        this.fwAdm.setNetwork(this.fwNetworkId);
        this.fwContext = this.fwAdm.newContext();
        this.fwConstants = this.fwContext.getConstants();
        this.supportedEventNames = this.getSupportedEventNames(this.fwConstants);
        this.initExtensions();
    }

    private void continueInitialization() {
        this.fwContext.setVideoState(IConstants.VideoState.PLAYING);
        this.videoView.signalLogicalPause();
        this.videoView.pause();
        this.fwContext.setVideoState(IConstants.VideoState.PAUSED);
        this.fwInitialSequenceCompleted = true;
    }

    private void playSkippedMidroll() {
        final int positionAfterSeek = this.videoView.getCurrentStreamPosition() * 1000;
        if (this.currentPosition < positionAfterSeek) {
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    if (FreewheelAdsHandler.this.fwPauseMidrollSlots == null) {
                        return;
                    }
                    for (int count = FreewheelAdsHandler.this.fwPauseMidrollSlots.size() - 1; count >= 0; --count) {
                        ISlot slotToPlay = (ISlot)FreewheelAdsHandler.this.fwPauseMidrollSlots.get(count);
                        int slotTimePosition = (int)slotToPlay.getTimePosition() * 1000;
                        if (positionAfterSeek <= slotTimePosition || FreewheelAdsHandler.this.currentPosition >= slotTimePosition) continue;
                        FreewheelAdsHandler.this.playSlot(slotToPlay, count);
                        break;
                    }
                }
            });
        }
    }

    private void playSlot(ISlot slotToPlay, int count) {
        LogManager.log((String)TAG, (String)(slotToPlay.getCustomId() + ""));
        this.currentSlot = slotToPlay;
        if (this.fwPauseMidrollSlots != null) {
            this.fwPauseMidrollSlots.remove(count);
        }
        this.onContentPauseRequested();
        this.currentPosition = 0;
        this.currentSlot.play();
    }

    private void slotStartedListener(IEvent event) {
        LogManager.log((String)TAG, (String)"slot started listener");
        this.isInAdBreak = true;
        this.positionInAdBreak = 0;
        this.showProgressBar(true);
        for (IAdsComponentListener listener : this.mListeners) {
            listener.onAdBreakStarted();
        }
    }

    private void updateTimer() {
        if (!this.isAdPlaying || this.videoView.isInBackground()) {
            return;
        }
        if (this.isAdBuffering) {
            LogManager.log((String)TAG, (String)"Ad is BUFFERING, the ad playhead is NOT being updated");
            return;
        }
        if (this.isResumingFromBackground) {
            LogManager.log((String)TAG, (String)"previousEventIsAdResume, the ad playhead is NOT being updated");
            return;
        }
        if (this.isEventError) {
            LogManager.log((String)TAG, (String)"isEventError, the ad playhead is NOT being updated");
            return;
        }
        for (IAdsComponentListener listener : this.mListeners) {
            listener.onAdsPlayheadUpdate(this.currentTime);
        }
        ++this.currentTime;
    }

    private void destroyRunnable() {
        if (this.mHandler != null && this.mRunnable != null) {
            this.mHandler.removeCallbacks(this.mRunnable);
            this.mRunnable = null;
        }
    }

    private void slotEndedListener(IEvent event) {
        boolean isPostroll;
        LogManager.log((String)TAG, (String)"slot ended listener");
        this.isInAdBreak = false;
        this.positionInAdBreak = 0;
        this.destroyRunnable();
        this.showProgressBar(false);
        for (IAdsComponentListener listener : this.mListeners) {
            listener.onAdBreakEnded();
        }
        boolean bl = isPostroll = this.latestAdInfo != null && this.latestAdInfo.isPostroll();
        if (isPostroll) {
            for (IAdsComponentListener listener : this.mListeners) {
                listener.onAllPostrollsEnded();
            }
        } else {
            this.onContentResumeRequested();
        }
    }

    private void requestCompleteListener(IEvent event) {
        String eType = event.getType();
        String eSuccess = event.getData().get(this.fwConstants.INFO_KEY_SUCCESS()).toString();
        if (this.fwConstants.EVENT_REQUEST_COMPLETE().equals(eType) && Boolean.valueOf(eSuccess).booleanValue()) {
            LogManager.log((String)TAG, (String)"Request completed successfully");
            this.handleAdManagerRequestComplete();
        } else {
            String message = event.getData().get(this.fwConstants.INFO_KEY_MESSAGE()).toString();
            this.onError(message);
        }
    }

    private void onError(String message) {
        this.notifyAdError(message);
        LogManager.log((String)TAG, (String)"Request failed. Playing main content.");
        this.playMainVideo();
    }

    private void notifyAdError(String message) {
        for (IAdsComponentListener listener : this.mListeners) {
            listener.onAdsError("Request failed: " + message);
        }
        LogManager.error((String)TAG, (String)message);
    }

    private void errorNotificationOnly(IEvent event) {
        this.isAdBuffering = false;
        HashMap data = event.getData();
        String message = data == null ? "" : " " + data;
        this.notifyAdError("EVENT_ERROR" + message);
    }

    private void onContentPauseRequested() {
        this.onPauseContentRequested();
        this.setVisibilities(true);
        this.videoView.signalLogicalPause();
        this.videoView.pause();
    }

    private void onContentResumeRequested() {
        this.showFreewheelsPlayer(false);
        if (this.videoView != null && !this.playBackFinished) {
            this.onResumeContentRequested();
            this.videoView.signalLogicalResume();
            this.videoView.bringToFront();
            this.videoView.resume();
        } else {
            this.videoCompleted();
        }
    }

    private FreewheelAdsInfo getAdInfo(ISlot currentSlot, IAdInstance adInstance, int adBreakTotal) {
        FreewheelData freewheelData = new FreewheelData();
        FreewheelAdsInfo adsInfo = new FreewheelAdsInfo(freewheelData, adInstance);
        if (currentSlot != null) {
            adsInfo.name = currentSlot.getCustomId();
            adsInfo.positionInStream = currentSlot.getTimePosition();
            adsInfo.adPosition = this.convertTimePosition(currentSlot.getSlotTimePositionClass());
        }
        if (adInstance != null) {
            adsInfo.adId = this.getAdId(adInstance);
            double duration = adInstance.getDuration();
            adsInfo.lengthInSeconds = (int)duration;
        }
        adsInfo.adBreakTotal = adBreakTotal;
        adsInfo.positionInAdBreak = ++this.positionInAdBreak;
        LogManager.log((String)TAG, (String)("Created FreewheelAdsInfo: " + (Object)((Object)adsInfo)));
        this.latestAdInfo = adsInfo;
        return adsInfo;
    }

    private String getAdId(IAdInstance adInstance) {
        ICreativeRendition activeCreativeRendition = adInstance.getActiveCreativeRendition();
        if (activeCreativeRendition != null) {
            String result = String.valueOf(activeCreativeRendition.getId());
            return result;
        }
        String result = "AD_" + System.currentTimeMillis();
        return result;
    }

    private AdPosition convertTimePosition(IConstants.TimePositionClass timePositionId) {
        if (timePositionId == IConstants.TimePositionClass.PREROLL) {
            return AdPosition.PREROLL;
        }
        if (timePositionId == IConstants.TimePositionClass.POSTROLL) {
            return AdPosition.POSTROLL;
        }
        return AdPosition.MIDROLL;
    }

    private void videoCompleted() {
        if (this.fwInitialSequenceCompleted) {
            if (this.fwContext == null) {
                this.onDestroy();
                return;
            }
            this.fwContext.setVideoState(IConstants.VideoState.COMPLETED);
        }
        if (this.fwCuepointTimer != null) {
            this.fwCuepointTimer.cancel();
            this.fwCuepointTimer = null;
        }
        this.setVisibilities(true);
        if (this.fwPauseMidrollSlots != null && this.fwPauseMidrollSlots.size() > 0) {
            this.fwPauseMidrollSlots.removeAll(this.fwPauseMidrollSlots);
        }
        this.playNextPostroll();
    }

    private void showProgressBar(boolean show) {
        View progressBar;
        if (this.videoView != null && (progressBar = this.videoView.getProgressBarControl()) != null) {
            if (show && !this.videoView.isFinished()) {
                progressBar.setVisibility(0);
            } else {
                progressBar.setVisibility(8);
            }
        }
    }

    private void pauseAd() {
        if (this.isInAdBreak) {
            this.currentSlot.pause();
            this.destroyRunnable();
            for (IAdsComponentListener listener : this.mListeners) {
                listener.onAdsPaused();
            }
        }
    }

    private void resumeAd() {
        if (this.isInAdBreak) {
            this.currentSlot.resume();
            for (IAdsComponentListener listener : this.mListeners) {
                listener.onAdsResumed();
            }
            this.updateSlotsTimePosition();
        }
    }

    private void invalid(String invokingMethod) {
        LogManager.log((String)TAG, (String)(invokingMethod + " invalid on Freewheel"));
    }

    private void throwIllegalMethodCall(String invokingMethod) {
        throw new IllegalStateException(invokingMethod + "() is not meant to be used with Freewheel");
    }

    @Override
    public void setExternalLogLevel(int logLevel) {
        Logger.setLogLevel((int)logLevel);
    }

    @Override
    public void showProgressBarBetweenAds() {
        this.showProgressBarBetweenAds = true;
    }

    @Override
    public void hideProgressBarBetweenAds() {
        this.showProgressBarBetweenAds = false;
    }

    public void doProxyInit() {
    }

    public void doSessionInit() {
    }

    public void doProxyInit(int debugFlags) {
    }

    public void doSessionInit(int debugFlags) {
    }

    @Override
    public void setAdRequestMetadata(Map<String, String> data) {
        this.adRequestMetadata = data;
    }

    @Override
    public IAdContext getFwContext() {
        return this.fwContext;
    }

    @Override
    public void addExtension(String extensionName, Class<? extends IExtension> extensionClass) {
        extensions.put(extensionName, extensionClass);
    }

    private void initExtensions() {
        for (String extensionName : extensions.keySet()) {
            Class<? extends IExtension> extensionClass = extensions.get(extensionName);
            this.initExtension(extensionName, extensionClass);
        }
    }

    private void initExtension(String extensionName, Class<? extends IExtension> extensionClass) {
        this.registerExtension(extensionName, extensionClass);
        this.loadExtension(extensionName);
    }

    private void registerExtension(String extensionName, Class<? extends IExtension> extensionClass) {
        ExtensionManager.registerExtension((String)extensionName, extensionClass);
        LogManager.log((String)TAG, (String)("ExtensionManager.registerExtension(" + extensionName + ") " + extensionClass));
    }

    private void loadExtension(String extensionName) {
        if (this.fwContext == null) {
            return;
        }
        this.fwContext.loadExtension(extensionName);
        LogManager.log((String)TAG, (String)("fwContext.loadExtension(" + extensionName + ")"));
    }
}

