/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.parser.config;

import com.akamai.amp.config.data.heartbeat.HeartbeatConfigurationData;
import com.akamai.amp.parser.utils.UtilsParser;
import org.json.JSONObject;

public class HeartbeatParser {
    public static final String OMNITURE_OBJ_TAG = "omniture";
    public static final String HEARTBEAT_OBJ_TAG = "heartbeat";

    public HeartbeatConfigurationData buildHeartbeatData(JSONObject root) {
        HeartbeatConfigurationData data = new HeartbeatConfigurationData();
        JSONObject omni = UtilsParser.getObj(OMNITURE_OBJ_TAG, root);
        if (omni == null) {
            return data;
        }
        JSONObject config = UtilsParser.getObj(HEARTBEAT_OBJ_TAG, omni);
        if (config == null) {
            return data;
        }
        data.setTrackingServer(UtilsParser.getValue("trackingServer", config));
        data.setPublisher(UtilsParser.getValue("publisher", config));
        data.setChannel(UtilsParser.getValue("channel", config));
        data.setOvp(UtilsParser.getValue("ovp", config));
        data.setAudienceManagerDpid(UtilsParser.getValue("audience-manager-dpid", config));
        data.setAudienceManagerDpuuid(UtilsParser.getValue("audience-manager-dpuuid", config));
        data.setAdobeUserId(UtilsParser.getValue("adobe-userid", config));
        return data;
    }
}

