/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.source.chunk;

import android.util.SparseArray;
import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.Format;
import com.akamai.amp.exoplayer2.extractor.ChunkIndex;
import com.akamai.amp.exoplayer2.extractor.DummyTrackOutput;
import com.akamai.amp.exoplayer2.extractor.Extractor;
import com.akamai.amp.exoplayer2.extractor.ExtractorInput;
import com.akamai.amp.exoplayer2.extractor.ExtractorOutput;
import com.akamai.amp.exoplayer2.extractor.PositionHolder;
import com.akamai.amp.exoplayer2.extractor.SeekMap;
import com.akamai.amp.exoplayer2.extractor.TrackOutput;
import com.akamai.amp.exoplayer2.source.chunk.ChunkExtractor;
import com.akamai.amp.exoplayer2.upstream.DataReader;
import com.akamai.amp.exoplayer2.util.Assertions;
import com.akamai.amp.exoplayer2.util.ParsableByteArray;
import com.akamai.amp.exoplayer2.util.Util;
import java.io.IOException;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public final class BundledChunkExtractor
implements ExtractorOutput,
ChunkExtractor {
    private static final PositionHolder POSITION_HOLDER = new PositionHolder();
    private final Extractor extractor;
    private final int primaryTrackType;
    private final Format primaryTrackManifestFormat;
    private final SparseArray<BindingTrackOutput> bindingTrackOutputs;
    private boolean extractorInitialized;
    @Nullable
    private ChunkExtractor.TrackOutputProvider trackOutputProvider;
    private long endTimeUs;
    private @MonotonicNonNull SeekMap seekMap;
    private Format @MonotonicNonNull [] sampleFormats;

    public BundledChunkExtractor(Extractor extractor, int primaryTrackType, Format primaryTrackManifestFormat) {
        this.extractor = extractor;
        this.primaryTrackType = primaryTrackType;
        this.primaryTrackManifestFormat = primaryTrackManifestFormat;
        this.bindingTrackOutputs = new SparseArray();
    }

    @Override
    @Nullable
    public ChunkIndex getChunkIndex() {
        return this.seekMap instanceof ChunkIndex ? (ChunkIndex)this.seekMap : null;
    }

    @Override
    @Nullable
    public Format[] getSampleFormats() {
        return this.sampleFormats;
    }

    @Override
    public void init(@Nullable ChunkExtractor.TrackOutputProvider trackOutputProvider, long startTimeUs, long endTimeUs) {
        this.trackOutputProvider = trackOutputProvider;
        this.endTimeUs = endTimeUs;
        if (!this.extractorInitialized) {
            this.extractor.init(this);
            if (startTimeUs != -9223372036854775807L) {
                this.extractor.seek(0L, startTimeUs);
            }
            this.extractorInitialized = true;
        } else {
            this.extractor.seek(0L, startTimeUs == -9223372036854775807L ? 0L : startTimeUs);
            for (int i = 0; i < this.bindingTrackOutputs.size(); ++i) {
                ((BindingTrackOutput)this.bindingTrackOutputs.valueAt(i)).bind(trackOutputProvider, endTimeUs);
            }
        }
    }

    @Override
    public void release() {
        this.extractor.release();
    }

    @Override
    public boolean read(ExtractorInput input) throws IOException {
        int result = this.extractor.read(input, POSITION_HOLDER);
        Assertions.checkState(result != 1);
        return result == 0;
    }

    @Override
    public TrackOutput track(int id, int type) {
        BindingTrackOutput bindingTrackOutput = (BindingTrackOutput)this.bindingTrackOutputs.get(id);
        if (bindingTrackOutput == null) {
            Assertions.checkState(this.sampleFormats == null);
            bindingTrackOutput = new BindingTrackOutput(id, type, type == this.primaryTrackType ? this.primaryTrackManifestFormat : null);
            bindingTrackOutput.bind(this.trackOutputProvider, this.endTimeUs);
            this.bindingTrackOutputs.put(id, (Object)bindingTrackOutput);
        }
        return bindingTrackOutput;
    }

    @Override
    public void endTracks() {
        Format[] sampleFormats = new Format[this.bindingTrackOutputs.size()];
        for (int i = 0; i < this.bindingTrackOutputs.size(); ++i) {
            sampleFormats[i] = Assertions.checkStateNotNull(((BindingTrackOutput)this.bindingTrackOutputs.valueAt((int)i)).sampleFormat);
        }
        this.sampleFormats = sampleFormats;
    }

    @Override
    public void seekMap(SeekMap seekMap) {
        this.seekMap = seekMap;
    }

    private static final class BindingTrackOutput
    implements TrackOutput {
        private final int id;
        private final int type;
        @Nullable
        private final Format manifestFormat;
        private final DummyTrackOutput fakeTrackOutput;
        public @MonotonicNonNull Format sampleFormat;
        private @MonotonicNonNull TrackOutput trackOutput;
        private long endTimeUs;

        public BindingTrackOutput(int id, int type, @Nullable Format manifestFormat) {
            this.id = id;
            this.type = type;
            this.manifestFormat = manifestFormat;
            this.fakeTrackOutput = new DummyTrackOutput();
        }

        public void bind(@Nullable ChunkExtractor.TrackOutputProvider trackOutputProvider, long endTimeUs) {
            if (trackOutputProvider == null) {
                this.trackOutput = this.fakeTrackOutput;
                return;
            }
            this.endTimeUs = endTimeUs;
            this.trackOutput = trackOutputProvider.track(this.id, this.type);
            if (this.sampleFormat != null) {
                this.trackOutput.format(this.sampleFormat);
            }
        }

        @Override
        public void format(Format format) {
            this.sampleFormat = this.manifestFormat != null ? format.withManifestFormatInfo(this.manifestFormat) : format;
            Util.castNonNull(this.trackOutput).format(this.sampleFormat);
        }

        @Override
        public int sampleData(DataReader input, int length, boolean allowEndOfInput, int sampleDataPart) throws IOException {
            return Util.castNonNull(this.trackOutput).sampleData(input, length, allowEndOfInput);
        }

        @Override
        public void sampleData(ParsableByteArray data, int length, int sampleDataPart) {
            Util.castNonNull(this.trackOutput).sampleData(data, length);
        }

        @Override
        public void sampleMetadata(long timeUs, int flags, int size, int offset, @Nullable TrackOutput.CryptoData cryptoData) {
            if (this.endTimeUs != -9223372036854775807L && timeUs >= this.endTimeUs) {
                this.trackOutput = this.fakeTrackOutput;
            }
            Util.castNonNull(this.trackOutput).sampleMetadata(timeUs, flags, size, offset, cryptoData);
        }
    }
}

