/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.text.ssa;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.util.Assertions;
import com.akamai.amp.exoplayer2.util.Util;

final class SsaDialogueFormat {
    public final int startTimeIndex;
    public final int endTimeIndex;
    public final int styleIndex;
    public final int textIndex;
    public final int length;

    private SsaDialogueFormat(int startTimeIndex, int endTimeIndex, int styleIndex, int textIndex, int length) {
        this.startTimeIndex = startTimeIndex;
        this.endTimeIndex = endTimeIndex;
        this.styleIndex = styleIndex;
        this.textIndex = textIndex;
        this.length = length;
    }

    @Nullable
    public static SsaDialogueFormat fromFormatLine(String formatLine) {
        int startTimeIndex = -1;
        int endTimeIndex = -1;
        int styleIndex = -1;
        int textIndex = -1;
        Assertions.checkArgument(formatLine.startsWith("Format:"));
        String[] keys = TextUtils.split((String)formatLine.substring("Format:".length()), (String)",");
        block12: for (int i = 0; i < keys.length; ++i) {
            switch (Util.toLowerInvariant(keys[i].trim())) {
                case "start": {
                    startTimeIndex = i;
                    continue block12;
                }
                case "end": {
                    endTimeIndex = i;
                    continue block12;
                }
                case "style": {
                    styleIndex = i;
                    continue block12;
                }
                case "text": {
                    textIndex = i;
                }
            }
        }
        return startTimeIndex != -1 && endTimeIndex != -1 ? new SsaDialogueFormat(startTimeIndex, endTimeIndex, styleIndex, textIndex, keys.length) : null;
    }
}

