/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.source;

import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.AbstractConcatenatedTimeline;
import com.akamai.amp.exoplayer2.MediaItem;
import com.akamai.amp.exoplayer2.Timeline;
import com.akamai.amp.exoplayer2.source.CompositeMediaSource;
import com.akamai.amp.exoplayer2.source.ForwardingTimeline;
import com.akamai.amp.exoplayer2.source.MaskingMediaPeriod;
import com.akamai.amp.exoplayer2.source.MaskingMediaSource;
import com.akamai.amp.exoplayer2.source.MediaPeriod;
import com.akamai.amp.exoplayer2.source.MediaSource;
import com.akamai.amp.exoplayer2.source.ShuffleOrder;
import com.akamai.amp.exoplayer2.upstream.Allocator;
import com.akamai.amp.exoplayer2.upstream.TransferListener;
import com.akamai.amp.exoplayer2.util.Assertions;
import java.util.HashMap;
import java.util.Map;

public final class LoopingMediaSource
extends CompositeMediaSource<Void> {
    private final MaskingMediaSource maskingMediaSource;
    private final int loopCount;
    private final Map<MediaSource.MediaPeriodId, MediaSource.MediaPeriodId> childMediaPeriodIdToMediaPeriodId;
    private final Map<MediaPeriod, MediaSource.MediaPeriodId> mediaPeriodToChildMediaPeriodId;

    public LoopingMediaSource(MediaSource childSource) {
        this(childSource, Integer.MAX_VALUE);
    }

    public LoopingMediaSource(MediaSource childSource, int loopCount) {
        Assertions.checkArgument(loopCount > 0);
        this.maskingMediaSource = new MaskingMediaSource(childSource, false);
        this.loopCount = loopCount;
        this.childMediaPeriodIdToMediaPeriodId = new HashMap<MediaSource.MediaPeriodId, MediaSource.MediaPeriodId>();
        this.mediaPeriodToChildMediaPeriodId = new HashMap<MediaPeriod, MediaSource.MediaPeriodId>();
    }

    @Override
    public boolean isLive() {
        if (this.maskingMediaSource == null) {
            return false;
        }
        return this.maskingMediaSource.isLive();
    }

    @Override
    @Deprecated
    @Nullable
    public Object getTag() {
        return this.maskingMediaSource.getTag();
    }

    @Override
    public MediaItem getMediaItem() {
        return this.maskingMediaSource.getMediaItem();
    }

    @Override
    @Nullable
    public Timeline getInitialTimeline() {
        return this.loopCount != Integer.MAX_VALUE ? new LoopingTimeline(this.maskingMediaSource.getTimeline(), this.loopCount) : new InfinitelyLoopingTimeline(this.maskingMediaSource.getTimeline());
    }

    @Override
    public boolean isSingleWindow() {
        return false;
    }

    @Override
    protected void prepareSourceInternal(@Nullable TransferListener mediaTransferListener) {
        super.prepareSourceInternal(mediaTransferListener);
        this.prepareChildSource(null, this.maskingMediaSource);
    }

    @Override
    public MediaPeriod createPeriod(MediaSource.MediaPeriodId id, Allocator allocator, long startPositionUs) {
        if (this.loopCount == Integer.MAX_VALUE) {
            return this.maskingMediaSource.createPeriod(id, allocator, startPositionUs);
        }
        Object childPeriodUid = LoopingTimeline.getChildPeriodUidFromConcatenatedUid(id.periodUid);
        MediaSource.MediaPeriodId childMediaPeriodId = id.copyWithPeriodUid(childPeriodUid);
        this.childMediaPeriodIdToMediaPeriodId.put(childMediaPeriodId, id);
        MaskingMediaPeriod mediaPeriod = this.maskingMediaSource.createPeriod(childMediaPeriodId, allocator, startPositionUs);
        this.mediaPeriodToChildMediaPeriodId.put(mediaPeriod, childMediaPeriodId);
        return mediaPeriod;
    }

    @Override
    public void releasePeriod(MediaPeriod mediaPeriod) {
        this.maskingMediaSource.releasePeriod(mediaPeriod);
        MediaSource.MediaPeriodId childMediaPeriodId = this.mediaPeriodToChildMediaPeriodId.remove(mediaPeriod);
        if (childMediaPeriodId != null) {
            this.childMediaPeriodIdToMediaPeriodId.remove(childMediaPeriodId);
        }
    }

    @Override
    protected void onChildSourceInfoRefreshed(Void id, MediaSource mediaSource, Timeline timeline) {
        Timeline loopingTimeline = this.loopCount != Integer.MAX_VALUE ? new LoopingTimeline(timeline, this.loopCount) : new InfinitelyLoopingTimeline(timeline);
        this.refreshSourceInfo(loopingTimeline);
    }

    @Override
    @Nullable
    protected MediaSource.MediaPeriodId getMediaPeriodIdForChildMediaPeriodId(Void id, MediaSource.MediaPeriodId mediaPeriodId) {
        return this.loopCount != Integer.MAX_VALUE ? this.childMediaPeriodIdToMediaPeriodId.get(mediaPeriodId) : mediaPeriodId;
    }

    private static final class LoopingTimeline
    extends AbstractConcatenatedTimeline {
        private final Timeline childTimeline;
        private final int childPeriodCount;
        private final int childWindowCount;
        private final int loopCount;

        public LoopingTimeline(Timeline childTimeline, int loopCount) {
            super(false, new ShuffleOrder.UnshuffledShuffleOrder(loopCount));
            this.childTimeline = childTimeline;
            this.childPeriodCount = childTimeline.getPeriodCount();
            this.childWindowCount = childTimeline.getWindowCount();
            this.loopCount = loopCount;
            if (this.childPeriodCount > 0) {
                Assertions.checkState(loopCount <= Integer.MAX_VALUE / this.childPeriodCount, "LoopingMediaSource contains too many periods");
            }
        }

        @Override
        public int getWindowCount() {
            return this.childWindowCount * this.loopCount;
        }

        @Override
        public int getPeriodCount() {
            return this.childPeriodCount * this.loopCount;
        }

        @Override
        protected int getChildIndexByPeriodIndex(int periodIndex) {
            return periodIndex / this.childPeriodCount;
        }

        @Override
        protected int getChildIndexByWindowIndex(int windowIndex) {
            return windowIndex / this.childWindowCount;
        }

        @Override
        protected int getChildIndexByChildUid(Object childUid) {
            if (!(childUid instanceof Integer)) {
                return -1;
            }
            return (Integer)childUid;
        }

        @Override
        protected Timeline getTimelineByChildIndex(int childIndex) {
            return this.childTimeline;
        }

        @Override
        protected int getFirstPeriodIndexByChildIndex(int childIndex) {
            return childIndex * this.childPeriodCount;
        }

        @Override
        protected int getFirstWindowIndexByChildIndex(int childIndex) {
            return childIndex * this.childWindowCount;
        }

        @Override
        protected Object getChildUidByChildIndex(int childIndex) {
            return childIndex;
        }
    }

    private static final class InfinitelyLoopingTimeline
    extends ForwardingTimeline {
        public InfinitelyLoopingTimeline(Timeline timeline) {
            super(timeline);
        }

        @Override
        public int getNextWindowIndex(int windowIndex, int repeatMode, boolean shuffleModeEnabled) {
            int childNextWindowIndex = this.timeline.getNextWindowIndex(windowIndex, repeatMode, shuffleModeEnabled);
            return childNextWindowIndex == -1 ? this.getFirstWindowIndex(shuffleModeEnabled) : childNextWindowIndex;
        }

        @Override
        public int getPreviousWindowIndex(int windowIndex, int repeatMode, boolean shuffleModeEnabled) {
            int childPreviousWindowIndex = this.timeline.getPreviousWindowIndex(windowIndex, repeatMode, shuffleModeEnabled);
            return childPreviousWindowIndex == -1 ? this.getLastWindowIndex(shuffleModeEnabled) : childPreviousWindowIndex;
        }
    }
}

