/*
 * Decompiled with CFR 0.152.
 */
package com.mux.stats.sdk.os;

import com.mux.stats.sdk.os.MuxArray;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MuxDictionary {
    private JSONObject query = new JSONObject();

    public String getJSONString() {
        return this.query.toString();
    }

    public MuxArray keys() {
        Iterator it = this.query.keys();
        MuxArray set = new MuxArray();
        while (it.hasNext()) {
            set.append(it.next());
        }
        return set;
    }

    public MuxArray getArray(String key) {
        MuxArray array = new MuxArray();
        try {
            JSONArray jsArray = this.query.optJSONArray(key);
            if (jsArray != null) {
                for (int i = 0; i < jsArray.length(); ++i) {
                    MuxDictionary item = new MuxDictionary();
                    item.query = jsArray.getJSONObject(i);
                    array.append(item);
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return array;
    }

    public void putArray(String key, MuxArray array) {
        try {
            JSONArray jsArray = new JSONArray();
            for (int i = 0; i < array.size(); ++i) {
                MuxDictionary dict = (MuxDictionary)array.get(i);
                jsArray.put((Object)dict.query);
            }
            this.query.put(key, (Object)jsArray);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public Integer getInt(String key) {
        String value = this.query.optString(key);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public Long getLong(String key) {
        String value = this.query.optString(key);
        if (value != null) {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public Double getDouble(String key) {
        String value = this.query.optString(key);
        if (value != null) {
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public Boolean getBoolean(String key) {
        String value = this.query.optString(key);
        if (value != null) {
            try {
                return Boolean.parseBoolean(value);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public String getString(String key) {
        return this.query.optString(key);
    }

    public MuxDictionary getDictionary(String key) {
        JSONObject json = this.query.optJSONObject(key);
        if (json == null) {
            return null;
        }
        MuxDictionary dict = new MuxDictionary();
        dict.query = json;
        return dict;
    }

    public void putInt(String key, int value) {
        try {
            this.query.put(key, (Object)String.valueOf(value));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void putLong(String key, long value) {
        try {
            this.query.put(key, (Object)String.valueOf(value));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void putDouble(String key, double value) {
        try {
            this.query.put(key, (Object)String.valueOf(value));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void putBoolean(String key, boolean value) {
        try {
            this.query.put(key, (Object)String.valueOf(value));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void putString(String key, String value) {
        try {
            this.query.put(key, (Object)value);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void putDictionary(String key, MuxDictionary dict) {
        try {
            this.query.put(key, (Object)dict.query);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }
}

