/*
 * Decompiled with CFR 0.152.
 */
package com.mux.stats.sdk.core.trackers;

import com.mux.stats.sdk.core.events.IEventDispatcher;
import com.mux.stats.sdk.core.events.playback.PlaybackEvent;
import com.mux.stats.sdk.core.events.playback.ViewStartEvent;
import com.mux.stats.sdk.core.trackers.BaseTracker;

public class ViewStateTracker
extends BaseTracker {
    private ViewState state = ViewState.STATE_UNKNOWN;

    public ViewStateTracker(IEventDispatcher dispatcher) {
        super(dispatcher);
    }

    @Override
    protected void handlePlaybackEvent(PlaybackEvent event) {
        switch (event.getType()) {
            case "viewinit": {
                this.state = ViewState.STATE_INIT;
                break;
            }
            case "play": 
            case "adbreakstart": {
                if (this.state != ViewState.STATE_INIT) break;
                this.state = ViewState.STATE_PLAY;
                this.dispatch(new ViewStartEvent(event.getPlayerData()));
            }
        }
    }

    private static enum ViewState {
        STATE_UNKNOWN,
        STATE_INIT,
        STATE_PLAY;

    }
}

