/*
 * Decompiled with CFR 0.152.
 */
package com.mux.stats.sdk.core.trackers;

import com.mux.stats.sdk.core.events.IEventDispatcher;
import com.mux.stats.sdk.core.events.ViewMetricEvent;
import com.mux.stats.sdk.core.events.playback.PlaybackEvent;
import com.mux.stats.sdk.core.model.ViewData;
import com.mux.stats.sdk.core.trackers.BaseTracker;
import com.mux.stats.sdk.core.util.MuxLogger;

public class TimeToFirstFrameTracker
extends BaseTracker {
    private static final String TAG = "TimeToFirstFrameTracker";
    private static final int PLAYING = 1;
    private static final int AD_PLAYING = 2;
    private int state = 0;

    public TimeToFirstFrameTracker(IEventDispatcher dispatcher) {
        super(dispatcher);
    }

    private void setAndSendTTFF(long viewWatchTime) {
        ViewData viewData = new ViewData();
        viewData.setViewTimeToFirstFrame(viewWatchTime);
        ViewMetricEvent event = new ViewMetricEvent(viewData);
        this.dispatcher.dispatch(event);
    }

    @Override
    protected void handlePlaybackEvent(PlaybackEvent event) {
        ViewData viewData = event.getViewData();
        if (viewData.getViewProgramChanged().booleanValue()) {
            MuxLogger.d(TAG, "Skipping Time to first frame calculation, this is a program change view");
            return;
        }
        Long contentPlaybackTime = viewData.getViewContentPlaybackTime();
        boolean probablyPreroll = contentPlaybackTime == null || contentPlaybackTime <= 1000L;
        switch (event.getType()) {
            case "playing": {
                if (this.state >= 1) break;
                this.state = 1;
                this.setAndSendTTFF(viewData.getViewWatchTime());
                break;
            }
            case "adplaying": {
                if (this.state >= 2 || !probablyPreroll) break;
                this.state = 2;
                this.setAndSendTTFF(viewData.getViewWatchTime());
            }
        }
    }
}

