/*
 * Decompiled with CFR 0.152.
 */
package com.mux.stats.sdk.core.trackers;

import com.mux.stats.sdk.core.events.IEventDispatcher;
import com.mux.stats.sdk.core.events.playback.PlaybackEvent;
import com.mux.stats.sdk.core.model.BandwidthMetricData;
import com.mux.stats.sdk.core.model.ViewData;
import com.mux.stats.sdk.core.trackers.BaseTracker;

public class RequestMetricsTracker
extends BaseTracker {
    protected long requestCount = 0L;
    protected long requestCompletedCount = 0L;
    protected long requestCanceledCount = 0L;
    protected long requestFailedCount = 0L;
    protected long totalBytes = 0L;
    protected long totalLoadTime = 0L;
    protected double totalLatency = 0.0;

    public RequestMetricsTracker(IEventDispatcher dispatcher) {
        super(dispatcher);
    }

    @Override
    protected void handlePlaybackEvent(PlaybackEvent event) {
        switch (event.getType()) {
            case "bandwidth": {
                BandwidthMetricData loadData = event.getBandwidthMetricData();
                String strCancel = loadData.getRequestCancel();
                ++this.requestCount;
                if (strCancel != null && !strCancel.isEmpty()) {
                    ++this.requestCanceledCount;
                    return;
                }
                String strError = loadData.getRequestError();
                if (strError != null && !strError.isEmpty()) {
                    ++this.requestFailedCount;
                    return;
                }
                Long requestStart = loadData.getRequestStart();
                long responseStart = loadData.getRequestResponseStart();
                long responseEnd = loadData.getRequestResponseEnd();
                long bytesLoaded = loadData.getRequestBytesLoaded();
                long loadTime = responseEnd - responseStart;
                if (bytesLoaded <= 0L || loadTime <= 0L) break;
                long throughput = (long)(8000.0 * (double)bytesLoaded / (double)loadTime);
                ++this.requestCompletedCount;
                this.totalBytes += bytesLoaded;
                this.totalLoadTime += loadTime;
                ViewData viewData = event.getViewData();
                if (viewData.getViewMinRequestThroughput() == null) {
                    viewData.setViewMinRequestThroughput(throughput);
                } else {
                    viewData.setViewMinRequestThroughput(Math.min(throughput, viewData.getViewMinRequestThroughput()));
                }
                viewData.setViewAverageRequestThroughput((long)(8000.0 * (double)this.totalBytes / (double)this.totalLoadTime));
                if (requestStart == null) break;
                double latency = responseStart - requestStart;
                this.totalLatency += latency;
                if (viewData.getViewMaxRequestLatency() == null) {
                    viewData.setViewMaxRequestLatency(latency);
                } else {
                    viewData.setViewMaxRequestLatency(Math.max(latency, viewData.getViewMaxRequestLatency()));
                }
                viewData.setViewAverageRequestLatency(this.totalLatency / (double)this.requestCompletedCount);
                break;
            }
        }
    }
}

