/*
 * Decompiled with CFR 0.152.
 */
package com.mux.stats.sdk.core.trackers;

import com.mux.stats.sdk.core.events.IEventDispatcher;
import com.mux.stats.sdk.core.events.ViewMetricEvent;
import com.mux.stats.sdk.core.events.playback.PlaybackEvent;
import com.mux.stats.sdk.core.events.playback.RebufferEndEvent;
import com.mux.stats.sdk.core.events.playback.RebufferStartEvent;
import com.mux.stats.sdk.core.model.ViewData;
import com.mux.stats.sdk.core.trackers.BaseAdTracker;

public class RebufferTracker
extends BaseAdTracker {
    private static final long MINIMUM_REBUFFER_DURATION_MS = 100L;
    private static final long SUSTAINED_REBUFFER_THRESHOLD_MS = 1000L;
    private boolean isSeeking = false;
    private boolean isRebuffering = false;
    private boolean playheadShouldBeProgressing = false;
    private Long lastCheckedTime = null;
    private Long lastPlayheadTime = null;
    private Long lastPlayheadTimeUpdatedTime = null;
    private int rebufferCount = 0;
    private long rebufferDuration = 0L;
    private double rebufferFrequency = 0.0;
    private double rebufferPercentage = 0.0;

    public RebufferTracker(IEventDispatcher dispatcher) {
        super(dispatcher);
    }

    private boolean sanityCheckLongs() {
        return this.lastCheckedTime != null && this.lastPlayheadTime != null && this.lastPlayheadTimeUpdatedTime != null;
    }

    private void update(PlaybackEvent event) {
        Long nextLastCheckedTime = event.getViewData().getViewerTime();
        Long nextLastPlayheadTime = event.getPlayerData().getPlayerPlayheadTime();
        Long nextLastPlayheadTimeUpdatedTime = event.getViewData().getViewerTime();
        if (nextLastCheckedTime != null && nextLastPlayheadTime != null && nextLastPlayheadTimeUpdatedTime != null) {
            this.lastCheckedTime = nextLastCheckedTime;
            this.lastPlayheadTime = nextLastPlayheadTime;
            this.lastPlayheadTimeUpdatedTime = nextLastPlayheadTimeUpdatedTime;
        }
    }

    private void endRebuffering(PlaybackEvent event, long viewerTime) {
        this.isRebuffering = false;
        this.computeMetrics(event, viewerTime - this.lastCheckedTime);
        RebufferEndEvent rebufferEnd = new RebufferEndEvent(event.getPlayerData());
        rebufferEnd.setViewData(event.getViewData());
        this.dispatch(rebufferEnd);
    }

    private void check(PlaybackEvent event) {
        Long vt = event.getViewData().getViewerTime();
        Long playerPlayheadTime = event.getPlayerData().getPlayerPlayheadTime();
        if (vt == null || playerPlayheadTime == null) {
            return;
        }
        if (this.isSeeking || this.isAdBreak || !this.playheadShouldBeProgressing) {
            this.cleanup(event);
            return;
        }
        if (this.lastCheckedTime == null) {
            this.computeMetrics(event, 0L);
            this.update(event);
            return;
        }
        long viewerTime = this.getViewerTime(event.getViewData());
        if (this.lastPlayheadTime != null && !this.lastPlayheadTime.equals(playerPlayheadTime)) {
            this.cleanup(event);
            this.update(event);
            return;
        }
        if (!this.sanityCheckLongs()) {
            return;
        }
        long viewerTimeDelta = viewerTime - this.lastPlayheadTimeUpdatedTime;
        if (viewerTimeDelta >= 1000L) {
            if (!this.isRebuffering) {
                this.isRebuffering = true;
                ++this.rebufferCount;
                this.computeMetrics(event, viewerTimeDelta);
                RebufferStartEvent rebufferStart = new RebufferStartEvent(event.getPlayerData());
                rebufferStart.setViewData(event.getViewData());
                this.dispatch(rebufferStart);
            } else {
                this.computeMetrics(event, viewerTime - this.lastCheckedTime);
            }
        }
        this.lastCheckedTime = viewerTime;
    }

    private long getViewerTime(ViewData viewData) {
        return viewData.getViewerTime();
    }

    private long getPlayerPlayheadTime(Long time) {
        return time;
    }

    private void cleanup(PlaybackEvent event) {
        if (event.getViewData().getViewerTime() == null) {
            this.lastCheckedTime = null;
            this.lastPlayheadTime = null;
            this.lastPlayheadTimeUpdatedTime = null;
            return;
        }
        long originalViewerTime = this.getViewerTime(event.getViewData());
        if (this.isRebuffering) {
            this.endRebuffering(event, originalViewerTime);
        } else if (this.lastCheckedTime == null) {
            this.computeMetrics(event, 0L);
        } else {
            Long playerPlayheadTime = event.getPlayerData().getPlayerPlayheadTime();
            if (playerPlayheadTime == null) {
                this.lastCheckedTime = null;
                this.lastPlayheadTime = null;
                this.lastPlayheadTimeUpdatedTime = null;
                return;
            }
            if (!this.sanityCheckLongs()) {
                return;
            }
            long playheadTimeDelta = this.getPlayerPlayheadTime(playerPlayheadTime) - this.lastPlayheadTime;
            long viewerTimeDelta = originalViewerTime - this.lastPlayheadTimeUpdatedTime;
            long rebufferDuration = viewerTimeDelta - playheadTimeDelta;
            if (playheadTimeDelta > 0L && rebufferDuration > 100L) {
                ++this.rebufferCount;
                this.computeMetrics(event, viewerTimeDelta - playheadTimeDelta);
                ViewData copiedViewData = new ViewData();
                copiedViewData.update(event.getViewData());
                copiedViewData.setViewerTime(originalViewerTime - rebufferDuration);
                RebufferStartEvent startEvent = new RebufferStartEvent(event.getPlayerData());
                startEvent.setViewData(copiedViewData);
                this.dispatch(startEvent);
                copiedViewData.setViewerTime(originalViewerTime);
                RebufferEndEvent endEvent = new RebufferEndEvent(event.getPlayerData());
                endEvent.setViewData(copiedViewData);
                this.dispatch(endEvent);
            } else {
                this.computeMetrics(event, 0L);
            }
        }
        this.lastCheckedTime = null;
        this.lastPlayheadTime = null;
        this.lastPlayheadTimeUpdatedTime = null;
    }

    private void computeMetrics(PlaybackEvent event, long delta) {
        boolean updatedMetrics = false;
        if (delta > 0L) {
            this.rebufferDuration += delta;
            updatedMetrics = true;
        }
        if (event.getViewData().getViewWatchTime() != null && this.rebufferCount > 0) {
            this.rebufferFrequency = (double)this.rebufferCount / (double)event.getViewData().getViewWatchTime().longValue();
            this.rebufferPercentage = (double)this.rebufferDuration / (double)event.getViewData().getViewWatchTime().longValue();
            updatedMetrics = true;
        }
        if (updatedMetrics) {
            ViewData viewData = new ViewData();
            viewData.setViewRebufferCount(this.rebufferCount);
            viewData.setViewRebufferDuration(this.rebufferDuration);
            viewData.setViewRebufferFrequency(this.rebufferFrequency);
            viewData.setViewRebufferPercentage(this.rebufferPercentage);
            this.dispatch(new ViewMetricEvent(viewData));
        }
    }

    @Override
    protected void handlePlaybackEvent(PlaybackEvent event) {
        String eventType = event.getType();
        if (eventType == "seeking") {
            if (!this.isSeeking) {
                this.isSeeking = true;
                this.cleanup(event);
            }
        } else if (eventType == "seeked") {
            this.isSeeking = false;
        } else if (eventType == "playing") {
            this.playheadShouldBeProgressing = true;
        } else if (eventType == "internalheartbeat") {
            this.check(event);
        } else if (eventType == "internalheartbeatend") {
            this.playheadShouldBeProgressing = false;
            this.cleanup(event);
        }
    }
}

