/*
 * Decompiled with CFR 0.152.
 */
package com.mux.stats.sdk.core.trackers;

import com.mux.stats.sdk.core.events.IEvent;
import com.mux.stats.sdk.core.events.IEventDispatcher;
import com.mux.stats.sdk.core.events.playback.HeartbeatEvent;
import com.mux.stats.sdk.core.events.playback.PlaybackEvent;
import com.mux.stats.sdk.core.model.PlayerData;
import com.mux.stats.sdk.core.trackers.BaseTracker;
import com.mux.stats.sdk.core.trackers.ITimeTracker;
import com.mux.stats.sdk.core.util.CurrentTime;

public class ExternalHeartbeatTracker
extends BaseTracker
implements ITimeTracker {
    private static final long TEN_SECONDS_IN_MS = 10000L;
    private long lastTrackableEvent = 0L;
    private CurrentTime currentTime = new CurrentTime();
    private boolean playing = false;

    public ExternalHeartbeatTracker(IEventDispatcher dispatcher) {
        super(dispatcher);
    }

    public void setCurrentTime(CurrentTime currentTime) {
        this.currentTime = currentTime;
    }

    @Override
    public long now() {
        return this.currentTime.now();
    }

    @Override
    public void handle(IEvent event) {
        if (event.isTrackable()) {
            this.lastTrackableEvent = this.now();
        } else if (event.isPlayback()) {
            if (event.getType() == "internalheartbeat") {
                if (!this.playing) {
                    this.lastTrackableEvent = 0L;
                }
                this.playing = true;
            } else if (event.getType() == "internalheartbeatend") {
                this.playing = false;
            }
            if (this.playing && this.lastTrackableEvent > 0L && this.lastTrackableEvent + 10000L < this.now()) {
                this.lastTrackableEvent = this.now();
                PlaybackEvent playbackEvent = (PlaybackEvent)event;
                PlayerData playerData = playbackEvent.getPlayerData();
                this.dispatch(new HeartbeatEvent(playerData));
            }
        }
    }
}

