/*
 * Decompiled with CFR 0.152.
 */
package com.mux.stats.sdk.core.model;

import com.mux.stats.sdk.core.model.BaseQueryData;
import com.mux.stats.sdk.os.MuxArray;
import com.mux.stats.sdk.os.MuxDictionary;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;

public class BandwidthMetricData
extends BaseQueryData {
    public static final String REQUEST_EVENT_TYPE = "qeety";
    public static final String REQUEST_START = "qst";
    public static final String REQUEST_RESPONSE_START = "qrpst";
    public static final String REQUEST_RESPONSE_END = "qrpen";
    public static final String REQUEST_BYTES_LOADED = "qbyld";
    public static final String REQUEST_TYPE = "qty";
    public static final String REQUEST_RESPONSE_HEADERS = "qrphe";
    public static final String REQUEST_HOSTNAME = "qhn";
    public static final String REQUEST_MEDIA_DURATION = "qmddu";
    public static final String REQUEST_CURRENT_LEVEL = "qcule";
    public static final String REQUEST_MEDIA_START_TIME = "qmdstti";
    public static final String REQUEST_VIDEO_WIDTH = "qviwd";
    public static final String REQUEST_VIDEO_HEIGHT = "qviht";
    public static final String REQUEST_ERROR = "qer";
    public static final String REQUEST_URL = "qur";
    public static final String REQUEST_ERROR_TEXT = "qerte";
    public static final String REQUEST_ERROR_CODE = "qercd";
    public static final String REQUEST_LABELED_BITRATE = "qlbbi";
    public static final String REQUEST_RENDITION_LISTS = "qrfls";
    public static final String REQUEST_CANCEL = "qcb";

    public void setRequestEventType(String eventType) {
        if (eventType != null) {
            this.put(REQUEST_EVENT_TYPE, eventType);
        }
    }

    public String getRequestEventType() {
        String value = this.get(REQUEST_EVENT_TYPE);
        return value == null ? null : value;
    }

    public void setRequestStart(Long startTime) {
        if (startTime != null) {
            this.put(REQUEST_START, startTime.toString());
        }
    }

    public Long getRequestStart() {
        String value = this.get(REQUEST_START);
        return value == null ? null : Long.valueOf(Long.parseLong(value));
    }

    public void setRequestResponseStart(Long startTime) {
        if (startTime != null) {
            this.put(REQUEST_RESPONSE_START, startTime.toString());
        }
    }

    public Long getRequestResponseStart() {
        String value = this.get(REQUEST_RESPONSE_START);
        return value == null ? null : Long.valueOf(Long.parseLong(value));
    }

    public void setRequestResponseEnd(Long endTime) {
        if (endTime != null) {
            this.put(REQUEST_RESPONSE_END, endTime.toString());
        }
    }

    public Long getRequestResponseEnd() {
        String value = this.get(REQUEST_RESPONSE_END);
        return value == null ? null : Long.valueOf(Long.parseLong(value));
    }

    public void setRequestBytesLoaded(Long bytes) {
        if (bytes != null) {
            this.put(REQUEST_BYTES_LOADED, bytes.toString());
        }
    }

    public Long getRequestBytesLoaded() {
        String value = this.get(REQUEST_BYTES_LOADED);
        return value == null ? null : Long.valueOf(Long.parseLong(value));
    }

    public void setRequestType(String type) {
        if (type != null) {
            this.put(REQUEST_TYPE, type);
        }
    }

    public String getRequestType() {
        String value = this.get(REQUEST_TYPE);
        return value == null ? null : value;
    }

    public void setRequestResponseHeaders(Hashtable<String, String> headers) {
        if (headers != null) {
            MuxDictionary headersDict = new MuxDictionary();
            Set<String> keys = headers.keySet();
            for (String key : keys) {
                headersDict.putString(key, headers.get(key));
            }
            this.query.putDictionary(REQUEST_RESPONSE_HEADERS, headersDict);
        }
    }

    public Hashtable<String, String> getRequestResponseHeaders() {
        Hashtable<String, String> headers = new Hashtable<String, String>();
        MuxDictionary headersDict = this.query.getDictionary(REQUEST_RESPONSE_HEADERS);
        if (headersDict != null) {
            MuxArray keys = headersDict.keys();
            for (int i = 0; i < keys.size(); ++i) {
                String key = (String)keys.get(i);
                headers.put(key, headersDict.getString(key));
            }
        }
        return headers;
    }

    public void setRequestHostName(String host) {
        if (host != null) {
            this.put(REQUEST_HOSTNAME, host);
        }
    }

    public String getRequestHostName() {
        String value = this.get(REQUEST_HOSTNAME);
        return value == null ? null : value;
    }

    public void setRequestMediaDuration(Long mediaDuration) {
        if (mediaDuration != null) {
            this.put(REQUEST_MEDIA_DURATION, mediaDuration.toString());
        }
    }

    public Long getRequestMediaDuration() {
        String value = this.get(REQUEST_MEDIA_DURATION);
        return value == null ? null : Long.valueOf(Long.parseLong(value));
    }

    public void setRequestCurrentLevel(Integer level) {
        if (level != null) {
            this.put(REQUEST_CURRENT_LEVEL, level.toString());
        }
    }

    public Integer getRequestCurrentLevel() {
        String value = this.get(REQUEST_CURRENT_LEVEL);
        return value == null ? null : Integer.valueOf(Integer.parseInt(value));
    }

    public void setRequestMediaStartTime(Long mediaStartTime) {
        if (mediaStartTime != null) {
            this.put(REQUEST_MEDIA_START_TIME, mediaStartTime.toString());
        }
    }

    public Long getRequestMediaStartTime() {
        String value = this.get(REQUEST_MEDIA_START_TIME);
        return value == null ? null : Long.valueOf(Long.parseLong(value));
    }

    public void setRequestVideoWidth(Integer width) {
        if (width != null) {
            this.put(REQUEST_VIDEO_WIDTH, width.toString());
        }
    }

    public Integer getRequestVideoWidth() {
        String value = this.get(REQUEST_VIDEO_WIDTH);
        return value == null ? null : Integer.valueOf(Integer.parseInt(value));
    }

    public void setRequestVideoHeight(Integer height) {
        if (height != null) {
            this.put(REQUEST_VIDEO_HEIGHT, height.toString());
        }
    }

    public Integer getRequestVideoHeight() {
        String value = this.get(REQUEST_VIDEO_HEIGHT);
        return value == null ? null : Integer.valueOf(Integer.parseInt(value));
    }

    public void setRequestError(String errorMsg) {
        if (errorMsg != null) {
            this.put(REQUEST_ERROR, errorMsg);
        }
    }

    public String getRequestError() {
        String value = this.get(REQUEST_ERROR);
        return value == null ? null : value;
    }

    public void setRequestUrl(String url) {
        if (url != null) {
            this.put(REQUEST_URL, url);
        }
    }

    public String setRequestUrl() {
        String value = this.get(REQUEST_URL);
        return value == null ? null : value;
    }

    public void setRequestErrorText(String errorText) {
        if (errorText != null) {
            this.put(REQUEST_ERROR_TEXT, errorText);
        }
    }

    public String getRequestErrorText() {
        String value = this.get(REQUEST_ERROR_TEXT);
        return value == null ? null : value;
    }

    public void setRequestErrorCode(Integer errorCode) {
        if (errorCode != null) {
            this.put(REQUEST_ERROR_CODE, errorCode.toString());
        }
    }

    public Integer getRequestErrorCode() {
        String value = this.get(REQUEST_ERROR_CODE);
        return value == null ? null : Integer.valueOf(Integer.parseInt(value));
    }

    public void setRequestLabeledBitrate(Integer labeledBitrate) {
        if (labeledBitrate != null) {
            this.put(REQUEST_LABELED_BITRATE, labeledBitrate.toString());
        }
    }

    public Integer getRequestLabeledBitrate() {
        String value = this.get(REQUEST_LABELED_BITRATE);
        return value == null ? null : Integer.valueOf(Integer.parseInt(value));
    }

    public void setRequestRenditionLists(List<Rendition> renditionList) {
        if (renditionList != null) {
            MuxArray renditions = new MuxArray();
            MuxDictionary renditionsDict = new MuxDictionary();
            for (Rendition rendition : renditionList) {
                MuxDictionary dict = new MuxDictionary();
                dict.putInt("width", rendition.width);
                dict.putInt("height", rendition.height);
                dict.putLong("bitrate", rendition.bitrate);
                dict.putString("attrs", rendition.attrs);
                renditions.append(dict);
            }
            renditionsDict.putArray("media", renditions);
            this.query.putDictionary(REQUEST_RENDITION_LISTS, renditionsDict);
        }
    }

    public List<Rendition> getRequestRenditionLists() {
        ArrayList<Rendition> renditionList = new ArrayList<Rendition>();
        MuxDictionary renditionsDict = this.query.getDictionary(REQUEST_RENDITION_LISTS);
        if (renditionsDict != null) {
            MuxArray medias = renditionsDict.getArray("media");
            for (int i = 0; medias != null && i < medias.size(); ++i) {
                MuxDictionary dict = (MuxDictionary)medias.get(i);
                Rendition rendition = new Rendition();
                rendition.width = dict.getInt("width");
                rendition.height = dict.getInt("height");
                rendition.bitrate = dict.getLong("bitrate");
                rendition.attrs = dict.getString("attrs");
                renditionList.add(rendition);
            }
        }
        return renditionList;
    }

    public void setRequestCancel(String event) {
        if (event != null) {
            this.put(REQUEST_CANCEL, event);
        }
    }

    public String getRequestCancel() {
        String value = this.get(REQUEST_CANCEL);
        return value == null ? null : value;
    }

    @Override
    public String getDebugString() {
        return "BandwidthMetricData: \n    requestEventType: " + this.getRequestEventType() + "\n    requestStart: " + this.getRequestStart() + "\n    requestResponseStart: " + this.getRequestResponseStart() + "\n    requestResponseEnd: " + this.getRequestResponseEnd() + "\n    requestBytesLoaded: " + this.getRequestBytesLoaded() + "\n    requestType: " + this.getRequestType() + "\n    requestResponseHeaders: " + this.getRequestResponseHeaders().keySet() + "\n    requestHostName: " + this.getRequestHostName() + "\n    requestMediaDuration: " + this.getRequestMediaDuration() + "\n    requestCurrentLevel: " + this.getRequestCurrentLevel() + "\n    requestMediaStartTime: " + this.getRequestMediaStartTime() + "\n    requestVideoWidth: " + this.getRequestVideoWidth() + "\n    requestVideoHeight: " + this.getRequestVideoHeight() + "\n    requestError: " + this.getRequestError() + "\n    requestErrorText: " + this.getRequestErrorText() + "\n    requestErrorCode: " + this.getRequestErrorCode() + "\n    requestLabeledBitrate: " + this.getRequestLabeledBitrate() + "\n    requestRenditionLists: " + this.getRequestRenditionLists() + "\n    requestCancel: " + this.getRequestCancel();
    }

    public static class Rendition {
        public int width;
        public int height;
        public long bitrate;
        public String attrs;
    }
}

