/*
 * Decompiled with CFR 0.152.
 */
package com.mux.stats.sdk.core.events;

import com.mux.stats.sdk.core.events.IEvent;
import com.mux.stats.sdk.core.events.IEventDispatcher;
import com.mux.stats.sdk.core.events.IEventListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;

public class EventBus
implements IEventDispatcher {
    private static final String TAG = "EventBus";
    private int nextId = 0;
    private ConcurrentHashMap<Integer, IEventListener> listenersMap = new ConcurrentHashMap();
    private HashSet<Integer> once = new HashSet();

    public void addListener(IEventListener listener) {
        listener.setId(this.nextId);
        this.listenersMap.put(this.nextId++, listener);
    }

    public void addListenerOnce(IEventListener listener) {
        this.once.add(this.nextId);
        this.addListener(listener);
    }

    public void removeListener(IEventListener listener) {
        this.listenersMap.remove(listener.getId());
    }

    public void removeAllListeners() {
        this.listenersMap = new ConcurrentHashMap();
        this.once = new HashSet();
    }

    @Override
    public void dispatch(IEvent event) {
        ArrayList<Integer> toRemove = new ArrayList<Integer>();
        for (int i = 0; i < this.nextId; ++i) {
            IEventListener listener = this.listenersMap.get(i);
            if (listener == null) continue;
            listener.handle(event);
            int id = listener.getId();
            if (!this.once.contains(id)) continue;
            toRemove.add(id);
        }
        Iterator iterator = toRemove.iterator();
        while (iterator.hasNext()) {
            int r = (Integer)iterator.next();
            this.listenersMap.remove(r);
        }
    }

    public void flush() {
        for (int i = 0; i < this.nextId; ++i) {
            IEventListener listener = this.listenersMap.get(i);
            if (listener == null) continue;
            listener.flush();
        }
    }
}

