/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.media.exowrapper2.drm;

import android.content.Context;
import android.content.Intent;
import android.media.MediaDrm;
import com.akamai.amp.exoplayer2.drm.DefaultDrmSessionManager;
import com.akamai.amp.exoplayer2.drm.DrmSessionManager;
import com.akamai.amp.exoplayer2.drm.DummyExoMediaDrm;
import com.akamai.amp.exoplayer2.drm.FrameworkMediaDrm;
import com.akamai.amp.exoplayer2.drm.HttpMediaDrmCallback;
import com.akamai.amp.exoplayer2.drm.UnsupportedDrmException;
import com.akamai.amp.exoplayer2.upstream.HttpDataSource;
import com.akamai.amp.exoplayer2.util.Log;
import com.akamai.amp.exoplayer2.util.Util;
import com.akamai.amp.media.exowrapper2.DataSourceBuilder;
import com.akamai.amp.media.exowrapper2.ExoMessages;
import com.akamai.amp.utils.IntentUtil;
import com.akamai.amp.utils.LogManager;
import java.util.Map;
import java.util.UUID;

public class DrmHandler {
    private static final String TAG = DrmHandler.class.getSimpleName();
    public static final String L1 = "L1";
    public static final String L3 = "L3";
    private Context context;
    private DrmInfo drmInfo;

    public DrmHandler(Context context, Intent intent) {
        this.context = context;
        this.buildDRMInfo(intent);
    }

    private void buildDRMInfo(Intent intent) {
        if (intent.hasExtra("drm_scheme") || intent.hasExtra("drm_scheme_uuid")) {
            String drmLicenseUrl = intent.getStringExtra("drm_license_url");
            String[] keyRequestPropertiesArray = DrmHandler.getRequestPropertiesArray(intent);
            boolean multiSession = intent.getBooleanExtra("drm_multi_session", false);
            int errorStringId = 3;
            String drmSchemeExtra = intent.hasExtra("drm_scheme") ? "drm_scheme" : "drm_scheme_uuid";
            UUID drmSchemeUuid = Util.getDrmUuid(intent.getStringExtra(drmSchemeExtra));
            if (drmSchemeUuid == null) {
                errorStringId = 2;
            } else {
                this.drmInfo = new DrmInfo(drmSchemeUuid, drmLicenseUrl, keyRequestPropertiesArray, multiSession);
            }
            if (this.drmInfo == null) {
                Log.e(TAG, this.context.getString(errorStringId));
            }
        }
    }

    private static String[] getRequestPropertiesArray(Intent intent) {
        Map<String, String> drmHeaders = IntentUtil.getDrmHeaders();
        if (drmHeaders == null || drmHeaders.isEmpty()) {
            String[] keyRequestPropertiesArray = intent.getStringArrayExtra("drm_key_request_properties");
            return keyRequestPropertiesArray;
        }
        return DrmHandler.interleave(drmHeaders);
    }

    private static String[] interleave(Map<String, String> map) {
        String[] result = new String[map.size() * 2];
        int i = 0;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            result[i++] = entry.getKey();
            result[i++] = entry.getValue();
        }
        return result;
    }

    public DrmSessionManager getDRMSessionManager(String securityLevel) {
        int errorStringId = 3;
        DrmSessionManager drmSessionManager = null;
        if (this.drmInfo == null) {
            drmSessionManager = DrmSessionManager.getDummyDrmSessionManager();
        } else if (Util.SDK_INT < 18) {
            errorStringId = 1;
        } else if (!MediaDrm.isCryptoSchemeSupported((UUID)this.drmInfo.drmScheme)) {
            errorStringId = 2;
        } else {
            HttpMediaDrmCallback mediaDrmCallback = this.createMediaDrmCallback(this.drmInfo.drmLicenseUrl, this.drmInfo.drmKeyRequestProperties);
            drmSessionManager = new DefaultDrmSessionManager.Builder().setUuidAndExoMediaDrmProvider(this.drmInfo.drmScheme, !L1.equals(securityLevel) && !L3.equals(securityLevel) ? FrameworkMediaDrm.DEFAULT_PROVIDER : uuid -> {
                try {
                    FrameworkMediaDrm mediaDrm = FrameworkMediaDrm.newInstance(uuid);
                    mediaDrm.setPropertyString("securityLevel", securityLevel);
                    return mediaDrm;
                }
                catch (UnsupportedDrmException e) {
                    return new DummyExoMediaDrm();
                }
            }).setMultiSession(this.drmInfo.drmMultiSession).setKeyRequestParameters(IntentUtil.getDrmHeaders()).build(mediaDrmCallback);
        }
        if (drmSessionManager == null) {
            LogManager.error(TAG, ExoMessages.getResource(errorStringId));
            return null;
        }
        return drmSessionManager;
    }

    private HttpMediaDrmCallback createMediaDrmCallback(String licenseUrl, String[] keyRequestPropertiesArray) {
        HttpDataSource.Factory licenseDataSourceFactory = DataSourceBuilder.buildHttpDataSourceFactory();
        HttpMediaDrmCallback drmCallback = new HttpMediaDrmCallback(licenseUrl, licenseDataSourceFactory);
        if (keyRequestPropertiesArray != null) {
            for (int i = 0; i < keyRequestPropertiesArray.length - 1; i += 2) {
                drmCallback.setKeyRequestProperty(keyRequestPropertiesArray[i], keyRequestPropertiesArray[i + 1]);
            }
        }
        return drmCallback;
    }

    private static final class DrmInfo {
        private final UUID drmScheme;
        private final String drmLicenseUrl;
        private final String[] drmKeyRequestProperties;
        private final boolean drmMultiSession;

        private DrmInfo(UUID drmScheme, String drmLicenseUrl, String[] drmKeyRequestProperties, boolean drmMultiSession) {
            this.drmScheme = drmScheme;
            this.drmLicenseUrl = drmLicenseUrl;
            this.drmKeyRequestProperties = drmKeyRequestProperties;
            this.drmMultiSession = drmMultiSession;
        }
    }
}

