/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.license.manager;

import android.content.Context;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.akamai.amp.license.manager.LicenseDecryption;
import com.akamai.amp.media.VideoPlayerContainer;
import com.akamai.amp.media.exceptions.InvalidLicenseException;
import com.akamai.amp.ui.LicenseNotification;
import com.akamai.amp.utils.Base64;
import com.akamai.amp.utils.LogManager;
import com.akamai.amp.utils.Utils;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class RSALicenseDecryption
extends LicenseDecryption {
    public static final String LOCAL_LICENSE_TAG = "Local License";
    private final String mPublicKey = "MFwwDQYJKoZIhvcNAQEBBQADSwAwSAJBAMSq0_b7hGrpyHdA7wvRfI1jSo_Lwbc5X4FqqMg_fr-oYxh7Hn5kV43Pu-twZdzjHLmpd2qV0y9rD_32gWujwFMCAwEAAQ==";
    private static final int MAX_PACKAGE_LENGTH_ALLOWED = 40;
    private String mPackageInLicense;
    private Date mExpirationDateInLicense;
    private VideoPlayerContainer videoPlayerContainer;
    private LicenseNotification licenseNotification;
    private boolean licenseValid = true;

    public RSALicenseDecryption(Context context, VideoPlayerContainer videoPlayerContainer) {
        this.videoPlayerContainer = videoPlayerContainer;
        this.mContext = context;
    }

    public RSALicenseDecryption(Context context) {
        this.mContext = context;
    }

    @Override
    public int getCause() {
        return this.cause;
    }

    public boolean isLicenseValid(String license) {
        this.doLicenseValidation(license);
        return this.getLicenseValidValue();
    }

    public boolean getLicenseValidValue() {
        return this.licenseValid;
    }

    public void showExpiredNotification() {
        if (this.licenseNotification == null) {
            this.licenseNotification = new LicenseNotification(this.mContext, "License expired");
        }
        this.attachInvalidLicenseNotification();
    }

    private void doLicenseValidation(String license) {
        try {
            LogManager.log(LOCAL_LICENSE_TAG, "License Validation run");
            this.checkHasContent(license);
            this.usingLicense = this.usingLicense + " [" + license + "]";
            LogManager.log(LOCAL_LICENSE_TAG, this.usingLicense);
            String[] params = this.decryptLicenseParams(license);
            this.mPackageInLicense = params[0];
            this.checkPackage(this.mPackageInLicense);
            this.mExpirationDateInLicense = new Date(Long.parseLong(params[1]));
            this.checkDate(this.mExpirationDateInLicense);
            this.licenseValid = true;
        }
        catch (InvalidLicenseException | IOException | InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            this.licenseValid = false;
        }
    }

    private void checkHasContent(String license) {
        if (license == null || license.trim().isEmpty()) {
            String message = "Local license key not set (Ignore in case a valid API key was provided)";
            Log.e((String)LOCAL_LICENSE_TAG, (String)message);
            this.cause = 2;
            throw new InvalidLicenseException(message);
        }
    }

    private void checkPackage(String packageInLicense) {
        boolean invalidPackage;
        packageInLicense = RSALicenseDecryption.trim(packageInLicense);
        String currentPackage = RSALicenseDecryption.trim(this.mContext.getPackageName());
        boolean bl = invalidPackage = !currentPackage.equals(packageInLicense);
        if (invalidPackage) {
            String message = "There is a mismatch with the packages: current[" + currentPackage + "] license[" + packageInLicense + "].\n" + this.usingLicense;
            Log.e((String)LOCAL_LICENSE_TAG, (String)message);
            this.cause = 1;
            throw new InvalidLicenseException(message);
        }
    }

    private static String trim(String license) {
        if (license.length() > 40) {
            String sub = (String)license.subSequence(0, 40);
            return sub;
        }
        return license;
    }

    protected void checkDate(Date expirationDateInLicense) {
        Date now = new Date();
        boolean expiredLicense = now.after(expirationDateInLicense);
        if (expiredLicense) {
            this.onExpired(expirationDateInLicense, now);
        } else {
            this.onNotExpired(expirationDateInLicense, now);
        }
    }

    private void onNotExpired(Date expirationDateInLicense, Date now) {
        boolean soonToExpire;
        this.daysUntilExpiration = Utils.getDateDiff(now, expirationDateInLicense, TimeUnit.DAYS);
        String message = this.daysUntilExpiration == 1L ? "This license will expire tomorrow" : String.format("This license will expire in %d days", this.daysUntilExpiration);
        boolean bl = soonToExpire = this.daysUntilExpiration <= 90L;
        if (soonToExpire) {
            LogManager.error(LOCAL_LICENSE_TAG, message);
        } else {
            LogManager.log(LOCAL_LICENSE_TAG, message);
        }
    }

    private void onExpired(Date expirationDateInLicense, Date now) {
        String message = "The license dates are incorrect: now[" + now + "] expiration[" + expirationDateInLicense + "].\n" + this.usingLicense;
        Log.e((String)LOCAL_LICENSE_TAG, (String)message);
        this.cause = 0;
        throw new InvalidLicenseException(message);
    }

    private String[] decryptLicenseParams(String license) throws NoSuchAlgorithmException, NoSuchPaddingException, IOException, InvalidKeySpecException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        Cipher rsa = Cipher.getInstance("RSA");
        byte[] keyBytes = Base64.decode("MFwwDQYJKoZIhvcNAQEBBQADSwAwSAJBAMSq0_b7hGrpyHdA7wvRfI1jSo_Lwbc5X4FqqMg_fr-oYxh7Hn5kV43Pu-twZdzjHLmpd2qV0y9rD_32gWujwFMCAwEAAQ==", 16);
        X509EncodedKeySpec specPublic = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PublicKey key = keyFactory.generatePublic(specPublic);
        byte[] decryptedBytes = null;
        rsa.init(2, key);
        decryptedBytes = rsa.doFinal(Base64.decode(license, 16));
        String decryptedText = new String(decryptedBytes);
        String[] params = decryptedText.split("-");
        if (params.length != 3) {
            String message = "The license key is invalid. " + this.usingLicense;
            Log.e((String)LOCAL_LICENSE_TAG, (String)message);
            throw new InvalidLicenseException(message);
        }
        return params;
    }

    public String getLicensePackageName() {
        return this.mPackageInLicense;
    }

    public Date getLicenseExpirationDate() {
        return this.mExpirationDateInLicense;
    }

    public void attachInvalidLicenseNotification() {
        if (this.videoPlayerContainer == null) {
            return;
        }
        Utils.tryRemoveFromParent((View)this.licenseNotification);
        FrameLayout.LayoutParams lParams = new FrameLayout.LayoutParams(-1, -2);
        lParams.gravity = 80;
        this.videoPlayerContainer.addView((View)this.licenseNotification, this.videoPlayerContainer.getChildCount(), (ViewGroup.LayoutParams)lParams);
        this.videoPlayerContainer.requestLayout();
        this.videoPlayerContainer.forceLayout();
    }

    public long getDaysUntilExpiration() {
        return this.daysUntilExpiration;
    }
}

