/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.extractor.flv;

import com.akamai.amp.exoplayer2.extractor.Extractor;
import com.akamai.amp.exoplayer2.extractor.ExtractorInput;
import com.akamai.amp.exoplayer2.extractor.ExtractorOutput;
import com.akamai.amp.exoplayer2.extractor.ExtractorsFactory;
import com.akamai.amp.exoplayer2.extractor.IndexSeekMap;
import com.akamai.amp.exoplayer2.extractor.PositionHolder;
import com.akamai.amp.exoplayer2.extractor.SeekMap;
import com.akamai.amp.exoplayer2.extractor.flv.AudioTagPayloadReader;
import com.akamai.amp.exoplayer2.extractor.flv.ScriptTagPayloadReader;
import com.akamai.amp.exoplayer2.extractor.flv.VideoTagPayloadReader;
import com.akamai.amp.exoplayer2.util.Assertions;
import com.akamai.amp.exoplayer2.util.ParsableByteArray;
import java.io.IOException;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

public final class FlvExtractor
implements Extractor {
    public static final ExtractorsFactory FACTORY = () -> new Extractor[]{new FlvExtractor()};
    private static final int STATE_READING_FLV_HEADER = 1;
    private static final int STATE_SKIPPING_TO_TAG_HEADER = 2;
    private static final int STATE_READING_TAG_HEADER = 3;
    private static final int STATE_READING_TAG_DATA = 4;
    private static final int FLV_HEADER_SIZE = 9;
    private static final int FLV_TAG_HEADER_SIZE = 11;
    private static final int TAG_TYPE_AUDIO = 8;
    private static final int TAG_TYPE_VIDEO = 9;
    private static final int TAG_TYPE_SCRIPT_DATA = 18;
    private static final int FLV_TAG = 4607062;
    private final ParsableByteArray scratch = new ParsableByteArray(4);
    private final ParsableByteArray headerBuffer = new ParsableByteArray(9);
    private final ParsableByteArray tagHeaderBuffer = new ParsableByteArray(11);
    private final ParsableByteArray tagData = new ParsableByteArray();
    private final ScriptTagPayloadReader metadataReader = new ScriptTagPayloadReader();
    private @MonotonicNonNull ExtractorOutput extractorOutput;
    private int state = 1;
    private boolean outputFirstSample;
    private long mediaTagTimestampOffsetUs;
    private int bytesToNextTagHeader;
    private int tagType;
    private int tagDataSize;
    private long tagTimestampUs;
    private boolean outputSeekMap;
    private @MonotonicNonNull AudioTagPayloadReader audioReader;
    private @MonotonicNonNull VideoTagPayloadReader videoReader;

    @Override
    public boolean sniff(ExtractorInput input) throws IOException {
        input.peekFully(this.scratch.getData(), 0, 3);
        this.scratch.setPosition(0);
        if (this.scratch.readUnsignedInt24() != 4607062) {
            return false;
        }
        input.peekFully(this.scratch.getData(), 0, 2);
        this.scratch.setPosition(0);
        if ((this.scratch.readUnsignedShort() & 0xFA) != 0) {
            return false;
        }
        input.peekFully(this.scratch.getData(), 0, 4);
        this.scratch.setPosition(0);
        int dataOffset = this.scratch.readInt();
        input.resetPeekPosition();
        input.advancePeekPosition(dataOffset);
        input.peekFully(this.scratch.getData(), 0, 4);
        this.scratch.setPosition(0);
        return this.scratch.readInt() == 0;
    }

    @Override
    public void init(ExtractorOutput output) {
        this.extractorOutput = output;
    }

    @Override
    public void seek(long position, long timeUs) {
        if (position == 0L) {
            this.state = 1;
            this.outputFirstSample = false;
        } else {
            this.state = 3;
        }
        this.bytesToNextTagHeader = 0;
    }

    @Override
    public void release() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int read(ExtractorInput input, PositionHolder seekPosition) throws IOException {
        Assertions.checkStateNotNull(this.extractorOutput);
        block6: while (true) {
            switch (this.state) {
                case 1: {
                    if (this.readFlvHeader(input)) continue block6;
                    return -1;
                }
                case 2: {
                    this.skipToTagHeader(input);
                    continue block6;
                }
                case 3: {
                    if (this.readTagHeader(input)) continue block6;
                    return -1;
                }
                case 4: {
                    if (this.readTagData(input)) return 0;
                    continue block6;
                }
            }
            break;
        }
        throw new IllegalStateException();
    }

    @RequiresNonNull(value={"extractorOutput"})
    private boolean readFlvHeader(ExtractorInput input) throws IOException {
        boolean hasVideo;
        if (!input.readFully(this.headerBuffer.getData(), 0, 9, true)) {
            return false;
        }
        this.headerBuffer.setPosition(0);
        this.headerBuffer.skipBytes(4);
        int flags = this.headerBuffer.readUnsignedByte();
        boolean hasAudio = (flags & 4) != 0;
        boolean bl = hasVideo = (flags & 1) != 0;
        if (hasAudio && this.audioReader == null) {
            this.audioReader = new AudioTagPayloadReader(this.extractorOutput.track(8, 1));
        }
        if (hasVideo && this.videoReader == null) {
            this.videoReader = new VideoTagPayloadReader(this.extractorOutput.track(9, 2));
        }
        this.extractorOutput.endTracks();
        this.bytesToNextTagHeader = this.headerBuffer.readInt() - 9 + 4;
        this.state = 2;
        return true;
    }

    private void skipToTagHeader(ExtractorInput input) throws IOException {
        input.skipFully(this.bytesToNextTagHeader);
        this.bytesToNextTagHeader = 0;
        this.state = 3;
    }

    private boolean readTagHeader(ExtractorInput input) throws IOException {
        if (!input.readFully(this.tagHeaderBuffer.getData(), 0, 11, true)) {
            return false;
        }
        this.tagHeaderBuffer.setPosition(0);
        this.tagType = this.tagHeaderBuffer.readUnsignedByte();
        this.tagDataSize = this.tagHeaderBuffer.readUnsignedInt24();
        this.tagTimestampUs = this.tagHeaderBuffer.readUnsignedInt24();
        this.tagTimestampUs = ((long)(this.tagHeaderBuffer.readUnsignedByte() << 24) | this.tagTimestampUs) * 1000L;
        this.tagHeaderBuffer.skipBytes(3);
        this.state = 4;
        return true;
    }

    @RequiresNonNull(value={"extractorOutput"})
    private boolean readTagData(ExtractorInput input) throws IOException {
        boolean wasConsumed = true;
        boolean wasSampleOutput = false;
        long timestampUs = this.getCurrentTimestampUs();
        if (this.tagType == 8 && this.audioReader != null) {
            this.ensureReadyForMediaOutput();
            wasSampleOutput = this.audioReader.consume(this.prepareTagData(input), timestampUs);
        } else if (this.tagType == 9 && this.videoReader != null) {
            this.ensureReadyForMediaOutput();
            wasSampleOutput = this.videoReader.consume(this.prepareTagData(input), timestampUs);
        } else if (this.tagType == 18 && !this.outputSeekMap) {
            wasSampleOutput = this.metadataReader.consume(this.prepareTagData(input), timestampUs);
            long durationUs = this.metadataReader.getDurationUs();
            if (durationUs != -9223372036854775807L) {
                this.extractorOutput.seekMap(new IndexSeekMap(this.metadataReader.getKeyFrameTagPositions(), this.metadataReader.getKeyFrameTimesUs(), durationUs));
                this.outputSeekMap = true;
            }
        } else {
            input.skipFully(this.tagDataSize);
            wasConsumed = false;
        }
        if (!this.outputFirstSample && wasSampleOutput) {
            this.outputFirstSample = true;
            this.mediaTagTimestampOffsetUs = this.metadataReader.getDurationUs() == -9223372036854775807L ? -this.tagTimestampUs : 0L;
        }
        this.bytesToNextTagHeader = 4;
        this.state = 2;
        return wasConsumed;
    }

    private ParsableByteArray prepareTagData(ExtractorInput input) throws IOException {
        if (this.tagDataSize > this.tagData.capacity()) {
            this.tagData.reset(new byte[Math.max(this.tagData.capacity() * 2, this.tagDataSize)], 0);
        } else {
            this.tagData.setPosition(0);
        }
        this.tagData.setLimit(this.tagDataSize);
        input.readFully(this.tagData.getData(), 0, this.tagDataSize);
        return this.tagData;
    }

    @RequiresNonNull(value={"extractorOutput"})
    private void ensureReadyForMediaOutput() {
        if (!this.outputSeekMap) {
            this.extractorOutput.seekMap(new SeekMap.Unseekable(-9223372036854775807L));
            this.outputSeekMap = true;
        }
    }

    private long getCurrentTimestampUs() {
        return this.outputFirstSample ? this.mediaTagTimestampOffsetUs + this.tagTimestampUs : (this.metadataReader.getDurationUs() == -9223372036854775807L ? 0L : this.tagTimestampUs);
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface States {
    }
}

