/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.extractor;

import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.extractor.ExtractorInput;
import com.akamai.amp.exoplayer2.metadata.Metadata;
import com.akamai.amp.exoplayer2.metadata.id3.Id3Decoder;
import com.akamai.amp.exoplayer2.util.ParsableByteArray;
import java.io.EOFException;
import java.io.IOException;

public final class Id3Peeker {
    private final ParsableByteArray scratch = new ParsableByteArray(10);

    @Nullable
    public Metadata peekId3Data(ExtractorInput input, @Nullable Id3Decoder.FramePredicate id3FramePredicate) throws IOException {
        int peekedId3Bytes = 0;
        Metadata metadata = null;
        while (true) {
            try {
                input.peekFully(this.scratch.getData(), 0, 10);
            }
            catch (EOFException e) {
                break;
            }
            this.scratch.setPosition(0);
            if (this.scratch.readUnsignedInt24() != 0x494433) break;
            this.scratch.skipBytes(3);
            int framesLength = this.scratch.readSynchSafeInt();
            int tagLength = 10 + framesLength;
            if (metadata == null) {
                byte[] id3Data = new byte[tagLength];
                System.arraycopy(this.scratch.getData(), 0, id3Data, 0, 10);
                input.peekFully(id3Data, 10, framesLength);
                metadata = new Id3Decoder(id3FramePredicate).decode(id3Data, tagLength);
            } else {
                input.advancePeekPosition(framesLength);
            }
            peekedId3Bytes += tagLength;
        }
        input.resetPeekPosition();
        input.advancePeekPosition(peekedId3Bytes);
        return metadata;
    }
}

