/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.cc;

import android.annotation.TargetApi;
import android.content.Context;
import android.util.AttributeSet;
import android.util.Pair;
import android.view.accessibility.CaptioningManager;
import com.akamai.amp.ads.AdsCount;
import com.akamai.amp.ads.AdsInfo;
import com.akamai.amp.ads.IAdsComponentListener;
import com.akamai.amp.exoplayer2.text.TextOutput;
import com.akamai.amp.exoplayer2.ui.SubtitleView;
import com.akamai.amp.exoplayer2.util.Util;
import com.akamai.amp.media.VideoPlayerView;
import com.akamai.amp.media.VideoPlayerViewExo;
import com.akamai.amp.media.exowrapper2.SideloadedCaptionsData;
import com.akamai.amp.utils.LogManager;
import com.akamai.amp.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AmpSubtitleView
extends SubtitleView
implements TextOutput {
    private static final String LOG_TAG = AmpSubtitleView.class.getSimpleName();
    private static final String VERSION = "9.10.6";
    private VideoPlayerViewExo exo = null;
    private int trackIndex = -1;
    private int formatIndex = -1;
    private boolean hasCaptions = false;
    private IAdsComponentListener iAdsComponentListener = new IAdsComponentListener(){

        public void onAdsStarted(AdsInfo ad) {
            AmpSubtitleView.this.hide();
        }

        @Override
        public void onAdsEnded() {
            AmpSubtitleView.this.show();
        }

        @Override
        public void onAdsResumed() {
            AmpSubtitleView.this.hide();
        }

        @Override
        public void onAdsError(String reason) {
            AmpSubtitleView.this.show();
        }

        @Override
        public void onResumeContentRequested() {
            AmpSubtitleView.this.show();
        }

        @Override
        public void onPauseContentRequested() {
            AmpSubtitleView.this.hide();
        }

        @Override
        public void onAdBreakStarted() {
        }

        @Override
        public void onAdBreakEnded() {
        }

        @Override
        public void onAllPostrollsEnded() {
        }

        @Override
        public void onAdsTapped() {
        }

        @Override
        public void onListenerRegistered() {
        }

        @Override
        public void onAdsInitialized() {
        }

        @Override
        public void onAdRequest() {
        }

        @Override
        public void onAdsLoaded(AdsCount adsCount) {
        }

        @Override
        public void onAdsPaused() {
        }

        @Override
        public void onAdsTrackProgress(int progress) {
        }

        @Override
        public void onAdsPlayheadUpdate(int seconds) {
        }

        @Override
        public void onAdSkipped() {
        }

        @Override
        public void onAdEvent() {
        }

        @Override
        public void onAdBufferingStarted() {
        }

        @Override
        public void onAdBufferingEnded() {
        }
    };

    public AmpSubtitleView(Context context) {
        super(context);
        this.init();
    }

    public AmpSubtitleView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public IAdsComponentListener getAdsComponentListener() {
        return this.iAdsComponentListener;
    }

    public void show() {
        this.setVisibility(0);
        if (this.exo != null) {
            this.exo.onCCEnabled();
        }
    }

    public void hide() {
        this.setVisibility(8);
        if (this.exo != null) {
            this.exo.onCCDisabled();
        }
    }

    @TargetApi(value=19)
    public boolean isCaptioningManagerEnabled() {
        if (Util.SDK_INT < 18) {
            return false;
        }
        CaptioningManager captioningManager = (CaptioningManager)this.getContext().getSystemService("captioning");
        boolean enabled = captioningManager.isEnabled();
        LogManager.log(LOG_TAG, "LOG_TAG.isCaptioningManagerEnabled() " + String.valueOf(enabled).toUpperCase());
        return enabled;
    }

    public void setVideoPlayerView(VideoPlayerView videoView) {
        this.invalidate();
        this.hasCaptions = false;
        if (this.exo == videoView) {
            return;
        }
        this.exo = null;
        if (videoView == null) {
            return;
        }
        this.exo = (VideoPlayerViewExo)videoView;
        this.exo.setTextRendererOutput(this);
    }

    public void setTrackIndex(int trackIndex) {
        if (trackIndex == this.trackIndex) {
            return;
        }
        this.trackIndex = trackIndex++;
        if (this.exo == null) {
            return;
        }
        if (this.exo.areThumbnailsEnabled()) {
            // empty if block
        }
        this.exo.setTrackIndex(trackIndex);
    }

    public void setFormatIndex(int formatIndex) {
        if (formatIndex == this.formatIndex) {
            return;
        }
        this.formatIndex = formatIndex;
        if (this.exo != null) {
            this.exo.setFormatIndex(formatIndex);
        }
    }

    public void setIndexes(int trackIndex, int formatIndex) {
        LogManager.log(LOG_TAG, "setTrackIndexes (" + trackIndex + ", " + formatIndex + ")");
        this.trackIndex = trackIndex++;
        this.formatIndex = formatIndex;
        if (this.exo == null) {
            return;
        }
        if (this.exo.areThumbnailsEnabled()) {
            // empty if block
        }
        this.exo.setTrackIndexes(trackIndex, formatIndex);
    }

    public Map<Pair<Integer, Integer>, String> getDataTracks() {
        if (this.exo == null) {
            return Collections.emptyMap();
        }
        return this.exo.getDataTracks();
    }

    public void sideload(SideloadedCaptionsData data) {
        if (this.exo == null) {
            return;
        }
        ArrayList<SideloadedCaptionsData> captions = new ArrayList<SideloadedCaptionsData>();
        captions.add(data);
        this.exo.sideload(captions);
    }

    public void sideload(List<SideloadedCaptionsData> data) {
        if (this.exo == null) {
            return;
        }
        this.exo.sideload(data);
    }

    public boolean isCCEnabled() {
        return 0 == this.getVisibility();
    }

    public boolean loadCaptionsLanguage(boolean captionsEnabled, String lang) {
        if (captionsEnabled) {
            this.show();
        } else {
            this.hide();
        }
        this.validateCaptionsAvailable(lang);
        if (!captionsEnabled) {
            return false;
        }
        return this.isCCTrackSelected(lang);
    }

    public boolean hasCaptions() {
        return this.hasCaptions;
    }

    public boolean validateCaptionsAvailable(String lang) {
        this.hasCaptions = this.getTrackPair(lang) != null;
        return this.hasCaptions;
    }

    private void init() {
        Utils.checkModuleVersion(LOG_TAG, VERSION);
        this.setUserDefaultStyle();
        this.setUserDefaultTextSize();
    }

    private boolean isCCTrackSelected(String lang) {
        if (this.exo == null) {
            return false;
        }
        Pair<Integer, Integer> trackPair = this.getTrackPair(lang);
        if (trackPair != null) {
            this.setIndexes((Integer)trackPair.first, (Integer)trackPair.second);
            this.show();
            return true;
        }
        return false;
    }

    private Pair<Integer, Integer> getTrackPair(String lang) {
        if (this.exo == null) {
            return null;
        }
        Map<Pair<Integer, Integer>, String> dataTracks = this.getDataTracks();
        try {
            boolean isLive = this.exo.isLive();
            return isLive ? this.firstKey(dataTracks) : this.findKeyStartsWith(dataTracks, lang);
        }
        catch (Exception e) {
            LogManager.error(LOG_TAG, e);
            return null;
        }
    }

    private Pair<Integer, Integer> findKeyStartsWith(Map<Pair<Integer, Integer>, String> m, String text) {
        if (m == null) {
            return null;
        }
        if (text == null) {
            return null;
        }
        text = text.toLowerCase();
        for (Pair<Integer, Integer> key : m.keySet()) {
            String captionLanguage = m.get(key);
            if (!captionLanguage.toLowerCase().startsWith(text)) continue;
            return key;
        }
        return null;
    }

    private Pair<Integer, Integer> firstKey(Map<Pair<Integer, Integer>, String> m) {
        if (m == null) {
            return null;
        }
        Iterator<Pair<Integer, Integer>> iterator = m.keySet().iterator();
        if (iterator.hasNext()) {
            Pair<Integer, Integer> key = iterator.next();
            return key;
        }
        return null;
    }
}

