/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.analytics.akamaimedia;

import com.akamai.amp.ads.AdsCount;
import com.akamai.amp.ads.AdsInfo;
import com.akamai.amp.analytics.AnalyticsTracker;
import com.akamai.amp.analytics.AnalyticsTrackerData;
import com.akamai.amp.analytics.akamaimedia.AmpAkamaiMediaAnalyticsTracker;
import com.akamai.amp.config.Config;
import com.akamai.amp.config.data.MediaAnalyticsData;
import com.akamai.amp.media.IPlayerEventsListener;
import com.akamai.amp.media.VideoPlayerView;
import com.akamai.amp.utils.LogManager;
import com.akamai.android.analytics.AkamaiMediaAnalytics;
import com.akamai.android.analytics.EndReasonCodes;
import com.akamai.android.analytics.PluginCallBacks;
import java.util.HashMap;
import java.util.Map;

public class MediaEventsHandler
extends AnalyticsTracker<MediaAnalyticsData>
implements AmpAkamaiMediaAnalyticsTracker {
    private static final String LOG_TAG = "AkamaiMediaAnalyticsTracker";
    public static final String VERSION = "9.10.6";
    private static AkamaiMediaAnalytics akamaiMediaAnalytics;
    private PluginCallBacks mMediaAnalyticsCallbacks = null;
    private boolean locationSupport = false;
    private boolean sessionClosed = false;

    public MediaEventsHandler(MediaAnalyticsData data) {
        super((AnalyticsTrackerData)data, LOG_TAG, VERSION);
    }

    public MediaEventsHandler(VideoPlayerView videoPlayerView, MediaAnalyticsData data) {
        super(videoPlayerView, (AnalyticsTrackerData)data, LOG_TAG, VERSION);
        this.setPlayerEventsListener(videoPlayerView);
    }

    private void setPlayerEventsListener(VideoPlayerView videoPlayerView) {
        if (videoPlayerView != null) {
            videoPlayerView.addEventsListener(new IPlayerEventsListener(){

                public boolean onPlayerEvent(int iInEventType) {
                    if (20 == iInEventType) {
                        MediaEventsHandler.this.trackABR();
                    }
                    return true;
                }

                public boolean onPlayerExtendedEvent(int eventId, int arg1, int arg2) {
                    return false;
                }
            });
        }
    }

    public void setVideoPlayerView(VideoPlayerView videoView) {
        super.setVideoPlayerView(videoView);
        this.setPlayerEventsListener(videoView);
    }

    public void setContentLabel(String tag, String value) {
        if (akamaiMediaAnalytics == null || this.sessionClosed) {
            return;
        }
        akamaiMediaAnalytics.setData(tag, value);
    }

    public void setContentLabels(Map<String, String> map) {
        if (akamaiMediaAnalytics == null || this.sessionClosed) {
            return;
        }
        for (Map.Entry<String, String> e : map.entrySet()) {
            akamaiMediaAnalytics.setData(e.getKey(), e.getValue());
        }
    }

    public void setAdLabel(String tag, String value) {
        if (akamaiMediaAnalytics == null || this.sessionClosed) {
            return;
        }
        akamaiMediaAnalytics.setData(tag, value);
    }

    public void setAdLabels(Map<String, String> map) {
        if (akamaiMediaAnalytics == null || this.sessionClosed) {
            return;
        }
        for (Map.Entry<String, String> e : map.entrySet()) {
            akamaiMediaAnalytics.setData(e.getKey(), e.getValue());
        }
    }

    public void cleanup() {
        if (akamaiMediaAnalytics != null && !this.sessionClosed) {
            akamaiMediaAnalytics.handleSessionCleanup();
        }
        akamaiMediaAnalytics = null;
        this.sessionClosed = true;
        this.isSessionInitialized = false;
    }

    public void onDestroy() {
        super.removeFromPlayerListeners();
        akamaiMediaAnalytics = null;
    }

    public String getExternalLibVersion() {
        return "3.3";
    }

    @Override
    public PluginCallBacks getPluginCallBacks() {
        if (this.mMediaAnalyticsCallbacks == null) {
            this.mMediaAnalyticsCallbacks = this.initPluginCallBacks();
        }
        return this.mMediaAnalyticsCallbacks;
    }

    @Override
    public void setMediaAnalyticsConfigUrl(String configUrl) {
        String currentBeacon;
        boolean isSameBeacon;
        if (akamaiMediaAnalytics != null && (isSameBeacon = (currentBeacon = this.getMediaAnalyticsData().getMediaAnalyticsBeacon()).equals(configUrl))) {
            return;
        }
        this.sessionClosed = false;
        LogManager.log((String)LOG_TAG, (String)("MediaAnalytics Config XML: " + configUrl + " " + this.printStatus()));
        MediaAnalyticsData data = this.getMediaAnalyticsData();
        data.setMediaAnalyticsBeacon(configUrl);
        akamaiMediaAnalytics = new AkamaiMediaAnalytics(this.getOwner(), configUrl);
        this.setLocationSupport(this.locationSupport);
        this.addDefaultDimensions(data);
        this.setDimensionsToAnalyticsController(data);
    }

    @Override
    public void setLocationSupport(boolean isEnabled) {
        this.locationSupport = isEnabled;
        if (akamaiMediaAnalytics == null || this.sessionClosed) {
            return;
        }
        if (isEnabled) {
            akamaiMediaAnalytics.enableLocationSupport();
        } else {
            akamaiMediaAnalytics.disableLocationSupport();
        }
    }

    @Override
    public void setMediaAnalyticsViewerDiagnosticsId(String viewerId) {
        if (akamaiMediaAnalytics == null || this.sessionClosed) {
            return;
        }
        LogManager.log((String)LOG_TAG, (String)("setMediaAnalyticsViewerDiagnosticsId: " + viewerId));
        akamaiMediaAnalytics.setViewerDiagnosticsId(viewerId);
    }

    @Override
    public void setMediaAnalyticsViewerId(String viewerId) {
        if (akamaiMediaAnalytics == null || this.sessionClosed) {
            return;
        }
        LogManager.log((String)LOG_TAG, (String)("setMediaAnalyticsViewerId: " + viewerId));
        akamaiMediaAnalytics.setViewerId(viewerId);
    }

    @Override
    public void setMediaAnalyticsData(String key, String value) {
        MediaAnalyticsData mediaAnalyticsData = this.getMediaAnalyticsData();
        mediaAnalyticsData.putValue(key, value);
    }

    public void trackInit() {
        if (akamaiMediaAnalytics == null || this.sessionClosed || this.mVideoPlayerView == null || this.isSessionInitialized) {
            return;
        }
        this.isSessionInitialized = true;
        LogManager.log((String)LOG_TAG, (String)("trackInit " + this.printStatus()));
        akamaiMediaAnalytics.setStreamURL(this.mVideoPlayerView.getStreamUrl(), true);
        akamaiMediaAnalytics.handleSessionInit(this.getPluginCallBacks());
        akamaiMediaAnalytics.setStreamDuration(this.mVideoPlayerView.getTimelineDuration());
    }

    public void trackVideoLoad() {
        this.trackInit();
    }

    public void trackStartRebuffering() {
        LogManager.log((String)LOG_TAG, (String)"trackStartRebuffering");
        if (akamaiMediaAnalytics == null || this.sessionClosed) {
            return;
        }
        akamaiMediaAnalytics.handleBufferStart();
    }

    public void trackStopRebuffering() {
        LogManager.log((String)LOG_TAG, (String)"trackStopRebuffering");
        if (akamaiMediaAnalytics == null || this.sessionClosed) {
            return;
        }
        akamaiMediaAnalytics.handleBufferEnd();
        this.trackABR();
    }

    public void trackPlayEvent() {
        LogManager.log((String)LOG_TAG, (String)"trackPlayEvent");
        if (akamaiMediaAnalytics == null || this.sessionClosed) {
            return;
        }
        this.setDeliveryType((MediaAnalyticsData)this.data);
        this.setDeliveryTypeDimension((MediaAnalyticsData)this.data);
        akamaiMediaAnalytics.handlePlaying();
        this.trackABR();
    }

    public void trackStopPlaying() {
        LogManager.log((String)LOG_TAG, (String)"trackStopPlaying");
        if (!this.sessionClosed) {
            this.trackFinish();
            this.cleanup();
        }
    }

    public void trackPauseEvent() {
        LogManager.log((String)LOG_TAG, (String)"trackPauseEvent");
        if (akamaiMediaAnalytics == null || this.sessionClosed) {
            return;
        }
        akamaiMediaAnalytics.handlePause();
    }

    public void trackResumeEvent() {
        LogManager.log((String)LOG_TAG, (String)"trackResumeEvent");
        if (akamaiMediaAnalytics == null || this.sessionClosed) {
            return;
        }
        akamaiMediaAnalytics.handleResume(false);
    }

    public void trackSendToBackground() {
        LogManager.log((String)LOG_TAG, (String)("trackSendToBackground " + this.printStatus()));
        if (akamaiMediaAnalytics == null || this.sessionClosed) {
            return;
        }
        this.trackStopPlaying();
    }

    public void trackSendToForeground() {
        LogManager.log((String)LOG_TAG, (String)("trackSendToForeground " + this.printStatus()));
        if (this.data == null) {
            return;
        }
        String beacon = ((MediaAnalyticsData)this.data).getMediaAnalyticsBeacon();
        this.setMediaAnalyticsConfigUrl(beacon);
        this.trackInit();
    }

    public void trackSeekStarted() {
        LogManager.log((String)LOG_TAG, (String)"trackSeekStarted");
        if (akamaiMediaAnalytics == null || this.sessionClosed) {
            return;
        }
        akamaiMediaAnalytics.handleSeekStart((float)this.getCurrentPositionInMillis());
    }

    public void trackSeekComplete() {
        LogManager.log((String)LOG_TAG, (String)"trackSeekComplete");
        if (akamaiMediaAnalytics == null || this.sessionClosed) {
            return;
        }
        akamaiMediaAnalytics.handleSeekEnd((float)this.getCurrentPositionInMillis());
    }

    public void trackError(String errorMessage) {
        LogManager.error((String)LOG_TAG, (String)("trackError: " + errorMessage));
        if (akamaiMediaAnalytics == null || this.sessionClosed) {
            return;
        }
        akamaiMediaAnalytics.handleError(errorMessage);
        this.isSessionInitialized = false;
    }

    public void trackFinish() {
        LogManager.log((String)LOG_TAG, (String)"trackFinish");
        if (akamaiMediaAnalytics == null || this.sessionClosed) {
            return;
        }
        akamaiMediaAnalytics.handlePlayEnd(EndReasonCodes.Play_End_Detected.toString());
        akamaiMediaAnalytics.handleVisit();
    }

    public void trackABR() {
        LogManager.log((String)LOG_TAG, (String)"trackABR");
        if (akamaiMediaAnalytics == null || this.sessionClosed) {
            return;
        }
        akamaiMediaAnalytics.handleBitRateSwitch(this.mVideoPlayerView != null ? (int)this.mVideoPlayerView.getCurrentBitrate() : 0);
    }

    public void trackFullScreen() {
        LogManager.log((String)LOG_TAG, (String)"trackFullScreen");
        if (akamaiMediaAnalytics == null || this.sessionClosed) {
            return;
        }
        akamaiMediaAnalytics.handleFullScreen(this.mVideoPlayerView != null && this.mVideoPlayerView.isFullScreen());
    }

    public void trackAdsError(String reason) {
        LogManager.error((String)LOG_TAG, (String)("trackAdsError: " + reason));
        if (akamaiMediaAnalytics == null || this.sessionClosed) {
            return;
        }
        akamaiMediaAnalytics.handleAdError();
    }

    public void trackAdsLoaded(AdsCount adsCount) {
        LogManager.log((String)LOG_TAG, (String)("trackAdsLoaded " + adsCount));
        if (akamaiMediaAnalytics == null || this.sessionClosed) {
            return;
        }
        HashMap adObject = new HashMap();
        akamaiMediaAnalytics.handleAdLoaded(adObject);
    }

    public void trackAdsStarted(AdsInfo ad) {
        LogManager.log((String)LOG_TAG, (String)("trackAdsStarted: " + ad));
        if (akamaiMediaAnalytics == null || this.sessionClosed) {
            return;
        }
        HashMap<String, String> adInfo = new HashMap<String, String>();
        adInfo.put("adId", ad.adId);
        adInfo.put("adName", ad.name);
        adInfo.put("adType", ad.getClass().getSimpleName());
        akamaiMediaAnalytics.handleAdStarted(adInfo);
    }

    public void trackAdsEnded() {
        LogManager.log((String)LOG_TAG, (String)"trackAdsEnded");
        if (akamaiMediaAnalytics == null || this.sessionClosed) {
            return;
        }
        akamaiMediaAnalytics.handleAdComplete();
    }

    public void trackAdsTrackProgress(int progress) {
        LogManager.log((String)LOG_TAG, (String)("trackAdsTrackProgress " + progress));
        if (akamaiMediaAnalytics == null || this.sessionClosed) {
            return;
        }
        switch (progress) {
            case 0: {
                akamaiMediaAnalytics.handleAdFirstQuartile();
                break;
            }
            case 1: {
                akamaiMediaAnalytics.handleAdMidPoint();
                break;
            }
            case 2: {
                akamaiMediaAnalytics.handleAdThirdQuartile();
                break;
            }
            case 3: {
                akamaiMediaAnalytics.handleAdComplete();
            }
        }
    }

    public void init() {
        String mediaAnalyticsBeacon = ((MediaAnalyticsData)this.data).getMediaAnalyticsBeacon();
        this.setMediaAnalyticsConfigUrl(mediaAnalyticsBeacon);
    }

    protected MediaAnalyticsData loadDataFromConfig() {
        return Config.getConfig().mediaAnalyticsData;
    }

    private PluginCallBacks initPluginCallBacks() {
        return new PluginCallBacks(){

            public float streamHeadPosition() {
                float streamHeadPosition = MediaEventsHandler.this.currentTimeInMillis;
                return streamHeadPosition;
            }

            public int droppedFrames() {
                return 0;
            }

            public long bytesLoaded() {
                long bytesLoaded = MediaEventsHandler.this.mVideoPlayerView != null ? MediaEventsHandler.this.mVideoPlayerView.getBytesLoaded() : 0L;
                return bytesLoaded;
            }
        };
    }

    private MediaAnalyticsData getMediaAnalyticsData() {
        MediaAnalyticsData configData = Config.getConfig().mediaAnalyticsData;
        if (configData == null || configData.getMediaAnalyticsBeacon() == null || "".equals(configData.getMediaAnalyticsBeacon())) {
            configData = this.data == null ? new MediaAnalyticsData() : (MediaAnalyticsData)this.data;
        }
        return configData;
    }

    private void addDefaultDimensions(MediaAnalyticsData maData) {
        if (!maData.containsValue("device")) {
            maData.putValue("device", "Akamai Android SDK 9.10.6 player");
        }
        if (!maData.containsValue("format")) {
            maData.putValue("format", "L");
        }
        if (!maData.containsValue("os")) {
            maData.putValue("os", "Android");
        }
        if (!maData.containsValue("playerId")) {
            maData.putValue("playerId", "Akamai AMP SDK Android version 9.10.6");
        }
    }

    private void setDeliveryType(MediaAnalyticsData maData) {
        if (!maData.containsValue("deliveryType")) {
            maData.putValue("deliveryType", this.isLive ? "L" : "O");
        }
    }

    private void setDeliveryTypeDimension(MediaAnalyticsData maData) {
        if (akamaiMediaAnalytics == null || this.sessionClosed) {
            return;
        }
        String value = maData.getValue("deliveryType");
        akamaiMediaAnalytics.setData("deliveryType", value);
        LogManager.log((String)LOG_TAG, (String)("dimension: deliveryType: " + value));
    }

    private void setDimensionsToAnalyticsController(MediaAnalyticsData mediaAnalyticsData) {
        if (akamaiMediaAnalytics == null || this.sessionClosed) {
            return;
        }
        Map dimensions = mediaAnalyticsData.getMediaAnalyticsDimensions();
        if (dimensions == null) {
            return;
        }
        for (String key : dimensions.keySet()) {
            String value = mediaAnalyticsData.getValue(key);
            akamaiMediaAnalytics.setData(key, value);
            LogManager.log((String)LOG_TAG, (String)("dimension: " + key + ": " + value));
        }
    }

    private String printStatus() {
        String s = "AMP " + System.identityHashCode(this) + ", MA " + System.identityHashCode(akamaiMediaAnalytics);
        return s;
    }
}

