/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.ads.yospace;

import android.app.Activity;
import android.view.View;
import com.akamai.amp.ads.AdsCount;
import com.akamai.amp.ads.AdsInfo;
import com.akamai.amp.ads.IAdsComponentListener;
import com.akamai.amp.ads.yospace.AmpYospaceManager;
import com.akamai.amp.ads.yospace.CreativeHandler;
import com.akamai.amp.ads.yospace.PlayerPolicy;
import com.akamai.amp.ads.yospace.YospaceAdsInfo;
import com.akamai.amp.ads.yospace.YospaceUi;
import com.akamai.amp.ads.yospace.exo.ExoAdapterLive;
import com.akamai.amp.ads.yospace.exo.ExoAnalyticListener;
import com.akamai.amp.media.IPlayerEventsListener;
import com.akamai.amp.media.VideoPlayerContainer;
import com.akamai.amp.media.VideoPlayerView;
import com.akamai.amp.media.elements.MediaResource;
import com.akamai.amp.media.errors.ErrorType;
import com.akamai.amp.media.networking.IAutoRecoveryCallback;
import com.akamai.amp.media.networking.IConnectionSwitchCallback;
import com.akamai.amp.utils.LogManager;
import com.akamai.amp.utils.Utils;
import com.yospace.android.hls.analytic.AnalyticEventListener;
import com.yospace.android.hls.analytic.Session;
import com.yospace.android.hls.analytic.SessionFactory;
import com.yospace.android.hls.analytic.SessionLive;
import com.yospace.android.hls.analytic.advert.Advert;
import com.yospace.android.hls.analytic.policy.PolicyHandler;
import com.yospace.util.event.Event;
import com.yospace.util.event.EventListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class YospaceAdsHandler
implements AmpYospaceManager {
    public static final String LOG_TAG = YospaceAdsHandler.class.getSimpleName();
    public static final String VERSION = "9.10.6";
    private final int NO_FLAGS = -1;
    private int debugFlags = -1;
    private Activity activity;
    private SessionLive mSession;
    private ExoAdapterLive liveAdapter;
    private String streamURL;
    private String morphURL;
    private VideoPlayerContainer videoPlayerContainer;
    private VideoPlayerView videoPlayerView;
    private IAutoRecoveryCallback autoRecoveryTriggeredCallback;
    private YospaceUi yospaceUi;
    private boolean _isStarted;
    private boolean initInProgress;
    private boolean proxyInitialisation;
    private boolean alternateAdIsPlaying;
    private List<IAdsComponentListener> mListeners = new CopyOnWriteArrayList<IAdsComponentListener>();
    private IAdsComponentListener alternateAdProviderListener = new IAdsComponentListener(){

        public void onAdsLoaded(AdsCount adsCount) {
            YospaceAdsHandler.this.alternateAdIsPlaying = true;
        }

        public void onAdsEnded() {
            YospaceAdsHandler.this.alternateAdIsPlaying = false;
            if (!YospaceAdsHandler.this._isStarted) {
                YospaceAdsHandler.this.doOnConnectIfAllowed();
            }
        }

        public void onListenerRegistered() {
        }

        public void onAdsInitialized() {
        }

        public void onAdRequest() {
        }

        public void onAdsStarted(AdsInfo ad) {
        }

        public void onAdsPaused() {
        }

        public void onAdsResumed() {
        }

        public void onAdBreakStarted() {
        }

        public void onAdBreakEnded() {
        }

        public void onAllPostrollsEnded() {
        }

        public void onAdsTrackProgress(int progress) {
        }

        public void onAdsPlayheadUpdate(int seconds) {
        }

        public void onAdsError(String reason) {
        }

        public void onPauseContentRequested() {
        }

        public void onResumeContentRequested() {
        }

        public void onAdsTapped() {
        }

        public void onAdSkipped() {
        }

        public void onAdEvent() {
        }

        public void onAdBufferingStarted() {
        }

        public void onAdBufferingEnded() {
        }
    };
    private IConnectionSwitchCallback iConnectionSwitchCallback = new IConnectionSwitchCallback(){

        public void onConnect() {
            YospaceAdsHandler.this.doOnConnect();
        }

        public void onDisconnect() {
            YospaceAdsHandler.this.doOnDisconnect();
        }
    };
    private IPlayerEventsListener iPlayerEventsListener = new IPlayerEventsListener(){

        public boolean onPlayerEvent(int eventId) {
            if (YospaceAdsHandler.this.proxyInitialisation) {
                switch (eventId) {
                    case 17: {
                        YospaceAdsHandler.this.doOnDisconnect();
                        YospaceAdsHandler.this.onStop();
                        if (YospaceAdsHandler.this.videoPlayerContainer == null) break;
                        YospaceAdsHandler.this.videoPlayerContainer.unregisterNetworkSwitchReceiver();
                        break;
                    }
                    case 18: {
                        YospaceAdsHandler.this.doOnConnectIfAllowed();
                    }
                }
            }
            return false;
        }

        public boolean onPlayerExtendedEvent(int eventId, int arg1, int arg2) {
            return false;
        }
    };
    private CreativeHandler creativeHandler = new CreativeHandler(){

        @Override
        public void onAdvertStart(Advert advert) {
            LogManager.log((String)LOG_TAG, (String)"onAdvertStart");
            if (YospaceAdsHandler.this.yospaceUi != null) {
                YospaceAdsHandler.this.yospaceUi.setAdvert(advert);
            }
            YospaceAdsHandler.this.showAdOverlay();
            AdsInfo adInfo = YospaceAdsHandler.this.convert(advert);
            for (IAdsComponentListener listener : YospaceAdsHandler.this.mListeners) {
                listener.onAdsStarted(adInfo);
            }
        }

        @Override
        public void onAdvertBreakStart() {
            LogManager.log((String)LOG_TAG, (String)"onAdvertBreakStart");
            YospaceAdsHandler.this.showAdOverlay();
            for (IAdsComponentListener listener : YospaceAdsHandler.this.mListeners) {
                listener.onAdBreakStarted();
            }
        }

        @Override
        public void onAdvertBreakEnd() {
            LogManager.log((String)LOG_TAG, (String)"onAdvertBreakEnd");
            YospaceAdsHandler.this.hideAdOverlay();
            for (IAdsComponentListener listener : YospaceAdsHandler.this.mListeners) {
                listener.onAdBreakEnded();
            }
        }

        @Override
        public void onAdvertEnd(Advert advert) {
            LogManager.log((String)LOG_TAG, (String)"onAdvertEnd");
            YospaceAdsHandler.this.hideAdOverlay();
            if (YospaceAdsHandler.this.yospaceUi != null) {
                YospaceAdsHandler.this.yospaceUi.setAdvert(advert);
            }
            for (IAdsComponentListener listener : YospaceAdsHandler.this.mListeners) {
                listener.onAdsEnded();
            }
        }
    };

    public YospaceAdsHandler(Activity activity, String url) {
        LogManager.log((String)LOG_TAG, (String)("Constructor: " + this + " / " + url));
        Utils.checkModuleVersion((String)LOG_TAG, (String)VERSION);
        this.activity = activity;
        this.streamURL = url;
    }

    public String getExternalLibVersion() {
        return String.valueOf("2.12.2");
    }

    @Override
    public IConnectionSwitchCallback getConnectionSwitchCallback() {
        return this.iConnectionSwitchCallback;
    }

    @Override
    public IAdsComponentListener getAlternateAdProviderListener() {
        return this.alternateAdProviderListener;
    }

    @Override
    public void setAutoRecoveryTriggeredCallback(IAutoRecoveryCallback autoRecoveryTriggeredCallback) {
        this.autoRecoveryTriggeredCallback = autoRecoveryTriggeredCallback;
    }

    public void setVideoPlayerContainer(VideoPlayerContainer container) {
        if (this.videoPlayerContainer != null) {
            return;
        }
        this.videoPlayerContainer = container;
        this.yospaceUi = new YospaceUi(this.activity.getBaseContext(), this.activity);
        this.videoPlayerContainer.addVideoPlayerContainerCallback(new VideoPlayerContainer.VideoPlayerContainerCallback(){

            public void onVideoPlayerCreated() {
                Utils.tryRemoveFromParent((View)YospaceAdsHandler.this.yospaceUi);
                YospaceAdsHandler.this.videoPlayerContainer.addView((View)YospaceAdsHandler.this.yospaceUi);
                YospaceAdsHandler.this.yospaceUi.setVisibility(8);
            }

            public void onResourceReady(MediaResource resource) {
            }

            public void onResourceError(ErrorType errorType, Exception exc) {
                YospaceAdsHandler.this.onStop();
            }
        });
    }

    public void setVideoPlayerView(VideoPlayerView videoPlayerView) {
        this.liveAdapter.setVideoPlayerView(videoPlayerView);
        videoPlayerView.addEventsListener(this.iPlayerEventsListener);
        this.addEventsListener(videoPlayerView.getAdsComponentListener());
    }

    public void addEventsListener(IAdsComponentListener listener) {
        if (listener == null) {
            return;
        }
        this.mListeners.add(listener);
    }

    public void playWithServerAds(String assetKey) {
    }

    public void playWithServerAds(String vodContentSourceId, String videoId) {
    }

    public void setAdsUrl(String adsUrl) {
    }

    public void setURLSuffix(String manifestSuffix) {
    }

    public void onDestroy() {
    }

    public boolean getPlayButtonVisibilityOnAds() {
        return false;
    }

    public boolean canPreparePlayback() {
        return true;
    }

    @Override
    public void doProxyInit(int debugFlags) {
        this.debugFlags = debugFlags;
        this.onStop();
        this.proxyInitialisation = true;
        this.initInProgress = true;
        if (this.videoPlayerView != null) {
            this.videoPlayerView.stop();
            this.videoPlayerView.onDestroy();
        }
        this.liveAdapter = new ExoAdapterLive(this.activity);
        SessionFactory factory = this.initProxy(this.debugFlags);
        this.morphURL = factory.getPlayerUrl();
        this.preparePlayer(this.morphURL);
    }

    @Override
    public void doProxyInit() {
        this.doProxyInit(this.debugFlags);
    }

    @Override
    public void doSessionInit(int debugFlags) {
        this.debugFlags = debugFlags;
        this.onStop();
        this.proxyInitialisation = false;
        this.liveAdapter = new ExoAdapterLive(this.activity);
        this.initSession(this.debugFlags);
    }

    @Override
    public void doSessionInit() {
        this.doSessionInit(this.debugFlags);
    }

    @Override
    public void onStop() {
        if (this.videoPlayerContainer.getVideoPlayer() != null) {
            this.videoPlayerView = this.videoPlayerContainer.getVideoPlayer();
        }
        if (this.mSession != null) {
            this.mSession.shutdown();
            this.mSession = null;
            this._isStarted = false;
        }
    }

    @Override
    public boolean getIsStarted() {
        return this._isStarted;
    }

    public int getContentPosition(int streamPosition) {
        return 0;
    }

    public int getStreamPosition(int contentPosition) {
        return 0;
    }

    public int getContentDuration(int streamDuration) {
        return 0;
    }

    public boolean isClientSideAds() {
        return false;
    }

    public boolean isServerSideAds() {
        return true;
    }

    private void preparePlayer(String streamURL) {
        this.videoPlayerContainer.prepareResource(streamURL, "application/x-mpegURL");
    }

    private void callAutoRecoveryTriggered() {
        if (this.autoRecoveryTriggeredCallback == null) {
            return;
        }
        this.autoRecoveryTriggeredCallback.onAutoRecoveryTriggered();
    }

    private AdsInfo convert(Advert advert) {
        if (advert == null) {
            return null;
        }
        YospaceAdsInfo adsInfo = new YospaceAdsInfo(advert);
        adsInfo.adId = advert.getId();
        adsInfo.name = advert.getAdTitle();
        adsInfo.lengthInSeconds = advert.getDuration();
        adsInfo.positionInAdBreak = advert.getSequence();
        return adsInfo;
    }

    private SessionFactory initProxy(int debugFlags) {
        Session.SessionProperties properties = new Session.SessionProperties(this.streamURL);
        if (debugFlags != -1) {
            properties.addDebugFlags(debugFlags);
        }
        properties.keepProxyAlive(true);
        return SessionFactory.createForLiveWithThread((EventListener)new EventListener<Session>(){

            public void handle(Event<Session> event) {
                YospaceAdsHandler.this.mSession = (SessionLive)event.getPayload();
                switch (YospaceAdsHandler.this.mSession.getState()) {
                    case INITIALISED: {
                        LogManager.log((String)LOG_TAG, (String)"PlayerLive.initYo - Yospace analytics session initialised");
                        YospaceAdsHandler.this.liveAdapter.setSession(YospaceAdsHandler.this.mSession);
                        ExoAnalyticListener listener = new ExoAnalyticListener(YospaceAdsHandler.this.creativeHandler);
                        listener.reportAdvertDetails(true).reportRawVast(true);
                        YospaceAdsHandler.this.mSession.addAnalyticListener((AnalyticEventListener)listener);
                        YospaceAdsHandler.this.mSession.setPlayerPolicy((PolicyHandler)new PlayerPolicy());
                        YospaceAdsHandler.this._isStarted = true;
                        YospaceAdsHandler.this.initInProgress = false;
                        return;
                    }
                    case NO_ANALYTICS: {
                        YospaceAdsHandler.this.initInProgress = false;
                        LogManager.log((String)LOG_TAG, (String)"PlayerLive.initYo - Video URL does not refer to a Yospace stream, no analytics session created");
                        return;
                    }
                    case NOT_INITIALISED: {
                        YospaceAdsHandler.this.initInProgress = false;
                        LogManager.error((String)LOG_TAG, (String)"PlayerLive.initYo - Failed to initialise analytics session");
                        return;
                    }
                }
            }
        }, (Session.SessionProperties)properties);
    }

    private void initSession(int debugFlags) {
        Session.SessionProperties properties = new Session.SessionProperties(this.streamURL);
        if (debugFlags != -1) {
            properties.addDebugFlags(debugFlags);
        }
        SessionLive.create((EventListener)new EventListener<Session>(){

            public void handle(Event<Session> event) {
                YospaceAdsHandler.this.mSession = (SessionLive)event.getPayload();
                switch (YospaceAdsHandler.this.mSession.getState()) {
                    case INITIALISED: {
                        LogManager.log((String)LOG_TAG, (String)"PlayerLive.initialiseYospace - Yospace analytics session initialised");
                        YospaceAdsHandler.this.liveAdapter.setSession(YospaceAdsHandler.this.mSession);
                        ExoAnalyticListener listener = new ExoAnalyticListener(YospaceAdsHandler.this.creativeHandler);
                        listener.reportAdvertDetails(true).reportRawVast(true);
                        YospaceAdsHandler.this.mSession.addAnalyticListener((AnalyticEventListener)listener);
                        YospaceAdsHandler.this.mSession.setPlayerPolicy((PolicyHandler)new PlayerPolicy());
                        YospaceAdsHandler.this._isStarted = true;
                        YospaceAdsHandler.this.initInProgress = false;
                        YospaceAdsHandler.this.activity.runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                YospaceAdsHandler.this.preparePlayer(YospaceAdsHandler.this.mSession.getPlayerUrl());
                            }
                        });
                        return;
                    }
                    case NO_ANALYTICS: {
                        YospaceAdsHandler.this.initInProgress = false;
                        LogManager.log((String)LOG_TAG, (String)"PlayerLive.initYo - Video URL does not refer to a Yospace stream, no analytics session created");
                        return;
                    }
                    case NOT_INITIALISED: {
                        YospaceAdsHandler.this.initInProgress = false;
                        LogManager.error((String)LOG_TAG, (String)"PlayerLive.initYo - Failed to initialise analytics session");
                        return;
                    }
                }
            }
        }, (Session.SessionProperties)properties);
    }

    private void showAdOverlay() {
        this.setAdOverlayVisibility(0);
    }

    private void hideAdOverlay() {
        this.setAdOverlayVisibility(4);
    }

    private void setAdOverlayVisibility(final int visibility) {
        if (this.activity != null && this.yospaceUi != null) {
            this.activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    YospaceAdsHandler.this.yospaceUi.setVisibility(visibility);
                }
            });
        }
    }

    private void doOnConnectIfAllowed() {
        if (!this.alternateAdIsPlaying && this.videoPlayerContainer != null) {
            this.doOnConnect();
            this.videoPlayerContainer.enableAutoRecoveryIfPreviouslyRegistered();
        }
    }

    private void doOnDisconnect() {
        LogManager.log((String)LOG_TAG, (String)"Internet: IConnectionSwitchCallback.onDisconnect()");
    }

    private void doOnConnect() {
        boolean shouldStart;
        LogManager.log((String)LOG_TAG, (String)"Internet: IConnectionSwitchCallback.onConnect()");
        boolean bl = shouldStart = !this._isStarted && !this.initInProgress;
        if (shouldStart) {
            this.callAutoRecoveryTriggered();
            this.doProxyInit();
        }
    }
}

