/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.media.errors;

import java.util.HashMap;
import java.util.Map;

public class ErrorEvents {
    private static final String UNKNOWN_ERROR_NAME = "UNKNOWN_ERROR_NAME";
    private static final Map<Integer, String> eventNames = new HashMap<Integer, String>(){
        {
            this.put(0, "ERROR_SUCCESS: No error");
            this.put(1, "ERROR_NETWORK_UNAVAILABLE: Network access is not available");
            this.put(2, "ERROR_NETWORK_RESOURCE_DONT_EXIST: Resource (stream URL) doesn't exist");
            this.put(3, "ERROR_NETWORK_SECURITY_ISSUE: Access not allowed to the provided stream URL");
            this.put(4, "ERROR_FORMAT_UNKNOWN: The provided stream doesn't have a known format");
            this.put(5, "ERROR_RESOURCES_ISSUE: There was an issue while allocating resources for playback");
            this.put(6, "ERROR_TS_SEGMENT_INVALID: The provided stream contains format errors");
            this.putExo(0, "ERROR_TYPE_SOURCE: The error occurred loading data from a MediaSource");
            this.putExo(1, "ERROR_TYPE_RENDERER: The error occurred in a Renderer");
            this.putExo(2, "ERROR_TYPE_UNEXPECTED: The error was an unexpected RuntimeException");
        }

        private void putExo(int errorID, String description) {
            this.put(errorID + 7, description);
        }
    };

    private ErrorEvents() {
    }

    @Deprecated
    public static String getDescription(int eventID) {
        return ErrorEvents.toString(eventID);
    }

    public static String toString(int eventID) {
        if (eventNames.containsKey(eventID)) {
            return eventNames.get(eventID);
        }
        return UNKNOWN_ERROR_NAME;
    }
}

