/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.text.ttml;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.util.Base64;
import android.util.Pair;
import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.text.Cue;
import com.akamai.amp.exoplayer2.text.ttml.DeleteTextSpan;
import com.akamai.amp.exoplayer2.text.ttml.TtmlRegion;
import com.akamai.amp.exoplayer2.text.ttml.TtmlRenderUtil;
import com.akamai.amp.exoplayer2.text.ttml.TtmlStyle;
import com.akamai.amp.exoplayer2.util.Assertions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

final class TtmlNode {
    public static final String TAG_TT = "tt";
    public static final String TAG_HEAD = "head";
    public static final String TAG_BODY = "body";
    public static final String TAG_DIV = "div";
    public static final String TAG_P = "p";
    public static final String TAG_SPAN = "span";
    public static final String TAG_BR = "br";
    public static final String TAG_STYLE = "style";
    public static final String TAG_STYLING = "styling";
    public static final String TAG_LAYOUT = "layout";
    public static final String TAG_REGION = "region";
    public static final String TAG_METADATA = "metadata";
    public static final String TAG_IMAGE = "image";
    public static final String TAG_DATA = "data";
    public static final String TAG_INFORMATION = "information";
    public static final String ANONYMOUS_REGION_ID = "";
    public static final String ATTR_ID = "id";
    public static final String ATTR_TTS_ORIGIN = "origin";
    public static final String ATTR_TTS_EXTENT = "extent";
    public static final String ATTR_TTS_DISPLAY_ALIGN = "displayAlign";
    public static final String ATTR_TTS_BACKGROUND_COLOR = "backgroundColor";
    public static final String ATTR_TTS_FONT_STYLE = "fontStyle";
    public static final String ATTR_TTS_FONT_SIZE = "fontSize";
    public static final String ATTR_TTS_FONT_FAMILY = "fontFamily";
    public static final String ATTR_TTS_FONT_WEIGHT = "fontWeight";
    public static final String ATTR_TTS_COLOR = "color";
    public static final String ATTR_TTS_RUBY = "ruby";
    public static final String ATTR_TTS_RUBY_POSITION = "rubyPosition";
    public static final String ATTR_TTS_TEXT_DECORATION = "textDecoration";
    public static final String ATTR_TTS_TEXT_ALIGN = "textAlign";
    public static final String ATTR_TTS_TEXT_COMBINE = "textCombine";
    public static final String ATTR_TTS_WRITING_MODE = "writingMode";
    public static final String RUBY_CONTAINER = "container";
    public static final String RUBY_BASE = "base";
    public static final String RUBY_BASE_CONTAINER = "baseContainer";
    public static final String RUBY_TEXT = "text";
    public static final String RUBY_TEXT_CONTAINER = "textContainer";
    public static final String RUBY_DELIMITER = "delimiter";
    public static final String RUBY_BEFORE = "before";
    public static final String RUBY_AFTER = "after";
    public static final String LINETHROUGH = "linethrough";
    public static final String NO_LINETHROUGH = "nolinethrough";
    public static final String UNDERLINE = "underline";
    public static final String NO_UNDERLINE = "nounderline";
    public static final String ITALIC = "italic";
    public static final String BOLD = "bold";
    public static final String LEFT = "left";
    public static final String CENTER = "center";
    public static final String RIGHT = "right";
    public static final String START = "start";
    public static final String END = "end";
    public static final String COMBINE_NONE = "none";
    public static final String COMBINE_ALL = "all";
    public static final String VERTICAL = "tb";
    public static final String VERTICAL_LR = "tblr";
    public static final String VERTICAL_RL = "tbrl";
    @Nullable
    public final String tag;
    @Nullable
    public final String text;
    public final boolean isTextNode;
    public final long startTimeUs;
    public final long endTimeUs;
    @Nullable
    public final TtmlStyle style;
    @Nullable
    private final String[] styleIds;
    public final String regionId;
    @Nullable
    public final String imageId;
    @Nullable
    public final TtmlNode parent;
    private final HashMap<String, Integer> nodeStartsByRegion;
    private final HashMap<String, Integer> nodeEndsByRegion;
    private @MonotonicNonNull List<TtmlNode> children;

    public static TtmlNode buildTextNode(String text) {
        return new TtmlNode(null, TtmlRenderUtil.applyTextElementSpacePolicy(text), -9223372036854775807L, -9223372036854775807L, null, null, ANONYMOUS_REGION_ID, null, null);
    }

    public static TtmlNode buildNode(@Nullable String tag, long startTimeUs, long endTimeUs, @Nullable TtmlStyle style, @Nullable String[] styleIds, String regionId, @Nullable String imageId, @Nullable TtmlNode parent) {
        return new TtmlNode(tag, null, startTimeUs, endTimeUs, style, styleIds, regionId, imageId, parent);
    }

    private TtmlNode(@Nullable String tag, @Nullable String text, long startTimeUs, long endTimeUs, @Nullable TtmlStyle style, @Nullable String[] styleIds, String regionId, @Nullable String imageId, @Nullable TtmlNode parent) {
        this.tag = tag;
        this.text = text;
        this.imageId = imageId;
        this.style = style;
        this.styleIds = styleIds;
        this.isTextNode = text != null;
        this.startTimeUs = startTimeUs;
        this.endTimeUs = endTimeUs;
        this.regionId = Assertions.checkNotNull(regionId);
        this.parent = parent;
        this.nodeStartsByRegion = new HashMap();
        this.nodeEndsByRegion = new HashMap();
    }

    public boolean isActive(long timeUs) {
        return this.startTimeUs == -9223372036854775807L && this.endTimeUs == -9223372036854775807L || this.startTimeUs <= timeUs && this.endTimeUs == -9223372036854775807L || this.startTimeUs == -9223372036854775807L && timeUs < this.endTimeUs || this.startTimeUs <= timeUs && timeUs < this.endTimeUs;
    }

    public void addChild(TtmlNode child) {
        if (this.children == null) {
            this.children = new ArrayList<TtmlNode>();
        }
        this.children.add(child);
    }

    public TtmlNode getChild(int index) {
        if (this.children == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.children.get(index);
    }

    public int getChildCount() {
        return this.children == null ? 0 : this.children.size();
    }

    public long[] getEventTimesUs() {
        TreeSet<Long> eventTimeSet = new TreeSet<Long>();
        this.getEventTimes(eventTimeSet, false);
        long[] eventTimes = new long[eventTimeSet.size()];
        int i = 0;
        for (long eventTimeUs : eventTimeSet) {
            eventTimes[i++] = eventTimeUs;
        }
        return eventTimes;
    }

    private void getEventTimes(TreeSet<Long> out, boolean descendsPNode) {
        boolean isPNode = TAG_P.equals(this.tag);
        boolean isDivNode = TAG_DIV.equals(this.tag);
        if (descendsPNode || isPNode || isDivNode && this.imageId != null) {
            if (this.startTimeUs != -9223372036854775807L) {
                out.add(this.startTimeUs);
            }
            if (this.endTimeUs != -9223372036854775807L) {
                out.add(this.endTimeUs);
            }
        }
        if (this.children == null) {
            return;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            this.children.get(i).getEventTimes(out, descendsPNode || isPNode);
        }
    }

    @Nullable
    public String[] getStyleIds() {
        return this.styleIds;
    }

    public List<Cue> getCues(long timeUs, Map<String, TtmlStyle> globalStyles, Map<String, TtmlRegion> regionMap, Map<String, String> imageMap) {
        ArrayList<Pair<String, String>> regionImageOutputs = new ArrayList<Pair<String, String>>();
        this.traverseForImage(timeUs, this.regionId, regionImageOutputs);
        TreeMap<String, Cue.Builder> regionTextOutputs = new TreeMap<String, Cue.Builder>();
        this.traverseForText(timeUs, false, this.regionId, regionTextOutputs);
        this.traverseForStyle(timeUs, globalStyles, regionTextOutputs);
        ArrayList<Cue> cues = new ArrayList<Cue>();
        for (Pair pair : regionImageOutputs) {
            String encodedBitmapData = imageMap.get(pair.second);
            if (encodedBitmapData == null) continue;
            byte[] bitmapData = Base64.decode((String)encodedBitmapData, (int)0);
            Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])bitmapData, (int)0, (int)bitmapData.length);
            TtmlRegion region = Assertions.checkNotNull(regionMap.get(pair.first));
            cues.add(new Cue.Builder().setBitmap(bitmap).setPosition(region.position).setPositionAnchor(0).setLine(region.line, 0).setLineAnchor(region.lineAnchor).setSize(region.width).setBitmapHeight(region.height).setVerticalType(region.verticalType).build());
        }
        for (Map.Entry entry : regionTextOutputs.entrySet()) {
            TtmlRegion region = Assertions.checkNotNull(regionMap.get(entry.getKey()));
            Cue.Builder regionOutput = (Cue.Builder)entry.getValue();
            TtmlNode.cleanUpText((SpannableStringBuilder)Assertions.checkNotNull(regionOutput.getText()));
            regionOutput.setLine(region.line, region.lineType);
            regionOutput.setLineAnchor(region.lineAnchor);
            regionOutput.setPosition(region.position);
            regionOutput.setSize(region.width);
            regionOutput.setTextSize(region.textSize, region.textSizeType);
            regionOutput.setVerticalType(region.verticalType);
            cues.add(regionOutput.build());
        }
        return cues;
    }

    private void traverseForImage(long timeUs, String inheritedRegion, List<Pair<String, String>> regionImageList) {
        String resolvedRegionId;
        String string2 = resolvedRegionId = ANONYMOUS_REGION_ID.equals(this.regionId) ? inheritedRegion : this.regionId;
        if (this.isActive(timeUs) && TAG_DIV.equals(this.tag) && this.imageId != null) {
            regionImageList.add((Pair<String, String>)new Pair((Object)resolvedRegionId, (Object)this.imageId));
            return;
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            this.getChild(i).traverseForImage(timeUs, resolvedRegionId, regionImageList);
        }
    }

    private void traverseForText(long timeUs, boolean descendsPNode, String inheritedRegion, Map<String, Cue.Builder> regionOutputs) {
        String resolvedRegionId;
        this.nodeStartsByRegion.clear();
        this.nodeEndsByRegion.clear();
        if (TAG_METADATA.equals(this.tag)) {
            return;
        }
        String string2 = resolvedRegionId = ANONYMOUS_REGION_ID.equals(this.regionId) ? inheritedRegion : this.regionId;
        if (this.isTextNode && descendsPNode) {
            TtmlNode.getRegionOutputText(resolvedRegionId, regionOutputs).append((CharSequence)Assertions.checkNotNull(this.text));
        } else if (TAG_BR.equals(this.tag) && descendsPNode) {
            TtmlNode.getRegionOutputText(resolvedRegionId, regionOutputs).append('\n');
        } else if (this.isActive(timeUs)) {
            for (Map.Entry<String, Cue.Builder> entry : regionOutputs.entrySet()) {
                this.nodeStartsByRegion.put(entry.getKey(), Assertions.checkNotNull(entry.getValue().getText()).length());
            }
            boolean isPNode = TAG_P.equals(this.tag);
            for (int i = 0; i < this.getChildCount(); ++i) {
                this.getChild(i).traverseForText(timeUs, descendsPNode || isPNode, resolvedRegionId, regionOutputs);
            }
            if (isPNode) {
                TtmlRenderUtil.endParagraph(TtmlNode.getRegionOutputText(resolvedRegionId, regionOutputs));
            }
            for (Map.Entry<String, Cue.Builder> entry : regionOutputs.entrySet()) {
                this.nodeEndsByRegion.put(entry.getKey(), Assertions.checkNotNull(entry.getValue().getText()).length());
            }
        }
    }

    private static SpannableStringBuilder getRegionOutputText(String resolvedRegionId, Map<String, Cue.Builder> regionOutputs) {
        if (!regionOutputs.containsKey(resolvedRegionId)) {
            Cue.Builder regionOutput = new Cue.Builder();
            regionOutput.setText((CharSequence)new SpannableStringBuilder());
            regionOutputs.put(resolvedRegionId, regionOutput);
        }
        return (SpannableStringBuilder)Assertions.checkNotNull(regionOutputs.get(resolvedRegionId).getText());
    }

    private void traverseForStyle(long timeUs, Map<String, TtmlStyle> globalStyles, Map<String, Cue.Builder> regionOutputs) {
        if (!this.isActive(timeUs)) {
            return;
        }
        for (Map.Entry<String, Integer> entry : this.nodeEndsByRegion.entrySet()) {
            int end;
            String regionId = entry.getKey();
            int start = this.nodeStartsByRegion.containsKey(regionId) ? this.nodeStartsByRegion.get(regionId) : 0;
            if (start == (end = entry.getValue().intValue())) continue;
            Cue.Builder regionOutput = Assertions.checkNotNull(regionOutputs.get(regionId));
            this.applyStyleToOutput(globalStyles, regionOutput, start, end);
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            this.getChild(i).traverseForStyle(timeUs, globalStyles, regionOutputs);
        }
    }

    private void applyStyleToOutput(Map<String, TtmlStyle> globalStyles, Cue.Builder regionOutput, int start, int end) {
        TtmlStyle resolvedStyle = TtmlRenderUtil.resolveStyle(this.style, this.styleIds, globalStyles);
        SpannableStringBuilder text = (SpannableStringBuilder)regionOutput.getText();
        if (text == null) {
            text = new SpannableStringBuilder();
            regionOutput.setText((CharSequence)text);
        }
        if (resolvedStyle != null) {
            TtmlRenderUtil.applyStylesToSpan((Spannable)text, start, end, resolvedStyle, this.parent, globalStyles);
            regionOutput.setTextAlignment(resolvedStyle.getTextAlign());
        }
    }

    private static void cleanUpText(SpannableStringBuilder builder) {
        int i;
        DeleteTextSpan[] deleteTextSpans;
        for (DeleteTextSpan deleteTextSpan : deleteTextSpans = (DeleteTextSpan[])builder.getSpans(0, builder.length(), DeleteTextSpan.class)) {
            builder.replace(builder.getSpanStart((Object)deleteTextSpan), builder.getSpanEnd((Object)deleteTextSpan), (CharSequence)ANONYMOUS_REGION_ID);
        }
        for (i = 0; i < builder.length(); ++i) {
            int j;
            if (builder.charAt(i) != ' ') continue;
            for (j = i + 1; j < builder.length() && builder.charAt(j) == ' '; ++j) {
            }
            int spacesToDelete = j - (i + 1);
            if (spacesToDelete <= 0) continue;
            builder.delete(i, i + spacesToDelete);
        }
        if (builder.length() > 0 && builder.charAt(0) == ' ') {
            builder.delete(0, 1);
        }
        for (i = 0; i < builder.length() - 1; ++i) {
            if (builder.charAt(i) != '\n' || builder.charAt(i + 1) != ' ') continue;
            builder.delete(i + 1, i + 2);
        }
        if (builder.length() > 0 && builder.charAt(builder.length() - 1) == ' ') {
            builder.delete(builder.length() - 1, builder.length());
        }
        for (i = 0; i < builder.length() - 1; ++i) {
            if (builder.charAt(i) != ' ' || builder.charAt(i + 1) != '\n') continue;
            builder.delete(i, i + 1);
        }
        if (builder.length() > 0 && builder.charAt(builder.length() - 1) == '\n') {
            builder.delete(builder.length() - 1, builder.length());
        }
    }
}

