/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.analytics.adobeexperienceplatform;

import android.app.Application;
import com.adobe.marketing.mobile.AdobeCallback;
import com.adobe.marketing.mobile.Analytics;
import com.adobe.marketing.mobile.Identity;
import com.adobe.marketing.mobile.InvalidInitException;
import com.adobe.marketing.mobile.Lifecycle;
import com.adobe.marketing.mobile.LoggingMode;
import com.adobe.marketing.mobile.Media;
import com.adobe.marketing.mobile.MobileCore;
import com.adobe.marketing.mobile.Signal;
import com.akamai.amp.analytics.adobeexperienceplatform.AdobeExperienceEventsHandler;
import com.akamai.amp.analytics.adobeexperienceplatform.AmpAdobeExperienceAnalyticsTracker;
import com.akamai.amp.config.data.experienceplatform.ExperiencePlatformData;
import com.akamai.amp.media.VideoPlayerView;
import com.akamai.amp.utils.LogManager;
import com.akamai.amp.utils.Utils;
import java.util.TimeZone;

public class AdobeExperience {
    private static final String LOG_TAG = AdobeExperience.class.getSimpleName();
    public static final String VERSION = "9.10.6";
    public static final String EXTERNAL_SDK = "AdobeVideoHeartbeatSDK";
    public static final String DEFAULT_AD_BREAK_NAME = "AD_BREAK";
    private static TimeZone parameterizedTimeZone;

    public static AmpAdobeExperienceAnalyticsTracker create(ExperiencePlatformData data) {
        return new AdobeExperienceEventsHandler(data);
    }

    public static AmpAdobeExperienceAnalyticsTracker create(VideoPlayerView videoPlayerView, ExperiencePlatformData data) {
        return new AdobeExperienceEventsHandler(videoPlayerView, data);
    }

    public static TimeZone getTimeZone() {
        return parameterizedTimeZone;
    }

    public static void setTimeZone(TimeZone tz) {
        parameterizedTimeZone = tz;
        LogManager.log((String)LOG_TAG, (String)("Setting java.util.TimeZone: " + tz));
        LogManager.log((String)LOG_TAG, (String)("Seconds since midnight: Using the above TimeZone (" + Utils.Time.getSecondsSinceMidnight((TimeZone)tz) + ")"));
        LogManager.log((String)LOG_TAG, (String)("Seconds since midnight: Using the Local TimeZone (" + Utils.Time.getSecondsSinceMidnightInLocalTimeZone() + ")"));
    }

    public static void onApplicationCreate(Application app, String launchEnvironmentFileID, final String appID) {
        LogManager.log((String)LOG_TAG, (String)("Invoked AdobeHeartbeat.onApplicationCreate() with Application " + app));
        LogManager.log((String)LOG_TAG, (String)("launchEnvironmentFileID " + launchEnvironmentFileID));
        LogManager.log((String)LOG_TAG, (String)("appID " + appID));
        MobileCore.setApplication((Application)app);
        MobileCore.setLogLevel((LoggingMode)LoggingMode.VERBOSE);
        try {
            Media.registerExtension();
            Analytics.registerExtension();
            Identity.registerExtension();
            Identity.registerExtension();
            Lifecycle.registerExtension();
            Signal.registerExtension();
            MobileCore.configureWithAppID((String)launchEnvironmentFileID);
            MobileCore.start((AdobeCallback)new AdobeCallback(){

                public void call(Object o) {
                    LogManager.log((String)LOG_TAG, (String)"AEP Mobile SDK is initialized");
                    MobileCore.configureWithAppID((String)appID);
                }
            });
        }
        catch (InvalidInitException e) {
            LogManager.error((String)LOG_TAG, (Exception)((Object)e));
        }
        LogManager.log((String)LOG_TAG, (String)("Called com.akamai.amp.analytics.adobeexperienceplatform.adobeheartbeat.onApplicationCreate() with Application " + app));
    }
}

