/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.id3tags;

import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import androidx.annotation.NonNull;
import com.akamai.amp.exoplayer2.metadata.Metadata;
import com.akamai.amp.exoplayer2.metadata.MetadataOutput;
import com.akamai.amp.exoplayer2.metadata.id3.Id3Frame;
import com.akamai.amp.exoplayer2.util.NonNullApi;
import com.akamai.amp.id3tags.ID3TagData;
import com.akamai.amp.id3tags.ID3TagEventListener;
import com.akamai.amp.id3tags.NativeID3TagExtractor;
import com.akamai.amp.id3tags.Serialization;
import com.akamai.amp.media.IPlayerEventsListener;
import com.akamai.amp.media.ISegmentInfoListener;
import com.akamai.amp.media.VideoPlayerView;
import com.akamai.amp.media.VideoPlayerViewExo;
import com.akamai.amp.utils.Utils;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;

@Deprecated
public class AmpID3TagsManager {
    private static final String LOG_TAG = AmpID3TagsManager.class.getSimpleName();
    public static final String VERSION = "9.10.6";
    private Object mLock = new Object();
    private List<ID3TagEventListener> mListeners = new ArrayList<ID3TagEventListener>();
    private List<ID3TagData> mID3Tags = new ArrayList<ID3TagData>();
    private List<ID3TagData> mID3TagsRenderTime = new ArrayList<ID3TagData>();
    private NativeID3TagExtractor mNativeID3TagExtractor;
    private VideoPlayerView mVideoPlayerView;
    private ISegmentInfoListener iSegmentInfoListener = new ISegmentInfoListener(){

        public boolean onPlayerExtendedEvent(int iEventType, String segmentUrl, byte[] data) {
            boolean bRes = true;
            if (data != null && 1 == iEventType) {
                ID3TagExtractorTask extractionTask = new ID3TagExtractorTask(segmentUrl);
                try {
                    extractionTask.execute((Object[])new byte[][]{data}).get();
                }
                catch (InterruptedException | ExecutionException e) {
                    bRes = false;
                    e.printStackTrace();
                }
            }
            return bRes;
        }

        public boolean onPlayerExtendedEvent(int iEventType, String segmentUrl, int offset) {
            if (iEventType == 2) {
                Message msg = Message.obtain(null, (int)2);
                Bundle messageData = new Bundle();
                messageData.putString("url", segmentUrl);
                messageData.putInt("offset", offset);
                msg.setData(messageData);
                return AmpID3TagsManager.this.mCommandsHandler.sendMessage(msg);
            }
            return AmpID3TagsManager.this.mCommandsHandler.sendEmptyMessage(iEventType);
        }
    };
    private IPlayerEventsListener iPlayerEventsListener = new IPlayerEventsListener(){

        public boolean onPlayerEvent(int iInEventType) {
            return AmpID3TagsManager.this.mCommandsHandler.sendEmptyMessage(iInEventType);
        }

        public boolean onPlayerExtendedEvent(int iInEventType, int arg1, int arg2) {
            return AmpID3TagsManager.this.mCommandsHandler.sendEmptyMessage(iInEventType);
        }
    };
    private MetadataOutput metadataOutput = new MetadataOutput(){

        @NonNullApi
        public void onMetadata(Metadata metadata) {
            ID3TagData id3Data = AmpID3TagsManager.this.convert(metadata);
            AmpID3TagsManager.this.notifyListeners(id3Data);
        }
    };
    private Handler mCommandsHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 2: {
                    Bundle messageData = msg.getData();
                    String segmentUrl = messageData.getString("url");
                    int offset = messageData.getInt("offset");
                    Log.i((String)"SEGMENT", (String)("PP: " + AmpID3TagsManager.this.mVideoPlayerView.getCurrentStreamPositionMS() + "offset: " + offset));
                    AmpID3TagsManager.this.extractSubtitleDataForSegmentOffset(segmentUrl, offset);
                    break;
                }
                case 0: {
                    break;
                }
            }
        }
    };

    @Deprecated
    public AmpID3TagsManager() {
        Utils.checkModuleVersion((String)LOG_TAG, (String)VERSION);
    }

    @Deprecated
    public void addEventListener(ID3TagEventListener listener) {
        if (listener == null) {
            return;
        }
        this.mListeners.add(listener);
    }

    @Deprecated
    public void removeEventListener(ID3TagEventListener listener) {
        this.mListeners.remove(listener);
    }

    @Deprecated
    public void setVideoPlayerView(VideoPlayerView videoPlayerView) {
        this.mVideoPlayerView = videoPlayerView;
        if (this.mVideoPlayerView != null) {
            this.mVideoPlayerView.setSegmentInfoListener(this.getSegmentInfoListener());
            this.mVideoPlayerView.addEventsListener(this.getPlayerEventsListener());
            VideoPlayerViewExo exo = (VideoPlayerViewExo)this.mVideoPlayerView;
            exo.setID3MetadataListener(this.getMetadataOutput());
        }
    }

    @Deprecated
    public List<ID3TagData> getId3TagsByPosition(int positionInSeconds) {
        ArrayList<ID3TagData> id3TagsByPosition = new ArrayList<ID3TagData>();
        for (ID3TagData id3Tag : this.mID3TagsRenderTime) {
            int startTimeInSeconds = (int)id3Tag.getStartTime() / 1000;
            if (positionInSeconds != startTimeInSeconds) continue;
            id3TagsByPosition.add(id3Tag);
        }
        return id3TagsByPosition;
    }

    private ISegmentInfoListener getSegmentInfoListener() {
        return this.iSegmentInfoListener;
    }

    private IPlayerEventsListener getPlayerEventsListener() {
        return this.iPlayerEventsListener;
    }

    private MetadataOutput getMetadataOutput() {
        return this.metadataOutput;
    }

    @NonNull
    private ID3TagData convert(Metadata metadata) {
        String text = this.getTxxxText(metadata);
        long startTime = 0L;
        String segmentUrl = "";
        byte[] data = new byte[]{};
        ID3TagData id3TagData = new ID3TagData(text, startTime, segmentUrl, data, metadata);
        return id3TagData;
    }

    private String getTxxxText(Metadata metadata) {
        if (metadata != null) {
            for (int i = 0; i < metadata.length(); ++i) {
                Metadata.Entry entry = metadata.get(i);
                if (entry == null) {
                    Log.e((String)LOG_TAG, (String)"NULL Metadata.Entry found");
                    continue;
                }
                if (!(entry instanceof Id3Frame)) continue;
                Id3Frame frame = (Id3Frame)entry;
                String value = frame.getValue();
                return value;
            }
        }
        return "";
    }

    private void extractSubtitleDataForSegmentOffset(String segmentUrl, int position) {
        if (this.mVideoPlayerView == null) {
            return;
        }
        ArrayList<ID3TagData> dataForPosition = this.getTextForPosition(segmentUrl, position);
        for (ID3TagData tagData : dataForPosition) {
            if (tagData.getText() == null || tagData.getText().equals("")) continue;
            Log.d((String)LOG_TAG, (String)(tagData.getText() + "  //for position segment " + position));
            this.notifyListeners(tagData);
        }
    }

    private void notifyListeners(ID3TagData dataForPosition) {
        for (ID3TagEventListener listener : this.mListeners) {
            if (listener == null) continue;
            listener.onFoundID3TagData(dataForPosition);
        }
    }

    private static int roundUp(double n) {
        int floorInt = (int)n;
        int ceilInt = floorInt + 1;
        double ceilDiff = (double)ceilInt - n;
        double floorDiff = n - (double)floorInt;
        return ceilDiff <= floorDiff ? ceilInt : floorInt;
    }

    private int millisToSeconds(int timeInMillis) {
        double timeInSeconds = (double)timeInMillis / 1000.0;
        double roundedTime = AmpID3TagsManager.roundUp(timeInSeconds);
        return (int)roundedTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<ID3TagData> getTextForPosition(String segmentUrl, int position) {
        ArrayList<ID3TagData> showData = new ArrayList<ID3TagData>();
        Object object = this.mLock;
        synchronized (object) {
            if (this.mID3Tags.size() > 0) {
                for (ID3TagData id3TagData : this.mID3Tags) {
                    int roundedPositionInSeconds;
                    int roundedStartTimeInSeconds;
                    if (!id3TagData.getSegmentUrl().equals(segmentUrl) || (roundedStartTimeInSeconds = this.millisToSeconds((int)id3TagData.getStartTime())) != (roundedPositionInSeconds = this.millisToSeconds(position))) continue;
                    Log.i((String)"TIMING-ID3", (String)("ST: " + id3TagData.getStartTime() + ", P: " + position + " RST: " + roundedStartTimeInSeconds + ", RP: " + roundedPositionInSeconds + ", PP: " + this.mVideoPlayerView.getCurrentStreamPositionMS()));
                    showData.add(id3TagData);
                }
                for (ID3TagData id3TagData : showData) {
                    this.mID3Tags.remove(id3TagData);
                }
            }
        }
        return showData;
    }

    private class ID3TagExtractorTask
    extends AsyncTask<byte[], Object, Void> {
        private String mSegmentUrl;

        ID3TagExtractorTask(String segmentUrl) {
            this.mSegmentUrl = segmentUrl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Void doInBackground(byte[] ... data) {
            Log.d((String)LOG_TAG, (String)("Start extraction task. Length: " + data[0].length));
            ByteBuffer directBuffer = ByteBuffer.allocateDirect(data[0].length);
            directBuffer.put(data[0]);
            byte[] parsedData = this.getNativeID3TagExtractor().parse(directBuffer);
            directBuffer.clear();
            int oneID3TagDataSize = 520;
            Log.d((String)LOG_TAG, (String)("Parsed data size: " + parsedData.length));
            for (int currentPosition = 0; currentPosition < parsedData.length; currentPosition += 520) {
                try {
                    ID3TagData id3TagData = Serialization.Deserialize(parsedData, currentPosition, this.mSegmentUrl);
                    Object object = AmpID3TagsManager.this.mLock;
                    synchronized (object) {
                        AmpID3TagsManager.this.mID3Tags.add(id3TagData);
                        AmpID3TagsManager.this.mID3TagsRenderTime.add(id3TagData);
                        continue;
                    }
                }
                catch (IllegalArgumentException e) {
                    Log.e((String)LOG_TAG, (String)("Detected error on deserialization ID3 tag data: " + e.getMessage()));
                }
            }
            return null;
        }

        private NativeID3TagExtractor getNativeID3TagExtractor() {
            if (AmpID3TagsManager.this.mNativeID3TagExtractor == null) {
                AmpID3TagsManager.this.mNativeID3TagExtractor = new NativeID3TagExtractor();
            }
            return AmpID3TagsManager.this.mNativeID3TagExtractor;
        }

        protected void onPostExecute(Void result) {
            Log.d((String)LOG_TAG, (String)"Finished ID3 tag extraction task");
        }

        protected void onPreExecute() {
            super.onPreExecute();
            Log.d((String)LOG_TAG, (String)"Starting ID3 tag extraction task....");
        }
    }
}

