/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.mobile;

import com.adobe.mobile.GoogleApiClientWrapper;
import com.adobe.mobile.RemoteDownload;
import com.adobe.mobile.StaticMethods;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.wearable.Asset;
import com.google.android.gms.wearable.DataApi;
import com.google.android.gms.wearable.DataMap;
import com.google.android.gms.wearable.Wearable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;

class WearableDataResponse {
    protected boolean success = false;

    WearableDataResponse() {
    }

    protected boolean isSuccess() {
        return this.success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveFileFromAsset(Asset asset, String fileName, GoogleApiClient mGoogleApiClient) {
        if (asset == null || mGoogleApiClient == null) {
            return;
        }
        ConnectionResult result = GoogleApiClientWrapper.blockingConnect(mGoogleApiClient, 15000L, TimeUnit.MILLISECONDS);
        if (result == null || !result.isSuccess()) {
            return;
        }
        PendingResult pendingResult = Wearable.DataApi.getFdForAsset(mGoogleApiClient, asset);
        Result awaitResult = GoogleApiClientWrapper.await(pendingResult);
        InputStream assetInputStream = awaitResult instanceof DataApi.GetFdForAssetResult ? ((DataApi.GetFdForAssetResult)awaitResult).getInputStream() : null;
        GoogleApiClientWrapper.disconnect(mGoogleApiClient);
        if (assetInputStream == null) {
            return;
        }
        File targetFile = new File(fileName);
        FileOutputStream outStream = null;
        try {
            int bytesRead;
            outStream = new FileOutputStream(targetFile);
            byte[] buffer = new byte[8192];
            while ((bytesRead = assetInputStream.read(buffer)) != -1) {
                ((OutputStream)outStream).write(buffer, 0, bytesRead);
            }
        }
        catch (IOException e) {
            StaticMethods.logErrorFormat("Wearable - Failed to save cache file", new Object[0]);
        }
        finally {
            if (outStream != null) {
                try {
                    ((OutputStream)outStream).close();
                }
                catch (IOException e) {
                    StaticMethods.logDebugFormat("Wearable - Failed to close file output stream", new Object[0]);
                }
            }
        }
    }

    protected static WearableDataResponse createResponseFromDataMap(DataMap dataMap, GoogleApiClient mGoogleApiClient) {
        if (!dataMap.containsKey("Type")) {
            return null;
        }
        if (dataMap.getString("Type").equals("POST")) {
            return new PostResponse(dataMap);
        }
        if (dataMap.getString("Type").equals("GET")) {
            return new GetResponse(dataMap);
        }
        if (dataMap.getString("Type").equals("Config")) {
            return new ShareConfigResponse(dataMap);
        }
        if (dataMap.getString("Type").equals("File")) {
            return new CacheResponse(dataMap, mGoogleApiClient);
        }
        if (dataMap.getString("Type").equals("ThirdParty")) {
            return new ThirdPartyResponse(dataMap);
        }
        return null;
    }

    static class CacheResponse
    extends WearableDataResponse {
        final boolean result;

        protected CacheResponse(DataMap dataMap, GoogleApiClient mGoogleApiClient) {
            boolean fileFound = dataMap.getBoolean("FileFound");
            if (!fileFound) {
                RemoteDownload.deleteFilesInDirectory("adbdownloadcache");
                this.result = false;
                return;
            }
            this.result = dataMap.getBoolean("Updated");
            if (!this.result) {
                return;
            }
            String url = dataMap.getString("URL");
            RemoteDownload.deleteCachedDataForURL(url, "adbdownloadcache");
            Asset asset = dataMap.getAsset("FileContent");
            String fileName = dataMap.getString("FileName");
            File dir = RemoteDownload.getDownloadCacheDirectory("adbdownloadcache");
            if (dir == null) {
                return;
            }
            WearableDataResponse.saveFileFromAsset(asset, dir.getPath() + File.separator + fileName, mGoogleApiClient);
        }

        protected boolean getResult() {
            return this.result;
        }
    }

    static class ShareConfigResponse
    extends WearableDataResponse {
        final DataMap result;

        protected ShareConfigResponse(DataMap dataMap) {
            this.result = dataMap;
        }

        protected DataMap getResult() {
            return this.result;
        }
    }

    static class ThirdPartyResponse
    extends WearableDataResponse {
        protected ThirdPartyResponse(DataMap dataMap) {
            this.success = dataMap.getBoolean("Result");
        }
    }

    static class PostResponse
    extends WearableDataResponse {
        protected byte[] result;

        protected PostResponse(DataMap dataMap) {
            this.result = dataMap.getByteArray("Result");
            if (this.result != null && this.result.length > 0) {
                this.success = true;
            }
        }

        protected byte[] getResult() {
            return this.result;
        }
    }

    static class GetResponse
    extends WearableDataResponse {
        protected byte[] result;

        protected GetResponse(DataMap dataMap) {
            this.result = dataMap.getByteArray("Result");
            if (this.result != null) {
                this.success = true;
            }
        }

        protected byte[] getResult() {
            return this.result;
        }
    }
}

