/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.mobile;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;
import com.adobe.mobile.ConfigSynchronizer;
import com.adobe.mobile.RemoteDownload;
import com.adobe.mobile.RequestHandler;
import com.adobe.mobile.StaticMethods;
import com.google.android.gms.wearable.Asset;
import com.google.android.gms.wearable.DataMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.UUID;

abstract class WearableDataRequest {
    protected int timeOut;
    protected String uuid = UUID.randomUUID().toString();

    protected abstract DataMap getDataMap();

    protected abstract DataMap handle(Context var1);

    protected WearableDataRequest() {
    }

    protected WearableDataRequest(int timeOut) {
        this();
        this.timeOut = timeOut;
    }

    protected String getUUID() {
        return this.uuid;
    }

    protected int getTimeOut() {
        return this.timeOut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readFile(File file) {
        byte[] buffer = new byte[(int)file.length()];
        FileInputStream ios = null;
        try {
            ios = new FileInputStream(file);
            if (((InputStream)ios).read(buffer) == -1) {
                byte[] byArray = null;
                return byArray;
            }
        }
        catch (IOException e) {
            StaticMethods.logErrorFormat("Wearable - Failed to read cached file", new Object[0]);
            byte[] byArray = null;
            return byArray;
        }
        catch (Exception e) {
            StaticMethods.logErrorFormat("Wearable - Failed to read cached file", new Object[0]);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                if (ios != null) {
                    ((InputStream)ios).close();
                }
            }
            catch (IOException e) {
                StaticMethods.logDebugFormat("Wearable - Failed to close the file input stream", new Object[0]);
            }
        }
        return buffer;
    }

    protected static WearableDataRequest createGetRequest(String url, int timeOut) {
        return new Get(url, timeOut);
    }

    protected static WearableDataRequest createPostRequest(String url, String body, int timeOut) {
        return new Post(url, body, timeOut);
    }

    protected static WearableDataRequest createThirdPartyRequest(String url, String body, int timeOut, String postType) {
        return new ThirdPartyRequest(url, body, timeOut, postType);
    }

    protected static WearableDataRequest createShareConfigRequest(int timeOut) {
        return new ShareConfig(timeOut);
    }

    protected static WearableDataRequest createFileRequest(String url, String fileName, int timeOut) {
        return new Cache(url, fileName, timeOut);
    }

    protected static WearableDataRequest createRequestFromDataMap(DataMap dataMap) {
        if (!dataMap.containsKey("Type")) {
            return null;
        }
        if (dataMap.getString("Type").equals("POST")) {
            return new Post(dataMap);
        }
        if (dataMap.getString("Type").equals("GET")) {
            return new Get(dataMap);
        }
        if (dataMap.getString("Type").equals("Config")) {
            return new ShareConfig(dataMap);
        }
        if (dataMap.getString("Type").equals("File")) {
            return new Cache(dataMap);
        }
        if (dataMap.getString("Type").equals("ThirdParty")) {
            return new ThirdPartyRequest(dataMap);
        }
        return null;
    }

    static class Cache
    extends WearableDataRequest {
        protected String url;
        protected String fileName;

        protected Cache(String url, String fileName, int timeOut) {
            super(timeOut);
            this.url = url;
            this.fileName = fileName;
        }

        protected Cache(DataMap dataMap) {
            this.uuid = dataMap.getString("ID");
            this.fileName = dataMap.getString("FileName");
            this.url = dataMap.getString("URL");
        }

        @Override
        protected DataMap getDataMap() {
            DataMap dataMap = new DataMap();
            dataMap.putString("Type", "File");
            dataMap.putString("ID", this.uuid);
            dataMap.putString("URL", this.url);
            dataMap.putString("FileName", this.fileName);
            return dataMap;
        }

        @Override
        protected DataMap handle(Context context) {
            DataMap responseDataMap = new DataMap();
            responseDataMap.putString("ID", this.uuid);
            responseDataMap.putString("Type", "File");
            responseDataMap.putString("URL", this.url);
            File file = RemoteDownload.getFileForCachedURL(this.url);
            if (file == null) {
                responseDataMap.putBoolean("FileFound", false);
            } else {
                responseDataMap.putBoolean("FileFound", true);
                if (file.getName().equals(this.fileName)) {
                    responseDataMap.putBoolean("Updated", false);
                } else {
                    responseDataMap.putBoolean("Updated", true);
                    responseDataMap.putString("FileName", file.getName());
                    byte[] fileContents = WearableDataRequest.readFile(file);
                    if (fileContents != null && fileContents.length > 0) {
                        responseDataMap.putAsset("FileContent", Asset.createFromBytes((byte[])fileContents));
                    }
                }
            }
            return responseDataMap;
        }
    }

    static class ShareConfig
    extends WearableDataRequest {
        protected ShareConfig(int timeOut) {
            super(timeOut);
        }

        protected ShareConfig(DataMap dataMap) {
            this.uuid = dataMap.getString("ID");
        }

        @Override
        protected DataMap getDataMap() {
            DataMap dataMap = new DataMap();
            dataMap.putString("Type", "Config");
            dataMap.putString("ID", this.uuid);
            return dataMap;
        }

        @Override
        protected DataMap handle(Context context) {
            DataMap responseDataMap = new DataMap();
            responseDataMap.putString("ID", this.uuid);
            responseDataMap.putString("Type", "Config");
            responseDataMap.putAll(ConfigSynchronizer.getSharedConfig());
            return responseDataMap;
        }
    }

    static class ThirdPartyRequest
    extends Post {
        protected String postType;
        protected static final String logPrefix = "Wearable Third Party Request Forward";

        protected ThirdPartyRequest(String url, String body, int timeout) {
            super(url, body, timeout);
        }

        protected ThirdPartyRequest(String url, String body, int timeOut, String postType) {
            this(url, body, timeOut);
            this.postType = postType;
        }

        protected ThirdPartyRequest(DataMap dataMap) {
            super(dataMap);
            this.postType = dataMap.getString("PostType");
        }

        @Override
        protected DataMap getDataMap() {
            DataMap dataMap = super.getDataMap();
            dataMap.putString("Type", "ThirdParty");
            dataMap.putString("PostType", this.postType);
            return dataMap;
        }

        @Override
        protected DataMap handle(Context context) {
            DataMap responseDataMap = new DataMap();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Accept-Language", ThirdPartyRequest.getDefaultAcceptLanguage(context));
            headers.put("User-Agent", ThirdPartyRequest.getDefaultUserAgent(context));
            boolean result = RequestHandler.sendThirdPartyRequest(this.url, this.body, headers, this.timeOut, this.postType, logPrefix);
            responseDataMap.putBoolean("Result", result);
            responseDataMap.putString("ID", this.uuid);
            responseDataMap.putString("Type", "ThirdParty");
            return responseDataMap;
        }
    }

    static class Post
    extends WearableDataRequest {
        protected String url;
        protected String body;
        protected static final String logPrefix = "Wearable POST Request Forward";
        private static String userAgent = null;
        private static final Object _userAgentMutex = new Object();

        protected Post() {
        }

        protected Post(String url, String body, int timeOut) {
            super(timeOut);
            this.url = url;
            this.body = body;
        }

        protected Post(DataMap dataMap) {
            this.timeOut = dataMap.getInt("Timeout");
            this.url = dataMap.getString("URL");
            this.body = dataMap.getString("Body");
            this.uuid = dataMap.getString("ID");
        }

        @Override
        protected DataMap getDataMap() {
            DataMap dataMap = new DataMap();
            dataMap.putString("ID", this.uuid);
            dataMap.putString("Type", "POST");
            dataMap.putString("URL", this.url);
            dataMap.putInt("Timeout", this.timeOut);
            dataMap.putString("Body", this.body);
            return dataMap;
        }

        @Override
        protected DataMap handle(Context context) {
            DataMap responseDataMap = new DataMap();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Accept-Language", Post.getDefaultAcceptLanguage(context));
            headers.put("User-Agent", Post.getDefaultUserAgent(context));
            byte[] byteArray = RequestHandler.retrieveAnalyticsRequestData(this.url, this.body, headers, this.timeOut, logPrefix);
            responseDataMap.putByteArray("Result", byteArray);
            responseDataMap.putString("ID", this.uuid);
            responseDataMap.putString("Type", "POST");
            return responseDataMap;
        }

        protected static String getDefaultAcceptLanguage(Context context) {
            if (context == null) {
                return null;
            }
            Resources resources = context.getResources();
            if (resources == null) {
                return null;
            }
            Configuration configuration = resources.getConfiguration();
            if (configuration == null) {
                return null;
            }
            Locale locale = configuration.locale;
            if (locale == null) {
                return null;
            }
            return locale.toString().replace('_', '-');
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected static String getDefaultUserAgent(Context context) {
            Object object = _userAgentMutex;
            synchronized (object) {
                if (userAgent == null) {
                    userAgent = "Mozilla/5.0 (Linux; U; Android " + Build.VERSION.RELEASE + "; " + Post.getDefaultAcceptLanguage(context) + "; " + Build.MODEL + " Build/" + Build.ID + ")";
                }
                return userAgent;
            }
        }

        protected String getURL() {
            return this.url;
        }
    }

    static class Get
    extends WearableDataRequest {
        protected String url;
        protected static final String logPrefix = "Wearable GET Requested Forward";

        protected Get(String url, int timeOut) {
            super(timeOut);
            this.url = url;
        }

        protected Get(DataMap dataMap) {
            this.url = dataMap.getString("URL");
            this.uuid = dataMap.getString("ID");
            this.timeOut = dataMap.getInt("Timeout");
        }

        @Override
        protected DataMap getDataMap() {
            DataMap dataMap = new DataMap();
            dataMap.putString("ID", this.uuid);
            dataMap.putInt("Timeout", this.timeOut);
            dataMap.putString("Type", "GET");
            dataMap.putString("URL", this.url);
            return dataMap;
        }

        @Override
        protected DataMap handle(Context context) {
            DataMap responseDataMap = new DataMap();
            byte[] byteArray = RequestHandler.retrieveData(this.url, null, this.timeOut, logPrefix);
            responseDataMap.putByteArray("Result", byteArray);
            responseDataMap.putString("ID", this.uuid);
            responseDataMap.putString("Type", "GET");
            return responseDataMap;
        }

        protected String getURL() {
            return this.url;
        }
    }
}

