/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.mobile;

import com.adobe.mobile.StaticMethods;

public class VisitorID {
    public final String idOrigin;
    public final String idType;
    public String id;
    public VisitorIDAuthenticationState authenticationState = VisitorIDAuthenticationState.VISITOR_ID_AUTHENTICATION_STATE_UNKNOWN;

    protected VisitorID(String idOrigin, String idType, String id, VisitorIDAuthenticationState authenticationState) throws IllegalStateException {
        String cleanIdType = StaticMethods.cleanContextDataKey(idType);
        if (cleanIdType == null || cleanIdType.length() == 0) {
            throw new IllegalStateException("idType must not be null/empty");
        }
        this.idOrigin = idOrigin;
        this.idType = cleanIdType;
        this.id = id;
        this.authenticationState = authenticationState;
    }

    protected boolean isVisitorID(String compareIDType) {
        return this.idType.equals(compareIDType);
    }

    protected String serializeIdentifierKeyForAnalyticsID() {
        return this.idType + ".id";
    }

    protected String serializeAuthenticationKeyForAnalyticsID() {
        return this.idType + ".as";
    }

    public static enum VisitorIDAuthenticationState {
        VISITOR_ID_AUTHENTICATION_STATE_UNKNOWN(0, "unknown"),
        VISITOR_ID_AUTHENTICATION_STATE_AUTHENTICATED(1, "authenticated"),
        VISITOR_ID_AUTHENTICATION_STATE_LOGGED_OUT(2, "logged_out");

        private final int value;
        private final String textValue;

        private VisitorIDAuthenticationState(int value, String textValue) {
            this.value = value;
            this.textValue = textValue;
        }

        protected int getValue() {
            return this.value;
        }

        protected String getTextValue() {
            return this.textValue;
        }
    }
}

