/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.mobile;

import com.adobe.mobile.StaticMethods;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

class RemoteDownload {
    private static final int DEFAULT_CONNECTION_TIMEOUT = 10000;
    private static final int DEFAULT_READ_TIMEOUT = 10000;

    RemoteDownload() {
    }

    protected static boolean stringIsUrl(String stringUrl) {
        if (stringUrl == null || stringUrl.length() <= 0) {
            return false;
        }
        try {
            new URL(stringUrl);
            return true;
        }
        catch (MalformedURLException ex) {
            return false;
        }
    }

    protected static void remoteDownloadAsync(String url, int connectionTimeout, int readTimeout, RemoteDownloadBlock block, String directory) {
        Thread thread = new Thread(new DownloadFileTask(url, block, connectionTimeout, readTimeout, directory));
        thread.start();
    }

    protected static void remoteDownloadAsync(String url, int connectionTimeout, int readTimeout, RemoteDownloadBlock block) {
        RemoteDownload.remoteDownloadAsync(url, connectionTimeout, readTimeout, block, "adbdownloadcache");
    }

    protected static void remoteDownloadAsync(String url, RemoteDownloadBlock block) {
        RemoteDownload.remoteDownloadAsync(url, 10000, 10000, block, "adbdownloadcache");
    }

    protected static void remoteDownloadAsync(String url, String directory, RemoteDownloadBlock block) {
        RemoteDownload.remoteDownloadAsync(url, 10000, 10000, block, directory);
    }

    protected static void remoteDownloadSync(String url, int connectionTimeout, int readTimeout, RemoteDownloadBlock block, String directory) {
        DownloadFileTask r = new DownloadFileTask(url, block, connectionTimeout, readTimeout, directory);
        r.run();
    }

    protected static void remoteDownloadSync(String url, int connectionTimeout, int readTimeout, RemoteDownloadBlock block) {
        RemoteDownload.remoteDownloadSync(url, connectionTimeout, readTimeout, block, "adbdownloadcache");
    }

    protected static void remoteDownloadSync(String url, RemoteDownloadBlock block) {
        RemoteDownload.remoteDownloadSync(url, 10000, 10000, block, "adbdownloadcache");
    }

    protected static void remoteDownloadSync(String url, String directory, RemoteDownloadBlock block) {
        RemoteDownload.remoteDownloadSync(url, 10000, 10000, block, directory);
    }

    protected static File getFileForCachedURL(String url) {
        return RemoteDownload.getFileForCachedURL(url, "adbdownloadcache");
    }

    protected static File getFileForCachedURL(String url, String directory) {
        if (url == null || url.length() < 1) {
            return null;
        }
        File cacheDirectory = RemoteDownload.getDownloadCacheDirectory(directory);
        if (cacheDirectory == null) {
            return null;
        }
        String[] cachedFiles = cacheDirectory.list();
        if (cachedFiles == null || cachedFiles.length < 1) {
            StaticMethods.logDebugFormat("Cached Files - Directory is empty (%s).", cacheDirectory.getAbsolutePath());
            return null;
        }
        String hashedName = RemoteDownload.md5hash(url);
        for (String fileName : cachedFiles) {
            if (!fileName.substring(0, fileName.lastIndexOf(46)).equals(hashedName)) continue;
            return new File(cacheDirectory, fileName);
        }
        StaticMethods.logDebugFormat("Cached Files - This file has not previously been cached (%s).", url);
        return null;
    }

    protected static void deleteFilesForDirectoryNotInList(String directory, List<String> urls) {
        if (urls == null || urls.size() <= 0) {
            RemoteDownload.deleteFilesInDirectory(directory);
            return;
        }
        File cacheDir = RemoteDownload.getDownloadCacheDirectory(directory);
        if (cacheDir == null) {
            return;
        }
        File[] cachedFiles = cacheDir.listFiles();
        if (cachedFiles == null || cachedFiles.length <= 0) {
            return;
        }
        ArrayList<String> hashedUrls = new ArrayList<String>();
        for (String url : urls) {
            hashedUrls.add(RemoteDownload.md5hash(url));
        }
        for (File file : cachedFiles) {
            String fileName = file.getName();
            String fileHash = fileName.substring(0, fileName.indexOf("."));
            if (hashedUrls.contains(fileHash)) continue;
            if (file.delete()) {
                StaticMethods.logDebugFormat("Cached File - Removed unused cache file", new Object[0]);
                continue;
            }
            StaticMethods.logWarningFormat("Cached File - Failed to remove unused cache file", new Object[0]);
        }
    }

    protected static void deleteFilesInDirectory(String directory) {
        File cacheDir = RemoteDownload.getDownloadCacheDirectory(directory);
        if (cacheDir == null) {
            return;
        }
        File[] cachedFiles = cacheDir.listFiles();
        if (cachedFiles == null || cachedFiles.length <= 0) {
            return;
        }
        for (File file : cachedFiles) {
            if (file.delete()) {
                StaticMethods.logDebugFormat("Cached File - Removed unused cache file", new Object[0]);
                continue;
            }
            StaticMethods.logWarningFormat("Cached File - Failed to remove unused cache file", new Object[0]);
        }
    }

    private static File getNewCachedFile(String url, Date lastModified, String etag, String directory) {
        if (url == null || url.length() < 1) {
            StaticMethods.logWarningFormat("Cached File - Invalid url parameter while attempting to create cache file. Could not save data.", new Object[0]);
            return null;
        }
        if (lastModified == null) {
            StaticMethods.logWarningFormat("Cached File - Invalid lastModified parameter while attempting to create cache file. Could not save data.", new Object[0]);
            return null;
        }
        if (etag == null || etag.length() < 1) {
            StaticMethods.logWarningFormat("Cached File - Invalid etag parameter while attempting to create cache file. Could not save data.", new Object[0]);
            return null;
        }
        File cacheDirectory = RemoteDownload.getDownloadCacheDirectory(directory);
        if (cacheDirectory == null) {
            return null;
        }
        String md5Hash = RemoteDownload.md5hash(url);
        if (md5Hash == null || md5Hash.length() < 1) {
            return null;
        }
        return new File(cacheDirectory.getPath() + File.separator + RemoteDownload.md5hash(url) + "." + lastModified.getTime() + "_" + etag);
    }

    protected static File getDownloadCacheDirectory(String directory) {
        File downloadCacheDirectory = new File(StaticMethods.getCacheDirectory(), directory);
        if (!downloadCacheDirectory.exists() && !downloadCacheDirectory.mkdir()) {
            StaticMethods.logWarningFormat("Cached File - unable to open/make download cache directory", new Object[0]);
            return null;
        }
        return downloadCacheDirectory;
    }

    protected static boolean deleteCachedDataForURL(String url, String directory) {
        if (url == null || url.length() < 1) {
            StaticMethods.logWarningFormat("Cached File - tried to delete cached file, but file path was empty", new Object[0]);
            return false;
        }
        File cachedFile = RemoteDownload.getFileForCachedURL(url, directory);
        return cachedFile != null && cachedFile.delete();
    }

    private static long getLastModifiedOfFile(String path) {
        if (path == null || path.length() < 1) {
            StaticMethods.logWarningFormat("Cached File - Path was null or empty for Cache File. Could not get Last Modified Date.", new Object[0]);
            return 0L;
        }
        String[] splitExtension = RemoteDownload.splitPathExtension(RemoteDownload.getPathExtension(path));
        if (splitExtension == null || splitExtension.length < 1) {
            StaticMethods.logWarningFormat("Cached File - No last modified date for file. Extension had no values after split.", new Object[0]);
            return 0L;
        }
        return Long.parseLong(splitExtension[0]);
    }

    private static String getEtagOfFile(String path) {
        if (path == null || path.length() < 1) {
            StaticMethods.logWarningFormat("Cached File - Path was null or empty for Cache File", new Object[0]);
            return null;
        }
        String[] splitExtension = RemoteDownload.splitPathExtension(RemoteDownload.getPathExtension(path));
        if (splitExtension == null || splitExtension.length < 2) {
            StaticMethods.logWarningFormat("Cached File - No etag for file. Extension had no second value after split.", new Object[0]);
            return null;
        }
        return splitExtension[1];
    }

    private static String getPathExtension(String path) {
        if (path == null || path.length() < 1) {
            StaticMethods.logWarningFormat("Cached File - Path was null or empty for Cache File", new Object[0]);
            return null;
        }
        return path.substring(path.lastIndexOf(".") + 1);
    }

    private static String[] splitPathExtension(String extension) {
        if (extension == null || extension.length() < 1) {
            StaticMethods.logWarningFormat("Cached File - Extension was null or empty on Cache File", new Object[0]);
            return null;
        }
        String[] separated = extension.split("_");
        if (separated.length != 2) {
            StaticMethods.logWarningFormat("Cached File - Invalid Extension on Cache File (%s)", extension);
            return null;
        }
        return separated;
    }

    private static SimpleDateFormat createRFC2822Formatter() {
        String pattern = "EEE, dd MMM yyyy HH:mm:ss Z";
        SimpleDateFormat rfc2822formatter = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.US);
        rfc2822formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        return rfc2822formatter;
    }

    private static String md5hash(String input) {
        if (input == null || input.length() < 1) {
            return null;
        }
        try {
            MessageDigest messagedigest = MessageDigest.getInstance("MD5");
            messagedigest.update(input.getBytes("UTF-8"));
            byte[] messageDigest = messagedigest.digest();
            StringBuilder md5HexBuilder = new StringBuilder();
            for (byte aMessageDigest : messageDigest) {
                String hexString = Integer.toHexString(0xFF & aMessageDigest);
                while (hexString.length() < 2) {
                    hexString = "0" + hexString;
                }
                md5HexBuilder.append(hexString);
            }
            return md5HexBuilder.toString();
        }
        catch (NoSuchAlgorithmException e) {
            StaticMethods.logErrorFormat("Cached Files - unable to get md5 hash (%s)", e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            StaticMethods.logErrorFormat("Cached Files - Unsupported Encoding: UTF-8 (%s)", e.getMessage());
        }
        return null;
    }

    static /* synthetic */ SimpleDateFormat access$100() {
        return RemoteDownload.createRFC2822Formatter();
    }

    static /* synthetic */ String access$200(String x0) {
        return RemoteDownload.getEtagOfFile(x0);
    }

    static /* synthetic */ long access$300(String x0) {
        return RemoteDownload.getLastModifiedOfFile(x0);
    }

    static /* synthetic */ File access$400(String x0, Date x1, String x2, String x3) {
        return RemoteDownload.getNewCachedFile(x0, x1, x2, x3);
    }

    private static class DownloadFileTask
    implements Runnable {
        private final RemoteDownloadBlock callback;
        private final String url;
        private final int connectionTimeout;
        private final int readTimeout;
        private final String directory;

        private DownloadFileTask(String initRequest, RemoteDownloadBlock initCallback, int initConnectionTimeout, int initReadTimeout, String initDirectory) {
            this.url = initRequest;
            this.callback = initCallback;
            this.connectionTimeout = initConnectionTimeout;
            this.readTimeout = initReadTimeout;
            this.directory = initDirectory;
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    protected static interface RemoteDownloadBlock {
        public void call(boolean var1, File var2);
    }
}

