/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.mobile;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.widget.Toast;
import com.adobe.mobile.MessageFullScreen;
import com.adobe.mobile.Messages;
import com.adobe.mobile.StaticMethods;
import com.adobe.mobile.TargetPreviewManager;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

final class MessageTargetExperienceUIFullScreen
extends MessageFullScreen {
    private static final String URL_QUERY_KEY_AT_PREVIEW_PARAMS = "at_preview_params=";

    MessageTargetExperienceUIFullScreen() {
        this.setShouldSendAnalyticsHitsOnInteractions(false);
    }

    @Override
    protected MessageFullScreen.MessageFullScreenRunner getNewMessageFullScreenRunner(MessageFullScreen messageFullScreen) {
        return new TargetPreviewFullScreenRunner(messageFullScreen);
    }

    @Override
    protected MessageFullScreen.MessageFullScreenWebViewClient getMessageFullScreenWebViewClient() {
        return new TargetPreviewExperienceUIWebviewClient(this);
    }

    @Override
    protected void show() {
        this.html = TargetPreviewManager.getInstance().getTargetPreviewExperienceUIHtml();
        if (this.html == null) {
            StaticMethods.logErrorFormat("Could not display the Target Preview Experience UI (no html payload found!)", new Object[0]);
            return;
        }
        super.show();
    }

    private static class TargetPreviewExperienceUIWebviewClient
    extends MessageFullScreen.MessageFullScreenWebViewClient {
        protected TargetPreviewExperienceUIWebviewClient(MessageFullScreen message) {
            super(message);
        }

        @Override
        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            super.shouldOverrideUrlLoading(view, url);
            if (!url.startsWith("adbinapp")) {
                Toast.makeText((Context)view.getContext(), (CharSequence)"Error while reading the response from the Experience UI! (Response mal-formed)", (int)0).show();
                this.dismissMessage(view);
            } else if (url.contains("confirm")) {
                String restartUrl;
                int atPreviewParamsStartIndex = url.indexOf(MessageTargetExperienceUIFullScreen.URL_QUERY_KEY_AT_PREVIEW_PARAMS);
                if (atPreviewParamsStartIndex >= 0) {
                    String params;
                    int atPreviewParamsEndIndex = url.indexOf(38, atPreviewParamsStartIndex);
                    if (atPreviewParamsEndIndex < 0) {
                        atPreviewParamsEndIndex = url.length();
                    }
                    if (!(params = url.substring(atPreviewParamsStartIndex + MessageTargetExperienceUIFullScreen.URL_QUERY_KEY_AT_PREVIEW_PARAMS.length(), atPreviewParamsEndIndex)).isEmpty()) {
                        try {
                            TargetPreviewManager.getInstance().setPreviewParams(URLDecoder.decode(params, "UTF-8"));
                        }
                        catch (UnsupportedEncodingException ex) {
                            StaticMethods.logDebugFormat("Could not decode the Target Preview parameters (%s)", ex);
                        }
                    }
                }
                if ((restartUrl = TargetPreviewManager.getInstance().getPreviewRestartDeeplink()) != null && !restartUrl.isEmpty()) {
                    try {
                        Intent intent = new Intent("android.intent.action.VIEW");
                        intent.setData(Uri.parse((String)restartUrl));
                        this.message.messageFullScreenActivity.startActivity(intent);
                    }
                    catch (Exception ex) {
                        StaticMethods.logDebugFormat("Messages - unable to launch restart deeplink intent from Target Preview message (%s)", ex.getMessage());
                    }
                }
            } else if (url.contains("cancel")) {
                TargetPreviewManager.getInstance().disableTargetPreviewMode();
            }
            Messages.setCurrentMessage(null);
            return true;
        }
    }

    private static class TargetPreviewFullScreenRunner
    extends MessageFullScreen.MessageFullScreenRunner {
        protected TargetPreviewFullScreenRunner(MessageFullScreen message) {
            super(message);
        }

        @Override
        protected WebView createWebView() {
            WebView webView = super.createWebView();
            WebSettings webSettings = webView.getSettings();
            webSettings.setDomStorageEnabled(true);
            File cacheDirectory = StaticMethods.getCacheDirectory();
            if (cacheDirectory != null) {
                webSettings.setDatabasePath(cacheDirectory.getPath());
                webSettings.setDatabaseEnabled(true);
            }
            return webView;
        }
    }
}

