/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.mobile;

import com.adobe.mobile.Media;
import com.adobe.mobile.MediaAnalytics;
import com.adobe.mobile.MediaSettings;
import com.adobe.mobile.MediaState;
import com.adobe.mobile.StaticMethods;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;

final class MediaItem {
    protected Media.MediaCallback<MediaState> callback = null;
    protected MediaAnalytics mediaAnalytics;
    protected MediaState currentMediaState = null;
    protected MediaState previousMediaState = null;
    protected String name;
    protected String playerName;
    protected String playerID;
    protected String parentName;
    protected String parentPod;
    protected String CPM;
    protected String channel;
    protected double parentPodPosition;
    protected double length;
    protected double timestamp;
    protected boolean mediaAd;
    protected boolean itemClosed;
    protected boolean trackCalled;
    private static final Object monitorMutex = new Object();
    private HashSet<String> firstEventList = new HashSet();
    private ArrayList<Integer> milestones = new ArrayList();
    private ArrayList<Integer> offsetMilestones = new ArrayList();
    private MonitorThread monitor;
    private boolean completeTracked;
    private boolean segmentByMilestones = false;
    private boolean segmentByOffsetMilestones = false;
    private int completeCloseOffsetThreshold = 1;
    private int trackSecondsThreshold = 0;
    protected int lastTrackSegmentNumber;

    public MediaItem(MediaSettings settings, MediaAnalytics mediaAnalytics, String cleanName, double validLength, String cleanPlayerName) {
        this.name = cleanName;
        this.length = validLength;
        this.playerName = cleanPlayerName;
        this.mediaAnalytics = mediaAnalytics;
        this.playerID = settings.playerID;
        this.timestamp = StaticMethods.getTimeSince1970();
        this.channel = settings.channel;
        this.setMilestones(settings.milestones);
        this.setOffsetMilestones(settings.offsetMilestones);
        this.setSegmentByMilestones(settings.segmentByMilestones && this.milestones.size() > 0);
        this.setSegmentByOffsetMilestones(settings.segmentByOffsetMilestones && this.offsetMilestones.size() > 0);
        this.setTrackSecondsThreshold(mediaAnalytics.trackSeconds);
        this.setCompleteCloseOffsetThreshold(mediaAnalytics.completeCloseOffsetThreshold);
        if (settings.isMediaAd) {
            this.mediaAd = true;
            this.parentPodPosition = settings.parentPodPosition;
            this.parentName = settings.parentName;
            this.parentPod = settings.parentPod;
            this.CPM = settings.CPM;
        }
        this.completeCloseOffsetThreshold = settings.completeCloseOffsetThreshold > 0 ? settings.completeCloseOffsetThreshold : 1;
        this.trackSecondsThreshold = settings.trackSeconds > 0 ? settings.trackSeconds : 0;
    }

    protected void startMonitor() {
        if (this.monitor != null && !this.monitor.canceled) {
            return;
        }
        if (this.monitor != null) {
            this.stopMonitor();
        }
        this.monitor = new MonitorThread();
        this.monitor.monitorMediaItem = this;
        this.monitor.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopMonitor() {
        if (this.monitor != null) {
            Object object = monitorMutex;
            synchronized (object) {
                this.monitor.canceled = true;
                this.monitor = null;
            }
        }
    }

    protected synchronized void play(double offset) {
        if (this.currentMediaState != null && this.isPlaying()) {
            return;
        }
        this.updateMediaStates();
        this.updateCurrentMediaStateWithOffset(offset, 1);
        if (!this.currentMediaState.complete) {
            this.startMonitor();
        }
    }

    protected synchronized void monitor(double offset) {
        this.updateMediaStates();
        if (this.previousMediaState == null) {
            return;
        }
        this.updateCurrentMediaStateWithOffset(offset, 3);
        if (this.currentMediaState.complete) {
            this.stopMonitor();
        }
    }

    protected synchronized void click(double offset) {
        this.updateMediaStates();
        if (this.previousMediaState == null) {
            return;
        }
        this.updateCurrentMediaStateWithOffset(offset, 6);
    }

    protected synchronized void complete(double offset) {
        this.updateMediaStates();
        if (this.previousMediaState == null || this.previousMediaState.getEventType() == 5) {
            return;
        }
        this.updateCurrentMediaStateWithOffset(offset, 5);
        if (this.currentMediaState.complete) {
            this.stopMonitor();
        }
        this.currentMediaState.complete = true;
    }

    protected synchronized void stop(double offset) {
        this.updateMediaStates();
        this.updateCurrentMediaStateWithOffset(offset, 2);
        this.stopMonitor();
    }

    protected synchronized void close() {
        this.updateMediaStates();
        if (this.previousMediaState == null || this.previousMediaState.getEventType() == 0) {
            return;
        }
        if (this.previousMediaState.eventType == 2) {
            this.updateCurrentMediaStateWithOffset(this.currentMediaState.offset, 0);
        } else {
            this.updateCurrentMediaStateWithOffset(-1.0, 0);
        }
        if (this.isCurrentOffsetPastCompleteThreshold()) {
            this.currentMediaState.complete = true;
        }
        this.stopMonitor();
    }

    private void updateMediaStates() {
        this.previousMediaState = this.currentMediaState;
        this.currentMediaState = new MediaState(this.name, this.length, this.playerName, (long)this.timestamp);
    }

    private void updateCurrentMediaStateWithOffset(double offset, int defaultEventType) {
        this.currentMediaState.clicked = defaultEventType == 6;
        this.currentMediaState.ad = this.mediaAd;
        this.currentMediaState.setOffset(this.validateOffset(offset));
        this.calculateCurrentOffsetMilestoneAndSegment();
        this.calculateCurrentMilestoneAndSegment();
        this.updateTimePlayed(defaultEventType);
        this.currentMediaState.setEventType(defaultEventType);
        this.updateCurrentMediaStateMediaEventIfNeeded(defaultEventType);
        this.setEventFirstTime(this.currentMediaState);
    }

    private void calculateCurrentMilestoneAndSegment() {
        int milestone;
        if (this.isLive()) {
            return;
        }
        if (this.milestones.size() == 0) {
            return;
        }
        int lastPassedMilestoneIndex = this.calculateLastPassedMilestoneIndex();
        if (lastPassedMilestoneIndex == -1) {
            return;
        }
        this.currentMediaState.milestone = milestone = this.milestones.get(lastPassedMilestoneIndex).intValue();
        if (this.segmentByMilestones) {
            this.currentMediaState.segmentNum = lastPassedMilestoneIndex + 1;
            StringBuilder segmentBuilder = new StringBuilder();
            segmentBuilder.append("M:");
            segmentBuilder.append(Integer.toString(milestone));
            segmentBuilder.append("-");
            if (lastPassedMilestoneIndex < this.milestones.size() - 1) {
                segmentBuilder.append(Integer.toString(this.milestones.get(lastPassedMilestoneIndex + 1)));
            } else {
                segmentBuilder.append("100");
            }
            this.currentMediaState.segment = segmentBuilder.toString();
        }
    }

    private void calculateCurrentOffsetMilestoneAndSegment() {
        int milestone;
        if (this.offsetMilestones.size() == 0) {
            return;
        }
        int lastPassedOffsetMilestoneIndex = this.calculateLastPassedOffsetMilestoneIndex();
        if (lastPassedOffsetMilestoneIndex == -1) {
            return;
        }
        this.currentMediaState.offsetMilestone = milestone = this.offsetMilestones.get(lastPassedOffsetMilestoneIndex).intValue();
        if (this.segmentByOffsetMilestones) {
            this.currentMediaState.segmentNum = lastPassedOffsetMilestoneIndex + 1;
            StringBuilder segmentBuilder = new StringBuilder();
            segmentBuilder.append("O:");
            segmentBuilder.append(Integer.toString(milestone));
            segmentBuilder.append("-");
            if (lastPassedOffsetMilestoneIndex < this.offsetMilestones.size() - 1) {
                segmentBuilder.append(Integer.toString(this.offsetMilestones.get(lastPassedOffsetMilestoneIndex + 1)));
            } else {
                String end = this.isLive() ? "E" : Integer.toString((int)this.length);
                segmentBuilder.append(end);
            }
            this.currentMediaState.segment = segmentBuilder.toString();
        }
    }

    private int calculateLastPassedMilestoneIndex() {
        if (this.milestones.size() == 0) {
            return -1;
        }
        int returnVal = -1;
        for (int i = 0; i < this.milestones.size(); ++i) {
            int milestone = this.milestones.get(i);
            if (!(this.currentMediaState.percent >= (double)milestone)) continue;
            returnVal = i;
        }
        return returnVal;
    }

    private int calculateLastPassedOffsetMilestoneIndex() {
        if (this.offsetMilestones.size() == 0) {
            return -1;
        }
        int returnVal = -1;
        for (int i = 0; i < this.offsetMilestones.size(); ++i) {
            int milestone = this.offsetMilestones.get(i);
            if (!(this.currentMediaState.offset >= (double)milestone)) continue;
            returnVal = i;
        }
        return returnVal;
    }

    private void updateCurrentMediaStateMediaEventIfNeeded(int eventType) {
        if (eventType == 0) {
            return;
        }
        if (this.currentMediaState.percent >= 100.0) {
            this.currentMediaState.mediaEvent = "CLOSE";
            return;
        }
        if (this.previousMediaState == null) {
            return;
        }
        if (this.currentMediaState.milestone > this.previousMediaState.milestone) {
            this.currentMediaState.mediaEvent = "MILESTONE";
            return;
        }
        if (this.currentMediaState.offsetMilestone > this.previousMediaState.offsetMilestone) {
            this.currentMediaState.mediaEvent = "OFFSET_MILESTONE";
            return;
        }
        if (this.getTrackSecondsThreshold() > 0 && this.currentMediaState.getTimePlayedSinceTrack() >= (double)this.getTrackSecondsThreshold()) {
            this.currentMediaState.mediaEvent = "SECONDS";
        }
    }

    private double validateOffset(double offset) {
        if (offset < 0.0 && this.previousMediaState != null) {
            offset = this.currentMediaState.getTimestamp() - this.previousMediaState.getTimestamp() + this.previousMediaState.offset;
        }
        return offset;
    }

    private void updateTimePlayed(int defaultEventType) {
        if (this.previousMediaState == null) {
            return;
        }
        double timePlayed = 0.0;
        if (this.currentMediaState.offset > this.previousMediaState.offset && defaultEventType != 1) {
            timePlayed = this.currentMediaState.offset - this.previousMediaState.offset;
        }
        this.currentMediaState.setTimePlayed(this.previousMediaState.getTimePlayed() + timePlayed);
        this.currentMediaState.setTimePlayedSinceTrack(this.previousMediaState.getTimePlayedSinceTrack() + timePlayed);
    }

    private void setEventFirstTime(MediaState mediaState) {
        String eventKey = mediaState.mediaEvent;
        if (eventKey.equals("MILESTONE")) {
            eventKey = eventKey + "_" + mediaState.milestone;
        } else if (eventKey.equals("OFFSET_MILESTONE")) {
            eventKey = eventKey + "_" + mediaState.offsetMilestone;
        }
        if (!this.firstEventList.contains(eventKey)) {
            mediaState.eventFirstTime = true;
            this.firstEventList.add(eventKey);
        }
    }

    protected boolean isPlaying() {
        if (this.currentMediaState != null) {
            return this.currentMediaState.eventType != 0 && this.currentMediaState.eventType != 2;
        }
        return false;
    }

    protected boolean isCurrentOffsetPastCompleteThreshold() {
        return this.currentMediaState.offset >= this.length - (double)this.completeCloseOffsetThreshold;
    }

    protected boolean isLive() {
        return this.length == -1.0;
    }

    private void setMilestones(String milestones) {
        String[] milestoneStrings;
        this.milestones.clear();
        if (milestones == null || milestones.length() <= 0) {
            return;
        }
        this.milestones.add(0);
        for (String milestoneString : milestoneStrings = milestones.split(",")) {
            int milestone = (int)Double.parseDouble(milestoneString);
            if (milestone <= 0 || milestone > 100 || this.milestones.contains(milestone)) continue;
            this.milestones.add(milestone);
        }
        Collections.sort(this.milestones);
    }

    private void setOffsetMilestones(String offsetMilestones) {
        String[] milestoneStrings;
        this.offsetMilestones.clear();
        if (offsetMilestones == null || offsetMilestones.length() <= 0) {
            return;
        }
        this.offsetMilestones.add(0);
        for (String milestoneString : milestoneStrings = offsetMilestones.split(",")) {
            int milestone = (int)Double.parseDouble(milestoneString);
            if (milestone <= 0 || this.offsetMilestones.contains(milestone) || !this.isLive() && (double)milestone > this.length) continue;
            this.offsetMilestones.add(milestone);
        }
        Collections.sort(this.offsetMilestones);
    }

    protected MediaState getReportMediaState() {
        MediaState reportedState = new MediaState(this.currentMediaState);
        if (this.previousMediaState != null) {
            boolean usePreviousSegmentInfo = false;
            if (this.currentMediaState.milestone <= this.previousMediaState.milestone) {
                reportedState.milestone = 0;
                usePreviousSegmentInfo = true;
            }
            if (this.currentMediaState.offsetMilestone <= this.previousMediaState.offsetMilestone) {
                reportedState.offsetMilestone = 0;
                usePreviousSegmentInfo = true;
            }
            if (usePreviousSegmentInfo) {
                reportedState.segment = this.previousMediaState.segment;
                reportedState.segmentNum = this.previousMediaState.segmentNum;
                reportedState.segmentLength = this.previousMediaState.segmentLength;
            }
        }
        return reportedState;
    }

    protected boolean isSegmentByMilestones() {
        return this.segmentByMilestones;
    }

    protected String getName() {
        return this.name;
    }

    protected double getLength() {
        return this.length;
    }

    protected String getPlayerName() {
        return this.playerName;
    }

    protected String getPlayerID() {
        return this.playerID;
    }

    protected void setSegmentByMilestones(boolean segmentByMilestones) {
        this.segmentByMilestones = segmentByMilestones;
    }

    protected boolean isSegmentByOffsetMilestones() {
        return this.segmentByOffsetMilestones;
    }

    protected void setSegmentByOffsetMilestones(boolean segmentByOffsetMilestones) {
        this.segmentByOffsetMilestones = segmentByOffsetMilestones;
    }

    public int getTrackSecondsThreshold() {
        return this.trackSecondsThreshold;
    }

    public void setTrackSecondsThreshold(int trackSecondsThreshold) {
        this.trackSecondsThreshold = trackSecondsThreshold;
    }

    protected boolean isCompleteTracked() {
        return this.completeTracked;
    }

    protected void setCompleteTracked(boolean completeTracked) {
        this.completeTracked = completeTracked;
    }

    public void setCompleteCloseOffsetThreshold(int completeCloseOffsetThreshold) {
        this.completeCloseOffsetThreshold = completeCloseOffsetThreshold;
    }

    private static class MonitorThread
    extends Thread {
        long delay = 1000L;
        protected boolean canceled = false;
        protected MediaItem monitorMediaItem;

        private MonitorThread() {
        }

        @Override
        public void run() {
            try {
                while (!this.canceled) {
                    Thread.sleep(this.delay);
                    StaticMethods.getMediaExecutor().execute(new Runnable(){

                        @Override
                        public void run() {
                            MonitorThread.this.monitorMediaItem.mediaAnalytics.monitor(MonitorThread.this.monitorMediaItem.name, -1.0);
                        }
                    });
                }
            }
            catch (InterruptedException e) {
                StaticMethods.logWarningFormat("Media - Background Thread Interrupted : %s", e.getMessage());
            }
        }
    }
}

