/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.mobile;

import android.app.Activity;
import android.content.Intent;
import android.content.SharedPreferences;
import android.net.Uri;
import com.adobe.mobile.AbstractHitDatabase;
import com.adobe.mobile.AnalyticsTrackInternal;
import com.adobe.mobile.AnalyticsTrackLifetimeValueIncrease;
import com.adobe.mobile.AnalyticsTrackTimedAction;
import com.adobe.mobile.AnalyticsWorker;
import com.adobe.mobile.AudienceManagerWorker;
import com.adobe.mobile.Config;
import com.adobe.mobile.Messages;
import com.adobe.mobile.MobileConfig;
import com.adobe.mobile.ReferrerHandler;
import com.adobe.mobile.StaticMethods;
import com.adobe.mobile.TargetPreviewManager;
import com.adobe.mobile.VisitorIDService;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

final class Lifecycle {
    protected static long sessionStartTime = 0L;
    private static boolean appIsInBackground = false;
    protected static final String ADB_TRACK_INTERNAL_PUSH_CLICK_THROUGH = "PushMessage";
    protected static final String ADB_TRACK_INTERNAL_ADOBE_LINK = "AdobeLink";
    protected static final String ADB_LIFECYCLE_PUSH_MESSAGE_ID_KEY = "adb_m_id";
    protected static final String ADB_DEEPLINK_TYPE_APP_LINK = "applink";
    protected static final String ADB_DEEPLINK_TYPE_TARGET_PREVIEW_LINK = "targetPreviewlink";
    protected static volatile boolean lifecycleHasRun = false;
    private static final Object _lifecycleContextDataMutex = new Object();
    private static final HashMap<String, Object> _lifecycleContextData = new HashMap();
    private static final Object _lifecycleContextDataLowercaseMutex = new Object();
    private static final HashMap<String, Object> _lifecycleContextDataLowercase = new HashMap();
    private static final Object _previousSessionlifecycleContextDataMutex = new Object();
    private static final HashMap<String, Object> _previousSessionlifecycleContextData = new HashMap();

    Lifecycle() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void start(Activity activity, Map<String, Object> data) {
        SharedPreferences userDefaults;
        appIsInBackground = false;
        Lifecycle.updateLifecycleDataForUpgradeIfNecessary();
        if (lifecycleHasRun) {
            return;
        }
        lifecycleHasRun = true;
        try {
            userDefaults = StaticMethods.getSharedPreferences();
        }
        catch (StaticMethods.NullContextException e) {
            StaticMethods.logErrorFormat("Lifecycle - Error starting lifecycle (%s).", e.getMessage());
            return;
        }
        Activity currentActivity = null;
        try {
            currentActivity = StaticMethods.getCurrentActivity();
        }
        catch (StaticMethods.NullActivityException nullActivityException) {
            // empty catch block
        }
        if (currentActivity != null && activity != null && currentActivity.getComponentName().toString().equals(activity.getComponentName().toString())) {
            Messages.checkForInAppMessage(null, null, null);
        }
        StaticMethods.setCurrentActivity(activity);
        Map<String, Object> targetLinkData = Lifecycle.checkForAdobeLinkData(activity, ADB_DEEPLINK_TYPE_TARGET_PREVIEW_LINK);
        if (targetLinkData != null && TargetPreviewManager.getInstance().getToken() == null) {
            Lifecycle.extractTargetPreviewData(targetLinkData);
            TargetPreviewManager.getInstance().downloadAndShowTargetPreviewUI();
        }
        TargetPreviewManager.getInstance().setupPreviewButton();
        MobileConfig mobileConfig = MobileConfig.getInstance();
        long lastPauseTime = Lifecycle.msToSec(userDefaults.getLong("ADMS_PauseDate", 0L));
        int sessionTimeout = mobileConfig.getLifecycleTimeout();
        if (lastPauseTime > 0L) {
            long originalStartTime;
            long pausedTime = StaticMethods.getTimeSince1970() - lastPauseTime;
            sessionStartTime = originalStartTime = Lifecycle.msToSec(userDefaults.getLong("ADMS_SessionStart", 0L));
            AnalyticsTrackTimedAction.sharedInstance().trackTimedActionUpdateAdjustedStartTime(pausedTime);
            if (pausedTime < (long)sessionTimeout && originalStartTime > 0L) {
                try {
                    SharedPreferences.Editor editor = StaticMethods.getSharedPreferencesEditor();
                    editor.putLong("ADMS_SessionStart", Lifecycle.secToMs(originalStartTime + pausedTime));
                    editor.putBoolean("ADMS_SuccessfulClose", false);
                    editor.remove("ADMS_PauseDate");
                    editor.commit();
                }
                catch (StaticMethods.NullContextException e) {
                    StaticMethods.logErrorFormat("Lifecycle - Error while updating start time (%s).", e.getMessage());
                }
                sessionStartTime = Lifecycle.msToSec(userDefaults.getLong("ADMS_SessionStart", 0L));
                Lifecycle.checkForAdobeClickThrough(activity, false);
                return;
            }
        }
        VisitorIDService.sharedInstance().idSync(null, null, null, true);
        mobileConfig.downloadRemoteConfigs();
        Object pausedTime = _lifecycleContextDataMutex;
        synchronized (pausedTime) {
            _lifecycleContextData.clear();
        }
        pausedTime = _lifecycleContextDataLowercaseMutex;
        synchronized (pausedTime) {
            _lifecycleContextDataLowercase.clear();
        }
        HashMap<String, Object> contextData = data != null ? new HashMap<String, Object>(data) : new HashMap();
        Map<String, Object> clickThroughData = Lifecycle.checkForAdobeLinkData(activity, ADB_DEEPLINK_TYPE_APP_LINK);
        if (clickThroughData != null) {
            contextData.putAll(clickThroughData);
        }
        long date = Lifecycle.secToMs(StaticMethods.getTimeSince1970());
        if (!userDefaults.contains("ADMS_InstallDate")) {
            Lifecycle.addInstallData(contextData, date);
        } else {
            Lifecycle.addNonInstallData(contextData, date);
            Lifecycle.addUpgradeData(contextData, date);
            Lifecycle.addSessionLengthData(contextData);
            Lifecycle.checkReferrerDataForLaunch();
        }
        Lifecycle.addLifecycleGenericData(contextData, date);
        Lifecycle.generateLifecycleToBeSaved(contextData);
        Lifecycle.persistLifecycleContextData();
        MobileConfig.getInstance().invokeAdobeDataCallback(Config.MobileDataEvent.MOBILE_EVENT_LIFECYCLE, contextData);
        AnalyticsTrackInternal.trackInternal("Lifecycle", contextData, StaticMethods.getTimeSince1970() - 1L);
        if (!mobileConfig.getAamAnalyticsForwardingEnabled()) {
            HashMap<String, Object> lifecycleContextDataCopy;
            Object object = _lifecycleContextDataMutex;
            synchronized (object) {
                lifecycleContextDataCopy = new HashMap<String, Object>(_lifecycleContextData);
            }
            AudienceManagerWorker.SubmitSignal(lifecycleContextDataCopy, null);
        }
        Lifecycle.checkForAdobeClickThrough(activity, true);
        Lifecycle.resetLifecycleFlags(date);
    }

    private static void extractTargetPreviewData(Map<String, Object> targetLinkData) {
        if (targetLinkData != null) {
            Object overrideUrl;
            Object token = targetLinkData.get("at_preview_token");
            if (token != null && token instanceof String) {
                TargetPreviewManager.getInstance().setTargetPreviewToken((String)token);
            }
            if ((overrideUrl = targetLinkData.get("at_preview_endpoint")) != null && overrideUrl instanceof String) {
                TargetPreviewManager.getInstance().setTargetPreviewApiUiFetchUrlBaseOverride((String)overrideUrl);
            }
        }
    }

    protected static void stop() {
        Activity currentActivity;
        appIsInBackground = true;
        lifecycleHasRun = false;
        StaticMethods.updateLastKnownTimestamp(StaticMethods.getTimeSince1970());
        try {
            SharedPreferences.Editor editor = StaticMethods.getSharedPreferencesEditor();
            editor.putBoolean("ADMS_SuccessfulClose", true);
            editor.putLong("ADMS_PauseDate", Lifecycle.secToMs(StaticMethods.getTimeSince1970()));
            editor.commit();
        }
        catch (StaticMethods.NullContextException e) {
            StaticMethods.logErrorFormat("Lifecycle - Error updating lifecycle pause data (%s)", e.getMessage());
        }
        try {
            currentActivity = StaticMethods.getCurrentActivity();
        }
        catch (StaticMethods.NullActivityException ex) {
            return;
        }
        if (currentActivity.isFinishing()) {
            Messages.resetAllInAppMessages();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void persistLifecycleContextData() {
        try {
            JSONObject lifecycleJSON;
            Object object = _lifecycleContextDataMutex;
            synchronized (object) {
                lifecycleJSON = new JSONObject(_lifecycleContextData);
            }
            SharedPreferences.Editor editor = StaticMethods.getSharedPreferencesEditor();
            editor.putString("ADMS_LifecycleData", lifecycleJSON.toString());
            editor.commit();
        }
        catch (StaticMethods.NullContextException e) {
            StaticMethods.logWarningFormat("Lifecycle - Error persisting lifecycle data (%s)", e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static HashMap<String, Object> getContextData() {
        Object object = _lifecycleContextDataMutex;
        synchronized (object) {
            if (_lifecycleContextData.size() > 0) {
                return new HashMap<String, Object>(_lifecycleContextData);
            }
        }
        object = _previousSessionlifecycleContextDataMutex;
        synchronized (object) {
            if (_previousSessionlifecycleContextData.size() > 0) {
                return new HashMap<String, Object>(_previousSessionlifecycleContextData);
            }
            Lifecycle.addPersistedLifecycleToMap(_previousSessionlifecycleContextData);
            return new HashMap<String, Object>(_previousSessionlifecycleContextData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void updateContextData(Map<String, Object> data) {
        Object object = _lifecycleContextDataMutex;
        synchronized (object) {
            _lifecycleContextData.putAll(data);
        }
        object = _lifecycleContextDataLowercaseMutex;
        synchronized (object) {
            for (Map.Entry<String, Object> entry : data.entrySet()) {
                _lifecycleContextDataLowercase.put(entry.getKey().toLowerCase(), entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void removeContextData(String key) {
        Object object = _lifecycleContextDataMutex;
        synchronized (object) {
            _lifecycleContextData.remove(key);
        }
        object = _lifecycleContextDataLowercaseMutex;
        synchronized (object) {
            _lifecycleContextDataLowercase.remove(key.toLowerCase());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Map<String, Object> getContextDataLowercase() {
        Object object = _lifecycleContextDataLowercaseMutex;
        synchronized (object) {
            if (_lifecycleContextDataLowercase.size() <= 0) {
                HashMap<String, Object> previousSessionlifecycleContextData = new HashMap<String, Object>();
                Lifecycle.addPersistedLifecycleToMap(previousSessionlifecycleContextData);
                for (Map.Entry<String, Object> entry : previousSessionlifecycleContextData.entrySet()) {
                    _lifecycleContextDataLowercase.put(entry.getKey().toLowerCase(), entry.getValue());
                }
            }
            return new HashMap<String, Object>(_lifecycleContextDataLowercase);
        }
    }

    protected static void processAdobeDeepLink(Uri deepLinkUri) {
        Map<String, Object> deepLinkData;
        Map<String, Object> targetLinkData = Lifecycle.getAdobeDeepLinkQueryParameters(deepLinkUri, ADB_DEEPLINK_TYPE_TARGET_PREVIEW_LINK);
        if (targetLinkData != null) {
            Lifecycle.extractTargetPreviewData(targetLinkData);
            TargetPreviewManager.getInstance().setupPreviewButton();
        }
        if ((deepLinkData = Lifecycle.getAdobeDeepLinkQueryParameters(deepLinkUri, ADB_DEEPLINK_TYPE_APP_LINK)) == null) {
            return;
        }
        if (!ReferrerHandler.getReferrerProcessed()) {
            ReferrerHandler.saveReferrerDataFromOtherSource(deepLinkData);
            AbstractHitDatabase.Hit oldestHit = AnalyticsWorker.sharedInstance().selectOldestHit();
            if (oldestHit != null) {
                oldestHit.urlFragment = StaticMethods.appendContextData(deepLinkData, oldestHit.urlFragment);
                AnalyticsWorker.sharedInstance().updateHitInDatabase(oldestHit);
                return;
            }
        }
        HashMap<String, Object> cData = new HashMap<String, Object>();
        cData.putAll(deepLinkData);
        Lifecycle.updateContextData(cData);
        if (MobileConfig.getInstance().mobileUsingAnalytics()) {
            AnalyticsTrackInternal.trackInternal(ADB_TRACK_INTERNAL_ADOBE_LINK, cData, StaticMethods.getTimeSince1970());
        }
    }

    protected static boolean applicationIsInBackground() {
        return appIsInBackground;
    }

    private static void addPersistedLifecycleToMap(Map<String, Object> data) {
        try {
            String lifecycleJSONString = StaticMethods.getSharedPreferences().getString("ADMS_LifecycleData", null);
            if (lifecycleJSONString != null && lifecycleJSONString.length() > 0) {
                JSONObject lifecycleData = new JSONObject(lifecycleJSONString);
                data.putAll(StaticMethods.mapFromJson(lifecycleData));
            }
        }
        catch (StaticMethods.NullContextException e) {
            StaticMethods.logErrorFormat("Lifecycle - Issue loading persisted lifecycle data", e.getMessage());
        }
        catch (JSONException ex) {
            StaticMethods.logWarningFormat("Lifecycle - Issue loading persisted lifecycle data (%s)", ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateLifecycleToBeSaved(Map<String, Object> data) {
        HashMap<String, Object> mutableData = data != null ? new HashMap<String, Object>(data) : new HashMap();
        mutableData.putAll(StaticMethods.getDefaultData());
        mutableData.put("a.locale", StaticMethods.getDefaultAcceptLanguage());
        mutableData.put("a.ltv.amount", AnalyticsTrackLifetimeValueIncrease.getLifetimeValue());
        Object object = _lifecycleContextDataMutex;
        synchronized (object) {
            _lifecycleContextData.putAll(mutableData);
            Object object2 = _lifecycleContextDataLowercaseMutex;
            synchronized (object2) {
                _lifecycleContextDataLowercase.clear();
                for (Map.Entry<String, Object> entry : _lifecycleContextData.entrySet()) {
                    _lifecycleContextDataLowercase.put(entry.getKey().toLowerCase(), entry.getValue());
                }
            }
        }
    }

    private static void resetLifecycleFlags(long date) {
        try {
            SharedPreferences.Editor editor = StaticMethods.getSharedPreferencesEditor();
            if (!StaticMethods.getSharedPreferences().contains("ADMS_SessionStart")) {
                editor.putLong("ADMS_SessionStart", date);
                sessionStartTime = date / 1000L;
            }
            editor.putString("ADMS_LastVersion", StaticMethods.getApplicationVersion());
            editor.putBoolean("ADMS_SuccessfulClose", false);
            editor.remove("ADMS_PauseDate");
            editor.commit();
        }
        catch (StaticMethods.NullContextException e) {
            StaticMethods.logErrorFormat("Lifecycle - Error resetting lifecycle flags (%s).", e.getMessage());
        }
    }

    private static void checkReferrerDataForLaunch() {
        Map<String, Object> referrerData = Lifecycle.getReferrerDataFromSharedPreferences();
        if (referrerData == null || referrerData.size() == 0) {
            return;
        }
        Lifecycle.updateContextData(referrerData);
        MobileConfig.getInstance().invokeAdobeDataCallback(Config.MobileDataEvent.MOBILE_EVENT_ACQUISITION_LAUNCH, referrerData);
    }

    private static Map<String, Object> getReferrerDataFromSharedPreferences() {
        block10: {
            try {
                if (StaticMethods.getSharedPreferences().contains("ADMS_Referrer_ContextData_Json_String")) {
                    HashMap<String, Object> referrerData = new HashMap<String, Object>();
                    String referrerDataString = StaticMethods.getSharedPreferences().getString("ADMS_Referrer_ContextData_Json_String", null);
                    referrerDataString = ReferrerHandler.processReferrerDataFromV3Server(referrerDataString);
                    referrerData.putAll(ReferrerHandler.parseV3ContextDataFromResponse(referrerDataString));
                    if (referrerData.size() > 0) {
                        referrerData.putAll(ReferrerHandler.processV3ResponseAndReturnAdobeData(referrerDataString));
                    } else {
                        HashMap<String, Object> otherReferrerData;
                        HashMap<String, Object> googleReferrerData = ReferrerHandler.parseGoogleReferrerFields(referrerDataString);
                        if (googleReferrerData.containsKey("a.referrer.campaign.name") && googleReferrerData.containsKey("a.referrer.campaign.source")) {
                            referrerData.putAll(googleReferrerData);
                        }
                        if (referrerData.size() == 0 && (otherReferrerData = ReferrerHandler.parseOtherReferrerFields(referrerDataString)) != null && otherReferrerData.size() > 0) {
                            referrerData.putAll(otherReferrerData);
                        }
                    }
                    return referrerData;
                }
                if (!StaticMethods.getSharedPreferences().contains("utm_campaign")) break block10;
                String source = StaticMethods.getSharedPreferences().getString("utm_source", null);
                String medium = StaticMethods.getSharedPreferences().getString("utm_medium", null);
                String term = StaticMethods.getSharedPreferences().getString("utm_term", null);
                String content = StaticMethods.getSharedPreferences().getString("utm_content", null);
                String campaign = StaticMethods.getSharedPreferences().getString("utm_campaign", null);
                String trackingcode = StaticMethods.getSharedPreferences().getString("trackingcode", null);
                if (source == null || campaign == null) break block10;
                HashMap<String, Object> referrerContextData = new HashMap<String, Object>();
                referrerContextData.put("a.referrer.campaign.source", source);
                referrerContextData.put("a.referrer.campaign.medium", medium);
                referrerContextData.put("a.referrer.campaign.term", term);
                referrerContextData.put("a.referrer.campaign.content", content);
                referrerContextData.put("a.referrer.campaign.name", campaign);
                referrerContextData.put("a.referrer.campaign.trackingcode", trackingcode);
                try {
                    SharedPreferences.Editor editor = StaticMethods.getSharedPreferencesEditor();
                    JSONObject googleReferrerObject = new JSONObject();
                    googleReferrerObject.put("googleReferrerData", (Object)new JSONObject(referrerContextData));
                    editor.putString("ADMS_Referrer_ContextData_Json_String", googleReferrerObject.toString());
                    editor.commit();
                }
                catch (StaticMethods.NullContextException e) {
                    StaticMethods.logErrorFormat("Analytics - Error persisting referrer data (%s)", e.getMessage());
                }
                catch (JSONException e) {
                    StaticMethods.logErrorFormat("Analytics - Error persisting referrer data (%s)", e.getMessage());
                }
                return referrerContextData;
            }
            catch (StaticMethods.NullContextException e) {
                StaticMethods.logErrorFormat("Lifecycle - Error pulling persisted Acquisition data (%s)", e.getMessage());
            }
        }
        return null;
    }

    private static void addInstallData(Map<String, Object> cdata, long date) {
        SimpleDateFormat dayMonthYearFormat = new SimpleDateFormat("M/d/yyyy", Locale.US);
        cdata.put("a.InstallDate", dayMonthYearFormat.format(date));
        cdata.put("a.InstallEvent", "InstallEvent");
        cdata.put("a.DailyEngUserEvent", "DailyEngUserEvent");
        cdata.put("a.MonthlyEngUserEvent", "MonthlyEngUserEvent");
        try {
            if (StaticMethods.getSharedPreferences().contains("ADMS_Referrer_ContextData_Json_String") || StaticMethods.getSharedPreferences().contains("utm_campaign")) {
                Map<String, Object> referrerData = Lifecycle.getReferrerDataFromSharedPreferences();
                String referrerDataString = StaticMethods.getSharedPreferences().getString("ADMS_Referrer_ContextData_Json_String", null);
                JSONObject responseJSON = ReferrerHandler.translateV3StringResponseToJSONObject(referrerDataString);
                ReferrerHandler.triggerDeepLink(ReferrerHandler.getDeepLinkFromJSON(responseJSON));
                if (referrerData != null && referrerData.size() >= 0) {
                    cdata.putAll(referrerData);
                    MobileConfig.getInstance().invokeAdobeDataCallback(Config.MobileDataEvent.MOBILE_EVENT_ACQUISITION_INSTALL, referrerData);
                }
            } else if (MobileConfig.getInstance().mobileReferrerConfigured() && MobileConfig.getInstance().getReferrerTimeout() > 0) {
                ReferrerHandler.setReferrerProcessed(false);
                Messages.block3rdPartyCallbacksQueueForReferrer();
            }
            SharedPreferences.Editor editor = StaticMethods.getSharedPreferencesEditor();
            editor.putLong("ADMS_InstallDate", date);
            editor.commit();
        }
        catch (StaticMethods.NullContextException e) {
            StaticMethods.logErrorFormat("Lifecycle - Error setting install data (%s).", e.getMessage());
        }
    }

    private static void addUpgradeData(Map<String, Object> cdata, long date) {
        try {
            SharedPreferences.Editor editor = StaticMethods.getSharedPreferencesEditor();
            long upgradeDate = StaticMethods.getSharedPreferences().getLong("ADMS_UpgradeDate", 0L);
            if (Lifecycle.isApplicationUpgrade()) {
                cdata.put("a.UpgradeEvent", "UpgradeEvent");
                editor.putLong("ADMS_UpgradeDate", date);
                editor.putInt("ADMS_LaunchesAfterUpgrade", 0);
            } else if (upgradeDate > 0L) {
                cdata.put("a.DaysSinceLastUpgrade", Lifecycle.calculateDaysSince(upgradeDate, date));
            }
            if (upgradeDate > 0L) {
                int newLaunchesAfterUpgradeCount = StaticMethods.getSharedPreferences().getInt("ADMS_LaunchesAfterUpgrade", 0) + 1;
                cdata.put("a.LaunchesSinceUpgrade", "" + newLaunchesAfterUpgradeCount);
                editor.putInt("ADMS_LaunchesAfterUpgrade", newLaunchesAfterUpgradeCount);
            }
            editor.commit();
        }
        catch (StaticMethods.NullContextException e) {
            StaticMethods.logErrorFormat("Lifecycle - Error setting upgrade data (%s).", e.getMessage());
        }
    }

    private static boolean isApplicationUpgrade() {
        try {
            return !StaticMethods.getApplicationVersion().equalsIgnoreCase(StaticMethods.getSharedPreferences().getString("ADMS_LastVersion", ""));
        }
        catch (StaticMethods.NullContextException ex) {
            StaticMethods.logErrorFormat("Lifecycle - Unable to get application version (%s)", ex.getLocalizedMessage());
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateLifecycleDataForUpgradeIfNecessary() {
        if (!Lifecycle.isApplicationUpgrade()) {
            return;
        }
        HashMap<String, Object> lifecycleData = Lifecycle.getContextData();
        if (lifecycleData == null || lifecycleData.size() <= 0) {
            return;
        }
        lifecycleData.put("a.AppID", StaticMethods.getApplicationID());
        Object object = _lifecycleContextDataMutex;
        synchronized (object) {
            if (_lifecycleContextData.size() > 0) {
                Lifecycle.updateContextData(lifecycleData);
            } else {
                try {
                    Object object2 = _previousSessionlifecycleContextDataMutex;
                    synchronized (object2) {
                        _previousSessionlifecycleContextData.put("a.AppID", StaticMethods.getApplicationID());
                    }
                    SharedPreferences.Editor editor = StaticMethods.getSharedPreferencesEditor();
                    JSONObject lifecycleJSON = new JSONObject(lifecycleData);
                    editor.putString("ADMS_LifecycleData", lifecycleJSON.toString());
                    editor.commit();
                    Object object3 = _lifecycleContextDataLowercaseMutex;
                    synchronized (object3) {
                        _lifecycleContextDataLowercase.clear();
                    }
                }
                catch (StaticMethods.NullContextException ex) {
                    StaticMethods.logWarningFormat("Lifecycle - Error persisting lifecycle data (%s)", ex.getMessage());
                }
            }
        }
    }

    private static void addLifecycleGenericData(Map<String, Object> cdata, long date) {
        cdata.putAll(StaticMethods.getDefaultData());
        cdata.put("a.LaunchEvent", "LaunchEvent");
        cdata.put("a.OSVersion", StaticMethods.getOperatingSystem());
        SimpleDateFormat hourOfDayDateFormat = new SimpleDateFormat("H", Locale.US);
        cdata.put("a.HourOfDay", hourOfDayDateFormat.format(date));
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(date);
        int dow = cal.get(7);
        cdata.put("a.DayOfWeek", Integer.toString(dow));
        String adid = StaticMethods.getAdvertisingIdentifier();
        if (adid != null) {
            cdata.put("a.adid", adid);
        }
        if (StaticMethods.isPushEnabled()) {
            cdata.put("a.push.optin", "True");
        }
        try {
            SharedPreferences.Editor editor = StaticMethods.getSharedPreferencesEditor();
            int launches = StaticMethods.getSharedPreferences().getInt("ADMS_Launches", 0) + 1;
            cdata.put("a.Launches", Integer.toString(launches));
            editor.putInt("ADMS_Launches", launches);
            editor.putLong("ADMS_LastDateUsed", date);
            editor.commit();
        }
        catch (StaticMethods.NullContextException e) {
            StaticMethods.logErrorFormat("Lifecycle - Error adding generic data (%s).", e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addNonInstallData(Map<String, Object> cdata, long date) {
        block11: {
            try {
                SimpleDateFormat dailyFormatter = new SimpleDateFormat("yyyy/M/d", Locale.US);
                long lastUseMillis = StaticMethods.getSharedPreferences().getLong("ADMS_LastDateUsed", 0L);
                String lastUsedDateDaily = dailyFormatter.format(new Date(lastUseMillis));
                String currentDateDaily = dailyFormatter.format(date);
                if (!currentDateDaily.equalsIgnoreCase(lastUsedDateDaily)) {
                    cdata.put("a.DailyEngUserEvent", "DailyEngUserEvent");
                }
                SimpleDateFormat monthlyFormatter = new SimpleDateFormat("yyyy/M", Locale.US);
                String lastUsedDateMonthly = monthlyFormatter.format(new Date(lastUseMillis));
                String currentDateMonthly = monthlyFormatter.format(date);
                if (!currentDateMonthly.equalsIgnoreCase(lastUsedDateMonthly)) {
                    cdata.put("a.MonthlyEngUserEvent", "MonthlyEngUserEvent");
                }
                long installMillis = StaticMethods.getSharedPreferences().getLong("ADMS_InstallDate", 0L);
                cdata.put("a.DaysSinceFirstUse", Lifecycle.calculateDaysSince(installMillis, date));
                cdata.put("a.DaysSinceLastUse", Lifecycle.calculateDaysSince(lastUseMillis, date));
                if (StaticMethods.getSharedPreferences().getBoolean("ADMS_SuccessfulClose", false)) break block11;
                SharedPreferences.Editor editor = StaticMethods.getSharedPreferencesEditor();
                editor.remove("ADMS_PauseDate");
                editor.remove("ADMS_SessionStart");
                sessionStartTime = StaticMethods.getTimeSince1970();
                editor.commit();
                long lastKnownTimestamp = StaticMethods.getSharedPreferences().getLong("ADBLastKnownTimestampKey", 0L);
                if (lastKnownTimestamp > 0L && MobileConfig.getInstance().mobileUsingAnalytics() && MobileConfig.getInstance().getOfflineTrackingEnabled() && MobileConfig.getInstance().getBackdateSessionInfoEnabled()) {
                    try {
                        SharedPreferences defaults = StaticMethods.getSharedPreferences();
                        HashMap<String, Object> crashCData = new HashMap<String, Object>();
                        crashCData.put("a.CrashEvent", "CrashEvent");
                        crashCData.put("a.OSVersion", defaults.getString("ADOBEMOBILE_STOREDDEFAULTS_OS", ""));
                        crashCData.put("a.AppID", defaults.getString("ADOBEMOBILE_STOREDDEFAULTS_APPID", ""));
                        AnalyticsTrackInternal.trackInternal("Crash", crashCData, lastKnownTimestamp + 1L);
                        Object object = _lifecycleContextDataMutex;
                        synchronized (object) {
                            _lifecycleContextData.put("a.CrashEvent", "CrashEvent");
                        }
                    }
                    catch (StaticMethods.NullContextException ex) {
                        StaticMethods.logWarningFormat("Config - Unable to get crash data for backdated hit (%s)", ex.getLocalizedMessage());
                    }
                } else {
                    cdata.put("a.CrashEvent", "CrashEvent");
                }
                AnalyticsTrackTimedAction.sharedInstance().trackTimedActionUpdateActionsClearAdjustedStartTime();
            }
            catch (StaticMethods.NullContextException e) {
                StaticMethods.logErrorFormat("Lifecycle - Error setting non install data (%s).", e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addSessionLengthData(Map<String, Object> cdata) {
        try {
            long pauseTime = Lifecycle.msToSec(StaticMethods.getSharedPreferences().getLong("ADMS_PauseDate", 0L));
            long sessionTimeout = MobileConfig.getInstance().getLifecycleTimeout();
            long timeSincePause = StaticMethods.getTimeSince1970() - pauseTime;
            if (timeSincePause < sessionTimeout) {
                return;
            }
            long lastSessionStartTime = Lifecycle.msToSec(StaticMethods.getSharedPreferences().getLong("ADMS_SessionStart", 0L));
            long lastSessionTime = pauseTime - lastSessionStartTime;
            sessionStartTime = StaticMethods.getTimeSince1970();
            if (lastSessionTime > 0L && lastSessionTime < 604800L) {
                long lastKnownTimestamp = StaticMethods.getSharedPreferences().getLong("ADBLastKnownTimestampKey", 0L);
                if (lastKnownTimestamp > 0L && MobileConfig.getInstance().mobileUsingAnalytics() && MobileConfig.getInstance().getOfflineTrackingEnabled() && MobileConfig.getInstance().getBackdateSessionInfoEnabled()) {
                    try {
                        SharedPreferences defaults = StaticMethods.getSharedPreferences();
                        HashMap<String, Object> sessionCData = new HashMap<String, Object>();
                        sessionCData.put("a.PrevSessionLength", String.valueOf(lastSessionTime));
                        sessionCData.put("a.OSVersion", defaults.getString("ADOBEMOBILE_STOREDDEFAULTS_OS", ""));
                        sessionCData.put("a.AppID", defaults.getString("ADOBEMOBILE_STOREDDEFAULTS_APPID", ""));
                        AnalyticsTrackInternal.trackInternal("SessionInfo", sessionCData, lastKnownTimestamp + 1L);
                        Object object = _lifecycleContextDataMutex;
                        synchronized (object) {
                            _lifecycleContextData.put("a.PrevSessionLength", String.valueOf(lastSessionTime));
                        }
                    }
                    catch (StaticMethods.NullContextException ex) {
                        StaticMethods.logWarningFormat("Config - Unable to get session data for backdated hit (%s)", ex.getLocalizedMessage());
                    }
                } else {
                    cdata.put("a.PrevSessionLength", Long.toString(lastSessionTime));
                }
            } else {
                cdata.put("a.ignoredSessionLength", Long.toString(lastSessionTime));
            }
            SharedPreferences.Editor editor = StaticMethods.getSharedPreferencesEditor();
            editor.remove("ADMS_SessionStart");
            editor.commit();
        }
        catch (StaticMethods.NullContextException e) {
            StaticMethods.logErrorFormat("Lifecycle - Error adding session length data (%s).", e.getMessage());
        }
    }

    private static String calculateDaysSince(long since, long to) {
        return Integer.toString((int)((to - since) / 86400000L));
    }

    private static void checkForAdobeClickThrough(Activity activity, boolean isNewSession) {
        if (activity == null) {
            return;
        }
        Intent intent = activity.getIntent();
        if (intent == null) {
            return;
        }
        String action = null;
        String pushMessageID = intent.getStringExtra(ADB_LIFECYCLE_PUSH_MESSAGE_ID_KEY);
        String messageID = intent.getStringExtra("adb_m_l_id");
        Uri uri = intent.getData();
        Map<String, Object> deepLinkData = Lifecycle.getAdobeDeepLinkQueryParameters(uri, ADB_DEEPLINK_TYPE_APP_LINK);
        HashMap<String, Object> cData = new HashMap<String, Object>();
        if (!isNewSession && deepLinkData != null) {
            action = ADB_TRACK_INTERNAL_ADOBE_LINK;
            cData.putAll(deepLinkData);
            Lifecycle.updateContextData(cData);
        }
        if (pushMessageID != null && pushMessageID.length() > 0) {
            cData.put("a.push.payloadId", pushMessageID);
            action = ADB_TRACK_INTERNAL_PUSH_CLICK_THROUGH;
            Lifecycle.updateContextData(cData);
        } else if (messageID != null && messageID.length() > 0) {
            cData.put("a.message.id", messageID);
            cData.put("a.message.clicked", 1);
            action = "In-App Message";
            Lifecycle.updateContextData(cData);
        }
        if (action != null && MobileConfig.getInstance().mobileUsingAnalytics()) {
            AnalyticsTrackInternal.trackInternal(action, cData, StaticMethods.getTimeSince1970());
        }
    }

    private static Map<String, Object> checkForAdobeLinkData(Activity activity, String type) {
        if (activity == null) {
            return null;
        }
        Intent intent = activity.getIntent();
        if (intent == null) {
            return null;
        }
        Uri uri = intent.getData();
        if (uri == null) {
            return null;
        }
        Map<String, Object> queryParameters = Lifecycle.getAdobeDeepLinkQueryParameters(uri, type);
        Lifecycle.clearTargetPreviewTokenInIntent(intent, queryParameters);
        return queryParameters;
    }

    private static void clearTargetPreviewTokenInIntent(Intent intent, Map<String, Object> queryParameters) {
        try {
            Uri uri = intent.getData();
            if (uri == null) {
                return;
            }
            if (queryParameters == null || queryParameters.isEmpty()) {
                return;
            }
            if (queryParameters.containsKey("at_preview_token")) {
                Uri.Builder builder = uri.buildUpon().encodedQuery("");
                intent.setData(builder.build());
            }
        }
        catch (Exception e) {
            StaticMethods.logErrorFormat("Lifecycle - Exception while attempting to remove target token parameters from Uri (%s).", e.getMessage());
        }
    }

    private static Map<String, Object> getAdobeDeepLinkQueryParameters(Uri uri, String type) {
        String[] paramArray;
        if (uri == null) {
            return null;
        }
        String query = uri.getEncodedQuery();
        String queryKey = "a.deeplink.id";
        if (type.equals(ADB_DEEPLINK_TYPE_TARGET_PREVIEW_LINK)) {
            queryKey = "at_preview_token";
        }
        if (query == null || query.length() <= 0 || !query.contains(queryKey + "=")) {
            return null;
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (String currentParam : paramArray = query.split("&")) {
            String newKey;
            String value;
            String key;
            if (currentParam == null || currentParam.length() <= 0) continue;
            String[] currentParamArray = currentParam.split("=", 2);
            if (currentParamArray.length == 1 || currentParamArray.length == 2 && currentParamArray[1].isEmpty()) {
                StaticMethods.logWarningFormat("Deep Link - Skipping an invalid variable on the URI query (%s).", currentParamArray[0]);
                continue;
            }
            try {
                key = URLDecoder.decode(currentParamArray[0], "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                key = currentParamArray[0];
            }
            try {
                value = URLDecoder.decode(currentParamArray[1], "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                value = currentParamArray[1];
            }
            if (key.startsWith("ctx")) {
                newKey = key.substring("ctx".length());
                parameters.put(newKey, value);
                continue;
            }
            if (key.startsWith("adb")) {
                newKey = key.substring("adb".length());
                parameters.put("a.acquisition.custom.".concat(newKey), value);
                continue;
            }
            parameters.put(key, value);
        }
        return parameters;
    }

    private static long msToSec(long milliSeconds) {
        return milliSeconds / 1000L;
    }

    private static long secToMs(long seconds) {
        return seconds * 1000L;
    }
}

