/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.mobile;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteStatement;
import android.os.Process;
import com.adobe.mobile.AbstractDatabaseBacking;
import com.adobe.mobile.AbstractHitDatabase;
import com.adobe.mobile.AudienceManagerWorker;
import com.adobe.mobile.MobileConfig;
import com.adobe.mobile.MobilePrivacyStatus;
import com.adobe.mobile.ReferrerHandler;
import com.adobe.mobile.RequestHandler;
import com.adobe.mobile.StaticMethods;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

final class AnalyticsWorker
extends AbstractHitDatabase {
    private static final int TIMESTAMP_DISABLED_WAIT_THRESHOLD = 60;
    private static final int CONNECTION_TIMEOUT_MSEC = 5000;
    protected static final String ANALYTICS_FILENAME = "ADBMobileDataCache.sqlite";
    protected static final String ANALYTICS_DB_CREATE_STATEMENT = "CREATE TABLE IF NOT EXISTS HITS (ID INTEGER PRIMARY KEY AUTOINCREMENT, URL TEXT, TIMESTAMP INTEGER)";
    private static final SecureRandom randomGen = new SecureRandom();
    protected SQLiteStatement _preparedInsertStatement = null;
    private static AnalyticsWorker _instance = null;
    private static final Object _instanceMutex = new Object();
    private static String baseURL;
    private static volatile boolean analyticsGetBaseURL_pred;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AnalyticsWorker sharedInstance() {
        Object object = _instanceMutex;
        synchronized (object) {
            if (_instance == null) {
                _instance = new AnalyticsWorker();
            }
            return _instance;
        }
    }

    protected AnalyticsWorker() {
        this.fileName = ANALYTICS_FILENAME;
        this.logPrefix = "Analytics";
        this.dbCreateStatement = ANALYTICS_DB_CREATE_STATEMENT;
        this.lastHitTimestamp = 0L;
        this.initDatabaseBacking(new File(StaticMethods.getCacheDirectory(), this.fileName));
        this.numberOfUnsentHits = this.getTrackingQueueSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void queue(String url, long timeStamp) {
        MobileConfig mobileConfigInstance = MobileConfig.getInstance();
        if (mobileConfigInstance == null) {
            StaticMethods.logErrorFormat("Analytics - Cannot send hit, MobileConfig is null (this really shouldn't happen)", new Object[0]);
            return;
        }
        if (!MobileConfig.getInstance().mobileUsingAnalytics()) {
            return;
        }
        if (mobileConfigInstance.getPrivacyStatus() == MobilePrivacyStatus.MOBILE_PRIVACY_STATUS_OPT_OUT) {
            StaticMethods.logDebugFormat("Analytics - Ignoring hit due to privacy status being opted out", new Object[0]);
            return;
        }
        if (this.databaseStatus == AbstractDatabaseBacking.DatabaseStatus.FATALERROR) {
            StaticMethods.logErrorFormat("Analytics - Ignoring hit due to database error", new Object[0]);
            return;
        }
        Object object = this.dbMutex;
        synchronized (object) {
            try {
                this._preparedInsertStatement.bindString(1, url);
                this._preparedInsertStatement.bindLong(2, timeStamp);
                this._preparedInsertStatement.execute();
                StaticMethods.updateLastKnownTimestamp(timeStamp);
                ++this.numberOfUnsentHits;
                this._preparedInsertStatement.clearBindings();
            }
            catch (SQLException e) {
                StaticMethods.logErrorFormat("Analytics - Unable to insert url (%s)", url);
                this.resetDatabase((Exception)((Object)e));
            }
            catch (Exception e) {
                StaticMethods.logErrorFormat("Analytics - Unknown error while inserting url (%s)", url);
                this.resetDatabase(e);
            }
        }
        this.kick(false);
    }

    private static String getBaseURL() {
        if (analyticsGetBaseURL_pred) {
            analyticsGetBaseURL_pred = false;
            baseURL = (MobileConfig.getInstance().getSSL() ? "https://" : "http://") + MobileConfig.getInstance().getTrackingServer() + "/b/ss/" + StaticMethods.URLEncode(MobileConfig.getInstance().getReportSuiteIds()) + "/" + MobileConfig.getInstance().getAnalyticsResponseType() + "/JAVA-" + "4.18.0-AN" + "/s";
            StaticMethods.logDebugFormat("Analytics - Setting base request URL(%s)", baseURL);
        }
        return baseURL;
    }

    @Override
    protected void preMigrate() {
        File oldFile = new File(StaticMethods.getCacheDirectory() + this.fileName);
        File newFile = new File(StaticMethods.getCacheDirectory(), this.fileName);
        if (oldFile.exists() && !newFile.exists()) {
            try {
                if (!oldFile.renameTo(newFile)) {
                    StaticMethods.logWarningFormat("Analytics - Unable to migrate old hits db, creating new hits db (move file returned false)", new Object[0]);
                }
            }
            catch (Exception e) {
                StaticMethods.logWarningFormat("Analytics - Unable to migrate old hits db, creating new hits db (%s)", e.getLocalizedMessage());
            }
        }
    }

    @Override
    protected void prepareStatements() {
        try {
            this._preparedInsertStatement = this.database.compileStatement("INSERT INTO HITS (URL, TIMESTAMP) VALUES (?, ?)");
        }
        catch (NullPointerException x) {
            StaticMethods.logErrorFormat("Analytics - Unable to create database due to an invalid path (%s)", x.getLocalizedMessage());
        }
        catch (SQLException x) {
            StaticMethods.logErrorFormat("Analytics - Unable to create database due to a sql error (%s)", x.getLocalizedMessage());
        }
        catch (Exception x) {
            StaticMethods.logErrorFormat("Analytics - Unable to create database due to an unexpected error (%s)", x.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected AbstractHitDatabase.Hit selectOldestHit() {
        AbstractHitDatabase.Hit hit = null;
        Object object = this.dbMutex;
        synchronized (object) {
            Cursor cursor = null;
            try {
                cursor = this.database.query("HITS", new String[]{"ID", "URL", "TIMESTAMP"}, null, null, null, null, "ID ASC", "1");
                if (cursor.moveToFirst()) {
                    hit = new AbstractHitDatabase.Hit();
                    hit.identifier = cursor.getString(0);
                    hit.urlFragment = cursor.getString(1);
                    hit.timestamp = cursor.getLong(2);
                }
            }
            catch (SQLException e) {
                StaticMethods.logErrorFormat("Analytics - Unable to read from database (%s)", e.getMessage());
            }
            catch (Exception e) {
                StaticMethods.logErrorFormat("Analytics - Unknown error reading from database (%s)", e.getMessage());
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
        return hit;
    }

    @Override
    protected final Runnable workerThread() {
        return new Runnable(){

            @Override
            public void run() {
                AbstractHitDatabase.Hit hit;
                AnalyticsWorker worker = AnalyticsWorker.sharedInstance();
                Process.setThreadPriority((int)10);
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("Accept-Language", StaticMethods.getDefaultAcceptLanguage());
                headers.put("User-Agent", StaticMethods.getDefaultUserAgent());
                while (MobileConfig.getInstance().getPrivacyStatus() == MobilePrivacyStatus.MOBILE_PRIVACY_STATUS_OPT_IN && (!MobileConfig.getInstance().reachabilityChecksEnabled() || MobileConfig.getInstance().networkConnectivity()) && worker.databaseStatus == AbstractDatabaseBacking.DatabaseStatus.OK && (hit = worker.selectOldestHit()) != null) {
                    if (MobileConfig.getInstance().getOfflineTrackingEnabled()) {
                        long delta = hit.timestamp - worker.lastHitTimestamp;
                        if (delta < 0L) {
                            long newTimestamp = worker.lastHitTimestamp + 1L;
                            String oldTSString = "&ts=" + Long.toString(hit.timestamp);
                            String newTSString = "&ts=" + Long.toString(newTimestamp);
                            hit.urlFragment = hit.urlFragment.replaceFirst(oldTSString, newTSString);
                            StaticMethods.logDebugFormat("Analytics - Adjusting out of order hit timestamp(%d->%d)", hit.timestamp, newTimestamp);
                            hit.timestamp = newTimestamp;
                        }
                    } else if (hit.timestamp < StaticMethods.getTimeSince1970() - 60L) {
                        try {
                            worker.deleteHit(hit.identifier);
                            continue;
                        }
                        catch (AbstractDatabaseBacking.CorruptedDatabaseException ex) {
                            AnalyticsWorker.sharedInstance().resetDatabase(ex);
                            break;
                        }
                    }
                    String postBody = hit.urlFragment.startsWith("ndh") ? hit.urlFragment : hit.urlFragment.substring(hit.urlFragment.indexOf(63) + 1);
                    byte[] response = RequestHandler.retrieveAnalyticsRequestData(AnalyticsWorker.getBaseURL() + randomGen.nextInt(100000000), postBody, headers, 5000, AnalyticsWorker.this.logPrefix);
                    if (response != null) {
                        if (response.length > 1) {
                            try {
                                worker.deleteHit(hit.identifier);
                                worker.lastHitTimestamp = hit.timestamp;
                                String responseString = new String(response, "UTF-8");
                                final JSONObject jsonResponse = new JSONObject(responseString);
                                StaticMethods.getAudienceExecutor().execute(new Runnable(){

                                    @Override
                                    public void run() {
                                        AudienceManagerWorker.processJsonResponse(jsonResponse);
                                    }
                                });
                                continue;
                            }
                            catch (AbstractDatabaseBacking.CorruptedDatabaseException ex) {
                                AnalyticsWorker.sharedInstance().resetDatabase(ex);
                                break;
                            }
                            catch (UnsupportedEncodingException e) {
                                StaticMethods.logWarningFormat("Audience Manager - Unable to decode server response (%s)", e.getLocalizedMessage());
                                continue;
                            }
                            catch (JSONException e) {
                                StaticMethods.logWarningFormat("Audience Manager - Unable to parse JSON data (%s)", e.getLocalizedMessage());
                                continue;
                            }
                        }
                        try {
                            worker.deleteHit(hit.identifier);
                            worker.lastHitTimestamp = hit.timestamp;
                            continue;
                        }
                        catch (AbstractDatabaseBacking.CorruptedDatabaseException ex) {
                            AnalyticsWorker.sharedInstance().resetDatabase(ex);
                            break;
                        }
                    }
                    long delay = 30L;
                    try {
                        int i = 0;
                        while ((long)i < delay && (!MobileConfig.getInstance().reachabilityChecksEnabled() || MobileConfig.getInstance().networkConnectivity())) {
                            Thread.sleep(1000L);
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        StaticMethods.logWarningFormat("Analytics - Background Thread Interrupted(%s)", e.getMessage());
                    }
                }
                worker.bgThreadActive = false;
            }
        };
    }

    protected void kickWithReferrerData(Map<String, Object> referrerData) {
        if (referrerData == null || referrerData.size() <= 0) {
            ReferrerHandler.setReferrerProcessed(true);
            this.kick(false);
            return;
        }
        AbstractHitDatabase.Hit hit = this.selectOldestHit();
        if (hit != null && hit.urlFragment != null) {
            hit.urlFragment = StaticMethods.appendContextData(referrerData, hit.urlFragment);
            this.updateHitInDatabase(hit);
            ReferrerHandler.setReferrerProcessed(true);
        }
        this.kick(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateHitInDatabase(AbstractHitDatabase.Hit hit) {
        Object object = this.dbMutex;
        synchronized (object) {
            try {
                ContentValues updatedURLFragment = new ContentValues();
                updatedURLFragment.put("URL", hit.urlFragment);
                this.database.update("HITS", updatedURLFragment, "id=" + hit.identifier, null);
            }
            catch (SQLException e) {
                StaticMethods.logErrorFormat("Analytics - Unable to update url in database (%s)", e.getMessage());
            }
            catch (Exception e) {
                StaticMethods.logErrorFormat("Analytics - Unknown error updating url in database (%s)", e.getMessage());
            }
        }
    }

    static {
        analyticsGetBaseURL_pred = true;
    }
}

