/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.tracker;

import android.content.Context;
import android.os.Build;
import android.webkit.URLUtil;
import com.akamai.amp.tracker.AkamaiEvent;
import com.akamai.amp.tracker.AkamaiMetaData;
import com.akamai.amp.tracker.DoGetTask;
import com.akamai.amp.tracker.OnTaskCompleted;
import com.akamai.amp.utils.Utils;

public class AMPTracker
implements OnTaskCompleted {
    private static final String AMP_ENDPOINT = "https://amp.akamaized.net/amp.gif?";
    private AkamaiMetaData metaData;

    public AMPTracker(Context c) {
        String os = "Android";
        String osVersion = Build.VERSION.RELEASE;
        String platform = Utils.getPlatform(c);
        AkamaiEvent eventType = AkamaiEvent.CREATE;
        this.metaData = new AkamaiMetaData(os, osVersion, platform, eventType);
    }

    public void trackEvent(AkamaiEvent event) {
        this.metaData.setEvent(event);
        this.sendBeacon();
    }

    public void setLicenseData(String license, String packageName, long daysUntilExpiration) {
        this.metaData.setLicenseData(license, packageName, daysUntilExpiration);
    }

    private void sendBeacon() {
        String stringURL = AMP_ENDPOINT + this.metaData.toQueryString();
        if (URLUtil.isValidUrl((String)stringURL)) {
            new DoGetTask(this).execute(new String[]{stringURL, this.metaData.getEventType()});
        }
    }

    @Override
    public void onTaskCompleted(Integer taskResult) {
    }
}

