/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.media;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.content.ReceiverCallNotAllowedException;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.Nullable;
import com.akamai.amp.config.AMPConfig;
import com.akamai.amp.config.AMPConfigLoader;
import com.akamai.amp.config.Config;
import com.akamai.amp.exoplayer2.DefaultLoadControl;
import com.akamai.amp.exoplayer2.Player;
import com.akamai.amp.exoplayer2.ampcustom.AMPPreSettings;
import com.akamai.amp.exoplayer2.util.EventLogger;
import com.akamai.amp.license.manager.AMPLicenseManager;
import com.akamai.amp.license.manager.RSALicenseDecryption;
import com.akamai.amp.mae.LmsManager;
import com.akamai.amp.media.IPlayerEventsListener;
import com.akamai.amp.media.Listeners;
import com.akamai.amp.media.VideoPlayerView;
import com.akamai.amp.media.VideoPlayerViewExo;
import com.akamai.amp.media.elements.AMPFeedLoader;
import com.akamai.amp.media.elements.Media;
import com.akamai.amp.media.elements.MediaResource;
import com.akamai.amp.media.elements.loaders.PMDFactoryLoader;
import com.akamai.amp.media.errors.ErrorType;
import com.akamai.amp.media.errors.IErrorBeacon;
import com.akamai.amp.media.exowrapper2.drm.DrmScheme;
import com.akamai.amp.media.hls.httpdownloaders.HttpDownloader;
import com.akamai.amp.media.networking.IConnectionSwitchCallback;
import com.akamai.amp.media.networking.NetworkSwitchingBroadcastReceiver;
import com.akamai.amp.poster.Poster;
import com.akamai.amp.utils.AbortListener;
import com.akamai.amp.utils.LogManager;
import com.akamai.amp.utils.MediaResourceUtils;
import com.akamai.amp.utils.Utils;
import com.akamai.amp.utils.autorecovery.StreamAutorecovery;
import java.util.Map;

public class VideoPlayerContainer
extends FrameLayout {
    private static final String TAG = "VideoPlayerContainer";
    public static final int MODE_EXO = 5;
    public static boolean isAppInBackground = false;
    private VideoPlayerView mVideoPlayerView = null;
    private MediaResource mediaResource;
    private AMPConfigLoader ampConfigLoader;
    private boolean isRemoteConfigAvailable = false;
    private Poster poster = null;
    private String posterURL = "";
    private static String latestPoster;
    private boolean abort;
    private Listeners<VideoPlayerContainerCallback> mCallbacks = new Listeners();
    private boolean retryOnConnectionChangesOnly;
    private boolean gotDisconnected;
    private int maxConnectionAttempts;
    private int attemptsRateInSeconds;
    private int attemptsRemaining = this.maxConnectionAttempts;
    protected boolean CMCDEnabled;
    protected RSALicenseDecryption mRSALicenseDecryptor;
    protected Player.EventListener exoEventsListener;
    private IConnectionSwitchCallback connCallback;
    private NetworkSwitchingBroadcastReceiver networkSwitchReceiver;
    private boolean isNetworkSwitchReceiverRegistered = false;
    private final AbortListener abortListener = new AbortListener(){

        @Override
        public void abortActionCompleted() {
            VideoPlayerContainer.this.abort = false;
            VideoPlayerContainer.this.resetVideoPlayerView();
        }
    };
    private final IErrorBeacon iErrorBeacon = new IErrorBeacon(){

        @Override
        public void onErrorTriggered() {
        }

        @Override
        public void onPlaybackBackNormal() {
            if (VideoPlayerContainer.this.attemptsRemaining != VideoPlayerContainer.this.maxConnectionAttempts) {
                VideoPlayerContainer.this.attemptsRemaining = VideoPlayerContainer.this.maxConnectionAttempts;
            }
        }
    };
    private final IConnectionSwitchCallback iConnectionSwitchCallback = new IConnectionSwitchCallback(){

        @Override
        public void onConnect() {
            LogManager.log(VideoPlayerContainer.TAG, "Internet: IConnectionSwitchCallback.onConnect()");
            VideoPlayerContainer.this.gotDisconnected = false;
            VideoPlayerContainer.this.doAutoRecovery();
        }

        @Override
        public void onDisconnect() {
            LogManager.log(VideoPlayerContainer.TAG, "Internet: IConnectionSwitchCallback.onDisconnect()");
            VideoPlayerContainer.this.gotDisconnected = true;
        }
    };
    private final AMPFeedLoader.AMPFeedLoaderListener ampFeedLoaderListener = new AMPFeedLoader.AMPFeedLoaderListener(){

        @Override
        public void feedLoaded(MediaResource resource) {
            if (resource == null) {
                VideoPlayerContainer.this.mediaResource = null;
                return;
            }
            VideoPlayerContainer.this.mediaResource = resource;
            if (VideoPlayerContainer.this.mediaResource.getUrl() != null) {
                VideoPlayerContainer.this.prepareResource(VideoPlayerContainer.this.mediaResource.getUrl());
            }
        }
    };
    private final IPlayerEventsListener iPlayerEventsListener = new IPlayerEventsListener(){

        @Override
        public boolean onPlayerEvent(int eventId) {
            if (eventId == 3) {
                VideoPlayerContainer.this.checkRemovePoster();
            } else if (eventId == 23) {
                VideoPlayerContainer.this.unregisterNetworkSwitchReceiver();
                if (VideoPlayerContainer.this.mVideoPlayerView != null) {
                    VideoPlayerContainer.this.mVideoPlayerView.removeEventsListener(this);
                }
            }
            return true;
        }

        @Override
        public boolean onPlayerExtendedEvent(int iInEventType, int arg1, int arg2) {
            return false;
        }
    };

    public void onFinishInflate() {
        super.onFinishInflate();
        Log.i((String)"AMP SDK", (String)"Akamai AMP SDK Android v9.10.6 is starting, using Exo v2.12.3");
        Log.i((String)"AMP SDK", (String)("App name: " + Utils.getApplicationName(this.getContext())));
        Log.i((String)"AMP SDK", (String)("App version: " + Utils.getApplicationVersion(this.getContext())));
        Log.i((String)"AMP SDK", (String)"Device:");
        Log.i((String)"AMP SDK", (String)Utils.getDeviceInfo());
    }

    public VideoPlayerContainer(Context context) {
        super(context);
        this.init(context);
    }

    public VideoPlayerContainer(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public AbortListener getAbortListener() {
        return this.abortListener;
    }

    public void setConfig(String jsonConfigData) {
        this.isRemoteConfigAvailable = true;
        Config.getConfig().configURL = jsonConfigData;
    }

    public void setConfigData(String configJsonData) {
        Config.getConfig().isLocalJson = true;
        Config.getConfig().configJsonData = configJsonData;
    }

    public void setConfig(AMPConfig ampConfig) {
        ampConfig.assignConfigToPlayer();
        Config.getConfig().isRemoteConfig = false;
    }

    public Config getConfig() {
        return Config.getConfig();
    }

    public void abortPlayback(boolean abort) {
        this.abort = abort;
        if (this.mVideoPlayerView != null) {
            this.queueAbortRequest();
        }
    }

    public VideoPlayerView getVideoPlayer() {
        if (this.mVideoPlayerView == null) {
            String errorMessage = "The call to getVideoPlayer() should be done after VideoPlayerContainerCallback().onVideoPlayerCreated() has being fired, not before";
            LogManager.error(TAG, errorMessage);
        }
        return this.mVideoPlayerView;
    }

    public boolean isVideoPlayerViewAvailable() {
        return this.mVideoPlayerView != null;
    }

    public VideoPlayerView getAudioPlayer() {
        return this.mVideoPlayerView;
    }

    public boolean isPmd() {
        if (this.mediaResource != null) {
            boolean result = PMDFactoryLoader.canHandle(this.mediaResource);
            return result;
        }
        return false;
    }

    public void setDRMSecurityLevel(String securityLevel) {
        AMPPreSettings.getPreSettingsInstance().setSecurityLevel(securityLevel);
    }

    public void setRequestHeaders(Map<String, String> headers) {
        AMPPreSettings.getPreSettingsInstance().setHttpHeaders(headers);
    }

    public void setDrmLicenseRequestHeaders(Map<String, String> headers) {
        AMPPreSettings.getPreSettingsInstance().setDrmLicenseRequestHeaders(headers);
    }

    public void setUserAgent(String userAgent) {
        AMPPreSettings.getPreSettingsInstance().setUserAgent(userAgent);
    }

    public void allowChunklessPreparation(boolean allowChunklessPreparation) {
        AMPPreSettings.getPreSettingsInstance().setAllowChunklessPreparation(allowChunklessPreparation);
    }

    public DefaultLoadControl setBufferDimensions(int minBufferMs, int maxBufferMs, int bufferForPlaybackMs, int bufferForPlaybackAfterRebufferMs) {
        DefaultLoadControl.Builder defaultControlBuilder = new DefaultLoadControl.Builder();
        defaultControlBuilder.setBufferDurationsMs(minBufferMs, maxBufferMs, bufferForPlaybackMs, bufferForPlaybackAfterRebufferMs);
        DefaultLoadControl defaultLoadControl = defaultControlBuilder.createDefaultLoadControl();
        AMPPreSettings.getPreSettingsInstance().setDefaultLoadControl(defaultLoadControl);
        return defaultLoadControl;
    }

    public DefaultLoadControl setBufferDimensions(int minBufferMs, int targetBufferBytes, int maxBufferMs, int bufferForPlaybackMs, int bufferForPlaybackAfterRebufferMs) {
        DefaultLoadControl.Builder defaultControlBuilder = new DefaultLoadControl.Builder();
        defaultControlBuilder.setBufferDurationsMs(minBufferMs, maxBufferMs, bufferForPlaybackMs, bufferForPlaybackAfterRebufferMs);
        defaultControlBuilder.setTargetBufferBytes(targetBufferBytes);
        DefaultLoadControl defaultLoadControl = defaultControlBuilder.createDefaultLoadControl();
        AMPPreSettings.getPreSettingsInstance().setDefaultLoadControl(defaultLoadControl);
        return defaultLoadControl;
    }

    public void setDefaultLoadControl(DefaultLoadControl defaultLoadControl) {
        AMPPreSettings.getPreSettingsInstance().setDefaultLoadControl(defaultLoadControl);
    }

    public DefaultLoadControl getDefaultLoadControl() {
        return AMPPreSettings.getPreSettingsInstance().getDefaultLoadControl();
    }

    public void turnOnLowLatency(boolean allowSeekJumps, int targetBufferMs, int maxBufferMs) {
        AMPPreSettings.getPreSettingsInstance().turnOnLowLatency(allowSeekJumps);
        AMPPreSettings.getPreSettingsInstance().getLowLatencySettings().setTargetLowLatencyBuffer(targetBufferMs);
        AMPPreSettings.getPreSettingsInstance().getLowLatencySettings().setMaxLowLatencyBuffer(maxBufferMs);
        this.setBufferDimensions(targetBufferMs, maxBufferMs, targetBufferMs, targetBufferMs / 2);
    }

    public void turnOnLowLatency(boolean allowSeekJumps) {
        this.turnOnLowLatency(allowSeekJumps, 3000, 10000);
    }

    public void setExoEventsListener(Player.EventListener exoEventsListener) {
        this.exoEventsListener = exoEventsListener;
    }

    public void onDestroy() {
        isAppInBackground = false;
        if (this.mVideoPlayerView == null) {
            return;
        }
        this.mVideoPlayerView.onDestroy();
    }

    public void onPause() {
        isAppInBackground = true;
        if (this.mVideoPlayerView != null) {
            this.mVideoPlayerView.onPause();
        }
    }

    public void onResume() {
        isAppInBackground = false;
        if (this.mVideoPlayerView != null) {
            this.mVideoPlayerView.onResume();
        }
    }

    public void doAutoRecovery() {
        boolean isReady;
        if (this.mVideoPlayerView == null) {
            return;
        }
        VideoPlayerViewExo exo = (VideoPlayerViewExo)this.mVideoPlayerView;
        int playbackState = exo.getPlaybackState();
        boolean bl = isReady = playbackState == 3;
        if (isReady) {
            Log.e((String)TAG, (String)("ExoState: " + EventLogger.getStateString(playbackState) + ", letting Exo continue"));
        } else {
            Log.e((String)TAG, (String)("ExoState: " + EventLogger.getStateString(playbackState) + ", re-initializing Exo"));
            exo.preparePlayback();
        }
    }

    public void enableStreamAutoRecovery(String poster, long intervalMillis) {
        StreamAutorecovery streamAutorecovery = new StreamAutorecovery(this, poster, intervalMillis);
    }

    public void enableAutoRecovery(int maxConnectionAttempts, int attemptsRateInSeconds) {
        LogManager.log(TAG, "Enabled internet autorecovery, maxConnectionAttempts: " + maxConnectionAttempts + ", attemptsRateInSeconds" + attemptsRateInSeconds);
        this.maxConnectionAttempts = maxConnectionAttempts;
        this.attemptsRateInSeconds = attemptsRateInSeconds;
        this.retryOnConnectionChangesOnly = false;
        this.registerNetworkSwitchReceiver();
    }

    public void enableAutoRecovery() {
        LogManager.log(TAG, "Enabled internet autorecovery");
        this.retryOnConnectionChangesOnly = true;
        this.registerNetworkSwitchReceiver();
    }

    public void enableAutoRecovery(IConnectionSwitchCallback callback) {
        LogManager.log(TAG, "Enabled internet autorecovery with callback " + callback);
        this.registerNetworkSwitchReceiver(callback);
    }

    public void unregisterNetworkSwitchReceiver() {
        try {
            boolean doUnregister;
            Context c = this.getContext().getApplicationContext();
            boolean bl = doUnregister = this.isNetworkSwitchReceiverRegistered && this.networkSwitchReceiver != null && c != null;
            if (doUnregister) {
                c.unregisterReceiver((BroadcastReceiver)this.networkSwitchReceiver);
                this.isNetworkSwitchReceiverRegistered = false;
            }
        }
        catch (IllegalArgumentException x) {
            LogManager.error(TAG, "unregisterNetworkSwitchReceiver() " + x);
        }
        finally {
            this.networkSwitchReceiver = null;
        }
    }

    public void enableAutoRecoveryIfPreviouslyRegistered() {
        this.enableAutoRecoveryIfPreviouslyRegistered(this.connCallback);
    }

    public void enableAutoRecoveryIfPreviouslyRegistered(IConnectionSwitchCallback callback) {
        if (this.connCallback != null && this.connCallback == callback) {
            this.enableAutoRecovery(callback);
        }
    }

    public void addVideoPlayerContainerCallback(VideoPlayerContainerCallback callback) {
        if (callback == null) {
            LogManager.error(TAG, "VideoPlayerContainerCallback Error: callback cannot be null");
        } else {
            boolean isAlreadyContained = this.mCallbacks.contains(callback);
            if (isAlreadyContained) {
                LogManager.error(TAG, "VideoPlayerContainerCallback Error: callback was already added " + callback);
            } else {
                this.mCallbacks.add(callback);
                LogManager.log(TAG, "VideoPlayerContainerCallback added: " + callback);
            }
        }
    }

    public void removeVideoPlayerContainerCallback(VideoPlayerContainerCallback callback) {
        this.mCallbacks.remove(callback);
    }

    public void setFeedURL(String feedURL) {
        AMPFeedLoader feedLoader = new AMPFeedLoader(this.ampFeedLoaderListener);
        feedLoader.execute(new String[]{feedURL});
    }

    public void setMediaFromConfig() {
        this.ampConfigLoader = new AMPConfigLoader(new AMPConfigLoader.ConfigLoaderListener(){

            @Override
            public void configLoaded() {
                VideoPlayerContainer.this.setMedia(Config.getConfig().media);
            }
        });
        if (this.isRemoteConfigAvailable) {
            this.ampConfigLoader.loadConfig(Config.getConfig().configURL, true);
        } else if (Config.getConfig().isLocalJson) {
            this.ampConfigLoader.loadConfig(Config.getConfig().configJsonData, false);
        } else {
            this.ampConfigLoader = null;
            this.setMedia(Config.getConfig().media);
        }
    }

    public void setFeedDataFromConfig() {
        this.ampConfigLoader = new AMPConfigLoader(new AMPConfigLoader.ConfigLoaderListener(){

            @Override
            public void configLoaded() {
                VideoPlayerContainer.this.setFeedData(Config.getConfig().feedData);
            }
        });
        if (this.isRemoteConfigAvailable) {
            this.ampConfigLoader.loadConfig(Config.getConfig().configURL, true);
        } else if (Config.getConfig().isLocalJson) {
            this.ampConfigLoader.loadConfig(Config.getConfig().configJsonData, false);
        } else {
            this.ampConfigLoader = null;
            this.setFeedData(Config.getConfig().feedData);
        }
    }

    public void setFeedURLFromConfig() {
        this.ampConfigLoader = new AMPConfigLoader(new AMPConfigLoader.ConfigLoaderListener(){

            @Override
            public void configLoaded() {
                VideoPlayerContainer.this.setFeedURL(Config.getConfig().feedURL);
            }
        });
        if (this.isRemoteConfigAvailable) {
            this.ampConfigLoader.loadConfig(Config.getConfig().configURL, true);
        } else if (Config.getConfig().isLocalJson) {
            this.ampConfigLoader.loadConfig(Config.getConfig().configJsonData, false);
        } else {
            this.ampConfigLoader = null;
            this.setFeedURL(Config.getConfig().feedURL);
        }
    }

    public void setFeedData(String rawFeed) {
        this.mediaResource = MediaResourceUtils.createMediaResourceFromRawFeed(rawFeed);
        if (this.mediaResource.getUrl() != null) {
            this.prepareResource(this.mediaResource.getUrl());
        } else {
            Log.e((String)TAG, (String)"There are no valid sources to load");
            this.onResourceError(ErrorType.VIDEO_PLAYER_CONTAINER_ERROR);
        }
    }

    public void setMedia(Media media) {
        if (media == null) {
            Log.e((String)TAG, (String)"Invalid Media provided");
            this.onResourceError(ErrorType.VIDEO_PLAYER_CONTAINER_ERROR);
        } else {
            this.mediaResource = MediaResourceUtils.createMediaResourceFromMediaObject(media);
        }
        if (this.mediaResource.getUrl() != null) {
            this.prepareResource(this.mediaResource.getUrl());
        } else {
            Log.e((String)TAG, (String)"There are no valid sources to load");
            this.onResourceError(ErrorType.VIDEO_PLAYER_CONTAINER_ERROR);
        }
    }

    public void setMediaData(String mediaData) {
        if (mediaData == null || mediaData.isEmpty()) {
            Log.e((String)TAG, (String)"Invalid Media provided");
            this.onResourceError(ErrorType.VIDEO_PLAYER_CONTAINER_ERROR);
        } else {
            this.mediaResource = MediaResourceUtils.createMediaResourceFromRawMedia(mediaData);
        }
        if (this.mediaResource.getUrl() != null) {
            this.prepareResource(this.mediaResource.getUrl());
        } else {
            Log.e((String)TAG, (String)"There are no valid sources to load");
            this.onResourceError(ErrorType.VIDEO_PLAYER_CONTAINER_ERROR);
        }
    }

    public void prepareResource(String url) {
        this.resetVideoPlayerView();
        if (this.mediaResource == null) {
            this.mediaResource = MediaResourceUtils.createMediaResourceFromURL(url);
        }
        this.setupPlayback(null);
    }

    public void prepareResource(String mediaAssetUrl, DrmScheme drmScheme, @Nullable String drmLicenseUrl) {
        if (this.mediaResource == null) {
            this.mediaResource = MediaResourceUtils.createMediaResourceFromURL(mediaAssetUrl, drmScheme, drmLicenseUrl);
        }
        this.setupPlayback(null);
    }

    public void prepareResource(String mediaAssetUrl, String extension, DrmScheme drmScheme, String drmLicenseUrl) {
        if (this.mediaResource == null) {
            this.mediaResource = MediaResourceUtils.createMediaResourceFromURL(mediaAssetUrl, extension, drmScheme, drmLicenseUrl);
        }
        this.setupPlayback(null);
    }

    private void setupPlayback(String MIMEType) {
        if (AMPLicenseManager.getInstance().isLicenseAllowingPlaybackUponFail()) {
            AMPLicenseManager.getInstance().allowLicenseRecheck();
            this.setApiKey(AMPLicenseManager.getInstance().getApiKey());
        }
        this.validateLms();
        this.ampConfigLoader = new AMPConfigLoader(() -> this.startMediaFactory(MIMEType));
        if (this.isRemoteConfigAvailable && !Config.getConfig().configLoaded) {
            this.ampConfigLoader.loadConfig(Config.getConfig().configURL, true);
        } else if (Config.getConfig().isLocalJson && !Config.getConfig().configLoaded) {
            this.ampConfigLoader.loadConfig(Config.getConfig().configJsonData, false);
        } else {
            this.ampConfigLoader = null;
            this.startMediaFactory(MIMEType);
        }
    }

    public void prepareResource(String streamUrl, String MIMEType) {
        if (this.mediaResource == null) {
            this.mediaResource = MediaResourceUtils.createMediaResourceFromURL(streamUrl);
        }
        this.setupPlayback(MIMEType);
    }

    public void prepareResourceWithExtension(String streamUrl, String extension) {
        if (this.mediaResource == null) {
            this.mediaResource = MediaResourceUtils.createMediaResourceFromURL(streamUrl, extension);
        }
        this.setupPlayback(null);
    }

    public void loadPoster(String url) {
        if (this.mediaResource == null) {
            this.doPosterLoad(url);
        } else {
            this.mediaResource.setPoster(url);
        }
    }

    public Poster getPoster() {
        return this.poster;
    }

    public void removePoster() {
        if (this.poster != null && this.poster.getParent() == this) {
            this.removeView((View)this.poster);
            this.poster = null;
        }
    }

    public void loadLatestPoster() {
        if (latestPoster == null) {
            return;
        }
        this.doPosterLoad(latestPoster);
    }

    public void enableMulticast(boolean debug, @Nullable String config) {
        LmsManager.getManager().enableMulticast(this.getContext(), debug, config);
    }

    public boolean isMulticastEnabled() {
        return LmsManager.getManager().isMulticastEnabled();
    }

    public void disableMulticast() {
        LmsManager.getManager().disableMulticast();
    }

    public static void releaseMultiCast() {
        LmsManager.getManager().releaseMulticast();
    }

    public void enableCMCD() {
        this.CMCDEnabled = true;
    }

    public void disableCMCD() {
        this.CMCDEnabled = false;
    }

    public boolean isCMCDEnabled() {
        return this.CMCDEnabled;
    }

    public void setApiKey(String apiKey) {
        AMPLicenseManager.setApiKey(apiKey);
    }

    private void onResourceReady(MediaResource resource) {
        for (VideoPlayerContainerCallback callback : this.mCallbacks) {
            if (callback == null) continue;
            callback.onResourceReady(resource);
        }
    }

    private void onVideoPlayerCreated() {
        for (VideoPlayerContainerCallback callback : this.mCallbacks) {
            if (callback == null) continue;
            callback.onVideoPlayerCreated();
        }
    }

    private void addPoster() {
        String posterUrl = this.mediaResource.getPoster();
        if (posterUrl != null) {
            this.doPosterLoad(posterUrl);
        }
    }

    private void doPosterLoad(String posterUrl) {
        latestPoster = posterUrl;
        this.poster = new Poster(this.getContext());
        this.addView((View)this.poster);
        this.poster.loadPoster(posterUrl);
    }

    private void onResourceError(ErrorType errorType) {
        this.onResourceError(errorType, null);
    }

    protected void onResourceError(ErrorType errorType, Exception exc) {
        for (VideoPlayerContainerCallback callback : this.mCallbacks) {
            if (callback == null) continue;
            callback.onResourceError(errorType, exc);
        }
    }

    private void init(Context context) {
        this.abort = false;
        Config.getConfig().clearConfig();
        AMPPreSettings.getPreSettingsInstance().flush();
        this.mRSALicenseDecryptor = new RSALicenseDecryption(context, this);
    }

    private void registerNetworkSwitchReceiver() {
        this.registerNetworkSwitchReceiver(this.iConnectionSwitchCallback);
    }

    private void registerNetworkSwitchReceiver(IConnectionSwitchCallback callback) {
        this.connCallback = callback;
        if (this.networkSwitchReceiver == null) {
            this.networkSwitchReceiver = new NetworkSwitchingBroadcastReceiver(callback);
            this.isNetworkSwitchReceiverRegistered = this.registerNetworkSwitchReceiver(this.getContext(), this.networkSwitchReceiver);
        } else {
            this.networkSwitchReceiver.setCallback(callback);
        }
    }

    private boolean registerNetworkSwitchReceiver(Context context, NetworkSwitchingBroadcastReceiver networkSwitchingBroadcastReceiver) {
        try {
            if (context == null || networkSwitchingBroadcastReceiver == null) {
                return false;
            }
            IntentFilter intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
            context = context.getApplicationContext();
            context.registerReceiver((BroadcastReceiver)networkSwitchingBroadcastReceiver, intentFilter);
            return true;
        }
        catch (ReceiverCallNotAllowedException e) {
            return false;
        }
    }

    private void selectModeByResource(MediaResource media) {
        if (media == null) {
            Log.e((String)TAG, (String)"selectModeByResource() MediaResource was null");
            return;
        }
        this.createVideoPlayerView();
    }

    private void validateLms() {
        if (LmsManager.getManager().isMulticastEnabled()) {
            this.mediaResource.setResourceURL(LmsManager.getManager().startMulticast(this.mediaResource.getUrl()));
        }
    }

    private void startMediaFactory(String MIMEType) {
        try {
            this.onMediaResourceReady(this.mediaResource);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)(e != null ? e.toString() : "exception null"));
            this.onResourceError(ErrorType.VIDEO_PLAYER_CONTAINER_ERROR, e);
        }
        finally {
            Exception x = HttpDownloader.fetchLatestExceptionAndNullify();
            if (x != null) {
                this.onResourceError(ErrorType.VIDEO_PLAYER_CONTAINER_ERROR, x);
            }
        }
    }

    private void onMediaResourceReady(MediaResource updatedMediaResource) {
        this.mediaResource = updatedMediaResource;
        this.setupJSOBjectsInEvaluator();
        this.selectModeByResource(this.mediaResource);
        if (this.abort) {
            this.queueAbortRequest();
        }
        this.onResourceReady(this.mediaResource);
        this.addPoster();
        if (this.mVideoPlayerView != null) {
            this.mVideoPlayerView.addEventsListener(this.iPlayerEventsListener);
        }
        this.mediaResource = null;
    }

    private void queueAbortRequest() {
        this.mVideoPlayerView.sendAbortRequest(this.abort, this.abortListener);
    }

    private void createVideoPlayerView() {
        if (this.isVideoPlayerViewAvailable()) {
            VideoPlayerView videoPlayerView = this.getVideoPlayer();
            Utils.tryRemoveFromParent((View)videoPlayerView);
        }
        this.assignVideoPlayerViewBasedOnMode();
    }

    private void resetVideoPlayerView() {
        if (this.mVideoPlayerView != null) {
            this.mVideoPlayerView.stop();
            this.removeVideoViews();
            this.mVideoPlayerView = null;
        }
    }

    private void assignVideoPlayerViewBasedOnMode() {
        this.setMode();
        this.requestLayout();
        this.forceLayout();
        this.onVideoPlayerCreated();
    }

    private void setMode() {
        this.setExoBasedDecoding();
    }

    private void removeVideoViews() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            View view = this.getChildAt(i);
            if (!(view instanceof VideoPlayerView)) continue;
            this.removeViewAt(i);
        }
    }

    private void setExoBasedDecoding() {
        this.mVideoPlayerView = new VideoPlayerViewExo(this, this.mRSALicenseDecryptor, this.exoEventsListener);
        this.mVideoPlayerView.setErrorBeacon(this.iErrorBeacon);
        FrameLayout.LayoutParams videoLayoutParams = new FrameLayout.LayoutParams(-1, -1);
        videoLayoutParams.gravity = 17;
        this.addView((View)this.mVideoPlayerView, (ViewGroup.LayoutParams)videoLayoutParams);
        Log.d((String)TAG, (String)"Created player using Exo engine");
    }

    private void checkRemovePoster() {
        if (!this.isVideoPlayerViewAvailable()) {
            return;
        }
        VideoPlayerView videoPlayerView = this.getVideoPlayer();
        boolean isAudioOnly = videoPlayerView.isAudioOnly();
        if (!isAudioOnly) {
            this.removePoster();
        }
    }

    private void setupJSOBjectsInEvaluator() {
        if (Config.getConfig().configLoaded) {
            Config.getConfig().jsEvaluator.createMediaJS(this.mediaResource);
            Config.getConfig().jsEvaluator.createAppJS(this.getContext());
        }
    }

    public static interface VideoPlayerContainerCallback {
        public void onVideoPlayerCreated();

        public void onResourceReady(MediaResource var1);

        public void onResourceError(ErrorType var1, Exception var2);
    }
}

