/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2;

import android.content.Context;
import android.os.Looper;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.akamai.amp.exoplayer2.DefaultLoadControl;
import com.akamai.amp.exoplayer2.ExoPlayerImpl;
import com.akamai.amp.exoplayer2.LoadControl;
import com.akamai.amp.exoplayer2.Player;
import com.akamai.amp.exoplayer2.PlayerMessage;
import com.akamai.amp.exoplayer2.Renderer;
import com.akamai.amp.exoplayer2.SeekParameters;
import com.akamai.amp.exoplayer2.analytics.AnalyticsCollector;
import com.akamai.amp.exoplayer2.source.DefaultMediaSourceFactory;
import com.akamai.amp.exoplayer2.source.MediaSource;
import com.akamai.amp.exoplayer2.source.MediaSourceFactory;
import com.akamai.amp.exoplayer2.source.ShuffleOrder;
import com.akamai.amp.exoplayer2.trackselection.DefaultTrackSelector;
import com.akamai.amp.exoplayer2.trackselection.TrackSelector;
import com.akamai.amp.exoplayer2.upstream.BandwidthMeter;
import com.akamai.amp.exoplayer2.upstream.DefaultBandwidthMeter;
import com.akamai.amp.exoplayer2.util.Assertions;
import com.akamai.amp.exoplayer2.util.Clock;
import com.akamai.amp.exoplayer2.util.Util;
import java.util.List;

public interface ExoPlayer
extends Player {
    public Looper getPlaybackLooper();

    @Deprecated
    public void retry();

    @Deprecated
    public void prepare(MediaSource var1);

    @Deprecated
    public void prepare(MediaSource var1, boolean var2, boolean var3);

    public void setMediaSources(List<MediaSource> var1);

    public void setMediaSources(List<MediaSource> var1, boolean var2);

    public void setMediaSources(List<MediaSource> var1, int var2, long var3);

    public void setMediaSource(MediaSource var1);

    public void setMediaSource(MediaSource var1, long var2);

    public void setMediaSource(MediaSource var1, boolean var2);

    public void addMediaSource(MediaSource var1);

    public void addMediaSource(int var1, MediaSource var2);

    public void addMediaSources(List<MediaSource> var1);

    public void addMediaSources(int var1, List<MediaSource> var2);

    public void setShuffleOrder(ShuffleOrder var1);

    public PlayerMessage createMessage(PlayerMessage.Target var1);

    public void setSeekParameters(@Nullable SeekParameters var1);

    public SeekParameters getSeekParameters();

    public void setForegroundMode(boolean var1);

    public void setPauseAtEndOfMediaItems(boolean var1);

    public boolean getPauseAtEndOfMediaItems();

    public void experimentalSetOffloadSchedulingEnabled(boolean var1);

    public static final class Builder {
        private final Renderer[] renderers;
        private Clock clock;
        private TrackSelector trackSelector;
        private MediaSourceFactory mediaSourceFactory;
        private LoadControl loadControl;
        private BandwidthMeter bandwidthMeter;
        private Looper looper;
        @Nullable
        private AnalyticsCollector analyticsCollector;
        private boolean useLazyPreparation;
        private SeekParameters seekParameters;
        private boolean pauseAtEndOfMediaItems;
        private boolean buildCalled;
        private long releaseTimeoutMs;
        private boolean throwWhenStuckBuffering;

        public Builder(Context context, Renderer ... renderers) {
            this(renderers, new DefaultTrackSelector(context), new DefaultMediaSourceFactory(context), new DefaultLoadControl(), DefaultBandwidthMeter.getSingletonInstance(context));
        }

        public Builder(Renderer[] renderers, TrackSelector trackSelector, MediaSourceFactory mediaSourceFactory, LoadControl loadControl, BandwidthMeter bandwidthMeter) {
            Assertions.checkArgument(renderers.length > 0);
            this.renderers = renderers;
            this.trackSelector = trackSelector;
            this.mediaSourceFactory = mediaSourceFactory;
            this.loadControl = loadControl;
            this.bandwidthMeter = bandwidthMeter;
            this.looper = Util.getCurrentOrMainLooper();
            this.useLazyPreparation = true;
            this.seekParameters = SeekParameters.DEFAULT;
            this.clock = Clock.DEFAULT;
            this.throwWhenStuckBuffering = true;
        }

        public Builder experimentalSetReleaseTimeoutMs(long timeoutMs) {
            this.releaseTimeoutMs = timeoutMs;
            return this;
        }

        public Builder experimentalSetThrowWhenStuckBuffering(boolean throwWhenStuckBuffering) {
            this.throwWhenStuckBuffering = throwWhenStuckBuffering;
            return this;
        }

        public Builder setTrackSelector(TrackSelector trackSelector) {
            Assertions.checkState(!this.buildCalled);
            this.trackSelector = trackSelector;
            return this;
        }

        public Builder setMediaSourceFactory(MediaSourceFactory mediaSourceFactory) {
            Assertions.checkState(!this.buildCalled);
            this.mediaSourceFactory = mediaSourceFactory;
            return this;
        }

        public Builder setLoadControl(LoadControl loadControl) {
            Assertions.checkState(!this.buildCalled);
            this.loadControl = loadControl;
            return this;
        }

        public Builder setBandwidthMeter(BandwidthMeter bandwidthMeter) {
            Assertions.checkState(!this.buildCalled);
            this.bandwidthMeter = bandwidthMeter;
            return this;
        }

        public Builder setLooper(Looper looper) {
            Assertions.checkState(!this.buildCalled);
            this.looper = looper;
            return this;
        }

        public Builder setAnalyticsCollector(AnalyticsCollector analyticsCollector) {
            Assertions.checkState(!this.buildCalled);
            this.analyticsCollector = analyticsCollector;
            return this;
        }

        public Builder setUseLazyPreparation(boolean useLazyPreparation) {
            Assertions.checkState(!this.buildCalled);
            this.useLazyPreparation = useLazyPreparation;
            return this;
        }

        public Builder setSeekParameters(SeekParameters seekParameters) {
            Assertions.checkState(!this.buildCalled);
            this.seekParameters = seekParameters;
            return this;
        }

        public Builder setPauseAtEndOfMediaItems(boolean pauseAtEndOfMediaItems) {
            Assertions.checkState(!this.buildCalled);
            this.pauseAtEndOfMediaItems = pauseAtEndOfMediaItems;
            return this;
        }

        @VisibleForTesting
        public Builder setClock(Clock clock) {
            Assertions.checkState(!this.buildCalled);
            this.clock = clock;
            return this;
        }

        public ExoPlayer build() {
            Assertions.checkState(!this.buildCalled);
            this.buildCalled = true;
            ExoPlayerImpl player = new ExoPlayerImpl(this.renderers, this.trackSelector, this.mediaSourceFactory, this.loadControl, this.bandwidthMeter, this.analyticsCollector, this.useLazyPreparation, this.seekParameters, this.pauseAtEndOfMediaItems, this.clock, this.looper);
            if (this.releaseTimeoutMs > 0L) {
                player.experimentalSetReleaseTimeoutMs(this.releaseTimeoutMs);
            }
            if (!this.throwWhenStuckBuffering) {
                player.experimentalDisableThrowWhenStuckBuffering();
            }
            return player;
        }
    }
}

