/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.ads.yospace;

import com.yospace.android.hls.analytic.Session;
import com.yospace.android.hls.analytic.advert.AdBreak;
import com.yospace.android.hls.analytic.advert.Advert;
import com.yospace.android.hls.analytic.policy.PolicyHandler;
import java.util.List;

public class PlayerPolicy
implements PolicyHandler {
    private Session.PlaybackMode mPlaybackMode;

    public boolean canStart(long playhead, List<AdBreak> timeline) {
        return true;
    }

    public boolean canStop(long playhead, List<AdBreak> timeline) {
        return true;
    }

    public boolean canPause(long playhead, List<AdBreak> timeline) {
        return this.mPlaybackMode != Session.PlaybackMode.LIVE;
    }

    public boolean canRewind(long playhead, List<AdBreak> timeline) {
        return this.mPlaybackMode != Session.PlaybackMode.LIVE;
    }

    public int canSkip(long playhead, List<AdBreak> timeline, long duration) {
        if (this.mPlaybackMode == Session.PlaybackMode.LIVE) {
            return -1;
        }
        Advert ad = this.isInAdvert(playhead, timeline);
        if (ad == null) {
            return -1;
        }
        long skipOffset = ad.getLinearCreative().getSkipOffset();
        if (skipOffset == -1L) {
            return -1;
        }
        if (!ad.isActive()) {
            skipOffset = 0L;
        } else if (skipOffset >= 0L) {
            skipOffset = Math.max(0L, ad.getStartMillis() + skipOffset - playhead);
        }
        if ((this.mPlaybackMode == Session.PlaybackMode.NONLINEARSTARTOVER || this.mPlaybackMode == Session.PlaybackMode.LIVEPAUSE) && ad.getStartMillis() + (long)ad.getDuration() - playhead > duration) {
            skipOffset = -1L;
        }
        return (int)skipOffset;
    }

    public boolean canSeek(long playhead, List<AdBreak> timeline) {
        return this.isInActiveBreak(playhead, timeline) == null;
    }

    public long willSeekTo(long position, List<AdBreak> timeline) {
        AdBreak br = this.isInActiveBreak(position, timeline);
        long actual = position;
        if (br != null) {
            actual = br.getStartMillis();
        } else {
            br = this.closestActiveBreakPriorTo(position, timeline);
            if (br != null) {
                actual = br.getStartMillis();
            }
        }
        return actual;
    }

    public boolean canMute(long playhead, List<AdBreak> timeline) {
        return true;
    }

    public boolean canGoFullScreen(long playhead, List<AdBreak> timeline) {
        return true;
    }

    public boolean canExitFullScreen(long playhead, List<AdBreak> timeline) {
        return true;
    }

    public boolean canExpandCreative(long playhead, List<AdBreak> timeline) {
        return true;
    }

    public boolean canCollapseCreative(long playhead, List<AdBreak> timeline) {
        return true;
    }

    public boolean canClickThrough(String url, long playhead, List<AdBreak> timeline) {
        return true;
    }

    public void setPlaybackMode(Session.PlaybackMode mode) {
        this.mPlaybackMode = mode;
    }

    private Advert isInAdvert(long playhead, List<AdBreak> timeline) {
        for (AdBreak br : timeline) {
            if (br.getStartMillis() > playhead || playhead >= br.getStartMillis() + (long)br.getDuration()) continue;
            for (Advert ad : br.getAdverts()) {
                if (ad.getStartMillis() > playhead || playhead >= ad.getStartMillis() + (long)ad.getDuration()) continue;
                return ad;
            }
        }
        return null;
    }

    private AdBreak isInActiveBreak(long playhead, List<AdBreak> timeline) {
        for (AdBreak br : timeline) {
            if (br.getStartMillis() > playhead || playhead >= br.getStartMillis() + (long)br.getDuration()) continue;
            return br.isActive() ? br : null;
        }
        return null;
    }

    private AdBreak closestActiveBreakPriorTo(long position, List<AdBreak> timeline) {
        AdBreak closest = null;
        for (AdBreak br : timeline) {
            if (br.getStartMillis() + (long)br.getDuration() >= position || !br.isActive()) continue;
            closest = br;
        }
        return closest;
    }
}

