/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.analytics.mux;

import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Point;
import android.view.Display;
import android.view.WindowManager;
import com.akamai.amp.ads.AdsInfo;
import com.akamai.amp.analytics.AnalyticsTracker;
import com.akamai.amp.analytics.AnalyticsTrackerData;
import com.akamai.amp.analytics.mux.AmpMuxDataAnalyticsTracker;
import com.akamai.amp.analytics.mux.MuxData;
import com.akamai.amp.analytics.mux.MuxDevice;
import com.akamai.amp.analytics.mux.MuxEventBus;
import com.akamai.amp.analytics.mux.MuxExoListener;
import com.akamai.amp.analytics.mux.MuxNetworkRequests;
import com.akamai.amp.analytics.mux.bandwidth.BandwidthMetricDispatcher;
import com.akamai.amp.exoplayer2.Player;
import com.akamai.amp.exoplayer2.SimpleExoPlayer;
import com.akamai.amp.exoplayer2.ampcustom.AmpBasePlayer;
import com.akamai.amp.exoplayer2.analytics.AnalyticsListener;
import com.akamai.amp.media.IPlayerEventsListener;
import com.akamai.amp.media.VideoPlayerView;
import com.akamai.amp.media.VideoPlayerViewExo;
import com.akamai.amp.media.elements.MediaResource;
import com.akamai.amp.utils.LogManager;
import com.akamai.amp.utils.ReflectionUtils;
import com.mux.stats.sdk.core.Core;
import com.mux.stats.sdk.core.MuxSDKViewOrientation;
import com.mux.stats.sdk.core.events.IEventListener;
import com.mux.stats.sdk.core.model.CustomerPlayerData;
import com.mux.stats.sdk.core.model.CustomerVideoData;
import com.mux.stats.sdk.muxstats.IDevice;
import com.mux.stats.sdk.muxstats.INetworkRequest;
import com.mux.stats.sdk.muxstats.IPlayerListener;
import com.mux.stats.sdk.muxstats.MuxStats;
import java.util.Date;

public class MuxEventsHandler
extends AnalyticsTracker<MuxData>
implements AmpMuxDataAnalyticsTracker {
    static final String LOG_TAG = MuxEventsHandler.class.getSimpleName();
    private static final String VERSION = "9.10.6";
    private MuxStats muxStats;
    private MuxEventBus muxEventBus;
    private BandwidthMetricDispatcher bandwidthDispatcher;
    private boolean prerollsExpected = false;
    private boolean ignoreFirstForeground = true;
    private AdsInfo latestAdsInfo;
    private boolean autologErrors = true;
    private boolean seekInProgress = false;
    private boolean isInitialPlayback = true;

    MuxEventsHandler(VideoPlayerView videoPlayerView, MuxData param) {
        super(videoPlayerView, (AnalyticsTrackerData)param, LOG_TAG, VERSION);
        this.initialize();
    }

    public String getExternalLibVersion() {
        return MuxEventsHandler.getExternalLibVersionStatic();
    }

    static String getExternalLibVersionStatic() {
        String version = ReflectionUtils.tryToReadDeclaredField(Core.class, (String)"MUX_EMBED_VERSION");
        return version;
    }

    public void init() {
        LogManager.log((String)LOG_TAG, (String)("Initializing MUX version " + this.getExternalLibVersion() + " with Android AMP version " + VERSION));
        Context context = this.mVideoPlayerView.getContext();
        MuxDevice device = new MuxDevice(context);
        MuxStats.setHostDevice((IDevice)device);
        MuxNetworkRequests network = new MuxNetworkRequests();
        MuxStats.setHostNetworkApi((INetworkRequest)network);
        this.mVideoPlayerView.addEventsListener(this.muxPlayerEventsListener());
    }

    private IPlayerEventsListener muxPlayerEventsListener() {
        IPlayerEventsListener listener = new IPlayerEventsListener(){

            public boolean onPlayerEvent(int eventId) {
                if (eventId == 1) {
                    MuxEventsHandler.this.initialize();
                    MuxEventsHandler.this.addMissingStartupEvents();
                    MuxEventsHandler.this.addSdkValues();
                }
                return false;
            }

            public boolean onPlayerExtendedEvent(int eventId, int arg1, int arg2) {
                return false;
            }
        };
        return listener;
    }

    private void initialize() {
        boolean objectsNotInitialized;
        boolean bl = objectsNotInitialized = this.muxEventBus == null || this.muxStats == null || this.bandwidthDispatcher == null;
        if (objectsNotInitialized) {
            LogManager.log((String)LOG_TAG, (String)("initialize() called with MUX version " + this.getExternalLibVersion() + " with Android AMP version " + VERSION));
            this.muxEventBus = new MuxEventBus(this.mVideoPlayerView, this.prerollsExpected);
            this.addSdkValues();
            this.muxStats = new MuxStats((IPlayerListener)this.muxEventBus, "Akamai AMP SDK Android", ((MuxData)this.data).getCustomerPlayerData(), ((MuxData)this.data).getCustomerVideoData(), ((MuxData)this.data).getCustomerViewData(), ((MuxData)this.data).isSentryEnabled());
            this.muxEventBus.addListener((IEventListener)this.muxStats);
            this.bandwidthDispatcher = new BandwidthMetricDispatcher(this.muxEventBus);
            boolean logEnabled = LogManager.isLogEnabled();
            this.enableMuxCoreDebug(logEnabled, logEnabled);
            this.setScreenSize();
            this.registerExoListener();
            this.isInitialPlayback = true;
            this.muxEventBus.dispatchPlayerReady();
        } else {
            LogManager.log((String)LOG_TAG, (String)"initialize() was called, but MUX was already constructed. MUX objects won't be recreated again.");
        }
    }

    private void addSdkValues() {
        this.addCustomerPlayerData();
        this.addCustomerVideoData();
    }

    private void addCustomerPlayerData() {
        CustomerPlayerData customerPlayerData = ((MuxData)this.data).getCustomerPlayerData();
        if (customerPlayerData == null) {
            customerPlayerData = new CustomerPlayerData();
            ((MuxData)this.data).setPlayerData(customerPlayerData);
        }
        customerPlayerData.setPlayerName("Akamai AMP SDK Android");
        customerPlayerData.setPlayerVersion(VERSION);
    }

    private void addCustomerVideoData() {
        CustomerVideoData customerVideoData = ((MuxData)this.data).getCustomerVideoData();
        if (customerVideoData == null) {
            customerVideoData = new CustomerVideoData();
            ((MuxData)this.data).setVideoData(customerVideoData);
        }
        if (this.mVideoPlayerView != null) {
            customerVideoData.setVideoContentType(this.mVideoPlayerView.getProtocol());
            customerVideoData.setVideoDuration(Long.valueOf(this.mVideoPlayerView.getStreamDuration()));
            MediaResource mediaResource = this.mVideoPlayerView.getMediaResource();
            if (mediaResource != null) {
                customerVideoData.setVideoSourceUrl(mediaResource.getResourceUrl());
            }
        }
    }

    private void addMissingStartupEvents() {
        if (this.isAutoPlayOff()) {
            return;
        }
        SimpleExoPlayer player = this.getSimpleExoPlayer();
        if (player == null) {
            return;
        }
        int playbackState = player.getPlaybackState();
        if (playbackState == 2 || playbackState == 3) {
            this.trackPlayRequestedEvent();
            this.trackStartRebuffering();
        }
    }

    private void registerExoListener() {
        SimpleExoPlayer simpleExoPlayer = this.getSimpleExoPlayer();
        if (simpleExoPlayer == null) {
            return;
        }
        MuxExoListener listener = new MuxExoListener(this.muxEventBus, this.bandwidthDispatcher);
        simpleExoPlayer.addListener((Player.EventListener)listener);
        simpleExoPlayer.addAnalyticsListener((AnalyticsListener)listener);
    }

    private SimpleExoPlayer getSimpleExoPlayer() {
        VideoPlayerViewExo exo = (VideoPlayerViewExo)this.mVideoPlayerView;
        AmpBasePlayer ampBasePlayer = exo.getAmpBasePlayer();
        return ampBasePlayer;
    }

    private void setScreenSize() {
        Point size = new Point();
        Context context = this.mVideoPlayerView.getContext();
        if (context instanceof Activity) {
            Activity activity = (Activity)context;
            WindowManager windowManager = activity.getWindowManager();
            Display defaultDisplay = windowManager.getDefaultDisplay();
            defaultDisplay.getSize(size);
            this.muxStats.setScreenSize(size.x, size.y);
        }
    }

    public void cleanup() {
        if (this.muxStats != null) {
            this.muxStats.release();
            this.muxStats = null;
        }
        if (this.muxEventBus != null) {
            this.muxEventBus.stopPlayerUpdate();
            this.muxEventBus = null;
        }
    }

    @Override
    public void updateCustomerData(CustomerPlayerData customPlayerData, CustomerVideoData customVideoData) {
        ((MuxData)this.data).setPlayerData(customPlayerData);
        ((MuxData)this.data).setVideoData(customVideoData);
        this.addSdkValues();
        this.muxStats.updateCustomerData(customPlayerData, customVideoData);
    }

    @Override
    public CustomerVideoData getCustomerVideoData() {
        return this.muxStats.getCustomerVideoData();
    }

    @Override
    public CustomerPlayerData getCustomerPlayerData() {
        return this.muxStats.getCustomerPlayerData();
    }

    @Override
    public void enableMuxCoreDebug(boolean enable, boolean verbose) {
        this.muxStats.allowLogcatOutput(enable, verbose);
    }

    @Override
    public void videoChange(CustomerVideoData customerVideoData) {
        ((MuxData)this.data).setVideoData(customerVideoData);
        this.addSdkValues();
        this.muxStats.videoChange(customerVideoData);
    }

    @Override
    public void programChange(CustomerVideoData customerVideoData) {
        ((MuxData)this.data).setVideoData(customerVideoData);
        this.addSdkValues();
        this.muxStats.programChange(customerVideoData);
    }

    @Override
    public void setAutomaticErrorTracking(boolean enabled) {
        this.muxStats.setAutomaticErrorTracking(enabled);
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        if (this.muxStats == null) {
            return;
        }
        if (2 == newConfig.orientation) {
            this.muxStats.orientationChange(MuxSDKViewOrientation.LANDSCAPE);
        } else if (1 == newConfig.orientation) {
            this.muxStats.orientationChange(MuxSDKViewOrientation.PORTRAIT);
        }
    }

    @Override
    public MuxEventBus getMuxEventBus() {
        return this.muxEventBus;
    }

    @Override
    public void expectPreroll() {
        this.prerollsExpected = true;
        if (this.muxEventBus != null) {
            this.muxEventBus.expectPreroll();
        }
    }

    @Override
    public void setAutologErrors(boolean autolog) {
        this.autologErrors = autolog;
    }

    public void trackPauseEvent() {
        if (this.muxEventBus == null) {
            return;
        }
        if (this.adBreakStarted != null && this.adBreakStarted.booleanValue()) {
            LogManager.log((String)LOG_TAG, (String)"trackPauseEvent() was called between ads from the same adBreak. Skipping muxEventBus.dispatchPause()");
            return;
        }
        LogManager.log((String)LOG_TAG, (String)"trackPauseEvent()");
        this.muxEventBus.dispatchPause();
    }

    public void trackPlayRequestedEvent() {
        if (this.isAutoPlayOff()) {
            return;
        }
        if (this.muxEventBus == null) {
            return;
        }
        LogManager.log((String)LOG_TAG, (String)"trackPlayRequestedEvent()");
        this.muxEventBus.dispatchPlay();
    }

    private boolean isAutoPlayOff() {
        boolean result = this.isInitialPlayback && !this.mVideoPlayerView.isAutoPlayOn();
        return result;
    }

    public void trackPlayEvent() {
        if (this.isAutoPlayOff()) {
            return;
        }
        this.addSdkValues();
        if (this.muxEventBus == null) {
            return;
        }
        LogManager.log((String)LOG_TAG, (String)"trackPlayEvent()");
        this.muxEventBus.dispatchPlaying();
    }

    public void trackResumeEvent() {
        if (this.isAutoPlayOff()) {
            this.addMissingStartupEventsForAutoplayOff();
            return;
        }
        if (this.muxEventBus == null) {
            return;
        }
        LogManager.log((String)LOG_TAG, (String)"trackResumeEvent()");
        this.muxEventBus.dispatchPlay();
        this.muxEventBus.dispatchPlaying();
    }

    private void addMissingStartupEventsForAutoplayOff() {
        this.isInitialPlayback = false;
        this.addMissingStartupEvents();
        this.trackPlayEvent();
    }

    public void trackFinish() {
        if (this.muxEventBus == null) {
            return;
        }
        LogManager.log((String)LOG_TAG, (String)"trackFinish()");
        this.muxEventBus.dispatchEnded();
    }

    public void trackSeekStarted() {
        if (this.muxEventBus == null) {
            return;
        }
        LogManager.log((String)LOG_TAG, (String)("trackSeekStarted() " + new Date()));
        this.muxEventBus.dispatchSeeking();
        this.seekInProgress = true;
    }

    public void trackSeekComplete() {
    }

    public void trackStopRebuffering() {
        if (this.seekInProgress) {
            this.dispatchSeekComplete();
            this.seekInProgress = false;
        }
    }

    private void dispatchSeekComplete() {
        if (this.muxEventBus == null) {
            return;
        }
        LogManager.log((String)LOG_TAG, (String)("dispatchSeekComplete() " + new Date() + " -> dispatchSeeked() and then forceDispatchPlaying()"));
        this.muxEventBus.dispatchSeeked();
        this.muxEventBus.forceDispatchPlaying();
    }

    public void trackPlaybackStalled() {
        if (this.muxEventBus == null) {
            return;
        }
        LogManager.log((String)LOG_TAG, (String)"trackPlaybackStalled()");
        this.muxEventBus.dispatchStalled();
    }

    public void trackError(String message) {
        if (this.autologErrors) {
            this.dispatchError(message);
        }
    }

    @Override
    public void dispatchError(String message) {
        if (this.muxEventBus == null) {
            return;
        }
        LogManager.log((String)LOG_TAG, (String)("trackError() " + message));
        Exception e = this.getException(message);
        this.muxEventBus.dispatchInternalError(e);
    }

    private Exception getException(String message) {
        Exception lastException = this.mVideoPlayerView.getLastException();
        if (lastException == null) {
            RuntimeException runtimeException = new RuntimeException(message);
            return runtimeException;
        }
        return lastException;
    }

    public void trackPauseContentRequested() {
        if (this.muxEventBus == null) {
            return;
        }
        LogManager.log((String)LOG_TAG, (String)"trackPauseContentRequested()");
        this.muxEventBus.dispatchAdPlay();
    }

    public void trackAdsStarted(AdsInfo ad) {
        this.latestAdsInfo = ad;
        if (this.muxEventBus == null) {
            return;
        }
        LogManager.log((String)LOG_TAG, (String)("trackAdsStarted() " + ad));
        this.muxEventBus.dispatchAdPlaying(ad);
    }

    public void trackAdsPaused() {
        if (this.muxEventBus == null) {
            return;
        }
        LogManager.log((String)LOG_TAG, (String)"trackAdsPaused()");
        this.muxEventBus.dispatchAdPaused();
    }

    public void trackAdsEnded() {
        if (this.muxEventBus == null) {
            return;
        }
        if (this.adErrorHappened != null && this.adErrorHappened.booleanValue()) {
            LogManager.error((String)LOG_TAG, (String)"An adErrorHappened, so we're skipping trackAdsEnded()");
        } else {
            LogManager.log((String)LOG_TAG, (String)"trackAdsEnded()");
            this.muxEventBus.dispatchAdEnded();
            if (this.latestAdsInfo != null && !this.latestAdsInfo.isFirstInAdBreak()) {
                LogManager.log((String)LOG_TAG, (String)"trackPauseContentRequested()");
                this.muxEventBus.dispatchAdPlay();
            }
        }
        this.latestAdsInfo = null;
    }

    public void trackAdsError(String reason) {
        if (this.muxEventBus == null) {
            return;
        }
        LogManager.log((String)LOG_TAG, (String)("trackAdsError() " + reason));
        this.muxEventBus.dispatchAdErrorEvent();
    }

    public void trackAdBreakStart() {
        if (this.muxEventBus == null) {
            return;
        }
        LogManager.log((String)LOG_TAG, (String)"trackAdBreakStart()");
        this.muxEventBus.dispatchAdBreakStarted();
    }

    public void trackAdBreakEnd() {
        if (this.muxEventBus == null) {
            return;
        }
        LogManager.log((String)LOG_TAG, (String)"trackAdBreakEnd()");
        this.muxEventBus.dispatchAdBreakEnded();
    }

    public void trackAdsTrackProgress(int progress) {
        if (this.muxEventBus == null) {
            return;
        }
        LogManager.log((String)LOG_TAG, (String)("trackAdsTrackProgress() " + progress));
        this.muxEventBus.dispatchAdTrackProgress(progress);
    }

    public void trackSendToBackground() {
        this.ignoreFirstForeground = false;
        if (this.muxEventBus == null) {
            return;
        }
        LogManager.log((String)LOG_TAG, (String)"trackSendToBackground()");
        this.muxEventBus.dispatchPause();
    }

    public void trackSendToForeground() {
        if (this.ignoreFirstForeground) {
            this.ignoreFirstForeground = false;
            return;
        }
        if (this.muxEventBus == null) {
            return;
        }
        LogManager.log((String)LOG_TAG, (String)"trackSendToForeground()");
        this.muxEventBus.dispatchPlay();
        this.muxEventBus.dispatchPlaying();
    }
}

