/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.license.manager;

import android.content.Context;
import android.util.Base64;
import com.akamai.amp.license.decryption.AES256JNCryptor;
import com.akamai.amp.license.decryption.CryptorException;
import com.akamai.amp.license.decryption.pool.KeyPool;
import com.akamai.amp.license.manager.License;
import com.akamai.amp.license.manager.LicenseDecryption;
import com.akamai.amp.utils.LogManager;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AES256LicenseDecryption
extends LicenseDecryption {
    public static final String API_KEY_TAG = "Api Key";
    private final License license = new License();
    private boolean allowPlaybackUponFail;
    private String encryptedResult;

    public void setEncryptedResult(String encryptedResult) {
        this.encryptedResult = encryptedResult;
        try {
            AES256JNCryptor cryptor = new AES256JNCryptor();
            byte[] decryptedText = cryptor.decryptData(Base64.decode((String)encryptedResult, (int)0), new String(KeyPool.work(), StandardCharsets.UTF_8).toCharArray());
            JSONObject decryptedObject = new JSONObject(new String(decryptedText, StandardCharsets.UTF_8));
            this.license.name = decryptedObject.getString("customer");
            this.license.licenseType = decryptedObject.getString("type");
            ArrayList<String> packageNames = new ArrayList<String>();
            if (decryptedObject.has("android")) {
                JSONArray jsonArray = decryptedObject.getJSONArray("android");
                for (int i = 0; i < jsonArray.length(); ++i) {
                    packageNames.add(jsonArray.getString(i));
                }
                this.license.packageNames = packageNames;
            }
            SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy", Locale.getDefault());
            this.license.expirationDate = format.parse(decryptedObject.getString("expirationDate"));
        }
        catch (CryptorException | IllegalArgumentException | ParseException | JSONException e) {
            LogManager.error(API_KEY_TAG, "Failed to decrypt the license");
            LogManager.error(API_KEY_TAG, e.getLocalizedMessage());
            this.encryptedResult = null;
            this.allowPlaybackUponFail = true;
        }
    }

    public boolean isLicenseValid(Context context) {
        this.mContext = context;
        LogManager.log(API_KEY_TAG, "License Validation run");
        if (this.license.expirationDate != null) {
            LogManager.log(API_KEY_TAG, "License Expiration date: " + this.license.expirationDate.toString());
        }
        if (this.encryptedResult == null || this.encryptedResult.trim().isEmpty()) {
            if (!this.allowPlaybackUponFail) {
                LogManager.error(API_KEY_TAG, "Forbidden access error: Unable to retrieve a license, playback denied");
            } else {
                LogManager.error(API_KEY_TAG, "Service reach error: validation incomplete, playback allowed in the meantime");
            }
            return this.allowPlaybackUponFail;
        }
        if (!this.license.packageNames.isEmpty()) {
            String currentPackage = this.mContext.getPackageName();
            boolean isValidPackageName = this.license.packageNames.contains(currentPackage);
            if (!isValidPackageName) {
                LogManager.error(API_KEY_TAG, "Package miss-match error: the current app is not listed as a valid target in the license retrieved");
            }
            return isValidPackageName;
        }
        return true;
    }

    @Override
    public int getCause() {
        return 3;
    }

    public License getLicense() {
        return this.license;
    }

    public void setAllowPlaybackUponFail(boolean allowPlaybackUponFail) {
        this.allowPlaybackUponFail = allowPlaybackUponFail;
    }

    public boolean isAllowPlaybackUponFail() {
        return this.allowPlaybackUponFail;
    }
}

