/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.source;

import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.MediaItem;
import com.akamai.amp.exoplayer2.Timeline;
import com.akamai.amp.exoplayer2.source.CompositeMediaSource;
import com.akamai.amp.exoplayer2.source.CompositeSequenceableLoaderFactory;
import com.akamai.amp.exoplayer2.source.DefaultCompositeSequenceableLoaderFactory;
import com.akamai.amp.exoplayer2.source.MediaPeriod;
import com.akamai.amp.exoplayer2.source.MediaSource;
import com.akamai.amp.exoplayer2.source.MergingMediaPeriod;
import com.akamai.amp.exoplayer2.upstream.Allocator;
import com.akamai.amp.exoplayer2.upstream.TransferListener;
import java.io.IOException;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;

public final class MergingMediaSource
extends CompositeMediaSource<Integer> {
    private static final int PERIOD_COUNT_UNSET = -1;
    private static final MediaItem EMPTY_MEDIA_ITEM = new MediaItem.Builder().setMediaId("MergingMediaSource").build();
    private final boolean adjustPeriodTimeOffsets;
    private final MediaSource[] mediaSources;
    private final Timeline[] timelines;
    private final ArrayList<MediaSource> pendingTimelineSources;
    private final CompositeSequenceableLoaderFactory compositeSequenceableLoaderFactory;
    private int periodCount;
    private long[][] periodTimeOffsetsUs;
    @Nullable
    private IllegalMergeException mergeError;

    public MergingMediaSource(MediaSource ... mediaSources) {
        this(false, mediaSources);
    }

    public MergingMediaSource(boolean adjustPeriodTimeOffsets, MediaSource ... mediaSources) {
        this(adjustPeriodTimeOffsets, new DefaultCompositeSequenceableLoaderFactory(), mediaSources);
    }

    public MergingMediaSource(boolean adjustPeriodTimeOffsets, CompositeSequenceableLoaderFactory compositeSequenceableLoaderFactory, MediaSource ... mediaSources) {
        this.adjustPeriodTimeOffsets = adjustPeriodTimeOffsets;
        this.mediaSources = mediaSources;
        this.compositeSequenceableLoaderFactory = compositeSequenceableLoaderFactory;
        this.pendingTimelineSources = new ArrayList<MediaSource>(Arrays.asList(mediaSources));
        this.periodCount = -1;
        this.timelines = new Timeline[mediaSources.length];
        this.periodTimeOffsetsUs = new long[0][];
    }

    @Override
    public boolean isLive() {
        if (this.mediaSources == null || this.mediaSources.length < 1) {
            return false;
        }
        return this.mediaSources[0].isLive();
    }

    @Override
    @Deprecated
    @Nullable
    public Object getTag() {
        return this.mediaSources.length > 0 ? this.mediaSources[0].getTag() : null;
    }

    @Override
    public MediaItem getMediaItem() {
        return this.mediaSources.length > 0 ? this.mediaSources[0].getMediaItem() : EMPTY_MEDIA_ITEM;
    }

    @Override
    protected void prepareSourceInternal(@Nullable TransferListener mediaTransferListener) {
        super.prepareSourceInternal(mediaTransferListener);
        for (int i = 0; i < this.mediaSources.length; ++i) {
            this.prepareChildSource(i, this.mediaSources[i]);
        }
    }

    @Override
    public void maybeThrowSourceInfoRefreshError() throws IOException {
        if (this.mergeError != null) {
            throw this.mergeError;
        }
        super.maybeThrowSourceInfoRefreshError();
    }

    @Override
    public MediaPeriod createPeriod(MediaSource.MediaPeriodId id, Allocator allocator, long startPositionUs) {
        MediaPeriod[] periods = new MediaPeriod[this.mediaSources.length];
        int periodIndex = this.timelines[0].getIndexOfPeriod(id.periodUid);
        for (int i = 0; i < periods.length; ++i) {
            MediaSource.MediaPeriodId childMediaPeriodId = id.copyWithPeriodUid(this.timelines[i].getUidOfPeriod(periodIndex));
            periods[i] = this.mediaSources[i].createPeriod(childMediaPeriodId, allocator, startPositionUs - this.periodTimeOffsetsUs[periodIndex][i]);
        }
        return new MergingMediaPeriod(this.compositeSequenceableLoaderFactory, this.periodTimeOffsetsUs[periodIndex], periods);
    }

    @Override
    public void releasePeriod(MediaPeriod mediaPeriod) {
        MergingMediaPeriod mergingPeriod = (MergingMediaPeriod)mediaPeriod;
        for (int i = 0; i < this.mediaSources.length; ++i) {
            this.mediaSources[i].releasePeriod(mergingPeriod.getChildPeriod(i));
        }
    }

    @Override
    protected void releaseSourceInternal() {
        super.releaseSourceInternal();
        Arrays.fill(this.timelines, null);
        this.periodCount = -1;
        this.mergeError = null;
        this.pendingTimelineSources.clear();
        Collections.addAll(this.pendingTimelineSources, this.mediaSources);
    }

    @Override
    protected void onChildSourceInfoRefreshed(Integer id, MediaSource mediaSource, Timeline timeline) {
        if (this.mergeError != null) {
            return;
        }
        if (this.periodCount == -1) {
            this.periodCount = timeline.getPeriodCount();
        } else if (timeline.getPeriodCount() != this.periodCount) {
            this.mergeError = new IllegalMergeException(0);
            return;
        }
        if (this.periodTimeOffsetsUs.length == 0) {
            this.periodTimeOffsetsUs = new long[this.periodCount][this.timelines.length];
        }
        this.pendingTimelineSources.remove(mediaSource);
        this.timelines[id.intValue()] = timeline;
        if (this.pendingTimelineSources.isEmpty()) {
            if (this.adjustPeriodTimeOffsets) {
                this.computePeriodTimeOffsets();
            }
            this.refreshSourceInfo(this.timelines[0]);
        }
    }

    @Override
    @Nullable
    protected MediaSource.MediaPeriodId getMediaPeriodIdForChildMediaPeriodId(Integer id, MediaSource.MediaPeriodId mediaPeriodId) {
        return id == 0 ? mediaPeriodId : null;
    }

    private void computePeriodTimeOffsets() {
        Timeline.Period period = new Timeline.Period();
        for (int periodIndex = 0; periodIndex < this.periodCount; ++periodIndex) {
            long primaryWindowOffsetUs = -this.timelines[0].getPeriod(periodIndex, period).getPositionInWindowUs();
            for (int timelineIndex = 1; timelineIndex < this.timelines.length; ++timelineIndex) {
                long secondaryWindowOffsetUs = -this.timelines[timelineIndex].getPeriod(periodIndex, period).getPositionInWindowUs();
                this.periodTimeOffsetsUs[periodIndex][timelineIndex] = primaryWindowOffsetUs - secondaryWindowOffsetUs;
            }
        }
    }

    public static final class IllegalMergeException
    extends IOException {
        public static final int REASON_PERIOD_COUNT_MISMATCH = 0;
        public final int reason;

        public IllegalMergeException(int reason) {
            this.reason = reason;
        }

        @Documented
        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Reason {
        }
    }
}

