/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.data.scte35;

import com.akamai.amp.data.scte35.ScteEventsListener;
import com.akamai.amp.exoplayer2.ampcustom.scte35.Pair;
import com.akamai.amp.exoplayer2.ampcustom.scte35.Scte35Data;
import com.akamai.amp.exoplayer2.ampcustom.scte35.Scte35Manager;
import com.akamai.amp.exoplayer2.source.hls.playlist.HlsPlaylistParser;
import com.akamai.amp.media.IPlayerEventsListener;
import com.akamai.amp.media.VideoPlayerView;
import com.akamai.amp.media.VideoPlayerViewExo;
import com.akamai.amp.utils.Utils;
import java.util.List;
import java.util.Set;

public class AmpScte35Manager {
    public static final String VERSION = "9.10.6";
    private static final String LOG_TAG = AmpScte35Manager.class.getSimpleName();
    private VideoPlayerViewExo exo;
    private ScteEventsListener scteEventsListener;

    private AmpScte35Manager() {
    }

    public static AmpScte35Manager of(VideoPlayerView videoPlayerView, ScteEventsListener listener) {
        Utils.checkModuleVersion((String)LOG_TAG, (String)VERSION);
        AmpScte35Manager ampScte35Manager = new AmpScte35Manager();
        ampScte35Manager.exo = (VideoPlayerViewExo)videoPlayerView;
        ampScte35Manager.scteEventsListener = listener;
        HlsPlaylistParser.scteEnabled = true;
        Scte35Manager.cache.clear();
        IPlayerEventsListener playerEventsListener = AmpScte35Manager.playerEventsListener(ampScte35Manager.exo, ampScte35Manager.scteEventsListener);
        ampScte35Manager.exo.addEventsListener(playerEventsListener);
        return ampScte35Manager;
    }

    public static void checkScte35(String uri, ScteEventsListener scteEventsListener) {
        if (scteEventsListener == null) {
            return;
        }
        Set segmentNames = Scte35Manager.cache.keySet();
        for (String segmentName : segmentNames) {
            boolean matches = uri.contains(segmentName);
            if (!matches) continue;
            List values = (List)Scte35Manager.cache.get(segmentName);
            for (Scte35Data value : values) {
                AmpScte35Manager.fireEvents(segmentName, value, scteEventsListener);
            }
            Scte35Manager.cache.remove(segmentName);
        }
    }

    private static IPlayerEventsListener playerEventsListener(final VideoPlayerViewExo exo, final ScteEventsListener scteEventsListener) {
        IPlayerEventsListener eventsListener = new IPlayerEventsListener(){

            public boolean onPlayerEvent(int eventId) {
                if (eventId == 20) {
                    String uri = exo.getLatestChunkUri();
                    AmpScte35Manager.checkScte35(uri, scteEventsListener);
                    return true;
                }
                return false;
            }

            public boolean onPlayerExtendedEvent(int eventId, int arg1, int arg2) {
                return false;
            }
        };
        return eventsListener;
    }

    private static void fireEvents(String uri, Scte35Data scte35Data, ScteEventsListener scteEventsListener) {
        if (scteEventsListener == null) {
            return;
        }
        if (scte35Data.isCueIn()) {
            scteEventsListener.onCueIn(uri);
        } else if (scte35Data.getCueOutCont() != null) {
            Pair pair = scte35Data.getCueOutCont();
            scteEventsListener.onCueOutCont(uri, ((Float)pair.first).floatValue(), ((Float)pair.second).floatValue());
        } else if (scte35Data.getCueOutDuration() != -1.0f) {
            float cueOutDuration = scte35Data.getCueOutDuration();
            scteEventsListener.onCueOut(uri, cueOutDuration);
        } else if (scte35Data.getOatclsScte35() != null) {
            String oatclsScte35 = scte35Data.getOatclsScte35();
            scteEventsListener.onOatclsScte35(uri, oatclsScte35);
        }
    }
}

