/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.cast;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.view.Menu;
import android.view.MenuItem;
import com.akamai.amp.cast.AmpCastManager;
import com.akamai.amp.cast.OTTDevice;
import com.akamai.amp.cast.OTTDeviceEventsListener;
import com.akamai.amp.cast.queue.AmpQueueManager;
import com.akamai.amp.cast.utils.AmpCastUtils;
import com.akamai.amp.cast.utils.CastSettings;
import com.akamai.amp.cast.values.PlaybackLocation;
import com.akamai.amp.media.VideoPlayerContainer;
import com.akamai.amp.media.VideoPlayerView;
import com.akamai.amp.media.elements.MediaResource;
import com.akamai.amp.media.errors.ErrorType;
import com.akamai.amp.utils.LogManager;
import com.akamai.amp.utils.Utils;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.CastStateListener;
import com.google.android.gms.cast.framework.IntroductoryOverlay;
import com.google.android.gms.cast.framework.SessionManagerListener;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;

public class CastHandler
implements AmpCastManager {
    public static final String VERSION = "9.10.6";
    private static final String TAG = CastHandler.class.getCanonicalName();
    private IntroductoryOverlay mIntroductoryOverlay;
    private MenuItem mediaRouteMenuItem;
    private Context appContext;
    private AmpQueueManager ampQueueManager;
    private final SessionManagerListener<CastSession> internalSessionManagerListener = new DefaultSessionManagerListener();
    private SessionManagerListener<CastSession> sessionManagerListener;
    private RemoteMediaClient.Callback mRemoteMediaClientCallback;
    private CastStateListener mCastStateListener;
    private boolean remoteCallbackAlreadyRegistered = false;
    private PlaybackLocation mLocation;
    private VideoPlayerView videoPlayerView;
    private OTTDevice OTTDevice;
    private SessionManagerListener<CastSession> deviceStatusListener = new SessionManagerListener<CastSession>(){

        public void onSessionStarting(CastSession castSession) {
        }

        public void onSessionStarted(CastSession castSession, String s) {
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (CastHandler.this.OTTDeviceEventsListener != null) {
                        CastHandler.this.OTTDeviceEventsListener.onCastAppConnected(CastHandler.this.getOTTDevice());
                    }
                }
            }, 100L);
        }

        public void onSessionStartFailed(CastSession castSession, int i) {
        }

        public void onSessionEnding(CastSession castSession) {
        }

        public void onSessionEnded(CastSession castSession, int i) {
            CastHandler.this.OTTDevice = null;
            if (CastHandler.this.OTTDeviceEventsListener != null) {
                CastHandler.this.OTTDeviceEventsListener.onCastAppDisconnected();
            }
        }

        public void onSessionResuming(CastSession castSession, String s) {
        }

        public void onSessionResumed(CastSession castSession, boolean b) {
        }

        public void onSessionResumeFailed(CastSession castSession, int i) {
        }

        public void onSessionSuspended(CastSession castSession, int i) {
        }
    };
    private OTTDeviceEventsListener OTTDeviceEventsListener;

    public CastHandler(Context context) {
        this.appContext = context;
    }

    private void registerSessionManagerListener(SessionManagerListener sessionManagerListener) {
        if (sessionManagerListener == null) {
            LogManager.error((String)TAG, (String)"SessionManagerListener is null, it can't be registered");
            return;
        }
        this.getCastContext().getSessionManager().addSessionManagerListener(sessionManagerListener, CastSession.class);
    }

    private void unregisterSessionManagerListener(SessionManagerListener sessionManagerListener) {
        if (sessionManagerListener == null) {
            LogManager.error((String)TAG, (String)"SessionManagerListener is null, it can't be unregistered");
            return;
        }
        this.getCastContext().getSessionManager().removeSessionManagerListener(sessionManagerListener, CastSession.class);
    }

    private void registerMediaRemoteCallback() {
        RemoteMediaClient remoteMediaClient = CastSettings.get().getRemoteMediaClient(this.appContext);
        if (remoteMediaClient == null || this.mRemoteMediaClientCallback == null || this.remoteCallbackAlreadyRegistered) {
            LogManager.error((String)TAG, (String)"RemoteMediaClient is null");
            return;
        }
        remoteMediaClient.registerCallback(this.mRemoteMediaClientCallback);
        this.remoteCallbackAlreadyRegistered = true;
    }

    private void unRegisterMediaRemoteCallback() {
        RemoteMediaClient remoteMediaClient = CastSettings.get().getRemoteMediaClient(this.appContext);
        if (remoteMediaClient == null || this.mRemoteMediaClientCallback == null || !this.remoteCallbackAlreadyRegistered) {
            LogManager.error((String)TAG, (String)"RemoteMediaClient is null");
            return;
        }
        remoteMediaClient.unregisterCallback(this.mRemoteMediaClientCallback);
        this.remoteCallbackAlreadyRegistered = false;
    }

    private void registerCastStateListener() {
        if (this.mCastStateListener == null) {
            LogManager.error((String)TAG, (String)"CastStateListener can't be registered, CastSession is null");
            return;
        }
        this.getCastContext().addCastStateListener(this.mCastStateListener);
    }

    private void unregisterCastStateListener() {
        if (this.mCastStateListener == null) {
            LogManager.error((String)TAG, (String)"CastStateListener can't be unregistered, CastSession is null");
            return;
        }
        this.getCastContext().removeCastStateListener(this.mCastStateListener);
    }

    private OTTDevice getOTTDevice() {
        if (CastSettings.get().getCastSession() != null && CastSettings.get().getCastSession().getCastDevice() != null) {
            this.OTTDevice = new OTTDevice();
            this.OTTDevice.deviceName = CastSettings.get().getCastSession().getCastDevice().getFriendlyName();
            this.OTTDevice.deviceID = CastSettings.get().getCastSession().getCastDevice().getDeviceId();
            this.OTTDevice.deviceModel = CastSettings.get().getCastSession().getCastDevice().getModelName();
            this.OTTDevice.deviceVersion = CastSettings.get().getCastSession().getCastDevice().getDeviceVersion();
        }
        return this.OTTDevice;
    }

    @Override
    public void setOTTDeviceEventsListener(OTTDeviceEventsListener OTTDeviceEventsListener2) {
        this.OTTDeviceEventsListener = OTTDeviceEventsListener2;
    }

    @Override
    public void setVideoplayerContainer(final VideoPlayerContainer videoplayerContainer) {
        videoplayerContainer.addVideoPlayerContainerCallback(new VideoPlayerContainer.VideoPlayerContainerCallback(){

            public void onVideoPlayerCreated() {
                CastHandler.this.videoPlayerView = videoplayerContainer.getVideoPlayer();
            }

            public void onResourceReady(MediaResource resource) {
            }

            public void onResourceError(ErrorType errorType, Exception exc) {
            }
        });
    }

    @Override
    public AmpQueueManager getQueueManager() {
        return this.ampQueueManager;
    }

    @Override
    public PlaybackLocation getPlaybackLocation() {
        return this.mLocation;
    }

    @Override
    public void setQueueManager(AmpQueueManager queueManager) {
        this.ampQueueManager = queueManager;
    }

    @Override
    public void setCastStateListener(CastStateListener mCastStateListener) {
        this.mCastStateListener = mCastStateListener;
    }

    @Override
    public void setSessionManagerListener(SessionManagerListener sessionManagerListener) {
        this.sessionManagerListener = sessionManagerListener;
    }

    @Override
    public void setRemoteMediaClientCallback(RemoteMediaClient.Callback remoteMediaClientCallback) {
        this.mRemoteMediaClientCallback = remoteMediaClientCallback;
    }

    @Override
    public void initCastButton(Context context, Menu menu, int menuItemId) {
        this.mediaRouteMenuItem = AmpCastUtils.initCastButton(context, menu, menuItemId);
    }

    @Override
    public CastContext getCastContext() {
        return CastSettings.get().getCastContext(this.appContext);
    }

    @Override
    public CastSession getCastSession() {
        CastSettings.get().updateCastSession(this.appContext);
        return CastSettings.get().getCastSession();
    }

    @Override
    public void onForeground() {
        this.registerSessionManagerListener(this.internalSessionManagerListener);
        this.registerSessionManagerListener(this.sessionManagerListener);
        this.registerSessionManagerListener(this.deviceStatusListener);
        this.registerMediaRemoteCallback();
        this.registerCastStateListener();
        this.getCastSession();
        this.updateLocationBasedOnConnection();
        if (this.videoPlayerView != null) {
            this.videoPlayerView.onResume();
        }
    }

    private void updateLocationBasedOnConnection() {
        this.mLocation = this.isConnected() ? PlaybackLocation.REMOTE : PlaybackLocation.LOCAL;
    }

    @Override
    public void onBackground() {
        this.unregisterSessionManagerListener(this.internalSessionManagerListener);
        this.unregisterSessionManagerListener(this.sessionManagerListener);
        this.unRegisterMediaRemoteCallback();
        this.unregisterCastStateListener();
        if (this.videoPlayerView != null) {
            this.videoPlayerView.onPause();
        }
    }

    @Override
    public boolean isConnected() {
        return CastSettings.get().isConnected(this.appContext);
    }

    @Override
    public boolean isConnecting() {
        return CastSettings.get().isConnecting(this.appContext);
    }

    @Override
    public void showIntroductoryOverlay(final Activity activity, final String title, final int overlayColor) {
        if (this.mIntroductoryOverlay != null) {
            this.mIntroductoryOverlay.remove();
        }
        if (this.mediaRouteMenuItem != null && this.mediaRouteMenuItem.isVisible()) {
            new Handler().post(new Runnable(){

                @Override
                public void run() {
                    CastHandler.this.mIntroductoryOverlay = new IntroductoryOverlay.Builder(activity, CastHandler.this.mediaRouteMenuItem).setTitleText(title).setOverlayColor(overlayColor).setSingleTime().setOnOverlayDismissedListener(new IntroductoryOverlay.OnOverlayDismissedListener(){

                        public void onOverlayDismissed() {
                            CastHandler.this.mIntroductoryOverlay = null;
                        }
                    }).build();
                    CastHandler.this.mIntroductoryOverlay.show();
                }
            });
        }
    }

    @Override
    public boolean isRemoteClientActive() {
        return CastSettings.get().getRemoteMediaClient(this.appContext) != null;
    }

    @Override
    public int getCastPlaybackState() {
        return CastSettings.get().getRemoteMediaClient(this.appContext).getPlayerState();
    }

    static {
        Utils.checkModuleVersion((String)TAG, (String)VERSION);
    }

    private class DefaultSessionManagerListener
    implements SessionManagerListener<CastSession> {
        private DefaultSessionManagerListener() {
        }

        public void onSessionEnded(CastSession session, int error) {
            CastSession currentSession = CastSettings.get().getCastSession();
            if (session == currentSession) {
                CastSettings.get().overrideCastSession(null);
            }
            CastHandler.this.registerMediaRemoteCallback();
            CastHandler.this.mLocation = PlaybackLocation.LOCAL;
        }

        public void onSessionResumed(CastSession session, boolean wasSuspended) {
            CastSettings.get().overrideCastSession(session);
            CastHandler.this.registerMediaRemoteCallback();
            CastHandler.this.mLocation = PlaybackLocation.REMOTE;
        }

        public void onSessionStarted(CastSession session, String sessionId) {
            CastSettings.get().overrideCastSession(session);
            CastHandler.this.registerMediaRemoteCallback();
            CastHandler.this.mLocation = PlaybackLocation.REMOTE;
        }

        public void onSessionStarting(CastSession session) {
        }

        public void onSessionStartFailed(CastSession session, int error) {
            CastHandler.this.mLocation = PlaybackLocation.LOCAL;
        }

        public void onSessionEnding(CastSession session) {
        }

        public void onSessionResuming(CastSession session, String sessionId) {
        }

        public void onSessionResumeFailed(CastSession session, int error) {
            CastHandler.this.mLocation = PlaybackLocation.LOCAL;
        }

        public void onSessionSuspended(CastSession session, int reason) {
            CastHandler.this.unRegisterMediaRemoteCallback();
        }
    }
}

