/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.ads.ima.adprogress;

import com.akamai.amp.ads.ima.IMAAdsHandler;
import com.akamai.amp.ads.ima.adprogress.AdProgressData;
import com.akamai.amp.ads.ima.adprogress.RepeatedAdProgressStrategy;
import com.akamai.amp.utils.LogManager;
import java.util.Objects;

public class AdProgressChecker {
    private static final String TAG = AdProgressChecker.class.getName();
    private int repeatThreshold = 30;
    private int repeatCounter = 0;
    private AdProgressData previous;
    private static RepeatedAdProgressStrategy strategy = RepeatedAdProgressStrategy.DO_NOTHING;
    private IMAAdsHandler imaAdsHandler;

    public AdProgressChecker(IMAAdsHandler imaAdsHandler) {
        this.imaAdsHandler = imaAdsHandler;
    }

    public boolean checkAdProgress(AdProgressData current) {
        boolean hasReachedThreshold;
        boolean isRepeated = Objects.equals(this.previous, current);
        if (isRepeated) {
            ++this.repeatCounter;
        } else {
            this.previous = current;
            this.repeatCounter = 0;
        }
        boolean bl = hasReachedThreshold = this.repeatCounter >= this.repeatThreshold;
        if (hasReachedThreshold) {
            this.actOnRepeatedAdProgress();
        }
        return hasReachedThreshold;
    }

    private void actOnRepeatedAdProgress() {
        LogManager.error((String)TAG, (String)(this.getErrorMessage() + ". Executing RepeatedAdProgressStrategy." + (Object)((Object)strategy)));
        switch (strategy) {
            case SIGNAL_ERROR: {
                this.imaAdsHandler.forceError();
                break;
            }
            case DO_NOT_SIGNAL_ERROR: {
                this.imaAdsHandler.resumeContentVideo();
                break;
            }
            case PAUSE_AND_RESUME_AD: {
                this.imaAdsHandler.pauseAd();
                this.imaAdsHandler.resumeAd();
                break;
            }
        }
    }

    public void setRepeatThreshold(int repeatThreshold) {
        this.repeatThreshold = repeatThreshold;
    }

    public static void setStrategy(RepeatedAdProgressStrategy strategy) {
        AdProgressChecker.strategy = strategy;
    }

    public int getRepeatThreshold() {
        return this.repeatThreshold;
    }

    public int getRepeatCounter() {
        return this.repeatCounter;
    }

    public AdProgressData getPrevious() {
        return this.previous;
    }

    public RepeatedAdProgressStrategy getStrategy() {
        return strategy;
    }

    public String getErrorMessage() {
        if (this.previous == null) {
            return "Undefined 'AdProgressChecker' error";
        }
        String error = String.format("The ad '%s' has been stuck on the AD_PROGRESS at second %f of %f more than %d times, out of the %d allowed", this.previous.getAdId(), this.previous.getCurrentTime(), this.previous.getDuration(), this.repeatCounter, this.repeatThreshold);
        return error;
    }
}

