/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.ads.ima.ImaSDK;

import android.content.Context;
import android.media.MediaPlayer;
import android.util.Log;
import android.widget.VideoView;
import com.google.ads.interactivemedia.v3.api.player.AdMediaInfo;
import com.google.ads.interactivemedia.v3.api.player.VideoAdPlayer;
import com.google.ads.interactivemedia.v3.api.player.VideoProgressUpdate;
import java.util.ArrayList;
import java.util.List;

public class AdsVideoView
extends VideoView
implements MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnPreparedListener {
    private final List<VideoAdPlayer.VideoAdPlayerCallback> mAdCallbacks = new ArrayList<VideoAdPlayer.VideoAdPlayerCallback>(1);
    private TrackingVideoCallback mCompleteCallback = null;
    private PlaybackState mPlayBackState = PlaybackState.STOPPED;
    public AdMediaInfo adMediaInfo;
    private int mVideoWidth = 0;
    private int mVideoHeight = 0;

    public AdsVideoView(Context context) {
        super(context);
        super.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
        super.setOnErrorListener((MediaPlayer.OnErrorListener)this);
        super.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
        this.setZOrderOnTop(true);
        this.setZOrderMediaOverlay(true);
        this.setEnabled(false);
    }

    public void onAdProgressChanged(VideoProgressUpdate adProgress) {
        for (VideoAdPlayer.VideoAdPlayerCallback callback : this.mAdCallbacks) {
            callback.onAdProgress(this.adMediaInfo, adProgress);
        }
    }

    public void onContentComplete() {
        for (VideoAdPlayer.VideoAdPlayerCallback callback : this.mAdCallbacks) {
            callback.onContentComplete();
        }
    }

    public void onCompletion(MediaPlayer mp) {
        this.onStop();
        for (VideoAdPlayer.VideoAdPlayerCallback callback : this.mAdCallbacks) {
            callback.onEnded(this.adMediaInfo);
        }
        if (this.mCompleteCallback != null) {
            this.mCompleteCallback.onComplete();
        }
    }

    public boolean onError(MediaPlayer mp, int what, int extra) {
        for (VideoAdPlayer.VideoAdPlayerCallback callback : this.mAdCallbacks) {
            callback.onError(this.adMediaInfo);
        }
        this.onStop();
        if (this.mCompleteCallback != null) {
            this.mCompleteCallback.onVideoError();
        }
        return true;
    }

    public void onPrepared(MediaPlayer mp) {
        this.mVideoWidth = mp.getVideoWidth();
        this.mVideoHeight = mp.getVideoHeight();
        this.forceLayout();
        this.invalidate();
        if (this.mCompleteCallback != null) {
            this.mCompleteCallback.onVideoPrepared();
        }
    }

    public void addCallback(VideoAdPlayer.VideoAdPlayerCallback callback) {
        this.mAdCallbacks.add(callback);
    }

    public void removeCallback(VideoAdPlayer.VideoAdPlayerCallback callback) {
        this.mAdCallbacks.remove(callback);
    }

    public void setOnCompletionListener(MediaPlayer.OnCompletionListener l) {
        throw new UnsupportedOperationException();
    }

    public void setmCompleteCallback(TrackingVideoCallback callback) {
        this.mCompleteCallback = callback;
    }

    public void stopPlayback() {
        super.stopPlayback();
        this.onStop();
    }

    public int getVideoWidth() {
        return this.mVideoWidth;
    }

    public int getVideoHeight() {
        return this.mVideoHeight;
    }

    private void onStop() {
        if (this.mPlayBackState == PlaybackState.STOPPED) {
            return;
        }
        this.mPlayBackState = PlaybackState.STOPPED;
    }

    public void togglePlayback() {
        switch (this.mPlayBackState) {
            case STOPPED: 
            case PAUSED: {
                this.play();
                break;
            }
            case PLAYING: {
                this.pause();
            }
        }
    }

    public void play() {
        super.start();
        PlaybackState oldState = this.mPlayBackState;
        this.mPlayBackState = PlaybackState.PLAYING;
        switch (oldState) {
            case STOPPED: {
                for (VideoAdPlayer.VideoAdPlayerCallback callback : this.mAdCallbacks) {
                    callback.onPlay(this.adMediaInfo);
                }
                break;
            }
            case PAUSED: {
                for (VideoAdPlayer.VideoAdPlayerCallback callback : this.mAdCallbacks) {
                    callback.onResume(this.adMediaInfo);
                }
                break;
            }
        }
    }

    public void pause() {
        super.pause();
        this.mPlayBackState = PlaybackState.PAUSED;
        for (VideoAdPlayer.VideoAdPlayerCallback callback : this.mAdCallbacks) {
            callback.onPause(this.adMediaInfo);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        Log.i((String)"@@@", (String)"onMeasureview");
        int width = AdsVideoView.getDefaultSize((int)this.mVideoWidth, (int)widthMeasureSpec);
        int height = AdsVideoView.getDefaultSize((int)this.mVideoHeight, (int)heightMeasureSpec);
        if (this.mVideoWidth > 0 && this.mVideoHeight > 0) {
            if (this.mVideoWidth * height > width * this.mVideoHeight) {
                height = width * this.mVideoHeight / this.mVideoWidth;
            } else if (this.mVideoWidth * height < width * this.mVideoHeight) {
                width = height * this.mVideoWidth / this.mVideoHeight;
            }
        }
        this.setMeasuredDimension(width, height);
    }

    public static interface TrackingVideoCallback {
        public void onComplete();

        public void onVideoPrepared();

        public void onVideoError();
    }

    private static enum PlaybackState {
        STOPPED,
        PAUSED,
        PLAYING;

    }
}

