/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.text.webvtt;

import com.akamai.amp.exoplayer2.text.Cue;
import com.akamai.amp.exoplayer2.text.Subtitle;
import com.akamai.amp.exoplayer2.text.webvtt.WebvttCueInfo;
import com.akamai.amp.exoplayer2.util.Assertions;
import com.akamai.amp.exoplayer2.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class WebvttSubtitle
implements Subtitle {
    private final List<WebvttCueInfo> cueInfos;
    private final long[] cueTimesUs;
    private final long[] sortedCueTimesUs;

    public WebvttSubtitle(List<WebvttCueInfo> cueInfos) {
        this.cueInfos = Collections.unmodifiableList(new ArrayList<WebvttCueInfo>(cueInfos));
        this.cueTimesUs = new long[2 * cueInfos.size()];
        for (int cueIndex = 0; cueIndex < cueInfos.size(); ++cueIndex) {
            WebvttCueInfo cueInfo = cueInfos.get(cueIndex);
            int arrayIndex = cueIndex * 2;
            this.cueTimesUs[arrayIndex] = cueInfo.startTimeUs;
            this.cueTimesUs[arrayIndex + 1] = cueInfo.endTimeUs;
        }
        this.sortedCueTimesUs = Arrays.copyOf(this.cueTimesUs, this.cueTimesUs.length);
        Arrays.sort(this.sortedCueTimesUs);
    }

    @Override
    public int getNextEventTimeIndex(long timeUs) {
        int index = Util.binarySearchCeil(this.sortedCueTimesUs, timeUs, false, false);
        return index < this.sortedCueTimesUs.length ? index : -1;
    }

    @Override
    public int getEventTimeCount() {
        return this.sortedCueTimesUs.length;
    }

    @Override
    public long getEventTime(int index) {
        Assertions.checkArgument(index >= 0);
        Assertions.checkArgument(index < this.sortedCueTimesUs.length);
        return this.sortedCueTimesUs[index];
    }

    @Override
    public List<Cue> getCues(long timeUs) {
        int i;
        ArrayList<Cue> currentCues = new ArrayList<Cue>();
        ArrayList<WebvttCueInfo> cuesWithUnsetLine = new ArrayList<WebvttCueInfo>();
        for (i = 0; i < this.cueInfos.size(); ++i) {
            if (this.cueTimesUs[i * 2] > timeUs || timeUs >= this.cueTimesUs[i * 2 + 1]) continue;
            WebvttCueInfo cueInfo = this.cueInfos.get(i);
            if (cueInfo.cue.line == -3.4028235E38f) {
                cuesWithUnsetLine.add(cueInfo);
                continue;
            }
            currentCues.add(cueInfo.cue);
        }
        Collections.sort(cuesWithUnsetLine, (c1, c2) -> Long.compare(c1.startTimeUs, c2.startTimeUs));
        for (i = 0; i < cuesWithUnsetLine.size(); ++i) {
            Cue cue = ((WebvttCueInfo)cuesWithUnsetLine.get((int)i)).cue;
            currentCues.add(cue.buildUpon().setLine(-1 - i, 1).build());
        }
        return currentCues;
    }
}

