/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.mediacodec;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaCrypto;
import android.media.MediaCryptoException;
import android.media.MediaFormat;
import android.os.Bundle;
import android.os.SystemClock;
import androidx.annotation.CallSuper;
import androidx.annotation.CheckResult;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.akamai.amp.exoplayer2.BaseRenderer;
import com.akamai.amp.exoplayer2.C;
import com.akamai.amp.exoplayer2.ExoPlaybackException;
import com.akamai.amp.exoplayer2.Format;
import com.akamai.amp.exoplayer2.FormatHolder;
import com.akamai.amp.exoplayer2.decoder.DecoderCounters;
import com.akamai.amp.exoplayer2.decoder.DecoderInputBuffer;
import com.akamai.amp.exoplayer2.drm.DrmSession;
import com.akamai.amp.exoplayer2.drm.ExoMediaCrypto;
import com.akamai.amp.exoplayer2.drm.FrameworkMediaCrypto;
import com.akamai.amp.exoplayer2.mediacodec.AsynchronousMediaCodecAdapter;
import com.akamai.amp.exoplayer2.mediacodec.BatchBuffer;
import com.akamai.amp.exoplayer2.mediacodec.C2Mp3TimestampTracker;
import com.akamai.amp.exoplayer2.mediacodec.MediaCodecAdapter;
import com.akamai.amp.exoplayer2.mediacodec.MediaCodecDecoderException;
import com.akamai.amp.exoplayer2.mediacodec.MediaCodecInfo;
import com.akamai.amp.exoplayer2.mediacodec.MediaCodecSelector;
import com.akamai.amp.exoplayer2.mediacodec.MediaCodecUtil;
import com.akamai.amp.exoplayer2.mediacodec.SynchronousMediaCodecAdapter;
import com.akamai.amp.exoplayer2.util.Assertions;
import com.akamai.amp.exoplayer2.util.Log;
import com.akamai.amp.exoplayer2.util.NalUnitUtil;
import com.akamai.amp.exoplayer2.util.TimedValueQueue;
import com.akamai.amp.exoplayer2.util.TraceUtil;
import com.akamai.amp.exoplayer2.util.Util;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;

public abstract class MediaCodecRenderer
extends BaseRenderer {
    public static final int OPERATION_MODE_SYNCHRONOUS = 0;
    public static final int OPERATION_MODE_ASYNCHRONOUS_DEDICATED_THREAD = 2;
    public static final int OPERATION_MODE_ASYNCHRONOUS_DEDICATED_THREAD_ASYNCHRONOUS_QUEUEING = 4;
    protected static final float CODEC_OPERATING_RATE_UNSET = -1.0f;
    private static final String TAG = "MediaCodecRenderer";
    private static final long MAX_CODEC_HOTSWAP_TIME_MS = 1000L;
    private static final int MAX_PENDING_OUTPUT_STREAM_OFFSET_COUNT = 10;
    protected static final int KEEP_CODEC_RESULT_NO = 0;
    protected static final int KEEP_CODEC_RESULT_YES_WITH_FLUSH = 1;
    protected static final int KEEP_CODEC_RESULT_YES_WITH_RECONFIGURATION = 2;
    protected static final int KEEP_CODEC_RESULT_YES_WITHOUT_RECONFIGURATION = 3;
    private static final int RECONFIGURATION_STATE_NONE = 0;
    private static final int RECONFIGURATION_STATE_WRITE_PENDING = 1;
    private static final int RECONFIGURATION_STATE_QUEUE_PENDING = 2;
    private static final int DRAIN_STATE_NONE = 0;
    private static final int DRAIN_STATE_SIGNAL_END_OF_STREAM = 1;
    private static final int DRAIN_STATE_WAIT_END_OF_STREAM = 2;
    private static final int DRAIN_ACTION_NONE = 0;
    private static final int DRAIN_ACTION_FLUSH = 1;
    private static final int DRAIN_ACTION_UPDATE_DRM_SESSION = 2;
    private static final int DRAIN_ACTION_REINITIALIZE = 3;
    private static final int ADAPTATION_WORKAROUND_MODE_NEVER = 0;
    private static final int ADAPTATION_WORKAROUND_MODE_SAME_RESOLUTION = 1;
    private static final int ADAPTATION_WORKAROUND_MODE_ALWAYS = 2;
    private static final byte[] ADAPTATION_WORKAROUND_BUFFER = new byte[]{0, 0, 1, 103, 66, -64, 11, -38, 37, -112, 0, 0, 1, 104, -50, 15, 19, 32, 0, 0, 1, 101, -120, -124, 13, -50, 113, 24, -96, 0, 47, -65, 28, 49, -61, 39, 93, 120};
    private static final int ADAPTATION_WORKAROUND_SLICE_WIDTH_HEIGHT = 32;
    private final MediaCodecSelector mediaCodecSelector;
    private final boolean enableDecoderFallback;
    private final float assumedMinimumCodecOperatingRate;
    private final DecoderInputBuffer buffer;
    private final DecoderInputBuffer flagsOnlyBuffer;
    private final BatchBuffer bypassBatchBuffer;
    private final TimedValueQueue<Format> formatQueue;
    private final ArrayList<Long> decodeOnlyPresentationTimestamps;
    private final MediaCodec.BufferInfo outputBufferInfo;
    private final long[] pendingOutputStreamStartPositionsUs;
    private final long[] pendingOutputStreamOffsetsUs;
    private final long[] pendingOutputStreamSwitchTimesUs;
    @Nullable
    private Format inputFormat;
    @Nullable
    private Format outputFormat;
    @Nullable
    private DrmSession codecDrmSession;
    @Nullable
    private DrmSession sourceDrmSession;
    @Nullable
    private MediaCrypto mediaCrypto;
    private boolean mediaCryptoRequiresSecureDecoder;
    private long renderTimeLimitMs;
    private float operatingRate;
    @Nullable
    private MediaCodec codec;
    @Nullable
    private MediaCodecAdapter codecAdapter;
    @Nullable
    private Format codecInputFormat;
    @Nullable
    private MediaFormat codecOutputMediaFormat;
    private boolean codecOutputMediaFormatChanged;
    private float codecOperatingRate;
    @Nullable
    private ArrayDeque<MediaCodecInfo> availableCodecInfos;
    @Nullable
    private DecoderInitializationException preferredDecoderInitializationException;
    @Nullable
    private MediaCodecInfo codecInfo;
    private int codecAdaptationWorkaroundMode;
    private boolean codecNeedsReconfigureWorkaround;
    private boolean codecNeedsDiscardToSpsWorkaround;
    private boolean codecNeedsFlushWorkaround;
    private boolean codecNeedsSosFlushWorkaround;
    private boolean codecNeedsEosFlushWorkaround;
    private boolean codecNeedsEosOutputExceptionWorkaround;
    private boolean codecNeedsMonoChannelCountWorkaround;
    private boolean codecNeedsAdaptationWorkaroundBuffer;
    private boolean shouldSkipAdaptationWorkaroundOutputBuffer;
    private boolean codecNeedsEosPropagation;
    @Nullable
    private C2Mp3TimestampTracker c2Mp3TimestampTracker;
    private ByteBuffer[] inputBuffers;
    private ByteBuffer[] outputBuffers;
    private long codecHotswapDeadlineMs;
    private int inputIndex;
    private int outputIndex;
    @Nullable
    private ByteBuffer outputBuffer;
    private boolean isDecodeOnlyOutputBuffer;
    private boolean isLastOutputBuffer;
    private boolean bypassEnabled;
    private boolean bypassDrainAndReinitialize;
    private boolean codecReconfigured;
    private int codecReconfigurationState;
    private int codecDrainState;
    private int codecDrainAction;
    private boolean codecReceivedBuffers;
    private boolean codecReceivedEos;
    private boolean codecHasOutputMediaFormat;
    private long largestQueuedPresentationTimeUs;
    private long lastBufferInStreamPresentationTimeUs;
    private boolean inputStreamEnded;
    private boolean outputStreamEnded;
    private boolean waitingForFirstSampleInFormat;
    private boolean pendingOutputEndOfStream;
    private int mediaCodecOperationMode;
    @Nullable
    private ExoPlaybackException pendingPlaybackException;
    protected DecoderCounters decoderCounters;
    private long outputStreamStartPositionUs;
    private long outputStreamOffsetUs;
    private int pendingOutputStreamOffsetCount;

    public MediaCodecRenderer(int trackType, MediaCodecSelector mediaCodecSelector, boolean enableDecoderFallback, float assumedMinimumCodecOperatingRate) {
        super(trackType);
        this.mediaCodecSelector = Assertions.checkNotNull(mediaCodecSelector);
        this.enableDecoderFallback = enableDecoderFallback;
        this.assumedMinimumCodecOperatingRate = assumedMinimumCodecOperatingRate;
        this.buffer = new DecoderInputBuffer(0);
        this.flagsOnlyBuffer = DecoderInputBuffer.newFlagsOnlyInstance();
        this.formatQueue = new TimedValueQueue();
        this.decodeOnlyPresentationTimestamps = new ArrayList();
        this.outputBufferInfo = new MediaCodec.BufferInfo();
        this.operatingRate = 1.0f;
        this.mediaCodecOperationMode = 0;
        this.renderTimeLimitMs = -9223372036854775807L;
        this.pendingOutputStreamStartPositionsUs = new long[10];
        this.pendingOutputStreamOffsetsUs = new long[10];
        this.pendingOutputStreamSwitchTimesUs = new long[10];
        this.outputStreamStartPositionUs = -9223372036854775807L;
        this.outputStreamOffsetUs = -9223372036854775807L;
        this.bypassBatchBuffer = new BatchBuffer();
        this.bypassBatchBuffer.ensureSpaceForWrite(0);
        this.bypassBatchBuffer.data.order(ByteOrder.nativeOrder());
        this.resetCodecStateForRelease();
    }

    public void setRenderTimeLimitMs(long renderTimeLimitMs) {
        this.renderTimeLimitMs = renderTimeLimitMs;
    }

    public void experimentalSetMediaCodecOperationMode(int mode) {
        this.mediaCodecOperationMode = mode;
    }

    @Override
    public final int supportsMixedMimeTypeAdaptation() {
        return 8;
    }

    @Override
    public final int supportsFormat(Format format) throws ExoPlaybackException {
        try {
            return this.supportsFormat(this.mediaCodecSelector, format);
        }
        catch (MediaCodecUtil.DecoderQueryException e) {
            throw this.createRendererException(e, format);
        }
    }

    protected abstract int supportsFormat(MediaCodecSelector var1, Format var2) throws MediaCodecUtil.DecoderQueryException;

    protected abstract List<MediaCodecInfo> getDecoderInfos(MediaCodecSelector var1, Format var2, boolean var3) throws MediaCodecUtil.DecoderQueryException;

    protected abstract void configureCodec(MediaCodecInfo var1, MediaCodecAdapter var2, Format var3, @Nullable MediaCrypto var4, float var5);

    protected final void maybeInitCodecOrBypass() throws ExoPlaybackException {
        if (this.codec != null || this.bypassEnabled || this.inputFormat == null) {
            return;
        }
        if (this.sourceDrmSession == null && this.shouldUseBypass(this.inputFormat)) {
            this.initBypass(this.inputFormat);
            return;
        }
        this.setCodecDrmSession(this.sourceDrmSession);
        String mimeType = this.inputFormat.sampleMimeType;
        if (this.codecDrmSession != null) {
            if (this.mediaCrypto == null) {
                FrameworkMediaCrypto sessionMediaCrypto = this.getFrameworkMediaCrypto(this.codecDrmSession);
                if (sessionMediaCrypto == null) {
                    DrmSession.DrmSessionException drmError = this.codecDrmSession.getError();
                    if (drmError == null) {
                        return;
                    }
                } else {
                    try {
                        this.mediaCrypto = new MediaCrypto(sessionMediaCrypto.uuid, sessionMediaCrypto.sessionId);
                    }
                    catch (MediaCryptoException e) {
                        throw this.createRendererException((Exception)((Object)e), this.inputFormat);
                    }
                    boolean bl = this.mediaCryptoRequiresSecureDecoder = !sessionMediaCrypto.forceAllowInsecureDecoderComponents && this.mediaCrypto.requiresSecureDecoderComponent(mimeType);
                }
            }
            if (FrameworkMediaCrypto.WORKAROUND_DEVICE_NEEDS_KEYS_TO_CONFIGURE_CODEC) {
                int drmSessionState = this.codecDrmSession.getState();
                if (drmSessionState == 1) {
                    throw this.createRendererException(this.codecDrmSession.getError(), this.inputFormat);
                }
                if (drmSessionState != 4) {
                    return;
                }
            }
        }
        try {
            this.maybeInitCodecWithFallback(this.mediaCrypto, this.mediaCryptoRequiresSecureDecoder);
        }
        catch (DecoderInitializationException e) {
            throw this.createRendererException(e, this.inputFormat);
        }
    }

    protected boolean shouldUseBypass(Format format) {
        return false;
    }

    protected boolean shouldInitCodec(MediaCodecInfo codecInfo) {
        return true;
    }

    protected boolean getCodecNeedsEosPropagation() {
        return false;
    }

    protected final void setPendingPlaybackException(ExoPlaybackException exception) {
        this.pendingPlaybackException = exception;
    }

    protected final void updateOutputFormatForTime(long presentationTimeUs) throws ExoPlaybackException {
        boolean outputFormatChanged = false;
        Format format = this.formatQueue.pollFloor(presentationTimeUs);
        if (format == null && this.codecOutputMediaFormatChanged) {
            format = this.formatQueue.pollFirst();
        }
        if (format != null) {
            this.outputFormat = format;
            outputFormatChanged = true;
        }
        if (outputFormatChanged || this.codecOutputMediaFormatChanged && this.outputFormat != null) {
            this.onOutputFormatChanged(this.outputFormat, this.codecOutputMediaFormat);
            this.codecOutputMediaFormatChanged = false;
        }
    }

    @Nullable
    protected Format getInputFormat() {
        return this.inputFormat;
    }

    @Nullable
    protected final Format getOutputFormat() {
        return this.outputFormat;
    }

    @Nullable
    protected final MediaCodec getCodec() {
        return this.codec;
    }

    @Nullable
    protected final MediaFormat getCodecOutputMediaFormat() {
        return this.codecOutputMediaFormat;
    }

    @Nullable
    protected final MediaCodecInfo getCodecInfo() {
        return this.codecInfo;
    }

    @Override
    protected void onEnabled(boolean joining, boolean mayRenderStartOfStream) throws ExoPlaybackException {
        this.decoderCounters = new DecoderCounters();
    }

    @Override
    protected void onStreamChanged(Format[] formats, long startPositionUs, long offsetUs) throws ExoPlaybackException {
        if (this.outputStreamOffsetUs == -9223372036854775807L) {
            Assertions.checkState(this.outputStreamStartPositionUs == -9223372036854775807L);
            this.outputStreamStartPositionUs = startPositionUs;
            this.outputStreamOffsetUs = offsetUs;
        } else {
            if (this.pendingOutputStreamOffsetCount == this.pendingOutputStreamOffsetsUs.length) {
                Log.w(TAG, "Too many stream changes, so dropping offset: " + this.pendingOutputStreamOffsetsUs[this.pendingOutputStreamOffsetCount - 1]);
            } else {
                ++this.pendingOutputStreamOffsetCount;
            }
            this.pendingOutputStreamStartPositionsUs[this.pendingOutputStreamOffsetCount - 1] = startPositionUs;
            this.pendingOutputStreamOffsetsUs[this.pendingOutputStreamOffsetCount - 1] = offsetUs;
            this.pendingOutputStreamSwitchTimesUs[this.pendingOutputStreamOffsetCount - 1] = this.largestQueuedPresentationTimeUs;
        }
    }

    @Override
    protected void onPositionReset(long positionUs, boolean joining) throws ExoPlaybackException {
        this.inputStreamEnded = false;
        this.outputStreamEnded = false;
        this.pendingOutputEndOfStream = false;
        if (this.bypassEnabled) {
            this.bypassBatchBuffer.flush();
        } else {
            this.flushOrReinitializeCodec();
        }
        if (this.formatQueue.size() > 0) {
            this.waitingForFirstSampleInFormat = true;
        }
        this.formatQueue.clear();
        if (this.pendingOutputStreamOffsetCount != 0) {
            this.outputStreamOffsetUs = this.pendingOutputStreamOffsetsUs[this.pendingOutputStreamOffsetCount - 1];
            this.outputStreamStartPositionUs = this.pendingOutputStreamStartPositionsUs[this.pendingOutputStreamOffsetCount - 1];
            this.pendingOutputStreamOffsetCount = 0;
        }
    }

    @Override
    public void setOperatingRate(float operatingRate) throws ExoPlaybackException {
        this.operatingRate = operatingRate;
        if (this.codec != null && this.codecDrainAction != 3 && this.getState() != 0) {
            this.updateCodecOperatingRate();
        }
    }

    @Override
    protected void onDisabled() {
        this.inputFormat = null;
        this.outputStreamStartPositionUs = -9223372036854775807L;
        this.outputStreamOffsetUs = -9223372036854775807L;
        this.pendingOutputStreamOffsetCount = 0;
        if (this.sourceDrmSession != null || this.codecDrmSession != null) {
            this.onReset();
        } else {
            this.flushOrReleaseCodec();
        }
    }

    @Override
    protected void onReset() {
        try {
            this.disableBypass();
            this.releaseCodec();
        }
        finally {
            this.setSourceDrmSession(null);
        }
    }

    private void disableBypass() {
        this.bypassDrainAndReinitialize = false;
        this.bypassBatchBuffer.clear();
        this.bypassEnabled = false;
    }

    protected void releaseCodec() {
        try {
            if (this.codecAdapter != null) {
                this.codecAdapter.shutdown();
            }
            if (this.codec != null) {
                ++this.decoderCounters.decoderReleaseCount;
                this.codec.release();
            }
        }
        finally {
            this.codec = null;
            this.codecAdapter = null;
            try {
                if (this.mediaCrypto != null) {
                    this.mediaCrypto.release();
                }
            }
            finally {
                this.mediaCrypto = null;
                this.setCodecDrmSession(null);
                this.resetCodecStateForRelease();
            }
        }
    }

    @Override
    protected void onStarted() {
    }

    @Override
    protected void onStopped() {
    }

    @Override
    public void render(long positionUs, long elapsedRealtimeUs) throws ExoPlaybackException {
        if (this.pendingOutputEndOfStream) {
            this.pendingOutputEndOfStream = false;
            this.processEndOfStream();
        }
        if (this.pendingPlaybackException != null) {
            ExoPlaybackException playbackException = this.pendingPlaybackException;
            this.pendingPlaybackException = null;
            throw playbackException;
        }
        try {
            if (this.outputStreamEnded) {
                this.renderToEndOfStream();
                return;
            }
            if (this.inputFormat == null && !this.readToFlagsOnlyBuffer(true)) {
                return;
            }
            this.maybeInitCodecOrBypass();
            if (this.bypassEnabled) {
                TraceUtil.beginSection("bypassRender");
                while (this.bypassRender(positionUs, elapsedRealtimeUs)) {
                }
                TraceUtil.endSection();
            } else if (this.codec != null) {
                long renderStartTimeMs = SystemClock.elapsedRealtime();
                TraceUtil.beginSection("drainAndFeed");
                while (this.drainOutputBuffer(positionUs, elapsedRealtimeUs) && this.shouldContinueRendering(renderStartTimeMs)) {
                }
                while (this.feedInputBuffer() && this.shouldContinueRendering(renderStartTimeMs)) {
                }
                TraceUtil.endSection();
            } else {
                this.decoderCounters.skippedInputBufferCount += this.skipSource(positionUs);
                this.readToFlagsOnlyBuffer(false);
            }
            this.decoderCounters.ensureUpdated();
        }
        catch (IllegalStateException e) {
            if (MediaCodecRenderer.isMediaCodecException(e)) {
                throw this.createRendererException(this.createDecoderException(e, this.getCodecInfo()), this.inputFormat);
            }
            throw e;
        }
    }

    protected final boolean flushOrReinitializeCodec() throws ExoPlaybackException {
        boolean released = this.flushOrReleaseCodec();
        if (released) {
            this.maybeInitCodecOrBypass();
        }
        return released;
    }

    protected boolean flushOrReleaseCodec() {
        if (this.codec == null) {
            return false;
        }
        if (this.codecDrainAction == 3 || this.codecNeedsFlushWorkaround || this.codecNeedsSosFlushWorkaround && !this.codecHasOutputMediaFormat || this.codecNeedsEosFlushWorkaround && this.codecReceivedEos) {
            this.releaseCodec();
            return true;
        }
        try {
            this.codecAdapter.flush();
        }
        finally {
            this.resetCodecStateForFlush();
        }
        return false;
    }

    @CallSuper
    protected void resetCodecStateForFlush() {
        this.resetInputBuffer();
        this.resetOutputBuffer();
        this.codecHotswapDeadlineMs = -9223372036854775807L;
        this.codecReceivedEos = false;
        this.codecReceivedBuffers = false;
        this.codecNeedsAdaptationWorkaroundBuffer = false;
        this.shouldSkipAdaptationWorkaroundOutputBuffer = false;
        this.isDecodeOnlyOutputBuffer = false;
        this.isLastOutputBuffer = false;
        this.decodeOnlyPresentationTimestamps.clear();
        this.largestQueuedPresentationTimeUs = -9223372036854775807L;
        this.lastBufferInStreamPresentationTimeUs = -9223372036854775807L;
        if (this.c2Mp3TimestampTracker != null) {
            this.c2Mp3TimestampTracker.reset();
        }
        this.codecDrainState = 0;
        this.codecDrainAction = 0;
        this.codecReconfigurationState = this.codecReconfigured ? 1 : 0;
    }

    @CallSuper
    protected void resetCodecStateForRelease() {
        this.resetCodecStateForFlush();
        this.pendingPlaybackException = null;
        this.c2Mp3TimestampTracker = null;
        this.availableCodecInfos = null;
        this.codecInfo = null;
        this.codecInputFormat = null;
        this.codecOutputMediaFormat = null;
        this.codecOutputMediaFormatChanged = false;
        this.codecHasOutputMediaFormat = false;
        this.codecOperatingRate = -1.0f;
        this.codecAdaptationWorkaroundMode = 0;
        this.codecNeedsReconfigureWorkaround = false;
        this.codecNeedsDiscardToSpsWorkaround = false;
        this.codecNeedsFlushWorkaround = false;
        this.codecNeedsSosFlushWorkaround = false;
        this.codecNeedsEosFlushWorkaround = false;
        this.codecNeedsEosOutputExceptionWorkaround = false;
        this.codecNeedsMonoChannelCountWorkaround = false;
        this.codecNeedsEosPropagation = false;
        this.codecReconfigured = false;
        this.codecReconfigurationState = 0;
        this.resetCodecBuffers();
        this.mediaCryptoRequiresSecureDecoder = false;
    }

    protected MediaCodecDecoderException createDecoderException(Throwable cause, @Nullable MediaCodecInfo codecInfo) {
        return new MediaCodecDecoderException(cause, codecInfo);
    }

    private boolean readToFlagsOnlyBuffer(boolean requireFormat) throws ExoPlaybackException {
        FormatHolder formatHolder = this.getFormatHolder();
        this.flagsOnlyBuffer.clear();
        int result = this.readSource(formatHolder, this.flagsOnlyBuffer, requireFormat);
        if (result == -5) {
            this.onInputFormatChanged(formatHolder);
            return true;
        }
        if (result == -4 && this.flagsOnlyBuffer.isEndOfStream()) {
            this.inputStreamEnded = true;
            this.processEndOfStream();
        }
        return false;
    }

    private void maybeInitCodecWithFallback(MediaCrypto crypto, boolean mediaCryptoRequiresSecureDecoder) throws DecoderInitializationException {
        if (this.availableCodecInfos == null) {
            try {
                List<MediaCodecInfo> allAvailableCodecInfos = this.getAvailableCodecInfos(mediaCryptoRequiresSecureDecoder);
                this.availableCodecInfos = new ArrayDeque();
                if (this.enableDecoderFallback) {
                    this.availableCodecInfos.addAll(allAvailableCodecInfos);
                } else if (!allAvailableCodecInfos.isEmpty()) {
                    this.availableCodecInfos.add(allAvailableCodecInfos.get(0));
                }
                this.preferredDecoderInitializationException = null;
            }
            catch (MediaCodecUtil.DecoderQueryException e) {
                throw new DecoderInitializationException(this.inputFormat, (Throwable)e, mediaCryptoRequiresSecureDecoder, -49998);
            }
        }
        if (this.availableCodecInfos.isEmpty()) {
            throw new DecoderInitializationException(this.inputFormat, null, mediaCryptoRequiresSecureDecoder, -49999);
        }
        while (this.codec == null) {
            MediaCodecInfo codecInfo = this.availableCodecInfos.peekFirst();
            if (!this.shouldInitCodec(codecInfo)) {
                return;
            }
            try {
                this.initCodec(codecInfo, crypto);
            }
            catch (Exception e) {
                Log.w(TAG, "Failed to initialize decoder: " + codecInfo, e);
                this.availableCodecInfos.removeFirst();
                DecoderInitializationException exception = new DecoderInitializationException(this.inputFormat, (Throwable)e, mediaCryptoRequiresSecureDecoder, codecInfo);
                this.preferredDecoderInitializationException = this.preferredDecoderInitializationException == null ? exception : this.preferredDecoderInitializationException.copyWithFallbackException(exception);
                if (!this.availableCodecInfos.isEmpty()) continue;
                throw this.preferredDecoderInitializationException;
            }
        }
        this.availableCodecInfos = null;
    }

    private List<MediaCodecInfo> getAvailableCodecInfos(boolean mediaCryptoRequiresSecureDecoder) throws MediaCodecUtil.DecoderQueryException {
        List<MediaCodecInfo> codecInfos = this.getDecoderInfos(this.mediaCodecSelector, this.inputFormat, mediaCryptoRequiresSecureDecoder);
        if (codecInfos.isEmpty() && mediaCryptoRequiresSecureDecoder && !(codecInfos = this.getDecoderInfos(this.mediaCodecSelector, this.inputFormat, false)).isEmpty()) {
            Log.w(TAG, "Drm session requires secure decoder for " + this.inputFormat.sampleMimeType + ", but no secure decoder available. Trying to proceed with " + codecInfos + ".");
        }
        return codecInfos;
    }

    private void initBypass(Format format) {
        this.disableBypass();
        String mimeType = format.sampleMimeType;
        if (!("audio/mp4a-latm".equals(mimeType) || "audio/mpeg".equals(mimeType) || "audio/opus".equals(mimeType))) {
            this.bypassBatchBuffer.setMaxAccessUnitCount(1);
        } else {
            this.bypassBatchBuffer.setMaxAccessUnitCount(32);
        }
        this.bypassEnabled = true;
    }

    private void initCodec(MediaCodecInfo codecInfo, MediaCrypto crypto) throws Exception {
        long codecInitializedTimestamp;
        long codecInitializingTimestamp;
        float codecOperatingRate;
        MediaCodec codec = null;
        String codecName = codecInfo.name;
        float f = codecOperatingRate = Util.SDK_INT < 23 ? -1.0f : this.getCodecOperatingRateV23(this.operatingRate, this.inputFormat, this.getStreamFormats());
        if (codecOperatingRate <= this.assumedMinimumCodecOperatingRate) {
            codecOperatingRate = -1.0f;
        }
        MediaCodecAdapter codecAdapter = null;
        try {
            codecInitializingTimestamp = SystemClock.elapsedRealtime();
            TraceUtil.beginSection("createCodec:" + codecName);
            codec = MediaCodec.createByCodecName((String)codecName);
            codecAdapter = this.mediaCodecOperationMode == 2 && Util.SDK_INT >= 23 ? new AsynchronousMediaCodecAdapter(codec, this.getTrackType()) : (this.mediaCodecOperationMode == 4 && Util.SDK_INT >= 23 ? new AsynchronousMediaCodecAdapter(codec, true, this.getTrackType()) : new SynchronousMediaCodecAdapter(codec));
            TraceUtil.endSection();
            TraceUtil.beginSection("configureCodec");
            this.configureCodec(codecInfo, codecAdapter, this.inputFormat, crypto, codecOperatingRate);
            TraceUtil.endSection();
            TraceUtil.beginSection("startCodec");
            codecAdapter.start();
            TraceUtil.endSection();
            codecInitializedTimestamp = SystemClock.elapsedRealtime();
            this.getCodecBuffers(codec);
        }
        catch (Exception e) {
            if (codecAdapter != null) {
                codecAdapter.shutdown();
            }
            if (codec != null) {
                this.resetCodecBuffers();
                codec.release();
            }
            throw e;
        }
        this.codec = codec;
        this.codecAdapter = codecAdapter;
        this.codecInfo = codecInfo;
        this.codecOperatingRate = codecOperatingRate;
        this.codecInputFormat = this.inputFormat;
        this.codecAdaptationWorkaroundMode = this.codecAdaptationWorkaroundMode(codecName);
        this.codecNeedsReconfigureWorkaround = MediaCodecRenderer.codecNeedsReconfigureWorkaround(codecName);
        this.codecNeedsDiscardToSpsWorkaround = MediaCodecRenderer.codecNeedsDiscardToSpsWorkaround(codecName, this.codecInputFormat);
        this.codecNeedsFlushWorkaround = MediaCodecRenderer.codecNeedsFlushWorkaround(codecName);
        this.codecNeedsSosFlushWorkaround = MediaCodecRenderer.codecNeedsSosFlushWorkaround(codecName);
        this.codecNeedsEosFlushWorkaround = MediaCodecRenderer.codecNeedsEosFlushWorkaround(codecName);
        this.codecNeedsEosOutputExceptionWorkaround = MediaCodecRenderer.codecNeedsEosOutputExceptionWorkaround(codecName);
        this.codecNeedsMonoChannelCountWorkaround = MediaCodecRenderer.codecNeedsMonoChannelCountWorkaround(codecName, this.codecInputFormat);
        boolean bl = this.codecNeedsEosPropagation = MediaCodecRenderer.codecNeedsEosPropagationWorkaround(codecInfo) || this.getCodecNeedsEosPropagation();
        if ("c2.android.mp3.decoder".equals(codecInfo.name)) {
            this.c2Mp3TimestampTracker = new C2Mp3TimestampTracker();
        }
        if (this.getState() == 2) {
            this.codecHotswapDeadlineMs = SystemClock.elapsedRealtime() + 1000L;
        }
        ++this.decoderCounters.decoderInitCount;
        long elapsed = codecInitializedTimestamp - codecInitializingTimestamp;
        this.onCodecInitialized(codecName, codecInitializedTimestamp, elapsed);
    }

    private boolean shouldContinueRendering(long renderStartTimeMs) {
        return this.renderTimeLimitMs == -9223372036854775807L || SystemClock.elapsedRealtime() - renderStartTimeMs < this.renderTimeLimitMs;
    }

    private void getCodecBuffers(MediaCodec codec) {
        if (Util.SDK_INT < 21) {
            this.inputBuffers = codec.getInputBuffers();
            this.outputBuffers = codec.getOutputBuffers();
        }
    }

    private void resetCodecBuffers() {
        if (Util.SDK_INT < 21) {
            this.inputBuffers = null;
            this.outputBuffers = null;
        }
    }

    private ByteBuffer getInputBuffer(int inputIndex) {
        if (Util.SDK_INT >= 21) {
            return this.codec.getInputBuffer(inputIndex);
        }
        return this.inputBuffers[inputIndex];
    }

    @Nullable
    private ByteBuffer getOutputBuffer(int outputIndex) {
        if (Util.SDK_INT >= 21) {
            return this.codec.getOutputBuffer(outputIndex);
        }
        return this.outputBuffers[outputIndex];
    }

    private boolean hasOutputBuffer() {
        return this.outputIndex >= 0;
    }

    private void resetInputBuffer() {
        this.inputIndex = -1;
        this.buffer.data = null;
    }

    private void resetOutputBuffer() {
        this.outputIndex = -1;
        this.outputBuffer = null;
    }

    private void setSourceDrmSession(@Nullable DrmSession session) {
        DrmSession.replaceSession(this.sourceDrmSession, session);
        this.sourceDrmSession = session;
    }

    private void setCodecDrmSession(@Nullable DrmSession session) {
        DrmSession.replaceSession(this.codecDrmSession, session);
        this.codecDrmSession = session;
    }

    private boolean feedInputBuffer() throws ExoPlaybackException {
        if (this.codec == null || this.codecDrainState == 2 || this.inputStreamEnded) {
            return false;
        }
        if (this.inputIndex < 0) {
            this.inputIndex = this.codecAdapter.dequeueInputBufferIndex();
            if (this.inputIndex < 0) {
                return false;
            }
            this.buffer.data = this.getInputBuffer(this.inputIndex);
            this.buffer.clear();
        }
        if (this.codecDrainState == 1) {
            if (!this.codecNeedsEosPropagation) {
                this.codecReceivedEos = true;
                this.codecAdapter.queueInputBuffer(this.inputIndex, 0, 0, 0L, 4);
                this.resetInputBuffer();
            }
            this.codecDrainState = 2;
            return false;
        }
        if (this.codecNeedsAdaptationWorkaroundBuffer) {
            this.codecNeedsAdaptationWorkaroundBuffer = false;
            this.buffer.data.put(ADAPTATION_WORKAROUND_BUFFER);
            this.codecAdapter.queueInputBuffer(this.inputIndex, 0, ADAPTATION_WORKAROUND_BUFFER.length, 0L, 0);
            this.resetInputBuffer();
            this.codecReceivedBuffers = true;
            return true;
        }
        if (this.codecReconfigurationState == 1) {
            for (int i = 0; i < this.codecInputFormat.initializationData.size(); ++i) {
                byte[] data = this.codecInputFormat.initializationData.get(i);
                this.buffer.data.put(data);
            }
            this.codecReconfigurationState = 2;
        }
        int adaptiveReconfigurationBytes = this.buffer.data.position();
        FormatHolder formatHolder = this.getFormatHolder();
        int result = this.readSource(formatHolder, this.buffer, false);
        if (this.hasReadStreamToEnd()) {
            this.lastBufferInStreamPresentationTimeUs = this.largestQueuedPresentationTimeUs;
        }
        if (result == -3) {
            return false;
        }
        if (result == -5) {
            if (this.codecReconfigurationState == 2) {
                this.buffer.clear();
                this.codecReconfigurationState = 1;
            }
            this.onInputFormatChanged(formatHolder);
            return true;
        }
        if (this.buffer.isEndOfStream()) {
            if (this.codecReconfigurationState == 2) {
                this.buffer.clear();
                this.codecReconfigurationState = 1;
            }
            this.inputStreamEnded = true;
            if (!this.codecReceivedBuffers) {
                this.processEndOfStream();
                return false;
            }
            try {
                if (!this.codecNeedsEosPropagation) {
                    this.codecReceivedEos = true;
                    this.codecAdapter.queueInputBuffer(this.inputIndex, 0, 0, 0L, 4);
                    this.resetInputBuffer();
                }
            }
            catch (MediaCodec.CryptoException e) {
                throw this.createRendererException((Exception)((Object)e), this.inputFormat);
            }
            return false;
        }
        if (!this.codecReceivedBuffers && !this.buffer.isKeyFrame()) {
            this.buffer.clear();
            if (this.codecReconfigurationState == 2) {
                this.codecReconfigurationState = 1;
            }
            return true;
        }
        boolean bufferEncrypted = this.buffer.isEncrypted();
        if (bufferEncrypted) {
            this.buffer.cryptoInfo.increaseClearDataFirstSubSampleBy(adaptiveReconfigurationBytes);
        }
        if (this.codecNeedsDiscardToSpsWorkaround && !bufferEncrypted) {
            NalUnitUtil.discardToSps(this.buffer.data);
            if (this.buffer.data.position() == 0) {
                return true;
            }
            this.codecNeedsDiscardToSpsWorkaround = false;
        }
        long presentationTimeUs = this.buffer.timeUs;
        if (this.c2Mp3TimestampTracker != null) {
            presentationTimeUs = this.c2Mp3TimestampTracker.updateAndGetPresentationTimeUs(this.inputFormat, this.buffer);
        }
        if (this.buffer.isDecodeOnly()) {
            this.decodeOnlyPresentationTimestamps.add(presentationTimeUs);
        }
        if (this.waitingForFirstSampleInFormat) {
            this.formatQueue.add(presentationTimeUs, this.inputFormat);
            this.waitingForFirstSampleInFormat = false;
        }
        this.largestQueuedPresentationTimeUs = this.c2Mp3TimestampTracker != null ? Math.max(this.largestQueuedPresentationTimeUs, this.buffer.timeUs) : Math.max(this.largestQueuedPresentationTimeUs, presentationTimeUs);
        this.buffer.flip();
        if (this.buffer.hasSupplementalData()) {
            this.handleInputBufferSupplementalData(this.buffer);
        }
        this.onQueueInputBuffer(this.buffer);
        try {
            if (bufferEncrypted) {
                this.codecAdapter.queueSecureInputBuffer(this.inputIndex, 0, this.buffer.cryptoInfo, presentationTimeUs, 0);
            } else {
                this.codecAdapter.queueInputBuffer(this.inputIndex, 0, this.buffer.data.limit(), presentationTimeUs, 0);
            }
        }
        catch (MediaCodec.CryptoException e) {
            throw this.createRendererException((Exception)((Object)e), this.inputFormat);
        }
        this.resetInputBuffer();
        this.codecReceivedBuffers = true;
        this.codecReconfigurationState = 0;
        ++this.decoderCounters.inputBufferCount;
        return true;
    }

    protected void onCodecInitialized(String name, long initializedTimestampMs, long initializationDurationMs) {
    }

    @CallSuper
    protected void onInputFormatChanged(FormatHolder formatHolder) throws ExoPlaybackException {
        this.waitingForFirstSampleInFormat = true;
        Format newFormat = Assertions.checkNotNull(formatHolder.format);
        if (newFormat.sampleMimeType == null) {
            throw this.createRendererException(new IllegalArgumentException(), newFormat);
        }
        this.setSourceDrmSession(formatHolder.drmSession);
        this.inputFormat = newFormat;
        if (this.bypassEnabled) {
            this.bypassDrainAndReinitialize = true;
            return;
        }
        if (this.codec == null) {
            if (!this.legacyKeepAvailableCodecInfosWithoutCodec()) {
                this.availableCodecInfos = null;
            }
            this.maybeInitCodecOrBypass();
            return;
        }
        if (this.sourceDrmSession == null && this.codecDrmSession != null || this.sourceDrmSession != null && this.codecDrmSession == null || this.sourceDrmSession != this.codecDrmSession && !this.codecInfo.secure && this.maybeRequiresSecureDecoder(this.sourceDrmSession, newFormat) || Util.SDK_INT < 23 && this.sourceDrmSession != this.codecDrmSession) {
            this.drainAndReinitializeCodec();
            return;
        }
        switch (this.canKeepCodec(this.codec, this.codecInfo, this.codecInputFormat, newFormat)) {
            case 0: {
                this.drainAndReinitializeCodec();
                break;
            }
            case 1: {
                this.codecInputFormat = newFormat;
                this.updateCodecOperatingRate();
                if (this.sourceDrmSession != this.codecDrmSession) {
                    this.drainAndUpdateCodecDrmSession();
                    break;
                }
                this.drainAndFlushCodec();
                break;
            }
            case 2: {
                if (this.codecNeedsReconfigureWorkaround) {
                    this.drainAndReinitializeCodec();
                    break;
                }
                this.codecReconfigured = true;
                this.codecReconfigurationState = 1;
                this.codecNeedsAdaptationWorkaroundBuffer = this.codecAdaptationWorkaroundMode == 2 || this.codecAdaptationWorkaroundMode == 1 && newFormat.width == this.codecInputFormat.width && newFormat.height == this.codecInputFormat.height;
                this.codecInputFormat = newFormat;
                this.updateCodecOperatingRate();
                if (this.sourceDrmSession == this.codecDrmSession) break;
                this.drainAndUpdateCodecDrmSession();
                break;
            }
            case 3: {
                this.codecInputFormat = newFormat;
                this.updateCodecOperatingRate();
                if (this.sourceDrmSession == this.codecDrmSession) break;
                this.drainAndUpdateCodecDrmSession();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    protected boolean legacyKeepAvailableCodecInfosWithoutCodec() {
        return false;
    }

    protected void onOutputFormatChanged(Format format, @Nullable MediaFormat mediaFormat) throws ExoPlaybackException {
    }

    protected void handleInputBufferSupplementalData(DecoderInputBuffer buffer) throws ExoPlaybackException {
    }

    protected void onQueueInputBuffer(DecoderInputBuffer buffer) throws ExoPlaybackException {
    }

    @CallSuper
    protected void onProcessedOutputBuffer(long presentationTimeUs) {
        while (this.pendingOutputStreamOffsetCount != 0 && presentationTimeUs >= this.pendingOutputStreamSwitchTimesUs[0]) {
            this.outputStreamStartPositionUs = this.pendingOutputStreamStartPositionsUs[0];
            this.outputStreamOffsetUs = this.pendingOutputStreamOffsetsUs[0];
            --this.pendingOutputStreamOffsetCount;
            System.arraycopy(this.pendingOutputStreamStartPositionsUs, 1, this.pendingOutputStreamStartPositionsUs, 0, this.pendingOutputStreamOffsetCount);
            System.arraycopy(this.pendingOutputStreamOffsetsUs, 1, this.pendingOutputStreamOffsetsUs, 0, this.pendingOutputStreamOffsetCount);
            System.arraycopy(this.pendingOutputStreamSwitchTimesUs, 1, this.pendingOutputStreamSwitchTimesUs, 0, this.pendingOutputStreamOffsetCount);
            this.onProcessedStreamChange();
        }
    }

    protected void onProcessedStreamChange() {
    }

    protected int canKeepCodec(MediaCodec codec, MediaCodecInfo codecInfo, Format oldFormat, Format newFormat) {
        return 0;
    }

    @Override
    public boolean isEnded() {
        return this.outputStreamEnded;
    }

    @Override
    public boolean isReady() {
        return this.inputFormat != null && (this.isSourceReady() || this.hasOutputBuffer() || this.codecHotswapDeadlineMs != -9223372036854775807L && SystemClock.elapsedRealtime() < this.codecHotswapDeadlineMs);
    }

    protected float getOperatingRate() {
        return this.operatingRate;
    }

    protected float getCodecOperatingRate() {
        return this.codecOperatingRate;
    }

    protected float getCodecOperatingRateV23(float operatingRate, Format format, Format[] streamFormats) {
        return -1.0f;
    }

    private void updateCodecOperatingRate() throws ExoPlaybackException {
        if (Util.SDK_INT < 23) {
            return;
        }
        float newCodecOperatingRate = this.getCodecOperatingRateV23(this.operatingRate, this.codecInputFormat, this.getStreamFormats());
        if (this.codecOperatingRate != newCodecOperatingRate) {
            if (newCodecOperatingRate == -1.0f) {
                this.drainAndReinitializeCodec();
            } else if (this.codecOperatingRate != -1.0f || newCodecOperatingRate > this.assumedMinimumCodecOperatingRate) {
                Bundle codecParameters = new Bundle();
                codecParameters.putFloat("operating-rate", newCodecOperatingRate);
                this.codec.setParameters(codecParameters);
                this.codecOperatingRate = newCodecOperatingRate;
            }
        }
    }

    private void drainAndFlushCodec() {
        if (this.codecReceivedBuffers) {
            this.codecDrainState = 1;
            this.codecDrainAction = 1;
        }
    }

    private void drainAndUpdateCodecDrmSession() throws ExoPlaybackException {
        if (Util.SDK_INT < 23) {
            this.drainAndReinitializeCodec();
            return;
        }
        if (this.codecReceivedBuffers) {
            this.codecDrainState = 1;
            this.codecDrainAction = 2;
        } else {
            this.updateDrmSessionOrReinitializeCodecV23();
        }
    }

    private void drainAndReinitializeCodec() throws ExoPlaybackException {
        if (this.codecReceivedBuffers) {
            this.codecDrainState = 1;
            this.codecDrainAction = 3;
        } else {
            this.reinitializeCodec();
        }
    }

    private boolean drainOutputBuffer(long positionUs, long elapsedRealtimeUs) throws ExoPlaybackException {
        boolean processedOutputBuffer;
        if (!this.hasOutputBuffer()) {
            int outputIndex;
            if (this.codecNeedsEosOutputExceptionWorkaround && this.codecReceivedEos) {
                try {
                    outputIndex = this.codecAdapter.dequeueOutputBufferIndex(this.outputBufferInfo);
                }
                catch (IllegalStateException e) {
                    this.processEndOfStream();
                    if (this.outputStreamEnded) {
                        this.releaseCodec();
                    }
                    return false;
                }
            } else {
                outputIndex = this.codecAdapter.dequeueOutputBufferIndex(this.outputBufferInfo);
            }
            if (outputIndex < 0) {
                if (outputIndex == -2) {
                    this.processOutputMediaFormatChanged();
                    return true;
                }
                if (outputIndex == -3) {
                    this.processOutputBuffersChanged();
                    return true;
                }
                if (this.codecNeedsEosPropagation && (this.inputStreamEnded || this.codecDrainState == 2)) {
                    this.processEndOfStream();
                }
                return false;
            }
            if (this.shouldSkipAdaptationWorkaroundOutputBuffer) {
                this.shouldSkipAdaptationWorkaroundOutputBuffer = false;
                this.codec.releaseOutputBuffer(outputIndex, false);
                return true;
            }
            if (this.outputBufferInfo.size == 0 && (this.outputBufferInfo.flags & 4) != 0) {
                this.processEndOfStream();
                return false;
            }
            this.outputIndex = outputIndex;
            this.outputBuffer = this.getOutputBuffer(outputIndex);
            if (this.outputBuffer != null) {
                this.outputBuffer.position(this.outputBufferInfo.offset);
                this.outputBuffer.limit(this.outputBufferInfo.offset + this.outputBufferInfo.size);
            }
            this.isDecodeOnlyOutputBuffer = this.isDecodeOnlyBuffer(this.outputBufferInfo.presentationTimeUs);
            this.isLastOutputBuffer = this.lastBufferInStreamPresentationTimeUs == this.outputBufferInfo.presentationTimeUs;
            this.updateOutputFormatForTime(this.outputBufferInfo.presentationTimeUs);
        }
        if (this.codecNeedsEosOutputExceptionWorkaround && this.codecReceivedEos) {
            try {
                processedOutputBuffer = this.processOutputBuffer(positionUs, elapsedRealtimeUs, this.codec, this.outputBuffer, this.outputIndex, this.outputBufferInfo.flags, 1, this.outputBufferInfo.presentationTimeUs, this.isDecodeOnlyOutputBuffer, this.isLastOutputBuffer, this.outputFormat);
            }
            catch (IllegalStateException e) {
                this.processEndOfStream();
                if (this.outputStreamEnded) {
                    this.releaseCodec();
                }
                return false;
            }
        } else {
            processedOutputBuffer = this.processOutputBuffer(positionUs, elapsedRealtimeUs, this.codec, this.outputBuffer, this.outputIndex, this.outputBufferInfo.flags, 1, this.outputBufferInfo.presentationTimeUs, this.isDecodeOnlyOutputBuffer, this.isLastOutputBuffer, this.outputFormat);
        }
        if (processedOutputBuffer) {
            this.onProcessedOutputBuffer(this.outputBufferInfo.presentationTimeUs);
            boolean isEndOfStream = (this.outputBufferInfo.flags & 4) != 0;
            this.resetOutputBuffer();
            if (!isEndOfStream) {
                return true;
            }
            this.processEndOfStream();
        }
        return false;
    }

    private void processOutputMediaFormatChanged() {
        this.codecHasOutputMediaFormat = true;
        MediaFormat mediaFormat = this.codecAdapter.getOutputFormat();
        if (this.codecAdaptationWorkaroundMode != 0 && mediaFormat.getInteger("width") == 32 && mediaFormat.getInteger("height") == 32) {
            this.shouldSkipAdaptationWorkaroundOutputBuffer = true;
            return;
        }
        if (this.codecNeedsMonoChannelCountWorkaround) {
            mediaFormat.setInteger("channel-count", 1);
        }
        this.codecOutputMediaFormat = mediaFormat;
        this.codecOutputMediaFormatChanged = true;
    }

    private void processOutputBuffersChanged() {
        if (Util.SDK_INT < 21) {
            this.outputBuffers = this.codec.getOutputBuffers();
        }
    }

    protected abstract boolean processOutputBuffer(long var1, long var3, @Nullable MediaCodec var5, @Nullable ByteBuffer var6, int var7, int var8, int var9, long var10, boolean var12, boolean var13, Format var14) throws ExoPlaybackException;

    protected void renderToEndOfStream() throws ExoPlaybackException {
    }

    @TargetApi(value=23)
    private void processEndOfStream() throws ExoPlaybackException {
        switch (this.codecDrainAction) {
            case 3: {
                this.reinitializeCodec();
                break;
            }
            case 2: {
                this.updateDrmSessionOrReinitializeCodecV23();
                break;
            }
            case 1: {
                this.flushOrReinitializeCodec();
                break;
            }
            default: {
                this.outputStreamEnded = true;
                this.renderToEndOfStream();
            }
        }
    }

    protected final void setPendingOutputEndOfStream() {
        this.pendingOutputEndOfStream = true;
    }

    protected final long getLargestQueuedPresentationTimeUs() {
        return this.largestQueuedPresentationTimeUs;
    }

    protected final long getOutputStreamStartPositionUs() {
        return this.outputStreamStartPositionUs;
    }

    protected final long getOutputStreamOffsetUs() {
        return this.outputStreamOffsetUs;
    }

    protected static boolean supportsFormatDrm(Format format) {
        return format.exoMediaCryptoType == null || FrameworkMediaCrypto.class.equals(format.exoMediaCryptoType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean maybeRequiresSecureDecoder(DrmSession drmSession, Format format) throws ExoPlaybackException {
        MediaCrypto mediaCrypto;
        FrameworkMediaCrypto sessionMediaCrypto = this.getFrameworkMediaCrypto(drmSession);
        if (sessionMediaCrypto == null) {
            return true;
        }
        if (sessionMediaCrypto.forceAllowInsecureDecoderComponents) {
            return false;
        }
        try {
            mediaCrypto = new MediaCrypto(sessionMediaCrypto.uuid, sessionMediaCrypto.sessionId);
        }
        catch (MediaCryptoException e) {
            return true;
        }
        try {
            boolean bl = mediaCrypto.requiresSecureDecoderComponent(format.sampleMimeType);
            return bl;
        }
        finally {
            mediaCrypto.release();
        }
    }

    private void reinitializeCodec() throws ExoPlaybackException {
        this.releaseCodec();
        this.maybeInitCodecOrBypass();
    }

    private boolean isDecodeOnlyBuffer(long presentationTimeUs) {
        int size = this.decodeOnlyPresentationTimestamps.size();
        for (int i = 0; i < size; ++i) {
            if (this.decodeOnlyPresentationTimestamps.get(i) != presentationTimeUs) continue;
            this.decodeOnlyPresentationTimestamps.remove(i);
            return true;
        }
        return false;
    }

    @RequiresApi(value=23)
    private void updateDrmSessionOrReinitializeCodecV23() throws ExoPlaybackException {
        FrameworkMediaCrypto sessionMediaCrypto = this.getFrameworkMediaCrypto(this.sourceDrmSession);
        if (sessionMediaCrypto == null) {
            this.reinitializeCodec();
            return;
        }
        if (C.PLAYREADY_UUID.equals(sessionMediaCrypto.uuid)) {
            this.reinitializeCodec();
            return;
        }
        if (this.flushOrReinitializeCodec()) {
            return;
        }
        try {
            this.mediaCrypto.setMediaDrmSession(sessionMediaCrypto.sessionId);
        }
        catch (MediaCryptoException e) {
            throw this.createRendererException((Exception)((Object)e), this.inputFormat);
        }
        this.setCodecDrmSession(this.sourceDrmSession);
        this.codecDrainState = 0;
        this.codecDrainAction = 0;
    }

    @Nullable
    private FrameworkMediaCrypto getFrameworkMediaCrypto(DrmSession drmSession) throws ExoPlaybackException {
        ExoMediaCrypto mediaCrypto = drmSession.getMediaCrypto();
        if (mediaCrypto != null && !(mediaCrypto instanceof FrameworkMediaCrypto)) {
            throw this.createRendererException(new IllegalArgumentException("Expecting FrameworkMediaCrypto but found: " + mediaCrypto), this.inputFormat);
        }
        return (FrameworkMediaCrypto)mediaCrypto;
    }

    private boolean bypassRender(long positionUs, long elapsedRealtimeUs) throws ExoPlaybackException {
        BatchBuffer batchBuffer = this.bypassBatchBuffer;
        Assertions.checkState(!this.outputStreamEnded);
        if (!batchBuffer.isEmpty()) {
            if (this.processOutputBuffer(positionUs, elapsedRealtimeUs, null, batchBuffer.data, this.outputIndex, 0, batchBuffer.getAccessUnitCount(), batchBuffer.getFirstAccessUnitTimeUs(), batchBuffer.isDecodeOnly(), batchBuffer.isEndOfStream(), this.outputFormat)) {
                this.onProcessedOutputBuffer(batchBuffer.getLastAccessUnitTimeUs());
            } else {
                return false;
            }
        }
        if (batchBuffer.isEndOfStream()) {
            this.outputStreamEnded = true;
            return false;
        }
        batchBuffer.batchWasConsumed();
        if (this.bypassDrainAndReinitialize) {
            if (!batchBuffer.isEmpty()) {
                return true;
            }
            this.disableBypass();
            this.bypassDrainAndReinitialize = false;
            this.maybeInitCodecOrBypass();
            if (!this.bypassEnabled) {
                return false;
            }
        }
        Assertions.checkState(!this.inputStreamEnded);
        FormatHolder formatHolder = this.getFormatHolder();
        boolean formatChange = this.readBatchFromSource(formatHolder, batchBuffer);
        if (!batchBuffer.isEmpty() && this.waitingForFirstSampleInFormat) {
            this.outputFormat = Assertions.checkNotNull(this.inputFormat);
            this.onOutputFormatChanged(this.outputFormat, null);
            this.waitingForFirstSampleInFormat = false;
        }
        if (formatChange) {
            this.onInputFormatChanged(formatHolder);
        }
        boolean haveDataToProcess = false;
        if (batchBuffer.isEndOfStream()) {
            this.inputStreamEnded = true;
            haveDataToProcess = true;
        }
        if (!batchBuffer.isEmpty()) {
            batchBuffer.flip();
            haveDataToProcess = true;
        }
        return haveDataToProcess;
    }

    private boolean readBatchFromSource(FormatHolder formatHolder, BatchBuffer batchBuffer) {
        block5: while (!batchBuffer.isFull() && !batchBuffer.isEndOfStream()) {
            int result = this.readSource(formatHolder, batchBuffer.getNextAccessUnitBuffer(), false);
            switch (result) {
                case -5: {
                    return true;
                }
                case -3: {
                    return false;
                }
                case -4: {
                    batchBuffer.commitNextAccessUnit();
                    continue block5;
                }
            }
            throw new IllegalStateException();
        }
        return false;
    }

    private static boolean isMediaCodecException(IllegalStateException error) {
        if (Util.SDK_INT >= 21 && MediaCodecRenderer.isMediaCodecExceptionV21(error)) {
            return true;
        }
        StackTraceElement[] stackTrace = error.getStackTrace();
        return stackTrace.length > 0 && stackTrace[0].getClassName().equals("android.media.MediaCodec");
    }

    @RequiresApi(value=21)
    private static boolean isMediaCodecExceptionV21(IllegalStateException error) {
        return error instanceof MediaCodec.CodecException;
    }

    private static boolean codecNeedsFlushWorkaround(String name) {
        return Util.SDK_INT < 18 || Util.SDK_INT == 18 && ("OMX.SEC.avc.dec".equals(name) || "OMX.SEC.avc.dec.secure".equals(name)) || Util.SDK_INT == 19 && Util.MODEL.startsWith("SM-G800") && ("OMX.Exynos.avc.dec".equals(name) || "OMX.Exynos.avc.dec.secure".equals(name));
    }

    private int codecAdaptationWorkaroundMode(String name) {
        if (Util.SDK_INT <= 25 && "OMX.Exynos.avc.dec.secure".equals(name) && (Util.MODEL.startsWith("SM-T585") || Util.MODEL.startsWith("SM-A510") || Util.MODEL.startsWith("SM-A520") || Util.MODEL.startsWith("SM-J700"))) {
            return 2;
        }
        if (Util.SDK_INT < 24 && ("OMX.Nvidia.h264.decode".equals(name) || "OMX.Nvidia.h264.decode.secure".equals(name)) && ("flounder".equals(Util.DEVICE) || "flounder_lte".equals(Util.DEVICE) || "grouper".equals(Util.DEVICE) || "tilapia".equals(Util.DEVICE))) {
            return 1;
        }
        return 0;
    }

    private static boolean codecNeedsReconfigureWorkaround(String name) {
        return Util.MODEL.startsWith("SM-T230") && "OMX.MARVELL.VIDEO.HW.CODA7542DECODER".equals(name);
    }

    private static boolean codecNeedsDiscardToSpsWorkaround(String name, Format format) {
        return Util.SDK_INT < 21 && format.initializationData.isEmpty() && "OMX.MTK.VIDEO.DECODER.AVC".equals(name);
    }

    private static boolean codecNeedsEosPropagationWorkaround(MediaCodecInfo codecInfo) {
        String name = codecInfo.name;
        return Util.SDK_INT <= 25 && "OMX.rk.video_decoder.avc".equals(name) || Util.SDK_INT <= 17 && "OMX.allwinner.video.decoder.avc".equals(name) || Util.SDK_INT <= 29 && ("OMX.broadcom.video_decoder.tunnel".equals(name) || "OMX.broadcom.video_decoder.tunnel.secure".equals(name)) || "Amazon".equals(Util.MANUFACTURER) && "AFTS".equals(Util.MODEL) && codecInfo.secure;
    }

    private static boolean codecNeedsEosFlushWorkaround(String name) {
        return Util.SDK_INT <= 23 && "OMX.google.vorbis.decoder".equals(name) || Util.SDK_INT <= 19 && ("hb2000".equals(Util.DEVICE) || "stvm8".equals(Util.DEVICE)) && ("OMX.amlogic.avc.decoder.awesome".equals(name) || "OMX.amlogic.avc.decoder.awesome.secure".equals(name));
    }

    private static boolean codecNeedsEosOutputExceptionWorkaround(String name) {
        return Util.SDK_INT == 21 && "OMX.google.aac.decoder".equals(name);
    }

    private static boolean codecNeedsMonoChannelCountWorkaround(String name, Format format) {
        return Util.SDK_INT <= 18 && format.channelCount == 1 && "OMX.MTK.AUDIO.DECODER.MP3".equals(name);
    }

    private static boolean codecNeedsSosFlushWorkaround(String name) {
        return Util.SDK_INT == 29 && "c2.android.aac.decoder".equals(name);
    }

    public static class DecoderInitializationException
    extends Exception {
        private static final int CUSTOM_ERROR_CODE_BASE = -50000;
        private static final int NO_SUITABLE_DECODER_ERROR = -49999;
        private static final int DECODER_QUERY_ERROR = -49998;
        public final String mimeType;
        public final boolean secureDecoderRequired;
        @Nullable
        public final MediaCodecInfo codecInfo;
        @Nullable
        public final String diagnosticInfo;
        @Nullable
        public final DecoderInitializationException fallbackDecoderInitializationException;

        public DecoderInitializationException(Format format, @Nullable Throwable cause, boolean secureDecoderRequired, int errorCode) {
            this("Decoder init failed: [" + errorCode + "], " + format, cause, format.sampleMimeType, secureDecoderRequired, null, DecoderInitializationException.buildCustomDiagnosticInfo(errorCode), null);
        }

        public DecoderInitializationException(Format format, @Nullable Throwable cause, boolean secureDecoderRequired, MediaCodecInfo mediaCodecInfo) {
            this("Decoder init failed: " + mediaCodecInfo.name + ", " + format, cause, format.sampleMimeType, secureDecoderRequired, mediaCodecInfo, Util.SDK_INT >= 21 ? DecoderInitializationException.getDiagnosticInfoV21(cause) : null, null);
        }

        private DecoderInitializationException(String message, @Nullable Throwable cause, String mimeType, boolean secureDecoderRequired, @Nullable MediaCodecInfo mediaCodecInfo, @Nullable String diagnosticInfo, @Nullable DecoderInitializationException fallbackDecoderInitializationException) {
            super(message, cause);
            this.mimeType = mimeType;
            this.secureDecoderRequired = secureDecoderRequired;
            this.codecInfo = mediaCodecInfo;
            this.diagnosticInfo = diagnosticInfo;
            this.fallbackDecoderInitializationException = fallbackDecoderInitializationException;
        }

        @CheckResult
        private DecoderInitializationException copyWithFallbackException(DecoderInitializationException fallbackException) {
            return new DecoderInitializationException(this.getMessage(), this.getCause(), this.mimeType, this.secureDecoderRequired, this.codecInfo, this.diagnosticInfo, fallbackException);
        }

        @RequiresApi(value=21)
        @Nullable
        private static String getDiagnosticInfoV21(@Nullable Throwable cause) {
            if (cause instanceof MediaCodec.CodecException) {
                return ((MediaCodec.CodecException)cause).getDiagnosticInfo();
            }
            return null;
        }

        private static String buildCustomDiagnosticInfo(int errorCode) {
            String sign = errorCode < 0 ? "neg_" : "";
            return "com.akamai.amp.exoplayer2.mediacodec.MediaCodecRenderer_" + sign + Math.abs(errorCode);
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface AdaptationWorkaroundMode {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface DrainAction {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface DrainState {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface ReconfigurationState {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    protected static @interface KeepCodecResult {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_PARAMETER, ElementType.TYPE_USE})
    public static @interface MediaCodecOperationMode {
    }
}

