/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.parser.config;

import com.akamai.amp.config.data.FreewheelData;
import com.akamai.amp.parser.utils.UtilsParser;
import org.json.JSONObject;

public class FreewheelParser {
    public static final String FREEWHEEL_OBJ_TAG = "freewheel";
    public static final String ENABLED_TAG = "enabled";
    public static final String NETWORK_ID_TAG = "networkId";
    public static final String SERVER_URL_TAG = "serverUrl";
    public static final String PROFILE_TAG = "profileId";
    public static final String SITE_SECTION_ID_TAG = "siteSectionId";
    public static final String VIDEO_ASSET_ID_TAG = "videoAssetId";

    public FreewheelData buildFreeWheelData(JSONObject root) {
        String videoAssetId;
        String siteSectionId;
        String profile;
        String adsURL;
        String networkId;
        JSONObject freeWheelObject = UtilsParser.getObj(FREEWHEEL_OBJ_TAG, root);
        FreewheelData freewheelData = new FreewheelData();
        String enabled = UtilsParser.getValue(ENABLED_TAG, freeWheelObject);
        if (enabled != null) {
            freewheelData.setFreewheelEnabled(Boolean.valueOf(enabled));
        }
        if ((networkId = UtilsParser.getValue(NETWORK_ID_TAG, freeWheelObject)) != null) {
            freewheelData.setFwNetworkId(Integer.valueOf(networkId));
        }
        if ((adsURL = UtilsParser.getValue(SERVER_URL_TAG, freeWheelObject)) != null) {
            freewheelData.setFwAdsURL(String.format("http:%s", adsURL));
        }
        if ((profile = UtilsParser.getValue(PROFILE_TAG, freeWheelObject)) != null) {
            freewheelData.setFwProfile(profile);
        }
        if ((siteSectionId = UtilsParser.getValue(SITE_SECTION_ID_TAG, freeWheelObject)) != null) {
            freewheelData.setFwSiteSectionId(siteSectionId);
        }
        if ((videoAssetId = UtilsParser.getValue(VIDEO_ASSET_ID_TAG, freeWheelObject)) != null) {
            freewheelData.setFwVideoAssetId(videoAssetId);
        }
        return freewheelData;
    }

    public String getAdId(JSONObject root) {
        JSONObject freeWheelObject = UtilsParser.getObj(FREEWHEEL_OBJ_TAG, root);
        return UtilsParser.getValue(NETWORK_ID_TAG, freeWheelObject);
    }
}

