/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.utils;

import android.util.Log;

public class NativeLibraryLoader {
    private static final String TAG = "AMP-NativeLibraryLoader";

    public static boolean load(String library, String invoker) {
        try {
            System.loadLibrary(library);
            String msg = "Library <" + NativeLibraryLoader.getFullLibName(library) + "> was LOADED by " + invoker;
            Log.i((String)TAG, (String)msg);
            return true;
        }
        catch (UnsatisfiedLinkError x) {
            Log.e((String)TAG, (String)("Library <" + NativeLibraryLoader.getFullLibName(library) + "> FAILED LOADING by " + invoker));
            Log.e((String)TAG, (String)x.getLocalizedMessage());
            x.printStackTrace();
            return false;
        }
    }

    private static String getFullLibName(String lib) {
        return "lib" + lib + ".so";
    }
}

